/*
 * Decompiled with CFR 0.152.
 */
package provida;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;
import provida.GenSubs;
import provida.Met99Datos;

public class ProductosController
implements Initializable {
    Stage stage;
    Parent root;
    Image imagenProducto;
    Image imgLogoProducto;
    @FXML
    Label lblVersion;
    @FXML
    ComboBox cmbProductos;
    @FXML
    ImageView imgProducto;
    @FXML
    ImageView imgInicio;
    @FXML
    ImageView logoProducto;
    private GenSubs genSubs = GenSubs.getInstance();
    private Met99Datos met99Datos = Met99Datos.getInstance();
    private Integer indexProducto;

    public void initialize(URL location, ResourceBundle resources) {
        this.cmbProductos.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                ProductosController.this.MuestraProducto();
            }
        });
        this.InicializaVentana();
    }

    private void MuestraProducto() {
        this.indexProducto = this.cmbProductos.getSelectionModel().getSelectedIndex();
        switch (this.indexProducto) {
            case 0: {
                try {
                    this.imagenProducto = this.met99Datos.esVida360 != false ? new Image("Img/PortadaVida360.jpg") : new Image("Img/PortadaMet99.jpg");
                    this.imgProducto.setImage(this.imagenProducto);
                    if (this.met99Datos.esVida360.booleanValue()) {
                        this.imgLogoProducto = new Image("Img/LogoMetLifeVida360.jpg");
                        this.imgProducto.setImage(this.imagenProducto);
                    } else {
                        this.imgLogoProducto = new Image("Img/LogoMetLifeMet99.jpg");
                        this.imgProducto.setImage(this.imagenProducto);
                    }
                    this.logoProducto.setImage(this.imgLogoProducto);
                }
                catch (Exception e2) {
                    System.out.println("No enuentra imagen, error: " + e2);
                }
                break;
            }
            case 1: {
                try {
                    this.imagenProducto = new Image("Img/PortadaMaestro20.jpg");
                    this.imgLogoProducto = new Image("Img/LogoMetLifeMaestro20.jpg");
                    this.imgProducto.setImage(this.imagenProducto);
                    this.logoProducto.setImage(this.imgLogoProducto);
                }
                catch (Exception e3) {
                    System.out.println("No enuentra imagen, error: " + e3);
                }
                break;
            }
            case 2: {
                try {
                    this.imagenProducto = new Image("Img/PortadaPT20.jpg");
                    this.imgProducto.setImage(this.imagenProducto);
                    this.imgLogoProducto = new Image("Img/LogoMetLifePT20.jpg");
                    this.imgProducto.setImage(this.imagenProducto);
                    this.logoProducto.setImage(this.imgLogoProducto);
                    break;
                }
                catch (Exception e4) {
                    System.out.println("No enuentra imagen, error: " + e4);
                }
            }
        }
    }

    public void MuestraPoliticas() {
        switch (this.indexProducto) {
            case 0: {
                if (this.met99Datos.esVida360.booleanValue()) {
                    this.AbreArchivoPDF("Politicas Vida360.pdf");
                    break;
                }
                this.AbreArchivoPDF("Politicas Met99.pdf");
                break;
            }
            case 1: {
                this.AbreArchivoPDF("Politicas Maestro20.pdf");
                break;
            }
            case 2: {
                this.AbreArchivoPDF("Politicas PT20.pdf");
            }
        }
    }

    public void MuestraRequisitos() {
        switch (this.indexProducto) {
            case 0: {
                if (this.met99Datos.esVida360.booleanValue()) {
                    this.AbreArchivoPDF("Requisitos Vida360.pdf");
                    break;
                }
                this.AbreArchivoPDF("Requisitos.pdf");
                break;
            }
            case 1: {
                this.AbreArchivoPDF("Requisitos.pdf");
                break;
            }
            case 2: {
                this.AbreArchivoPDF("Requisitos.pdf");
            }
        }
    }

    public void MuestraDescripcionProducto() {
        switch (this.indexProducto) {
            case 0: {
                if (this.met99Datos.esVida360.booleanValue()) {
                    this.AbreArchivoPDF("Conoce Vida360.pdf");
                    break;
                }
                this.AbreArchivoPDF("Conoce Met99.pdf");
                break;
            }
            case 1: {
                this.AbreArchivoPDF("Conoce Maestro20.pdf");
                break;
            }
            case 2: {
                this.AbreArchivoPDF("Conoce PT20.pdf");
            }
        }
    }

    private void InicializaVentana() {
        this.cmbProductos.getItems().add(0, (Object)"Met99");
        this.cmbProductos.getItems().add(1, (Object)"Maestro20");
        this.cmbProductos.setValue((Object)"Met99");
        if (this.met99Datos.esVida360.booleanValue()) {
            this.lblVersion.setText(this.met99Datos.idVersion360);
            this.imgLogoProducto = new Image("Img/LogoMetLifeVida360.jpg");
            this.imgProducto.setImage(this.imagenProducto);
            this.logoProducto.setImage(this.imgLogoProducto);
            this.cmbProductos.setVisible(false);
        } else {
            this.lblVersion.setText(this.met99Datos.idVersion);
            this.imgLogoProducto = new Image("Img/LogoMetLifeMet99.jpg");
            this.imgProducto.setImage(this.imagenProducto);
            this.logoProducto.setImage(this.imgLogoProducto);
            this.cmbProductos.setVisible(true);
        }
    }

    public void RegresaInicio() {
        this.stage = (Stage)this.imgInicio.getScene().getWindow();
        this.MostrarVentana("Provida.fxml");
    }

    private void MostrarVentana(String nombreVentana) {
        try {
            this.root = (Parent)FXMLLoader.load((URL)this.getClass().getResource(nombreVentana));
        }
        catch (Exception e2) {
            System.out.println("No pudo cargar " + nombreVentana + " error: " + e2);
        }
        Scene scene = new Scene(this.root);
        this.stage.setScene(scene);
        this.stage.show();
    }

    private void AbreArchivoPDF(String archivoPDF) {
        if (Desktop.isDesktopSupported()) {
            try {
                File myFile = new File(archivoPDF);
                Desktop.getDesktop().open(myFile);
            }
            catch (IOException ex) {
                this.genSubs.MuestraMensaje("Es necesario tener instalado Adobe Acrobat Reader", "TarifarioMet99");
            }
        }
    }

    public void Salir() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Provida");
        alert.setHeaderText("");
        alert.setContentText("\u00bfEst\u00e1 seguro de salir del cotizador?");
        Optional result = alert.showAndWait();
        if (result.get() == ButtonType.OK) {
            Platform.exit();
        }
    }
}

