/*
 * Decompiled with CFR 0.152.
 */
package provida;

import com.cete.dynamicpdf.Document;
import com.cete.dynamicpdf.LineStyle;
import com.cete.dynamicpdf.Page;
import com.cete.dynamicpdf.PageDimensions;
import com.cete.dynamicpdf.PageOrientation;
import com.cete.dynamicpdf.PageSize;
import com.cete.dynamicpdf.RgbColor;
import com.cete.dynamicpdf.Template;
import com.cete.dynamicpdf.TextAlign;
import com.cete.dynamicpdf.pageelements.Image;
import com.cete.dynamicpdf.pageelements.Line;
import com.cete.dynamicpdf.pageelements.Row2;
import com.cete.dynamicpdf.pageelements.Table2;
import com.cete.dynamicpdf.pageelements.TextArea;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;
import provida.AutoCompleteComboBoxListener;
import provida.GenSubs;
import provida.Met99Calcula;
import provida.Met99Datos;
import provida.Met99Reglas;
import provida.Tablas;

public class Met99Tarifario
implements Initializable {
    Stage stage;
    Parent root;
    @FXML
    Label lblVersion;
    @FXML
    ImageView logoProducto;
    @FXML
    ImageView imgInicio;
    @FXML
    TextField sumaIni;
    @FXML
    TextField sumaFin;
    @FXML
    TextField sumaInc;
    @FXML
    TextField edadIni;
    @FXML
    TextField edadFin;
    @FXML
    Label lblSumaEG;
    @FXML
    Label lblSumaCR;
    @FXML
    TextField sumaIniEG;
    @FXML
    TextField sumaFinEG;
    @FXML
    TextField sumaIncEG;
    @FXML
    TextField sumaIniCR;
    @FXML
    TextField sumaFinCR;
    @FXML
    TextField sumaIncCR;
    @FXML
    CheckBox chkBAS;
    @FXML
    CheckBox chkCII;
    @FXML
    CheckBox chkCMA;
    @FXML
    CheckBox chkTIBA;
    @FXML
    CheckBox chkCAT;
    @FXML
    CheckBox chkGF;
    @FXML
    CheckBox chkGE;
    @FXML
    CheckBox chkAP;
    @FXML
    CheckBox chkEG;
    @FXML
    CheckBox chkCR;
    @FXML
    CheckBox chkPHT;
    @FXML
    CheckBox chkBACY;
    @FXML
    CheckBox chkGFC;
    @FXML
    CheckBox chkGFH;
    @FXML
    CheckBox chkBAC;
    @FXML
    CheckBox chkBCAC;
    @FXML
    CheckBox chkGFcomp;
    @FXML
    CheckBox chkEGcomp;
    @FXML
    CheckBox chkCRcomp;
    @FXML
    CheckBox chkPHX;
    @FXML
    Label lblOpcionGF;
    @FXML
    RadioButton optGFminima;
    @FXML
    RadioButton optGFmaxima;
    @FXML
    Label lblConyuge;
    @FXML
    Label lblHijos;
    @FXML
    Label lblComp;
    @FXML
    Label lblExtraprima;
    @FXML
    ComboBox cmbOcupaciones;
    @FXML
    Label lblDecisionSus;
    @FXML
    ImageView imgTarifario;
    private Integer indexOcupacion;
    private String ocupacionSel;
    private String txtDecision;
    private String txtEPvida;
    private String txtEPinvalidez;
    private String txtEPaccidentes;
    javafx.scene.image.Image imgLogoProducto;
    private Met99Calcula met99Calcula = Met99Calcula.getInstance();
    private Met99Datos met99Datos = Met99Datos.getInstance();
    private Met99Reglas met99Reglas = Met99Reglas.getInstance();
    private GenSubs genSubs = GenSubs.getInstance();
    private Tablas tablas = Tablas.getInstance();
    private Boolean hayError;
    private Integer sumaAsegurada;
    private Integer sumaInicial;
    private Integer sumaFinal;
    private Integer sumaIncremento;
    private Integer sumaInicialEG;
    private Integer sumaFinalEG;
    private Integer sumaIncrementoEG;
    private Integer sumaInicialCR;
    private Integer sumaFinalCR;
    private Integer sumaIncrementoCR;
    private Integer edadInicial;
    private Integer edadFinal;
    private String valorTemp;
    private String msgError;
    private Float anchoPag;
    private Float altoPag;
    private Float margenIzq;
    private Float margenDer;
    private Integer numSumasAseguradas;
    private Integer numCoberturas;
    private Integer numTablas;
    private Float anchoColumna;
    private Integer numPag = 0;
    private List<String> idCobertura = new ArrayList<String>();
    private List<String> nombreCobertura = new ArrayList<String>();
    private Integer indexSumaAsegurada;
    private Integer indexTblTarifario;
    private String sumaGF;
    private String sumaEG;
    private String sumaCR;
    private String sumaPHT;
    private String sumaPHX;
    private List<RgbColor> colorClaro = new ArrayList<RgbColor>();
    private List<RgbColor> colorOscuro = new ArrayList<RgbColor>();
    private Boolean hayEG;
    private Boolean hayCR;
    private Boolean hayPHT;
    private Boolean hayPHX;
    private Boolean hayOtrasCob;
    private List<Integer> ctlVisible = new ArrayList<Integer>();
    private List<Integer> ctlPosicionX = new ArrayList<Integer>();
    private List<Integer> ctlPosicionY = new ArrayList<Integer>();
    private Boolean errorPDF;
    private Document tarifarioDoc;
    private Page pagTarifario;
    private PageDimensions dimensions;
    private List<Table2> tblTarifario = new ArrayList<Table2>();
    private List<Table2> tblTitTarifario = new ArrayList<Table2>();
    private List<Table2> tblEdades = new ArrayList<Table2>();
    private Row2 renTarifario;
    private Row2 renEdades;
    private Row2 renTitTarifario;
    private Table2 tblEncabezado;
    private Row2 renEncabezado;
    private Table2 tblPie;
    private Row2 renPie;
    private Float fontSize = Float.valueOf(7.0f);
    private Table2 tblSuma1;
    private Table2 tblSuma2;
    private Row2 renSuma1;
    private Row2 renSuma2;
    private Table2 tblEncabezado2;
    private Row2 renEncabezado2;
    Image logoMet99;
    Line linea;
    TextArea texto1;
    TextArea texto2;
    Float currentY;
    Image logoMetLife;

    public void initialize(URL location, ResourceBundle resources) {
        this.cmbOcupaciones.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Met99Tarifario.this.DeterminaEP();
            }
        });
        new AutoCompleteComboBoxListener(this.cmbOcupaciones);
        this.InicializaVentana();
    }

    private void InicializaVentana() {
        if (this.met99Datos.esVida360.booleanValue()) {
            this.lblVersion.setText(this.met99Datos.idVersion360);
        } else {
            this.lblVersion.setText(this.met99Datos.idVersion);
        }
        this.InicializaObjetos();
        this.RevisaSiHayEGoCR();
        this.LlenaCmbOcupaciones();
        this.cmbOcupaciones.setValue((Object)"No especificada");
        if (this.met99Datos.phTarifario.booleanValue()) {
            this.chkPHT.setVisible(true);
            this.chkPHX.setVisible(true);
        } else {
            this.chkPHT.setVisible(false);
            this.chkPHX.setVisible(false);
        }
        if (this.met99Datos.esVida360.booleanValue()) {
            this.lblExtraprima.setVisible(true);
            this.cmbOcupaciones.setVisible(true);
            this.lblDecisionSus.setVisible(true);
        } else {
            this.lblExtraprima.setVisible(true);
            this.cmbOcupaciones.setVisible(true);
            this.lblDecisionSus.setVisible(true);
        }
    }

    private void DeterminaEP() {
        if (this.cmbOcupaciones.getItems().size() > 0) {
            this.met99Datos.indexOcupacionSel = this.indexOcupacion = Integer.valueOf(this.cmbOcupaciones.getSelectionModel().getSelectedIndex());
            if (this.indexOcupacion == -1) {
                this.indexOcupacion = 0;
            }
            this.met99Datos.ocupacionSel = this.ocupacionSel = this.met99Datos.lstOcupaciones.get(this.indexOcupacion);
            this.txtDecision = this.met99Datos.lstDecisiones.get(this.indexOcupacion);
            this.met99Datos.epVida = this.met99Datos.lstEPvida.get(this.indexOcupacion);
            this.met99Datos.epInvalidez = this.met99Datos.lstEPinvalidez.get(this.indexOcupacion);
            this.met99Datos.epAccidentes = this.met99Datos.lstEPaccidentes.get(this.indexOcupacion);
            this.met99Datos.APactivado = this.met99Datos.lstAPactivado.get(this.indexOcupacion);
            if (this.met99Datos.lstSumaLimitada.get(this.indexOcupacion) == 0) {
                this.met99Datos.sumaLimitada = false;
            } else {
                this.met99Datos.sumaLimitada = true;
                this.met99Datos.impSumaLimitada = this.met99Datos.lstSumaLimitada.get(this.indexOcupacion);
            }
            this.txtEPvida = "Vida: ";
            this.txtEPaccidentes = "Accidentes: ";
            this.txtEPinvalidez = "Invalidez: ";
            this.met99Datos.txtSuscripcion = "";
            this.met99Datos.rechazoAccidentes = false;
            this.met99Datos.rechazoInvalidez = false;
            if (this.indexOcupacion >= 0) {
                if ("RECHAZO".equals(this.txtDecision)) {
                    this.met99Datos.txtSuscripcion = "RECHAZO";
                    this.imgTarifario.setDisable(true);
                    this.lblDecisionSus.setStyle("-fx-background-color: red;");
                } else {
                    this.imgTarifario.setDisable(false);
                    this.lblDecisionSus.setStyle("-fx-background-color: rgb(235,235,235);");
                    if (this.met99Datos.epVida == 0.0 && this.met99Datos.epInvalidez == 1.0 && this.met99Datos.epAccidentes == 1.0) {
                        this.met99Datos.txtSuscripcion = "No se aplican extraprimas ocupacionales";
                    } else {
                        this.txtEPvida = this.txtEPvida + this.met99Datos.epVida.toString() + " al millar,";
                        if (this.met99Datos.epAccidentes == 9.9) {
                            this.txtEPaccidentes = this.txtEPaccidentes + "RECHAZO,";
                            this.met99Datos.rechazoAccidentes = true;
                        } else {
                            this.txtEPaccidentes = this.txtEPaccidentes + this.met99Datos.epAccidentes.toString() + " tantos,";
                            this.met99Datos.rechazoAccidentes = false;
                        }
                        if (this.met99Datos.epInvalidez == 9.9) {
                            this.txtEPinvalidez = this.txtEPinvalidez + "RECHAZO,";
                            this.met99Datos.rechazoInvalidez = true;
                        } else {
                            this.txtEPinvalidez = this.txtEPinvalidez + this.met99Datos.epInvalidez.toString() + " tantos.";
                            this.met99Datos.rechazoInvalidez = false;
                        }
                        this.met99Datos.txtSuscripcion = this.txtEPvida + " " + this.txtEPaccidentes + " " + this.txtEPinvalidez;
                    }
                    this.met99Datos.txtSuscripcion = this.txtDecision;
                }
            } else {
                this.imgTarifario.setDisable(false);
                this.lblDecisionSus.setStyle("-fx-background-color: rgb(235,235,235);");
            }
            if (this.met99Datos.epAccidentes == 0.0) {
                this.met99Datos.epAccidentes = 1.0;
            }
            if (this.met99Datos.epInvalidez == 0.0) {
                this.met99Datos.epInvalidez = 1.0;
            }
            this.lblDecisionSus.setText(this.met99Datos.txtSuscripcion);
            this.met99Datos.hayEP = "".equals(this.met99Datos.txtSuscripcion) ? Boolean.valueOf(false) : Boolean.valueOf(true);
            this.RevisaCoberturasValidas();
        }
    }

    private void RevisaCoberturasValidas() {
        if (this.met99Datos.epAccidentes == 9.9) {
            this.chkCMA.setSelected(false);
            this.chkTIBA.setSelected(false);
            this.chkCMA.setDisable(true);
            this.chkTIBA.setDisable(true);
        } else {
            this.chkCMA.setDisable(false);
            this.chkTIBA.setDisable(false);
        }
        if (this.met99Datos.epInvalidez == 9.9) {
            this.chkCII.setSelected(false);
            this.chkCII.setDisable(true);
        } else {
            this.chkCII.setDisable(false);
        }
        if (this.met99Datos.lstAPactivado.get(this.indexOcupacion) == 1) {
            this.chkAP.setDisable(false);
        } else {
            this.chkAP.setSelected(false);
            this.chkAP.setDisable(true);
        }
    }

    private void LlenaCmbOcupaciones() {
        this.cmbOcupaciones.getItems().clear();
        this.cmbOcupaciones.getItems().addAll(this.met99Datos.lstOcupaciones);
    }

    public void TarifarioMet99() {
        this.ValidaDatos();
        if (this.hayError.booleanValue()) {
            this.genSubs.MuestraMensaje(this.msgError, "Provida");
        } else {
            this.met99Datos.formaPago = "Quincenal";
            this.sumaIni.setText(this.genSubs.FormatoNumInteger("###,###", this.sumaInicial));
            this.sumaFin.setText(this.genSubs.FormatoNumInteger("###,###", this.sumaFinal));
            this.sumaInc.setText(this.genSubs.FormatoNumInteger("###,###", this.sumaIncremento));
            this.RevisaCoberturasSeleccionadas();
            this.DefineDocumento();
            this.PaginaNueva();
            this.DefineTemplate();
            this.DefineTablas();
            this.InicializaValores();
            this.indexSumaAsegurada = 0;
            this.met99Datos.numComp = 1;
            this.BorraDatosComp();
            this.met99Datos.lstEpBAC.add(0.0);
            this.met99Datos.lstEpBCAC.add(0.0);
            this.met99Datos.lstEpGF.add(0.0);
            this.met99Datos.lstEpEG.add(0.0);
            this.met99Datos.lstEpCR.add(0.0);
            this.met99Datos.lstEpPHX.add(0.0);
            this.met99Datos.lstEpAP.add(0.0);
            this.met99Datos.lstEdadComp.add(0);
            this.met99Datos.lstSumaBAC.add(0);
            this.met99Datos.lstSumaBCAC.add(0);
            this.met99Datos.lstSumaGF.add(0);
            this.met99Datos.lstSumaEG.add(0);
            this.met99Datos.lstSumaCR.add(0);
            this.met99Datos.lstSumaPHX.add(0);
            this.met99Datos.lstSumaAP.add(0);
            this.met99Datos.lstPrimaBAC.add(0.0);
            this.met99Datos.lstPrimaBCAC.add(0.0);
            this.met99Datos.lstPrimaGF.add(0.0);
            this.met99Datos.lstPrimaEG.add(0.0);
            this.met99Datos.lstPrimaCR.add(0.0);
            this.met99Datos.lstPrimaPHX.add(0.0);
            this.met99Datos.lstPrimaAP.add(0.0);
            this.met99Datos.lstSelBAC.add(false);
            this.met99Datos.lstSelBCAC.add(false);
            this.met99Datos.lstSelGF.add(false);
            this.met99Datos.lstSelEG.add(false);
            this.met99Datos.lstSelCR.add(false);
            this.met99Datos.lstSelAP.add(false);
            this.met99Datos.lstSelPHX.add(false);
            this.met99Datos.lstSexoComp.add("M");
            this.met99Datos.selBAS = this.chkBAS.isSelected();
            this.met99Datos.selCII = this.chkCII.isSelected();
            this.met99Datos.selCMA = this.chkCMA.isSelected();
            this.met99Datos.selTIBA = this.chkTIBA.isSelected();
            this.met99Datos.selCAT = this.chkCAT.isSelected();
            this.met99Datos.selGFA = this.chkGF.isSelected();
            this.met99Datos.selGE = this.chkGE.isSelected();
            this.met99Datos.selAP = this.chkAP.isSelected();
            this.met99Datos.selEG = this.chkEG.isSelected();
            this.met99Datos.selCR = this.chkCR.isSelected();
            this.met99Datos.selPHT = this.chkPHT.isSelected();
            this.met99Datos.selBACY = this.chkBACY.isSelected();
            this.met99Datos.selGFC = this.chkGFC.isSelected();
            this.met99Datos.selGFH = this.chkGFH.isSelected();
            this.met99Datos.lstSelBAC.set(0, this.chkBAC.isSelected());
            this.met99Datos.lstSelBCAC.set(0, this.chkBCAC.isSelected());
            this.met99Datos.lstSelGF.set(0, this.chkGFcomp.isSelected());
            this.met99Datos.lstSelEG.set(0, this.chkEGcomp.isSelected());
            this.met99Datos.lstSelCR.set(0, this.chkCRcomp.isSelected());
            this.met99Datos.lstSelPHX.set(0, this.chkPHX.isSelected());
            if (this.hayOtrasCob.booleanValue()) {
                this.sumaAsegurada = this.sumaInicial;
                while (this.sumaAsegurada <= this.sumaFinal) {
                    this.indexSumaAsegurada = this.indexSumaAsegurada + 1;
                    if (this.hayEG.booleanValue()) {
                        this.met99Datos.sumaEG = this.sumaInicialEG + this.sumaIncrementoEG * (this.indexSumaAsegurada - 1);
                        if (this.met99Datos.sumaEG > this.sumaFinalEG) {
                            this.met99Datos.sumaEG = 0;
                        }
                    } else {
                        this.met99Datos.sumaEG = 0;
                    }
                    if (this.hayCR.booleanValue()) {
                        this.met99Datos.sumaCR = this.sumaInicialCR + this.sumaIncrementoCR * (this.indexSumaAsegurada - 1);
                        if (this.met99Datos.sumaCR > this.sumaFinalCR) {
                            this.met99Datos.sumaCR = 0;
                        }
                    } else {
                        this.met99Datos.sumaCR = 0;
                    }
                    this.CalculaPrimasTarifario();
                    this.sumaAsegurada = this.sumaAsegurada + this.sumaIncremento;
                }
            } else if (this.hayEG.booleanValue()) {
                this.sumaAsegurada = this.sumaInicialEG;
                while (this.sumaAsegurada <= this.sumaFinalEG) {
                    this.indexSumaAsegurada = this.indexSumaAsegurada + 1;
                    this.met99Datos.sumaEG = this.sumaAsegurada;
                    if (this.hayCR.booleanValue()) {
                        this.met99Datos.sumaCR = this.sumaInicialCR + this.sumaIncrementoCR * (this.indexSumaAsegurada - 1);
                        if (this.met99Datos.sumaCR > this.sumaFinalCR) {
                            this.met99Datos.sumaCR = 0;
                        }
                    } else {
                        this.met99Datos.sumaCR = 0;
                    }
                    this.CalculaPrimasTarifario();
                    this.sumaAsegurada = this.sumaAsegurada + this.sumaIncrementoEG;
                }
            } else {
                if (this.hayCR.booleanValue()) {
                    this.sumaAsegurada = this.sumaInicialCR;
                    while (this.sumaAsegurada <= this.sumaFinalCR) {
                        this.indexSumaAsegurada = this.indexSumaAsegurada + 1;
                        this.met99Datos.sumaCR = this.sumaAsegurada;
                        this.CalculaPrimasTarifario();
                        this.sumaAsegurada = this.sumaAsegurada + this.sumaIncrementoCR;
                    }
                }
                if (this.hayPHT.booleanValue() || this.hayPHX.booleanValue()) {
                    this.sumaAsegurada = 1000;
                    while (this.sumaAsegurada <= 1000) {
                        this.indexSumaAsegurada = this.indexSumaAsegurada + 1;
                        this.met99Datos.sumaCR = this.sumaAsegurada;
                        this.CalculaPrimasTarifario();
                        this.sumaAsegurada = this.sumaAsegurada + 1;
                    }
                }
            }
            this.EscribeTarifario();
        }
    }

    private void BorraDatosComp() {
        this.met99Datos.lstSumaBAC.clear();
        this.met99Datos.lstSumaBCAC.clear();
        this.met99Datos.lstSumaGF.clear();
        this.met99Datos.lstSumaEG.clear();
        this.met99Datos.lstSumaCR.clear();
        this.met99Datos.lstEpBAC.clear();
        this.met99Datos.lstEpBCAC.clear();
        this.met99Datos.lstEpGF.clear();
        this.met99Datos.lstEpEG.clear();
        this.met99Datos.lstEpCR.clear();
        this.met99Datos.lstEpAP.clear();
        this.met99Datos.lstPrimaBAC.clear();
        this.met99Datos.lstPrimaBCAC.clear();
        this.met99Datos.lstPrimaGF.clear();
        this.met99Datos.lstPrimaEG.clear();
        this.met99Datos.lstPrimaCR.clear();
        this.met99Datos.lstPrimaAP.clear();
        this.met99Datos.lstEdadComp.clear();
        this.met99Datos.lstSelBAC.clear();
        this.met99Datos.lstSelBCAC.clear();
        this.met99Datos.lstSelGF.clear();
        this.met99Datos.lstSelEG.clear();
        this.met99Datos.lstSelCR.clear();
        this.met99Datos.lstSelPHX.clear();
        this.met99Datos.lstSelAP.clear();
        this.met99Datos.lstSexoComp.clear();
    }

    private void CalculaPrimasTarifario() {
        Integer valorTemp;
        this.met99Datos.sumaBAS = this.sumaAsegurada;
        if (this.met99Datos.sumaBAS < this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("BAS"))) {
            this.met99Datos.sumaBAS = 0;
        }
        this.met99Datos.sumaCII = this.sumaAsegurada;
        if (this.met99Datos.sumaCII < this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("CII"))) {
            this.met99Datos.sumaCII = 0;
        }
        this.met99Datos.sumaCMA = this.sumaAsegurada;
        if (this.met99Datos.sumaCMA < this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("CMA"))) {
            this.met99Datos.sumaCMA = 0;
        }
        this.met99Datos.sumaTIBA = this.sumaAsegurada;
        if (this.met99Datos.sumaTIBA < this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("TIBA"))) {
            this.met99Datos.sumaTIBA = 0;
        }
        if (this.met99Datos.productoSeleccionado.equals("Maestro20") && this.met99Datos.sumaTIBA > this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("TIBA"))) {
            this.met99Datos.sumaTIBA = 0;
        }
        this.met99Datos.sumaCAT = this.sumaAsegurada > this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("CAT")) ? Integer.valueOf(0) : this.sumaAsegurada;
        if (this.met99Datos.sumaCAT < this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("CAT"))) {
            this.met99Datos.sumaCAT = 0;
        }
        this.met99Datos.sumaGE = this.sumaAsegurada;
        if (this.met99Datos.sumaGE < this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GE"))) {
            this.met99Datos.sumaGE = 0;
        }
        if (0.35 * (double)this.sumaAsegurada.intValue() < (double)this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFA")).intValue()) {
            valorTemp = 0;
        } else if (this.optGFminima.isSelected()) {
            valorTemp = this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFA"));
        } else {
            valorTemp = (int)(0.35 * (double)this.sumaAsegurada.intValue() + 0.5);
            if (valorTemp > this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("GFA"))) {
                valorTemp = this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("GFA"));
            }
            if (valorTemp < this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFA"))) {
                valorTemp = 0;
            }
        }
        this.met99Datos.sumaGFA = this.chkGF.isSelected() ? valorTemp : Integer.valueOf(0);
        if (0.35 * (double)this.sumaAsegurada.intValue() < (double)this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFC")).intValue()) {
            valorTemp = 0;
        } else if (this.optGFminima.isSelected()) {
            valorTemp = this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFC"));
        } else {
            valorTemp = (int)(0.35 * (double)this.sumaAsegurada.intValue() + 0.5);
            if (valorTemp > this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("GFC"))) {
                valorTemp = this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("GFC"));
            }
            if (valorTemp < this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFC"))) {
                valorTemp = 0;
            }
        }
        this.met99Datos.sumaGFC = this.chkGFC.isSelected() ? valorTemp : Integer.valueOf(0);
        if (0.35 * (double)this.sumaAsegurada.intValue() < (double)this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFH")).intValue()) {
            valorTemp = 0;
        } else if (this.optGFminima.isSelected()) {
            valorTemp = this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFH"));
        } else {
            valorTemp = (int)(0.35 * (double)this.sumaAsegurada.intValue() + 0.5);
            if (valorTemp > this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("GFH"))) {
                valorTemp = this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("GFH"));
            }
            if (valorTemp < this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFH"))) {
                valorTemp = 0;
            }
        }
        this.met99Datos.sumaGFH = this.chkGFH.isSelected() ? valorTemp : Integer.valueOf(0);
        if (this.chkGFcomp.isSelected()) {
            this.met99Datos.lstSumaGF.set(0, valorTemp);
        } else {
            this.met99Datos.lstSumaGF.set(0, 0);
        }
        this.met99Datos.sumaBACY = 0;
        if (this.sumaAsegurada <= this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("BACY"))) {
            this.met99Datos.sumaBACY = this.sumaAsegurada;
        }
        if (this.met99Datos.sumaBACY < this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("BACY"))) {
            this.met99Datos.sumaBACY = 0;
        }
        this.met99Datos.lstSumaBAC.set(0, this.sumaAsegurada);
        if (this.sumaAsegurada < this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("BACcomp"))) {
            this.met99Datos.lstSumaBAC.set(0, 0);
        }
        this.met99Datos.lstSumaBCAC.set(0, 0);
        if (this.sumaAsegurada <= this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("BCAC"))) {
            this.met99Datos.lstSumaBCAC.set(0, this.sumaAsegurada);
        }
        if (this.sumaAsegurada < this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("BCAC"))) {
            this.met99Datos.lstSumaBCAC.set(0, 0);
        }
        this.met99Datos.lstSumaEG.set(0, this.met99Datos.sumaEG);
        this.met99Datos.lstSumaCR.set(0, this.met99Datos.sumaCR);
        this.met99Datos.lstSumaPHX.set(0, this.met99Datos.sumaPHT);
        for (int tbl = 0; tbl < 2; ++tbl) {
            switch (tbl) {
                case 0: {
                    this.met99Datos.sexoTitular = "M";
                    this.met99Datos.fumaTitular = "N";
                    this.met99Datos.lstSexoComp.set(0, "M");
                    break;
                }
                case 1: {
                    this.met99Datos.sexoTitular = "F";
                    this.met99Datos.fumaTitular = "N";
                    this.met99Datos.lstSexoComp.set(0, "F");
                }
            }
            this.indexTblTarifario = 2 * this.indexSumaAsegurada - 2 + tbl;
            Integer currentRow = -1;
            for (int edad = this.edadInicial.intValue(); edad <= this.edadFinal; ++edad) {
                currentRow = currentRow + 1;
                this.met99Datos.edadRealTitular = edad;
                this.met99Reglas.DeterminaEdadCalculoTitular();
                this.met99Datos.edadRealConyuge = edad;
                this.met99Datos.hayConuge = true;
                this.met99Datos.lstEdadComp.set(0, edad);
                if (this.met99Datos.productoSeleccionado.equals("Met99")) {
                    this.tablas.CargaTarifasMet99();
                } else if (this.met99Datos.productoSeleccionado.equals("Maestro20")) {
                    this.tablas.CargaTarifasMaestro20();
                } else {
                    this.tablas.CargaTarifasPT20();
                }
                this.met99Calcula.CalculaPrimas();
                for (int indexCob = 0; indexCob < this.numCoberturas; ++indexCob) {
                    String primaCob = "-";
                    Integer indiceTemp = this.genSubs.IndiceCob(this.idCobertura.get(indexCob));
                    if (edad <= this.met99Datos.edadMax.get(indiceTemp) && edad >= this.met99Datos.edadMin.get(indiceTemp)) {
                        primaCob = this.SeleccionaPrimaCob(this.idCobertura.get(indexCob));
                    }
                    this.tblTarifario.get(this.indexTblTarifario).getRows().getRow2(currentRow).getCells().getCell2(indexCob).setText(primaCob);
                }
            }
        }
    }

    private String SeleccionaPrimaCob(String idCob) {
        String txtPrima = "";
        switch (idCob) {
            case "BAS": {
                Double valorTemp = this.genSubs.Redondea(this.met99Datos.primaBAS / 24.0, 0);
                txtPrima = this.genSubs.FormatoNumDouble("###,###", valorTemp);
                break;
            }
            case "CII": {
                Double valorTemp = this.genSubs.Redondea(this.met99Datos.primaCII / 24.0, 0);
                txtPrima = this.genSubs.FormatoNumDouble("###,###", valorTemp);
                break;
            }
            case "CMA": {
                Double valorTemp = this.genSubs.Redondea(this.met99Datos.primaCMA / 24.0, 0);
                txtPrima = this.genSubs.FormatoNumDouble("###,###", valorTemp);
                break;
            }
            case "TIBA": {
                Double valorTemp = this.genSubs.Redondea(this.met99Datos.primaTIBA / 24.0, 0);
                txtPrima = this.genSubs.FormatoNumDouble("###,###", valorTemp);
                break;
            }
            case "CAT": {
                Double valorTemp = this.genSubs.Redondea(this.met99Datos.primaCAT / 24.0, 0);
                txtPrima = this.genSubs.FormatoNumDouble("###,###", valorTemp);
                break;
            }
            case "GF": {
                Double valorTemp = this.genSubs.Redondea(this.met99Datos.primaGFA / 24.0, 0);
                txtPrima = this.genSubs.FormatoNumDouble("###,###", valorTemp);
                break;
            }
            case "GE": {
                Double valorTemp = this.genSubs.Redondea(this.met99Datos.primaGE / 24.0, 0);
                txtPrima = this.genSubs.FormatoNumDouble("###,###", valorTemp);
                break;
            }
            case "AP": {
                Double valorTemp = this.genSubs.Redondea(this.met99Datos.primaAP / 24.0, 0);
                txtPrima = this.genSubs.FormatoNumDouble("###,###", valorTemp);
                break;
            }
            case "EG": {
                Double valorTemp = this.genSubs.Redondea(this.met99Datos.primaEG / 24.0, 0);
                txtPrima = this.genSubs.FormatoNumDouble("###,###", valorTemp);
                break;
            }
            case "CR": {
                Double valorTemp = this.genSubs.Redondea(this.met99Datos.primaCR / 24.0, 0);
                txtPrima = this.genSubs.FormatoNumDouble("###,###", valorTemp);
                break;
            }
            case "PHT": {
                Double valorTemp = this.genSubs.Redondea(this.met99Datos.primaPHT / 24.0, 0);
                txtPrima = this.genSubs.FormatoNumDouble("###,###", valorTemp);
                break;
            }
            case "BACY": {
                Double valorTemp = this.genSubs.Redondea(this.met99Datos.primaBACY / 24.0, 0);
                txtPrima = this.genSubs.FormatoNumDouble("###,###", valorTemp);
                break;
            }
            case "GFC": {
                Double valorTemp = this.genSubs.Redondea(this.met99Datos.primaGFC / 24.0, 0);
                txtPrima = this.genSubs.FormatoNumDouble("###,###", valorTemp);
                break;
            }
            case "GFH": {
                Double valorTemp = this.genSubs.Redondea(this.met99Datos.primaGFH / 24.0, 0);
                txtPrima = this.genSubs.FormatoNumDouble("###,###", valorTemp);
                break;
            }
            case "BAC": {
                Double valorTemp = this.genSubs.Redondea(this.met99Datos.lstPrimaBAC.get(0) / 24.0, 0);
                txtPrima = this.genSubs.FormatoNumDouble("###,###", valorTemp);
                break;
            }
            case "BCAC": {
                Double valorTemp = this.genSubs.Redondea(this.met99Datos.lstPrimaBCAC.get(0) / 24.0, 0);
                txtPrima = this.genSubs.FormatoNumDouble("###,###", valorTemp);
                break;
            }
            case "GFcomp": {
                Double valorTemp = this.genSubs.Redondea(this.met99Datos.lstPrimaGF.get(0) / 24.0, 0);
                txtPrima = this.genSubs.FormatoNumDouble("###,###", valorTemp);
                break;
            }
            case "EGcomp": {
                Double valorTemp = this.genSubs.Redondea(this.met99Datos.lstPrimaEG.get(0) / 24.0, 0);
                txtPrima = this.genSubs.FormatoNumDouble("###,###", valorTemp);
                break;
            }
            case "CRcomp": {
                Double valorTemp = this.genSubs.Redondea(this.met99Datos.lstPrimaCR.get(0) / 24.0, 0);
                txtPrima = this.genSubs.FormatoNumDouble("###,###", valorTemp);
                break;
            }
            case "PHX": {
                Double valorTemp = this.genSubs.Redondea(this.met99Datos.lstPrimaPHX.get(0) / 24.0, 0);
                txtPrima = this.genSubs.FormatoNumDouble("###,###", valorTemp);
            }
        }
        if (txtPrima.equals("0")) {
            txtPrima = "-";
        }
        return txtPrima;
    }

    private void DefineDocumento() {
        this.margenIzq = Float.valueOf(10.0f);
        this.margenDer = Float.valueOf(10.0f);
        this.tarifarioDoc = new Document();
        this.tarifarioDoc.setCreator("Ramos Tecnolog\u00eda y Herramientas, S.C.");
        this.tarifarioDoc.setAuthor("Fenando Ramos S.");
        this.tarifarioDoc.setTitle("Provida");
        this.dimensions = new PageDimensions(PageSize.LETTER, PageOrientation.LANDSCAPE);
        this.dimensions.setLeftMargin(this.margenIzq.floatValue());
        this.dimensions.setTopMargin(5.0f);
        this.dimensions.setRightMargin(this.margenDer.floatValue());
        this.dimensions.setBottomMargin(5.0f);
        this.anchoColumna = Float.valueOf(30.0f);
        if (this.numCoberturas == 1) {
            this.anchoColumna = Float.valueOf(50.0f);
        }
    }

    private void DefineTemplate() {
        String ubicacionLogoProducto;
        Integer tmpInt = 0;
        String textoPie = "Material para uso exclusivo de la fuerza de ventas de MetLife";
        Template template = new Template();
        Image logo1Met = null;
        try {
            logo1Met = new Image("src/Img/MetLife fondo blanco.gif", 20.0f, 0.0f);
        }
        catch (Exception e2) {
            System.out.println("Mensaje: " + e2);
            this.genSubs.MuestraMensaje("No encuentra imagen MetLife fondo blanco.gif", "Provids");
        }
        if (this.met99Datos.productoSeleccionado.equals("Met99")) {
            if (this.met99Datos.esVida360.booleanValue()) {
                ubicacionLogoProducto = "src/Img/LogoVida360.jpg";
                tmpInt = 285;
            } else {
                ubicacionLogoProducto = "src/Img/LogoMet99.jpg";
                tmpInt = 240;
            }
        } else if (this.met99Datos.productoSeleccionado.equals("Maestro20")) {
            ubicacionLogoProducto = "src/Img/LogoMaestro20.jpg";
            tmpInt = 270;
        } else {
            ubicacionLogoProducto = "src/Img/LogoPT20.jpg";
            tmpInt = 240;
        }
        Image logoMet99 = null;
        String tmpString = this.met99Datos.ocupacionSel.equals("Seleccione una ocupaci\u00f3n") ? "Ocupaci\u00f3n no especificada" : this.met99Datos.ocupacionSel;
        try {
            logoMet99 = new Image(ubicacionLogoProducto, 180.0f, 5.0f);
            this.texto1 = new TextArea("- " + tmpString, tmpInt.intValue(), 10.0f, 520.0f, 100.0f);
        }
        catch (Exception e3) {
            System.out.println("Mensaje: " + e3);
            this.genSubs.MuestraMensaje("No encuentra imagen " + ubicacionLogoProducto, "Provida");
        }
        Image logoPromotor = null;
        Float posicionLogoPromotor = Float.valueOf(this.anchoPag.floatValue() - this.met99Datos.anchoLogo.floatValue() - this.margenIzq.floatValue());
        try {
            logoPromotor = new Image("src/Logos/" + this.met99Datos.nombreLogo + ".jpg", posicionLogoPromotor.floatValue(), 0.0f);
        }
        catch (Exception e4) {
            System.out.println("Mensaje: " + e4);
            this.genSubs.MuestraMensaje("No encuentra imagen " + this.met99Datos.nombreLogo, "Provida");
        }
        logoPromotor.setWidth(this.met99Datos.anchoLogo.floatValue());
        logoPromotor.setHeight(this.met99Datos.altoLogo.floatValue());
        template.getElements().add(logo1Met);
        template.getElements().add(logoMet99);
        template.getElements().add(this.texto1);
        template.getElements().add(logoPromotor);
        this.tblPie = this.genSubs.CreaTablaEstandar(this.anchoPag, Float.valueOf(20.0f));
        this.tblPie.getColumns().add(this.anchoPag.floatValue() - 5.0f);
        this.tblPie.getBorder().getTop().setWidth(0.0f);
        this.tblPie.getBorder().getBottom().setWidth(0.0f);
        this.renPie = this.genSubs.CreaRenglonEstandar(this.tblPie, this.fontSize);
        this.renPie.getCellDefault().getBorder().getTop().setWidth(0.0f);
        this.renPie.getCellDefault().getBorder().getBottom().setWidth(0.0f);
        this.renPie.getCellDefault().setAlign(TextAlign.CENTER);
        this.renPie.getCells().add(textoPie);
        this.tblPie.setX(0.0f);
        this.tblPie.setY(this.altoPag.floatValue() - 13.0f);
        template.getElements().add(this.tblPie);
        this.tarifarioDoc.setTemplate(template);
    }

    private void DefineTablas() {
        Integer n;
        Integer j;
        int i;
        String txtEP = "";
        this.numSumasAseguradas = this.hayOtrasCob.booleanValue() ? Integer.valueOf((this.sumaFinal - this.sumaInicial) / this.sumaIncremento + 1) : (this.hayEG.booleanValue() || this.hayCR.booleanValue() ? (this.hayEG.booleanValue() ? Integer.valueOf((this.sumaFinalEG - this.sumaInicialEG) / this.sumaIncrementoEG + 1) : Integer.valueOf((this.sumaFinalCR - this.sumaInicialCR) / this.sumaIncrementoCR + 1)) : Integer.valueOf(1));
        this.numTablas = this.numSumasAseguradas * 2;
        this.tblTarifario.clear();
        this.tblEdades.clear();
        this.tblTitTarifario.clear();
        this.colorClaro.clear();
        this.colorOscuro.clear();
        RgbColor colorBlanco = new RgbColor(255, 255, 255);
        RgbColor colorTemp = new RgbColor(54, 96, 146);
        this.colorClaro.add(colorTemp);
        colorTemp = new RgbColor(22, 54, 92);
        this.colorOscuro.add(colorTemp);
        colorTemp = new RgbColor(255, 102, 0);
        this.colorClaro.add(colorTemp);
        colorTemp = new RgbColor(153, 0, 0);
        this.colorOscuro.add(colorTemp);
        colorTemp = new RgbColor(54, 96, 146);
        this.colorClaro.add(colorTemp);
        colorTemp = new RgbColor(22, 54, 92);
        this.colorOscuro.add(colorTemp);
        colorTemp = new RgbColor(51, 204, 51);
        this.colorClaro.add(colorTemp);
        colorTemp = new RgbColor(0, 153, 0);
        this.colorOscuro.add(colorTemp);
        Integer numColor = -1;
        for (i = 0; i < this.numSumasAseguradas; ++i) {
            if ((numColor = Integer.valueOf(numColor + 1)) > 3) {
                numColor = 0;
            }
            Integer ultimaCelda = 0;
            this.tblEdades.add(this.genSubs.CreaTablaEstandar(this.anchoColumna, this.altoPag));
            this.tblEdades.get(i).getColumns().add(this.anchoColumna.floatValue());
            this.tblEdades.get(i).getColumns().getColumn2(0).getCellDefault().getBorder().getRight().setWidth(0.5f);
            j = this.edadInicial;
            while (j <= this.edadFinal) {
                this.renEdades = this.genSubs.CreaRenglonEstandar(this.tblEdades.get(i), this.fontSize);
                this.renEdades.getCellDefault().setAlign(TextAlign.CENTER);
                this.renEdades.getCellDefault().setBackgroundColor(this.colorClaro.get(numColor));
                this.renEdades.getCellDefault().setTextColor(colorBlanco);
                if (j % 2 == 0) {
                    // empty if block
                }
                this.renEdades.getCells().add(j.toString());
                Integer n2 = j;
                n = j = Integer.valueOf(j + 1);
            }
            this.tblTitTarifario.add(this.genSubs.CreaTablaEstandar(this.anchoPag, Float.valueOf(100.0f)));
            for (int k = 1; k <= this.numCoberturas * 2 + 1; ++k) {
                if (k % this.numCoberturas == 0) {
                    this.tblTitTarifario.get(i).getColumns().add(this.anchoColumna.floatValue() + 0.5f);
                    continue;
                }
                this.tblTitTarifario.get(i).getColumns().add(this.anchoColumna.floatValue());
            }
            Integer sumaActual = this.sumaInicial + i * this.sumaIncremento;
            Boolean continuar = true;
            block12: for (int k = 1; k <= 7; ++k) {
                continuar = true;
                if (k == 6) {
                    continuar = false;
                } else if (k == 2 || k == 3) {
                    continuar = this.chkAP.isSelected() || this.chkGFH.isSelected() ? Boolean.valueOf(true) : Boolean.valueOf(false);
                }
                if (k == 4 && !this.hayOtrasCob.booleanValue()) {
                    continuar = false;
                }
                if (!continuar.booleanValue()) continue;
                this.renTitTarifario = this.genSubs.CreaRenglonEstandar(this.tblTitTarifario.get(i), this.fontSize);
                switch (k) {
                    case 1: {
                        txtEP = "Prima Quincenal. Extraprimas: " + this.met99Datos.txtSuscripcion;
                        this.renTitTarifario.getCells().add(txtEP, this.numCoberturas * 2 + 1);
                        this.renTitTarifario.getCellDefault().setFontSize(10.0f);
                        this.renTitTarifario.getCellDefault().getBorder().getBottom().setWidth(0.5f);
                        this.renTitTarifario.getCellDefault().setBackgroundColor(this.colorClaro.get(numColor));
                        this.renTitTarifario.getCellDefault().setTextColor(colorBlanco);
                        this.renTitTarifario.getCellDefault().getBorder().getBottom().setLineStyle(LineStyle.getDots());
                        this.renTitTarifario.getCellDefault().getBorder().getBottom().setColor(colorBlanco);
                        continue block12;
                    }
                    case 2: {
                        this.renTitTarifario.getCellDefault().setAlign(TextAlign.CENTER);
                        this.renTitTarifario.getCellDefault().setBackgroundColor(this.colorClaro.get(numColor));
                        this.renTitTarifario.getCellDefault().setTextColor(colorBlanco);
                        if (this.chkAP.isSelected()) {
                            this.renTitTarifario.getCellDefault().setBackgroundColor(this.colorClaro.get(numColor));
                            this.renTitTarifario.getCellDefault().setTextColor(colorBlanco);
                            Double valorTemp = this.met99Datos.tarAPbasicoConPFT * (double)this.met99Datos.sumaAPbasico.intValue() / 24000.0;
                            valorTemp = this.genSubs.Redondea(valorTemp, 0);
                            if (this.met99Datos.esVida360.booleanValue()) {
                                this.renTitTarifario.getCells().add(" ", 2);
                                this.renTitTarifario.getCells().add(" ", 1);
                            } else {
                                this.renTitTarifario.getCells().add("AP B\u00e1sico: ", 2);
                                this.renTitTarifario.getCells().add(this.genSubs.FormatoNumDouble("###", valorTemp), 1);
                            }
                        } else {
                            this.renTitTarifario.getCells().add(" ", 2);
                            this.renTitTarifario.getCells().add(" ", 1);
                        }
                        if (this.chkGFH.isSelected()) {
                            this.renTitTarifario.getCells().add("GFH", 1);
                            this.renTitTarifario.getCells().add("1 Hijo", 1);
                            this.renTitTarifario.getCells().add("2 Hijos", 1);
                            this.renTitTarifario.getCells().add("3 Hijos", 1);
                            this.renTitTarifario.getCells().add(" ", this.numCoberturas * 4 + 1 - 8);
                            continue block12;
                        }
                        this.renTitTarifario.getCells().add(" ", 1);
                        this.renTitTarifario.getCells().add(" ", 1);
                        this.renTitTarifario.getCells().add(" ", 1);
                        this.renTitTarifario.getCells().add(" ", 1);
                        continue block12;
                    }
                    case 3: {
                        Integer valorTempSuma;
                        this.renTitTarifario.getCellDefault().setAlign(TextAlign.CENTER);
                        this.renTitTarifario.getCellDefault().setBackgroundColor(this.colorClaro.get(numColor));
                        this.renTitTarifario.getCellDefault().setTextColor(colorBlanco);
                        if (0.35 * (double)sumaActual.intValue() < (double)this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFH")).intValue()) {
                            valorTempSuma = 0;
                        } else if (this.optGFminima.isSelected()) {
                            valorTempSuma = this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFH"));
                        } else {
                            valorTempSuma = (int)(0.35 * (double)sumaActual.intValue() + 0.5);
                            if (valorTempSuma > this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("GFH"))) {
                                valorTempSuma = this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("GFH"));
                            }
                            if (valorTempSuma < this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFH"))) {
                                valorTempSuma = 0;
                            }
                        }
                        this.met99Datos.edadCalculoTitular = 15;
                        this.tablas.CargaTarifasMet99();
                        Double tarGF1 = this.genSubs.Redondea(this.met99Datos.tarGFH1 * (double)valorTempSuma.intValue() / 24000.0, 0);
                        Double tarGF2 = this.genSubs.Redondea(this.met99Datos.tarGFH2 * (double)valorTempSuma.intValue() / 24000.0, 0);
                        Double tarGF3 = this.genSubs.Redondea(this.met99Datos.tarGFH3 * (double)valorTempSuma.intValue() / 24000.0, 0);
                        if (this.chkAP.isSelected()) {
                            this.renTitTarifario.getCells().add("AP Extra: ", 2);
                            this.renTitTarifario.getCells().add(this.genSubs.FormatoNumDouble("###", this.met99Datos.tarAPextraConPFT * (double)this.met99Datos.sumaAPextra.intValue() / 24000.0), 1);
                        } else {
                            this.renTitTarifario.getCells().add(" ", 2);
                            this.renTitTarifario.getCells().add(" ", 1);
                        }
                        if (this.chkGFH.isSelected()) {
                            this.renTitTarifario.getCells().add(this.genSubs.FormatoNumInteger("###,###", valorTempSuma), 1);
                            this.renTitTarifario.getCells().add(this.genSubs.FormatoNumDouble("###", tarGF1), 1);
                            this.renTitTarifario.getCells().add(this.genSubs.FormatoNumDouble("###", tarGF2), 1);
                            this.renTitTarifario.getCells().add(this.genSubs.FormatoNumDouble("###", tarGF3), 1);
                            this.renTitTarifario.getCells().add(" ", this.numCoberturas * 4 + 1 - 8);
                        } else {
                            this.renTitTarifario.getCells().add(" ", 1);
                            this.renTitTarifario.getCells().add(" ", 1);
                            this.renTitTarifario.getCells().add(" ", 1);
                            this.renTitTarifario.getCells().add(" ", 1);
                            this.renTitTarifario.getCells().add(" ", this.numCoberturas * 4 + 1 - 8);
                        }
                        this.renTitTarifario.getCellDefault().getBorder().getBottom().setWidth(0.5f);
                        this.renTitTarifario.getCellDefault().getBorder().getBottom().setLineStyle(LineStyle.getDots());
                        this.renTitTarifario.getCellDefault().getBorder().getBottom().setColor(colorBlanco);
                        continue block12;
                    }
                    case 4: {
                        this.renTitTarifario.getCellDefault().setBackgroundColor(this.colorClaro.get(numColor));
                        this.renTitTarifario.getCellDefault().setTextColor(colorBlanco);
                        this.renTitTarifario.getCellDefault().getBorder().getBottom().setLineStyle(LineStyle.getDots());
                        this.renTitTarifario.getCellDefault().getBorder().getBottom().setColor(colorBlanco);
                        this.renTitTarifario.getCells().add("", 1);
                        this.renTitTarifario.getCells().getCell2(0).getBorder().getRight().setWidth(0.0f);
                        this.renTitTarifario.getCells().getCell2(0).getBorder().getLeft().setWidth(0.0f);
                        this.renTitTarifario.getCells().getCell2(0).getBorder().getTop().setWidth(0.0f);
                        this.renTitTarifario.getCells().add("Suma Asegurada: " + this.genSubs.FormatoNumInteger("###,###", sumaActual), this.numCoberturas * 4);
                        this.renTitTarifario.getCellDefault().setAlign(TextAlign.CENTER);
                        this.renTitTarifario.getCellDefault().setFontSize(this.fontSize.floatValue() + 1.0f);
                        this.renTitTarifario.getCellDefault().getBorder().getBottom().setWidth(0.25f);
                        continue block12;
                    }
                    case 5: {
                        this.renTitTarifario.getCellDefault().setBackgroundColor(this.colorOscuro.get(numColor));
                        this.renTitTarifario.getCellDefault().setTextColor(colorBlanco);
                        this.renTitTarifario.getCells().add("Sexo", 1);
                        this.renTitTarifario.getCells().getCell2(0).getBorder().getRight().setWidth(0.5f);
                        this.renTitTarifario.getCells().getCell2(0).getBorder().getRight().setLineStyle(LineStyle.getDots());
                        this.renTitTarifario.getCells().getCell2(0).getBorder().getRight().setColor(colorBlanco);
                        this.renTitTarifario.getCells().getCell2(0).getBorder().getLeft().setWidth(0.0f);
                        this.renTitTarifario.getCells().getCell2(0).getBorder().getTop().setWidth(0.0f);
                        this.renTitTarifario.getCells().add("Hombre", this.numCoberturas * 1);
                        this.renTitTarifario.getCells().getCell2(1).getBorder().getRight().setWidth(0.5f);
                        this.renTitTarifario.getCells().getCell2(1).getBorder().getLeft().setWidth(0.0f);
                        this.renTitTarifario.getCells().getCell2(1).getBorder().getTop().setWidth(0.0f);
                        this.renTitTarifario.getCells().getCell2(1).getBorder().getRight().setLineStyle(LineStyle.getDots());
                        this.renTitTarifario.getCells().getCell2(1).getBorder().getRight().setColor(colorBlanco);
                        this.renTitTarifario.getCellDefault().setAlign(TextAlign.CENTER);
                        this.renTitTarifario.getCells().add("Mujer", this.numCoberturas * 1);
                        this.renTitTarifario.getCellDefault().getBorder().getBottom().setWidth(0.25f);
                        this.renTitTarifario.getCellDefault().getBorder().getBottom().setLineStyle(LineStyle.getDots());
                        this.renTitTarifario.getCellDefault().getBorder().getBottom().setColor(colorBlanco);
                        continue block12;
                    }
                    case 6: {
                        this.renTitTarifario.getCellDefault().setBackgroundColor(this.colorClaro.get(numColor));
                        this.renTitTarifario.getCellDefault().setTextColor(colorBlanco);
                        this.renTitTarifario.getCells().add("H\u00e1bito", 1);
                        this.renTitTarifario.getCells().getCell2(0).getBorder().getRight().setWidth(0.5f);
                        this.renTitTarifario.getCells().getCell2(0).getBorder().getLeft().setWidth(0.0f);
                        this.renTitTarifario.getCells().getCell2(0).getBorder().getTop().setWidth(0.0f);
                        this.renTitTarifario.getCells().getCell2(0).getBorder().getRight().setLineStyle(LineStyle.getDots());
                        this.renTitTarifario.getCells().getCell2(0).getBorder().getRight().setColor(colorBlanco);
                        this.renTitTarifario.getCellDefault().setAlign(TextAlign.CENTER);
                        this.renTitTarifario.getCells().add("Fumador", (int)this.numCoberturas);
                        this.renTitTarifario.getCells().getCell2(1).getBorder().getRight().setWidth(0.5f);
                        this.renTitTarifario.getCells().getCell2(1).getBorder().getLeft().setWidth(0.0f);
                        this.renTitTarifario.getCells().getCell2(1).getBorder().getTop().setWidth(0.0f);
                        this.renTitTarifario.getCells().getCell2(1).getBorder().getRight().setLineStyle(LineStyle.getDots());
                        this.renTitTarifario.getCells().getCell2(1).getBorder().getRight().setColor(colorBlanco);
                        this.renTitTarifario.getCells().add(" No Fumador", (int)this.numCoberturas);
                        this.renTitTarifario.getCells().getCell2(2).getBorder().getRight().setWidth(0.5f);
                        this.renTitTarifario.getCells().getCell2(2).getBorder().getLeft().setWidth(0.0f);
                        this.renTitTarifario.getCells().getCell2(2).getBorder().getTop().setWidth(0.0f);
                        this.renTitTarifario.getCells().getCell2(2).getBorder().getRight().setLineStyle(LineStyle.getDots());
                        this.renTitTarifario.getCells().getCell2(2).getBorder().getRight().setColor(colorBlanco);
                        this.renTitTarifario.getCells().add("Fumador", (int)this.numCoberturas);
                        this.renTitTarifario.getCells().getCell2(3).getBorder().getRight().setWidth(0.5f);
                        this.renTitTarifario.getCells().getCell2(3).getBorder().getLeft().setWidth(0.0f);
                        this.renTitTarifario.getCells().getCell2(3).getBorder().getTop().setWidth(0.0f);
                        this.renTitTarifario.getCells().add(" No Fumador", (int)this.numCoberturas);
                        this.renTitTarifario.getCellDefault().getBorder().getBottom().setWidth(0.25f);
                        this.renTitTarifario.getCellDefault().getBorder().getBottom().setLineStyle(LineStyle.getDots());
                        this.renTitTarifario.getCellDefault().getBorder().getBottom().setColor(colorBlanco);
                        this.renTitTarifario.getCells().getCell2(3).getBorder().getRight().setLineStyle(LineStyle.getDots());
                        this.renTitTarifario.getCells().getCell2(3).getBorder().getRight().setColor(colorBlanco);
                        continue block12;
                    }
                    case 7: {
                        this.DefineSumaGF(sumaActual);
                        this.sumaEG = this.hayEG != false ? this.genSubs.FormatoNumInteger("###,###", this.sumaInicialEG + this.sumaIncrementoEG * i) : "";
                        this.sumaCR = this.hayCR != false ? this.genSubs.FormatoNumInteger("###,###", this.sumaInicialCR + this.sumaIncrementoCR * i) : "";
                        this.sumaPHT = this.hayPHT != false ? "1,000" : "";
                        this.sumaPHX = this.hayPHX != false ? "1,000" : "";
                        for (int n3 = 0; n3 < 2; ++n3) {
                            this.renTitTarifario.getCellDefault().setBackgroundColor(this.colorClaro.get(numColor));
                            this.renTitTarifario.getCellDefault().setTextColor(colorBlanco);
                            if (n3 == 0) {
                                this.renTitTarifario.getCells().add("Cob.", 1);
                                this.renTitTarifario.getCells().getCell2(0).getBorder().getRight().setWidth(0.5f);
                                this.renTitTarifario.getCells().getCell2(0).getBorder().getLeft().setWidth(0.0f);
                                this.renTitTarifario.getCells().getCell2(0).getBorder().getTop().setWidth(0.0f);
                                this.renTitTarifario.getCells().getCell2(0).getBorder().getBottom().setWidth(0.0f);
                                this.renTitTarifario.getCells().getCell2(0).getBorder().getRight().setLineStyle(LineStyle.getDots());
                                this.renTitTarifario.getCells().getCell2(0).getBorder().getRight().setColor(colorBlanco);
                            }
                            for (int m = 0; m < this.numCoberturas; ++m) {
                                if (this.nombreCobertura.get(m).equals("GFT") || this.nombreCobertura.get(m).equals("GFC") || this.nombreCobertura.get(m).equals("GFH") || this.nombreCobertura.get(m).equals("GFX")) {
                                    this.renTitTarifario.getCells().add(this.nombreCobertura.get(m) + " " + this.sumaGF);
                                } else if (this.nombreCobertura.get(m).equals("EGT") || this.nombreCobertura.get(m).equals("CRT") || this.nombreCobertura.get(m).equals("EGX") || this.nombreCobertura.get(m).equals("CRX")) {
                                    if (this.nombreCobertura.get(m).equals("EGT") || this.nombreCobertura.get(m).equals("EGX")) {
                                        this.renTitTarifario.getCells().add(this.nombreCobertura.get(m) + " " + this.sumaEG);
                                    } else {
                                        this.renTitTarifario.getCells().add(this.nombreCobertura.get(m) + " " + this.sumaCR);
                                    }
                                } else if (this.nombreCobertura.get(m).equals("PHT") || this.nombreCobertura.get(m).equals("PHX")) {
                                    this.renTitTarifario.getCells().add(this.nombreCobertura.get(m) + " " + this.sumaPHT);
                                } else {
                                    this.renTitTarifario.getCells().add(this.nombreCobertura.get(m));
                                }
                                ultimaCelda = ultimaCelda + 1;
                            }
                            if (n3 >= 3) continue;
                            this.renTitTarifario.getCells().getCell2(ultimaCelda).getBorder().getRight().setWidth(0.5f);
                            this.renTitTarifario.getCells().getCell2(ultimaCelda).getBorder().getRight().setLineStyle(LineStyle.getDots());
                            this.renTitTarifario.getCells().getCell2(ultimaCelda).getBorder().getRight().setColor(colorBlanco);
                            this.renTitTarifario.getCells().getCell2(ultimaCelda).getBorder().getLeft().setWidth(0.0f);
                            this.renTitTarifario.getCells().getCell2(ultimaCelda).getBorder().getTop().setWidth(0.0f);
                            this.renTitTarifario.getCells().getCell2(ultimaCelda).getBorder().getBottom().setWidth(0.0f);
                        }
                        this.renTitTarifario.getCellDefault().setAlign(TextAlign.CENTER);
                    }
                }
            }
        }
        for (i = 0; i < this.numTablas; ++i) {
            this.tblTarifario.add(this.genSubs.CreaTablaEstandar(this.anchoPag, this.altoPag));
            for (int j2 = 1; j2 <= this.numCoberturas; ++j2) {
                this.tblTarifario.get(i).getColumns().add(this.anchoColumna.floatValue());
                if (j2 != this.numCoberturas || (i + 1) % 4 == 0) continue;
                this.tblTarifario.get(i).getColumns().getColumn2(j2 - 1).getCellDefault().getBorder().getRight().setWidth(0.5f);
            }
            j = this.edadInicial;
            while (j <= this.edadFinal) {
                this.renTarifario = this.genSubs.CreaRenglonEstandar(this.tblTarifario.get(i), this.fontSize);
                this.renTarifario.getCellDefault().setAlign(TextAlign.CENTER);
                if (j % 2 == 0) {
                    this.renTarifario.getCellDefault().setBackgroundColor(RgbColor.getLightGrey());
                }
                for (int k = 1; k <= this.numCoberturas; ++k) {
                    this.renTarifario.getCells().add("-", 1);
                }
                Integer n4 = j;
                n = j = Integer.valueOf(j + 1);
            }
        }
    }

    private void DefineSumaGF(Integer suma) {
        Integer valorTemp = 0;
        if (this.met99Datos.productoSeleccionado.equals("PT20")) {
            if (0.35 * (double)suma.intValue() < (double)this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFC")).intValue()) {
                valorTemp = 0;
            } else if (this.optGFminima.isSelected()) {
                valorTemp = this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFC"));
            } else {
                valorTemp = (int)(0.35 * (double)suma.intValue() + 0.5);
                if (valorTemp > this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("GFC"))) {
                    valorTemp = this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("GFC"));
                }
                if (valorTemp < this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFC"))) {
                    valorTemp = 0;
                }
            }
        } else if (0.35 * (double)suma.intValue() < (double)this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFA")).intValue()) {
            valorTemp = 0;
        } else if (this.optGFminima.isSelected()) {
            valorTemp = this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFA"));
        } else {
            valorTemp = (int)(0.35 * (double)suma.intValue() + 0.5);
            if (valorTemp > this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("GFA"))) {
                valorTemp = this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("GFA"));
            }
            if (valorTemp < this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFA"))) {
                valorTemp = 0;
            }
        }
        this.sumaGF = valorTemp > 0 ? this.genSubs.FormatoNumInteger("###,###", valorTemp) : "    ------";
    }

    private void DefineSumaCRyEG(Integer suma) {
    }

    private void EscribeTarifario() {
        Float posicionInicialX;
        Float currentX = Float.valueOf(0.0f);
        Float currentY = Float.valueOf(40.0f);
        Integer indexTbl = 0;
        Integer tablasPorSuma = this.numTablas / this.numSumasAseguradas;
        Float anchoDeTablaPorSuma = Float.valueOf(this.tblEdades.get(0).getVisibleWidth() + this.tblTarifario.get(0).getVisibleWidth() * 2.0f);
        Integer numSumasPorPag = 0;
        Float anchoTablasPorPag = Float.valueOf(0.0f);
        for (int i = 1; i <= this.numSumasAseguradas; ++i) {
            if (!((anchoTablasPorPag = Float.valueOf(anchoTablasPorPag.floatValue() + anchoDeTablaPorSuma.floatValue())).floatValue() < this.anchoPag.floatValue())) continue;
            numSumasPorPag = numSumasPorPag + 1;
        }
        Float anchoTotalSumasPorPag = Float.valueOf(anchoDeTablaPorSuma.floatValue() * (float)numSumasPorPag.intValue() + (float)(5 * (numSumasPorPag - 1)));
        currentX = posicionInicialX = Float.valueOf((this.anchoPag.floatValue() - anchoTotalSumasPorPag.floatValue()) / 2.0f);
        Integer numSumasEscritas = 0;
        for (int s = 0; s < this.numSumasAseguradas; ++s) {
            Float espacioLibre = Float.valueOf(this.anchoPag.floatValue() - currentX.floatValue());
            Float espacioNecesario = Float.valueOf(this.tblTarifario.get(indexTbl).getVisibleWidth() * 2.0f + 5.0f);
            currentY = Float.valueOf(40.0f);
            if (espacioLibre.floatValue() < espacioNecesario.floatValue()) {
                this.PaginaNueva();
                currentX = this.numSumasAseguradas - numSumasEscritas >= numSumasPorPag ? posicionInicialX : Float.valueOf((this.anchoPag.floatValue() - (float)(this.numSumasAseguradas - numSumasEscritas) * anchoDeTablaPorSuma.floatValue()) / 2.0f);
                currentY = Float.valueOf(40.0f);
            }
            this.tblTitTarifario.get(s).setX(currentX.floatValue());
            this.tblTitTarifario.get(s).setY(currentY.floatValue());
            this.pagTarifario.getElements().add(this.tblTitTarifario.get(s));
            currentY = Float.valueOf(currentY.floatValue() + this.tblTitTarifario.get(s).getVisibleHeight());
            this.tblEdades.get(s).setX(currentX.floatValue());
            this.tblEdades.get(s).setY(currentY.floatValue());
            this.pagTarifario.getElements().add(this.tblEdades.get(s));
            currentX = Float.valueOf(currentX.floatValue() + (this.tblEdades.get(s).getVisibleWidth() + 0.5f));
            for (int i = 0; i < tablasPorSuma; ++i) {
                this.tblTarifario.get(indexTbl).setX(currentX.floatValue());
                this.tblTarifario.get(indexTbl).setY(currentY.floatValue());
                this.pagTarifario.getElements().add(this.tblTarifario.get(indexTbl));
                currentX = Float.valueOf(currentX.floatValue() + (this.tblTarifario.get(indexTbl).getVisibleWidth() + 0.5f));
                indexTbl = indexTbl + 1;
            }
            numSumasEscritas = numSumasEscritas + 1;
            currentX = Float.valueOf(currentX.floatValue() + 5.0f);
        }
        this.DibujaPDF();
        this.AbreTarifario();
    }

    private void DibujaPDF() {
        String nombreArchivo = "";
        nombreArchivo = this.met99Datos.esVida360 != false ? "TarifarioVida360.pdf" : (this.met99Datos.productoSeleccionado == "Met99" ? "TarifarioMet99.pdf" : (this.met99Datos.productoSeleccionado == "Maestro20" ? "TarifarioM20.pdf" : "TarifarioPT20.pdf"));
        this.errorPDF = false;
        String rutaUser = System.getProperty("user.home") + File.separator + nombreArchivo;
        Path pathArchivo = Paths.get(rutaUser, new String[0]);
        if (Files.exists(pathArchivo, new LinkOption[0])) {
            try {
                Files.delete(pathArchivo);
                this.tarifarioDoc.draw(rutaUser);
            }
            catch (IOException x2) {
                System.err.println(x2);
                this.genSubs.MuestraMensaje("Por favor cierre la cotizaci\u00f3n anterior", "TarifarioMet99");
                this.errorPDF = true;
            }
        } else {
            this.tarifarioDoc.draw(rutaUser);
            this.errorPDF = false;
        }
    }

    private void PaginaNueva() {
        this.pagTarifario = new Page(this.dimensions);
        this.tarifarioDoc.getPages().add(this.pagTarifario);
        this.numPag = this.numPag + 1;
        this.altoPag = Float.valueOf(this.pagTarifario.getDimensions().getBody().getHeight());
        this.anchoPag = Float.valueOf(this.pagTarifario.getDimensions().getBody().getWidth() - this.margenIzq.floatValue() - this.margenDer.floatValue());
    }

    private void InicializaValores() {
        this.met99Datos.selBIT = false;
        this.met99Datos.selCII = false;
        this.met99Datos.selCMA = false;
        this.met99Datos.selTIBA = false;
        this.met99Datos.selCAT = false;
        this.met99Datos.selGFA = false;
        this.met99Datos.selGE = false;
        this.met99Datos.selAP = false;
        this.met99Datos.selEG = false;
        this.met99Datos.selCR = false;
        this.met99Datos.selPHT = false;
        this.met99Datos.selBACY = false;
        this.met99Datos.selGFC = false;
        this.met99Datos.selBCAC = false;
        this.met99Datos.selGFH = false;
        this.met99Datos.sumaBIT = 0.0;
        this.met99Datos.sumaCII = 0;
        this.met99Datos.sumaCMA = 0;
        this.met99Datos.sumaTIBA = 0;
        this.met99Datos.sumaCAT = 0;
        this.met99Datos.sumaGFA = 0;
        this.met99Datos.sumaGE = 0;
        this.met99Datos.sumaAP = 0;
        this.met99Datos.sumaEG = 0;
        this.met99Datos.sumaCR = 0;
        this.met99Datos.sumaPHT = 0;
        this.met99Datos.sumaBACY = 0;
        this.met99Datos.sumaGFC = 0;
        this.met99Datos.sumaBCAC = 0;
        this.met99Datos.sumaGFH = 0;
        this.met99Datos.primaExcedente = 0.0;
        this.met99Datos.ftpSel = 1;
        this.met99Datos.optSuma = true;
    }

    public void RegresaInicio() {
        this.met99Datos.txtInicio = "PrimeraVez";
        this.stage = (Stage)this.imgInicio.getScene().getWindow();
        this.MostrarVentana("Provida.fxml");
    }

    public void RegresaDatosPersonales() {
        this.met99Datos.regresaDeTarifario = true;
        this.met99Datos.numComp = 0;
        this.BorraDatosComp();
        this.stage = (Stage)this.imgInicio.getScene().getWindow();
        this.MostrarVentana("Met99DPer.fxml");
    }

    private void MostrarVentana(String nombreVentana) {
        try {
            this.root = (Parent)FXMLLoader.load((URL)this.getClass().getResource(nombreVentana));
        }
        catch (Exception e2) {
            System.out.println("No pudo cargar " + nombreVentana + " error: " + e2);
        }
        Scene scene = new Scene(this.root);
        this.stage.setScene(scene);
        this.stage.show();
    }

    private void ValidaDatos() {
        this.hayError = false;
        this.msgError = "";
        this.hayEG = false;
        this.hayCR = false;
        if (this.chkEG.isSelected() || this.chkEGcomp.isSelected()) {
            this.hayEG = true;
        }
        if (this.chkCR.isSelected() || this.chkCRcomp.isSelected()) {
            this.hayCR = true;
        }
        this.sumaInicial = 0;
        this.sumaFinal = 0;
        this.sumaIncremento = 0;
        this.sumaInicialEG = 0;
        this.sumaFinalEG = 0;
        this.sumaIncrementoEG = 0;
        this.sumaInicialCR = 0;
        this.sumaFinalCR = 0;
        this.sumaIncrementoCR = 0;
        this.sumaInicial = this.ValidaSuma(this.genSubs.QuitaComas(this.sumaIni.getText()), "Suma inicial incorrecta");
        this.sumaFinal = this.ValidaSuma(this.genSubs.QuitaComas(this.sumaFin.getText()), "Suma final incorrecta");
        this.sumaIncremento = this.ValidaSuma(this.genSubs.QuitaComas(this.sumaInc.getText()), "Suma incremento incorrecta");
        this.edadInicial = this.ValidaSuma(this.genSubs.QuitaComas(this.edadIni.getText()), "Edad inicial incorrecta");
        this.edadFinal = this.ValidaSuma(this.genSubs.QuitaComas(this.edadFin.getText()), "Edad final incorrecta");
        if (this.hayEG.booleanValue()) {
            this.sumaInicialEG = this.ValidaSuma(this.genSubs.QuitaComas(this.sumaIniEG.getText()), "Suma inicial EG incorrecta");
            this.sumaFinalEG = this.ValidaSuma(this.genSubs.QuitaComas(this.sumaFinEG.getText()), "Suma final EG incorrecta");
            this.sumaIncrementoEG = this.ValidaSuma(this.genSubs.QuitaComas(this.sumaIncEG.getText()), "Suma incremento EG incorrecta");
        }
        if (this.hayCR.booleanValue()) {
            this.sumaInicialCR = this.ValidaSuma(this.genSubs.QuitaComas(this.sumaIniCR.getText()), "Suma inicial CR incorrecta");
            this.sumaFinalCR = this.ValidaSuma(this.genSubs.QuitaComas(this.sumaFinCR.getText()), "Suma final CR incorrecta");
            this.sumaIncrementoCR = this.ValidaSuma(this.genSubs.QuitaComas(this.sumaIncCR.getText()), "Suma incremento CR incorrecta");
        }
        this.DeterminaCoberturasSeleccionadas();
        if (!this.hayError.booleanValue()) {
            if (this.edadInicial < 15 || this.edadInicial > 80) {
                this.hayError = true;
                this.msgError = this.msgError + "Edad inicial fuera de rango.\rLas edades deben estar entre 15 y 70.\r";
            }
            if (this.edadFinal < 15 || this.edadFinal > 80) {
                this.hayError = true;
                this.msgError = this.msgError + "Edad final fuera de rango.\rLas edades deben estar entre 15 y 70.\r";
            }
            if (this.edadInicial > this.edadFinal) {
                this.hayError = true;
                this.msgError = this.msgError + "Edad inicial mayor que edad finalo.\r";
            }
            if (this.hayEG.booleanValue() && (this.sumaInicialEG < 30000 || this.sumaInicialEG > 100000)) {
                this.hayError = true;
                this.msgError = this.msgError + "Suma inicial EG fuera de rango.\r";
            }
            if (this.hayEG.booleanValue() && (this.sumaFinalEG < 30000 || this.sumaFinalEG > 100000)) {
                this.hayError = true;
                this.msgError = this.msgError + "Suma final EG fuera de rango.\r";
            }
            if (this.hayCR.booleanValue() && (this.sumaInicialCR < 15000 || this.sumaInicialCR > 30000)) {
                this.hayError = true;
                this.msgError = this.msgError + "Suma inicial CR fuera de rango.\r";
            }
            if (this.hayCR.booleanValue() && (this.sumaFinalCR < 15000 || this.sumaFinalCR > 30000)) {
                this.hayError = true;
                this.msgError = this.msgError + "Suma final CR fuera de rango.\r";
            }
            if (this.met99Datos.sumaLimitada.booleanValue() && (this.sumaInicial > this.met99Datos.impSumaLimitada || this.sumaFinal > this.met99Datos.impSumaLimitada)) {
                this.hayError = true;
                this.msgError = this.msgError + "Suma m\u00e1xima para esta ocupaci\u00f3n: " + this.met99Datos.impSumaLimitada + "\r";
            }
        }
    }

    private Integer ValidaSuma(String valorTxt, String errorTxt) {
        Integer valorInt = 0;
        if (!this.genSubs.EsNumeroEntero(valorTxt).booleanValue()) {
            this.hayError = true;
            this.msgError = this.msgError + errorTxt;
        } else {
            valorInt = Integer.parseInt(valorTxt);
        }
        return valorInt;
    }

    private void DeterminaCoberturasSeleccionadas() {
        this.numCoberturas = 0;
        this.idCobertura.clear();
        this.nombreCobertura.clear();
        Integer index = 0;
        if (this.chkBAS.isSelected()) {
            this.numCoberturas = this.numCoberturas + 1;
            index = index + 1;
            this.idCobertura.add("BAS");
            this.nombreCobertura.add("BAS");
        }
        if (this.chkCII.isSelected()) {
            this.numCoberturas = this.numCoberturas + 1;
            index = index + 1;
            this.idCobertura.add("CII");
            this.nombreCobertura.add("CII");
        }
        if (this.chkCMA.isSelected()) {
            this.numCoberturas = this.numCoberturas + 1;
            index = index + 1;
            this.idCobertura.add("CMA");
            this.nombreCobertura.add("CMA");
        }
        if (this.chkTIBA.isSelected()) {
            this.numCoberturas = this.numCoberturas + 1;
            index = index + 1;
            this.idCobertura.add("TIBA");
            this.nombreCobertura.add("TIBA");
        }
        if (this.chkCAT.isSelected()) {
            this.numCoberturas = this.numCoberturas + 1;
            index = index + 1;
            this.idCobertura.add("CAT");
            this.nombreCobertura.add("CAT");
        }
        if (this.chkGF.isSelected()) {
            this.numCoberturas = this.numCoberturas + 1;
            index = index + 1;
            this.idCobertura.add("GF");
            this.nombreCobertura.add("GFT");
        }
        if (this.chkGE.isSelected()) {
            this.numCoberturas = this.numCoberturas + 1;
            index = index + 1;
            this.idCobertura.add("GE");
            this.nombreCobertura.add("GE");
        }
        if (this.chkEG.isSelected()) {
            this.numCoberturas = this.numCoberturas + 1;
            index = index + 1;
            this.idCobertura.add("EG");
            this.nombreCobertura.add("EGT");
        }
        if (this.chkCR.isSelected()) {
            this.numCoberturas = this.numCoberturas + 1;
            index = index + 1;
            this.idCobertura.add("CR");
            this.nombreCobertura.add("CRT");
        }
        if (this.chkBACY.isSelected()) {
            this.numCoberturas = this.numCoberturas + 1;
            index = index + 1;
            this.idCobertura.add("BACY");
            this.nombreCobertura.add("BACY");
        }
        if (this.chkGFC.isSelected()) {
            this.numCoberturas = this.numCoberturas + 1;
            index = index + 1;
            this.idCobertura.add("GFC");
            this.nombreCobertura.add("GFC");
        }
        if (this.chkBAC.isSelected()) {
            this.numCoberturas = this.numCoberturas + 1;
            index = index + 1;
            this.idCobertura.add("BAC");
            this.nombreCobertura.add("BAC");
        }
        if (this.chkBCAC.isSelected()) {
            this.numCoberturas = this.numCoberturas + 1;
            index = index + 1;
            this.idCobertura.add("BCAC");
            this.nombreCobertura.add("CAX");
        }
        if (this.chkGFcomp.isSelected()) {
            this.numCoberturas = this.numCoberturas + 1;
            index = index + 1;
            this.idCobertura.add("GFcomp");
            this.nombreCobertura.add("GFX");
        }
        if (this.chkEGcomp.isSelected()) {
            this.numCoberturas = this.numCoberturas + 1;
            index = index + 1;
            this.idCobertura.add("EGcomp");
            this.nombreCobertura.add("EGX");
        }
        if (this.chkCRcomp.isSelected()) {
            this.numCoberturas = this.numCoberturas + 1;
            index = index + 1;
            this.idCobertura.add("CRcomp");
            this.nombreCobertura.add("CRX");
        }
        if (this.chkPHT.isSelected()) {
            this.numCoberturas = this.numCoberturas + 1;
            index = index + 1;
            this.idCobertura.add("PHT");
            this.nombreCobertura.add("PHT");
        }
        if (this.chkPHX.isSelected()) {
            this.numCoberturas = this.numCoberturas + 1;
            index = index + 1;
            this.idCobertura.add("PHX");
            this.nombreCobertura.add("PHX");
        }
        if (this.numCoberturas == 0) {
            this.hayError = true;
            this.msgError = this.msgError + "Seleccione al menos una cobertura";
        }
        if (this.numCoberturas > 6) {
            this.hayError = true;
            this.msgError = this.msgError + "M\u00e1ximo 6 coberturas seleccionadas";
        }
    }

    private void RevisaCoberturasSeleccionadas() {
        this.hayEG = false;
        this.hayCR = false;
        this.hayOtrasCob = false;
        this.hayPHT = false;
        this.hayPHX = false;
        if (this.chkEG.isSelected() || this.chkEGcomp.isSelected()) {
            this.hayEG = true;
        }
        if (this.chkCR.isSelected() || this.chkCRcomp.isSelected()) {
            this.hayCR = true;
        }
        if (this.chkPHT.isSelected()) {
            this.hayPHT = true;
        }
        if (this.chkBAS.isSelected() || this.chkCII.isSelected() || this.chkCMA.isSelected() || this.chkTIBA.isSelected()) {
            this.hayOtrasCob = true;
        }
        if (this.chkCAT.isSelected() || this.chkGF.isSelected() || this.chkGE.isSelected() || this.chkAP.isSelected()) {
            this.hayOtrasCob = true;
        }
        if (this.chkBACY.isSelected()) {
            this.hayOtrasCob = true;
        }
        if (this.chkGFC.isSelected() || this.chkGFH.isSelected() || this.chkGE.isSelected() || this.chkBAC.isSelected()) {
            this.hayOtrasCob = true;
        }
        if (this.chkBCAC.isSelected() || this.chkGFcomp.isSelected()) {
            this.hayOtrasCob = true;
        }
        if (this.chkPHT.isSelected()) {
            this.hayPHT = true;
        }
        if (this.chkPHX.isSelected()) {
            this.hayPHX = true;
        }
    }

    public void RevisaSiHayEGoCR() {
        if (this.chkEG.isSelected() || this.chkEGcomp.isSelected()) {
            this.lblSumaEG.setVisible(true);
            this.sumaIniEG.setVisible(true);
            this.sumaFinEG.setVisible(true);
            this.sumaIncEG.setVisible(true);
        } else {
            this.lblSumaEG.setVisible(false);
            this.sumaIniEG.setVisible(false);
            this.sumaFinEG.setVisible(false);
            this.sumaIncEG.setVisible(false);
        }
        if (this.chkCR.isSelected() || this.chkCRcomp.isSelected()) {
            this.lblSumaCR.setVisible(true);
            this.sumaIniCR.setVisible(true);
            this.sumaFinCR.setVisible(true);
            this.sumaIncCR.setVisible(true);
        } else {
            this.lblSumaCR.setVisible(false);
            this.sumaIniCR.setVisible(false);
            this.sumaFinCR.setVisible(false);
            this.sumaIncCR.setVisible(false);
        }
    }

    private void InicializaObjetos() {
        this.ctlVisible.clear();
        switch (this.met99Datos.productoSeleccionado) {
            case "Met99": {
                this.ctlVisible = this.met99Datos.esVida360 != false ? this.met99Datos.Vida360VisibleTar : this.met99Datos.Met99VisibleTar;
                this.lblSumaEG.setVisible(true);
                this.sumaIniEG.setVisible(true);
                this.sumaFinEG.setVisible(true);
                this.lblSumaCR.setVisible(true);
                this.sumaIniCR.setVisible(true);
                this.sumaFinCR.setVisible(true);
                this.lblConyuge.setVisible(true);
                this.lblHijos.setVisible(true);
                this.lblComp.setVisible(true);
                if (this.met99Datos.esVida360.booleanValue()) {
                    this.imgLogoProducto = new javafx.scene.image.Image("Img/LogoMetLifeVida360.jpg");
                    this.logoProducto.setImage(this.imgLogoProducto);
                    break;
                }
                this.imgLogoProducto = new javafx.scene.image.Image("Img/LogoMetLifeMet99.jpg");
                this.logoProducto.setImage(this.imgLogoProducto);
                break;
            }
            case "Maestro20": {
                this.ctlVisible = this.met99Datos.Maestro20VisibleTar;
                this.lblSumaEG.setVisible(false);
                this.sumaIniEG.setVisible(false);
                this.sumaFinEG.setVisible(false);
                this.lblSumaCR.setVisible(false);
                this.sumaIniCR.setVisible(false);
                this.sumaFinCR.setVisible(false);
                this.lblConyuge.setVisible(false);
                this.lblHijos.setVisible(false);
                this.lblComp.setVisible(false);
                this.imgLogoProducto = new javafx.scene.image.Image("Img/LogoMetLifeMaestro20.jpg");
                this.logoProducto.setImage(this.imgLogoProducto);
                break;
            }
            case "PT20": {
                this.ctlVisible = this.met99Datos.PT20VisibleTar;
                this.lblSumaEG.setVisible(false);
                this.sumaIniEG.setVisible(false);
                this.sumaFinEG.setVisible(false);
                this.lblSumaCR.setVisible(false);
                this.sumaIniCR.setVisible(false);
                this.sumaFinCR.setVisible(false);
                this.lblConyuge.setVisible(true);
                this.lblHijos.setVisible(true);
                this.lblComp.setVisible(true);
                this.imgLogoProducto = new javafx.scene.image.Image("Img/LogoMetLifePT20.jpg");
                this.logoProducto.setImage(this.imgLogoProducto);
            }
        }
        this.AsignaVisible(this.chkCII, "CII");
        this.AsignaVisible(this.chkCMA, "CMA");
        this.AsignaVisible(this.chkTIBA, "TIBA");
        this.AsignaVisible(this.chkCAT, "CAT");
        this.AsignaVisible(this.chkGF, "GF");
        this.AsignaVisible(this.chkGE, "GE");
        this.AsignaVisible(this.chkAP, "AP");
        this.AsignaVisible(this.chkEG, "EG");
        this.AsignaVisible(this.chkCR, "CR");
        this.AsignaVisible(this.chkBACY, "BACY");
        this.AsignaVisible(this.chkGFC, "GFC");
        this.AsignaVisible(this.chkGFH, "GFH");
        this.AsignaVisible(this.chkBAC, "BAC");
        this.AsignaVisible(this.chkBCAC, "BCAC");
        this.AsignaVisible(this.chkGFcomp, "GFcomp");
        this.AsignaVisible(this.chkEGcomp, "EGcomp");
        this.AsignaVisible(this.chkCRcomp, "CRcomp");
        this.PosicionaControles();
    }

    private void AsignaVisible(CheckBox chkCob, String idCob) {
        Integer visible = this.ctlVisible.get(this.genSubs.IndiceCtlVisibleTar(idCob));
        if (visible == 1) {
            chkCob.setVisible(true);
        } else {
            chkCob.setVisible(false);
        }
    }

    private void PosicionaControles() {
        this.ctlPosicionX.clear();
        this.ctlPosicionY.clear();
        switch (this.met99Datos.productoSeleccionado) {
            case "Met99": {
                if (this.met99Datos.esVida360.booleanValue()) {
                    this.ctlPosicionX = this.met99Datos.Met99Xtar;
                    this.ctlPosicionY = this.met99Datos.Met99Ytar;
                    break;
                }
                this.ctlPosicionX = this.met99Datos.Met99Xtar;
                this.ctlPosicionY = this.met99Datos.Met99Ytar;
                break;
            }
            case "Maestro20": {
                this.ctlPosicionX = this.met99Datos.Maestro20Xtar;
                this.ctlPosicionY = this.met99Datos.Maestro20Ytar;
                break;
            }
            case "PT20": {
                this.ctlPosicionX = this.met99Datos.PT20Xtar;
                this.ctlPosicionY = this.met99Datos.PT20Ytar;
            }
        }
        if (this.chkCII.isVisible()) {
            this.Posicion(this.chkCII, "chkCII");
        }
        if (this.chkCMA.isVisible()) {
            this.Posicion(this.chkCMA, "chkCMA");
        }
        if (this.chkTIBA.isVisible()) {
            this.Posicion(this.chkTIBA, "chkTIBA");
        }
        if (this.chkCAT.isVisible()) {
            this.Posicion(this.chkCAT, "chkCAT");
        }
        if (this.chkGF.isVisible()) {
            this.Posicion(this.chkGF, "chkGFA");
        }
        if (this.chkGE.isVisible()) {
            this.Posicion(this.chkGE, "chkGE");
        }
        if (this.chkAP.isVisible()) {
            this.Posicion(this.chkAP, "chkAP");
        }
        if (this.chkEG.isVisible()) {
            this.Posicion(this.chkEG, "chkEG");
        }
        if (this.chkCR.isVisible()) {
            this.Posicion(this.chkCR, "chkCR");
        }
        if (this.chkBACY.isVisible()) {
            this.Posicion(this.chkBACY, "chkBACY");
        }
        if (this.chkGFC.isVisible()) {
            this.Posicion(this.chkGFC, "chkGFC");
        }
        if (this.chkGFH.isVisible()) {
            this.Posicion(this.chkGFH, "chkGFH");
        }
        if (this.chkBAC.isVisible()) {
            this.Posicion(this.chkBAC, "chkBAC");
        }
        if (this.chkBCAC.isVisible()) {
            this.Posicion(this.chkBCAC, "chkBCAC");
        }
        if (this.chkGFcomp.isVisible()) {
            this.Posicion(this.chkGFcomp, "chkGFcomp");
        }
        if (this.chkEGcomp.isVisible()) {
            this.Posicion(this.chkEGcomp, "chkEGcomp");
        }
        if (this.chkCRcomp.isVisible()) {
            this.Posicion(this.chkCRcomp, "chkCRcomp");
        }
    }

    private void Posicion(CheckBox ctlChk, String idChk) {
        ctlChk.layoutXProperty().setValue((Number)this.ctlPosicionX.get(this.genSubs.IndiceCtlPosicionTar(idChk)));
        ctlChk.layoutYProperty().setValue((Number)this.ctlPosicionY.get(this.genSubs.IndiceCtlPosicionTar(idChk)));
    }

    private void AbreTarifario() {
        String nombreArchivo = "";
        nombreArchivo = this.met99Datos.esVida360 != false ? "TarifarioVida360.pdf" : (this.met99Datos.productoSeleccionado == "Met99" ? "TarifarioMet99.pdf" : (this.met99Datos.productoSeleccionado == "Maestro20" ? "TarifarioM20.pdf" : "TarifarioPT20.pdf"));
        String rutaUser = System.getProperty("user.home") + File.separator + nombreArchivo;
        if (Desktop.isDesktopSupported()) {
            try {
                File myFile = new File(rutaUser);
                Desktop.getDesktop().open(myFile);
            }
            catch (IOException e2) {
                this.genSubs.MuestraMensaje("Es necesario tener instalado Adobe Acrobat Reader", "TarifarioMet99");
            }
        }
    }

    public void Salir() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Provida");
        alert.setHeaderText("");
        alert.setContentText("\u00bfEst\u00e1 seguro de salir del cotizador?");
        Optional result = alert.showAndWait();
        if (result.get() == ButtonType.OK) {
            Platform.exit();
        }
    }
}

