/*
 * Decompiled with CFR 0.152.
 */
package provida;

import com.cete.dynamicpdf.Document;
import com.cete.dynamicpdf.Font;
import com.cete.dynamicpdf.Grayscale;
import com.cete.dynamicpdf.Page;
import com.cete.dynamicpdf.PageDimensions;
import com.cete.dynamicpdf.PageOrientation;
import com.cete.dynamicpdf.PageSize;
import com.cete.dynamicpdf.RgbColor;
import com.cete.dynamicpdf.Template;
import com.cete.dynamicpdf.TextAlign;
import com.cete.dynamicpdf.VAlign;
import com.cete.dynamicpdf.pageelements.Image;
import com.cete.dynamicpdf.pageelements.Row2;
import com.cete.dynamicpdf.pageelements.Table2;
import com.cete.dynamicpdf.pageelements.TextArea;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import provida.GenSubs;
import provida.MemoriaCalculo;
import provida.Met99Datos;

public class Met99Imprime {
    private static Met99Imprime met99Imprime = new Met99Imprime();
    private Met99Datos met99Datos = Met99Datos.getInstance();
    private GenSubs genSubs = GenSubs.getInstance();
    private MemoriaCalculo memoriaCalculo = MemoriaCalculo.getInstance();
    public String nombreTitular;
    public Integer edadRealTitular;
    public Integer edadRealConyuge;
    private String txtConyuge;
    private String txtHijos;
    private String txtComp;
    private List<Float> anchoCol = new ArrayList<Float>();
    private Float posInicial = Float.valueOf(50.0f);
    private Float alturaTblCoberturas;
    private Float alturaTblPry;
    private Float alturaRen;
    private Integer numPag;
    private Float posDT;
    private Float posTitCob;
    private Float alturaLogo;
    private Float alturaDT;
    private Float alturaTitCob;
    private Float alturaTitPry;
    private Float alturaPag;
    private Float currentY;
    private Float gapTablas;
    private Float espacioRestante;
    private Float iniciaCoberturas;
    private PageDimensions dimensions;
    private PageDimensions dimensionsMem;
    private String titEP;
    private Double primaDiaria;
    private Double primaConExc;
    private Double primaFPago;
    private Row2 rowMem;
    private Table2 tblMem;
    private Table2 tblMemTit;
    private Row2 rowMemTit;
    private String txtHabito;
    private String txtSexo;
    private String encabezadoTitular;
    private Document met99Doc;
    private Integer indiceCobDes;
    Integer renRequisitos;
    Integer colRequisitos;
    Boolean errorPDF = false;
    Page pageMet99;
    private Table2 tblDT;
    private Row2 RenDT;
    private Table2 tblCoberturas;
    private Row2 RenCob;
    private Table2 tblTitCob;
    private Row2 RenTitCob;
    private Table2 tblPry;
    private Row2 RenPry;
    private Table2 tblTitPry;
    private Table2 tblTitPry2;
    private Row2 RenTitPry;
    private Row2 RenTitPry2;
    private Table2 tblDesCob;
    private Row2 RenDesCob;
    private Table2 tblTitDesCob;
    private Table2 tblTitDesCob2;
    private Row2 RenTitDesCob;
    private Row2 RenTitDesCob2;
    private Table2 tblRequisitos;
    private Row2 RenRequisitos;
    private String txtRequisito;
    private TextArea texto1;
    private String textoVar;
    private Table2 tblDatosAgente;
    private Row2 RenDatosAgente;
    private Table2 tblPrueba;
    private Row2 RenPrueba;

    private Met99Imprime() {
    }

    public static Met99Imprime getInstance() {
        return met99Imprime;
    }

    public void GeneraCotizacion() {
        this.txtHabito = "No fuma";
        if ("S".equals(this.met99Datos.fumaTitular)) {
            this.txtHabito = "Fuma";
        }
        this.txtSexo = "Femenino";
        if ("M".equals(this.met99Datos.sexoTitular)) {
            this.txtSexo = "Masculino";
        }
        this.encabezadoTitular = this.met99Datos.productoSeleccionado.equals("Met99") ? (this.met99Datos.ftpSel == 1 ? "Coberturas con devoluci\u00f3n de primas (PFT)." : "Coberturas sin devoluci\u00f3n de primas (PFT).") : (this.met99Datos.productoSeleccionado.equals("Maestro20") ? (this.met99Datos.ftpSel == 1 ? "Coberturas con devoluci\u00f3n de primas (DPF)." : "Coberturas sin devoluci\u00f3n de primas (DPF).") : "");
        this.encabezadoTitular = this.met99Datos.optNueva != false ? this.encabezadoTitular + " Cotizaci\u00f3n para p\u00f3liza nueva" : this.encabezadoTitular + " Cotizaci\u00f3n para incrementos e inclusiones";
        this.anchoCol.clear();
        for (int i = 0; i < 10; ++i) {
            this.anchoCol.add(Float.valueOf(50.0f));
        }
        this.ColumnasParaCoberturas();
        this.met99Doc = new Document();
        this.met99Doc.setCreator("Ramos Tecnolog\u00eda y Herramientas, S.C.");
        this.met99Doc.setAuthor("Fenando Ramos S.");
        this.met99Doc.setTitle("Met99");
        this.dimensions = new PageDimensions(PageSize.LETTER, PageOrientation.PORTRAIT);
        this.dimensions.setLeftMargin(56.7f);
        this.dimensions.setTopMargin(14.18f);
        this.dimensions.setRightMargin(56.7f);
        this.dimensions.setBottomMargin(56.7f);
        this.alturaRen = Float.valueOf(14.2f);
        this.gapTablas = Float.valueOf(10.0f);
        Template template = new Template();
        String ubicacionLogoProducto = this.met99Datos.productoSeleccionado.equals("Met99") ? (this.met99Datos.esVida360.booleanValue() ? "src/Img/LogoMetLifeVida360.jpg" : "src/Img/LogoMetLifeMet99.jpg") : (this.met99Datos.productoSeleccionado.equals("Maestro20") ? "src/Img/LogoMetLifeMaestro20.jpg" : "src/Img/LogoMetLifePT20.jpg");
        Image logoMet99 = null;
        try {
            logoMet99 = new Image(ubicacionLogoProducto, 0.0f, 10.0f);
        }
        catch (Exception e2) {
            System.out.println("Mensaje: " + e2);
            this.genSubs.MuestraMensaje("No encuentra imagen " + ubicacionLogoProducto, "Provida");
        }
        Image logoPromotor = null;
        Float margenLogo = Float.valueOf(500.0f - this.met99Datos.anchoLogo.floatValue() - 10.0f);
        try {
            logoPromotor = new Image("src/Logos/" + this.met99Datos.nombreLogo + ".jpg", margenLogo.floatValue(), 0.0f);
        }
        catch (Exception e3) {
            System.out.println("Mensaje: " + e3);
            this.genSubs.MuestraMensaje("No encuentra imagen " + this.met99Datos.nombreLogo, "Provida");
        }
        logoPromotor.setWidth(this.met99Datos.anchoLogo.floatValue());
        logoPromotor.setHeight(this.met99Datos.altoLogo.floatValue());
        template.getElements().add(logoMet99);
        template.getElements().add(logoPromotor);
        Float posTexto = Float.valueOf(margenLogo.floatValue() + (this.met99Datos.anchoLogo.floatValue() - 100.0f) / 2.0f);
        if (!this.met99Datos.nombreLogo.equals("MetLife")) {
            TextArea textArea = new TextArea("Agente Autorizado MetLife", posTexto.floatValue(), 40.0f, 100.0f, 10.0f, Font.getHelvetica(), 7.0f, TextAlign.CENTER);
            template.getElements().add(textArea);
        }
        this.met99Doc.setTemplate(template);
        this.posDT = Float.valueOf(50.0f);
        this.posTitCob = Float.valueOf(75.0f);
        this.alturaLogo = Float.valueOf(40.0f);
        this.alturaDT = Float.valueOf(35.0f);
        this.alturaTitCob = Float.valueOf(22.0f);
        this.alturaTitPry = Float.valueOf(45.0f);
        Float anchoDesCob = Float.valueOf(498.0f);
        this.tblDT = this.CreaTabla(this.posDT, 9, Float.valueOf(502.4f), Float.valueOf(60.0f));
        this.ConstruyeTblDT();
        this.tblTitCob = this.CreaTabla(this.posTitCob, 9, Float.valueOf(502.4f), Float.valueOf(22.68f));
        this.ConstruyeTblTitCob();
        this.tblCoberturas = this.CreaTabla(Float.valueOf(97.0f), 9, Float.valueOf(502.4f), Float.valueOf(600.0f));
        this.ConstruyeTblCoberturas();
        this.ColumnasParaProyeccion();
        this.tblTitPry = this.CreaTabla(Float.valueOf(107.0f), 6, anchoDesCob, Float.valueOf(600.0f));
        this.tblTitPry2 = this.CreaTabla(Float.valueOf(107.0f), 6, anchoDesCob, Float.valueOf(600.0f));
        this.ConstruyeTblTitPry();
        this.ConstruyeTblTitPry2();
        this.tblPry = this.CreaTabla(Float.valueOf(120.0f), 6, anchoDesCob, Float.valueOf(600.0f));
        this.ConstruyeTblPry();
        this.tblDesCob = new Table2(0.0f, 0.0f, anchoDesCob.floatValue(), 600.0f);
        this.tblDesCob.getCellDefault().getPadding().setValue(2.0f);
        this.tblDesCob.setCellSpacing(0.5f);
        this.tblDesCob.getBorder().setWidth(0.0f);
        this.tblDesCob.getBorder().getTop().setColor(RgbColor.getBlack());
        this.tblDesCob.getBorder().getBottom().setColor(RgbColor.getBlack());
        this.tblDesCob.getBorder().getTop().setWidth(0.5f);
        this.tblDesCob.getBorder().getBottom().setWidth(0.5f);
        this.tblDesCob.getColumns().add(anchoDesCob.floatValue());
        this.tblTitDesCob = new Table2(0.0f, 0.0f, anchoDesCob.floatValue(), 50.0f);
        this.tblTitDesCob.getCellDefault().getPadding().setValue(2.0f);
        this.tblTitDesCob.setCellSpacing(0.5f);
        this.tblTitDesCob.getBorder().setWidth(0.0f);
        this.tblTitDesCob.getBorder().getTop().setColor(RgbColor.getBlack());
        this.tblTitDesCob.getBorder().getBottom().setColor(RgbColor.getBlack());
        this.tblTitDesCob.getBorder().getTop().setWidth(0.5f);
        this.tblTitDesCob.getBorder().getBottom().setWidth(0.5f);
        this.tblTitDesCob.getColumns().add(anchoDesCob.floatValue());
        this.tblTitDesCob2 = new Table2(0.0f, 0.0f, anchoDesCob.floatValue(), 50.0f);
        this.tblTitDesCob2.getCellDefault().getPadding().setValue(2.0f);
        this.tblTitDesCob2.setCellSpacing(0.5f);
        this.tblTitDesCob2.getBorder().setWidth(0.0f);
        this.tblTitDesCob2.getBorder().getTop().setColor(RgbColor.getBlack());
        this.tblTitDesCob2.getBorder().getBottom().setColor(RgbColor.getBlack());
        this.tblTitDesCob2.getBorder().getTop().setWidth(0.5f);
        this.tblTitDesCob2.getBorder().getBottom().setWidth(0.5f);
        this.tblTitDesCob2.getColumns().add(anchoDesCob.floatValue());
        this.tblRequisitos = new Table2(0.0f, 0.0f, anchoDesCob.floatValue(), 300.0f);
        this.tblRequisitos.getCellDefault().getPadding().setValue(2.0f);
        this.tblRequisitos.setCellSpacing(0.5f);
        this.tblRequisitos.getBorder().setWidth(0.0f);
        this.tblRequisitos.getBorder().getTop().setColor(RgbColor.getBlack());
        this.tblRequisitos.getBorder().getBottom().setColor(RgbColor.getBlack());
        this.tblRequisitos.getBorder().getTop().setWidth(0.5f);
        this.tblRequisitos.getBorder().getBottom().setWidth(0.5f);
        this.tblRequisitos.getColumns().add(anchoDesCob.floatValue() / 3.0f);
        this.tblRequisitos.getColumns().add(anchoDesCob.floatValue() / 3.0f);
        this.tblRequisitos.getColumns().add(anchoDesCob.floatValue() / 3.0f);
        this.tblDatosAgente = new Table2(0.0f, 0.0f, anchoDesCob.floatValue(), 300.0f);
        this.tblDatosAgente.getCellDefault().getPadding().setValue(2.0f);
        this.tblDatosAgente.setCellSpacing(0.5f);
        this.tblDatosAgente.getBorder().setWidth(0.0f);
        this.tblDatosAgente.getBorder().getTop().setColor(RgbColor.getBlack());
        this.tblDatosAgente.getBorder().getBottom().setColor(RgbColor.getBlack());
        this.tblDatosAgente.getBorder().getTop().setWidth(0.0f);
        this.tblDatosAgente.getBorder().getBottom().setWidth(0.0f);
        this.tblDatosAgente.getColumns().add(70.0f);
        this.tblDatosAgente.getColumns().add(160.0f);
        this.tblDatosAgente.getColumns().add(160.0f);
        this.tblDatosAgente.getColumns().add(anchoDesCob.floatValue() - 395.0f);
        this.ConstruyeTblTitDesCob();
        this.ConstruyeTblTitDesCob2();
        this.ConstruyeTblDesCob();
        this.ConstruyeTblRequisitos();
        this.ConstruyeTblDatosAgente();
        try {
            this.EscribeTablas();
            this.AbreCotizacion();
        }
        catch (Exception e4) {
            System.out.println("error al generar pdf " + e4);
        }
        if (this.met99Datos.conMemoriaCalculo.booleanValue()) {
            this.memoriaCalculo.GeneraMemoria();
        }
    }

    private Table2 CreaTabla(Float pos, Integer numCols, Float anchoTabla, Float altoTabla) {
        Table2 tbl = new Table2(0.0f, pos.floatValue(), anchoTabla.floatValue(), altoTabla.floatValue());
        tbl.getCellDefault().getPadding().setValue(2.0f);
        tbl.setCellSpacing(0.5f);
        tbl.getBorder().setWidth(0.0f);
        tbl.getBorder().getTop().setColor(RgbColor.getBlack());
        tbl.getBorder().getBottom().setColor(RgbColor.getBlack());
        tbl.getBorder().getTop().setWidth(0.5f);
        tbl.getBorder().getBottom().setWidth(0.5f);
        for (int i = 1; i <= numCols; ++i) {
            tbl.getColumns().add(this.anchoCol.get(i).floatValue());
        }
        return tbl;
    }

    private void ConstruyeTblDT() {
        this.RenDT = this.tblDT.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
        this.RenDT.getCellDefault().getBorder().setWidth(0.0f);
        this.RenDT.getCellDefault().getBorder().getBottom().setWidth(0.1f);
        this.RenDT.getCellDefault().setBackgroundColor(RgbColor.getLightBlue());
        this.RenDT.getCells().add("Titular:");
        this.RenDT.getCells().add(this.met99Datos.nombreTitular, 6);
        this.RenDT.getCells().add("Edad real:");
        this.RenDT.getCells().add(this.met99Datos.edadRealTitular.toString());
        this.RenDT = this.tblDT.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
        this.RenDT.getCellDefault().getBorder().setWidth(0.0f);
        this.RenDT.getCellDefault().setBackgroundColor(RgbColor.getLightBlue());
        this.RenDT.getCells().add("Ocupaci\u00f3n:");
        if (this.met99Datos.indexOcupacionSel == 0) {
            this.RenDT.getCells().add("No especificada", 4);
        } else {
            this.RenDT.getCells().add(this.met99Datos.ocupacionSel, 4);
        }
        this.RenDT.getCells().add("Sexo:");
        this.RenDT.getCells().add(this.txtSexo);
        this.RenDT.getCells().add("Edad c\u00e1lculo:");
        this.RenDT.getCells().add(this.met99Datos.edadCalculoTitular.toString());
        this.tblDT.getColumns().getColumn2(1).getCellDefault().getBorder().getRight().setWidth(0.1f);
        this.tblDT.getColumns().getColumn2(6).getCellDefault().getBorder().getRight().setWidth(0.1f);
    }

    private void ConstruyeTblTitCob() {
        this.RenTitCob = this.tblTitCob.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
        this.RenTitCob.getCellDefault().getBorder().setWidth(0.0f);
        this.RenTitCob.getCellDefault().setVAlign(VAlign.CENTER);
        this.RenTitCob.getCellDefault().setAlign(TextAlign.LEFT);
        this.RenTitCob.getCells().add(this.encabezadoTitular, 6);
        this.RenTitCob.getCells().add("Suma asegurada");
        this.RenTitCob.getCells().add("Prima anual");
        if (this.met99Datos.epVida > 0.0 || this.met99Datos.epInvalidez > 1.0 || this.met99Datos.epAccidentes > 1.0) {
            this.RenTitCob.getCells().add("Extraprima *");
        } else {
            this.RenTitCob.getCells().add("Extraprima");
        }
        this.RenTitCob.getCellDefault().setBackgroundColor(RgbColor.getLightBlue());
    }

    private void ConstruyeTblCoberturas() {
        Boolean tieneCoberturas;
        this.alturaTblCoberturas = Float.valueOf(0.0f);
        this.ConstruyeCobertura(this.met99Datos.selBAS, "BAS", "Cobertura b\u00e1sica por fallecimiento (BAS)", this.met99Datos.sumaBAS, this.met99Datos.primaBAS, this.met99Datos.epBAS);
        this.ConstruyeCobertura(this.met99Datos.selBIT, "BIT", "Exenci\u00f3n del pago de primas por invalidez (BIT)", 1, this.met99Datos.primaBIT, this.met99Datos.epBIT);
        this.ConstruyeCobertura(this.met99Datos.selCII, "CII", "Indemnizaci\u00f3n por invalidez (CII)", this.met99Datos.sumaCII, this.met99Datos.primaCII, this.met99Datos.epCII);
        this.ConstruyeCobertura(this.met99Datos.selCMA, "CMA", "Muerte accidental (CMA)", this.met99Datos.sumaCMA, this.met99Datos.primaCMA, this.met99Datos.epCMA);
        this.ConstruyeCobertura(this.met99Datos.selTIBA, "TIBA", "Triple indemnizaci\u00f3n por muerte accidental (TIBA)", this.met99Datos.sumaTIBA, this.met99Datos.primaTIBA, this.met99Datos.epTIBA);
        this.ConstruyeCobertura(this.met99Datos.selCAT, "CAT", "C\u00e1ncer (CAT)", this.met99Datos.sumaCAT, this.met99Datos.primaCAT, this.met99Datos.epCAT);
        this.ConstruyeCobertura(this.met99Datos.selGFA, "GFA", "Gastos funerarios (GFA)", this.met99Datos.sumaGFA, this.met99Datos.primaGFA, this.met99Datos.epGFA);
        this.ConstruyeCobertura(this.met99Datos.selGE, "GE", "Garant\u00eda escolar (GE)", this.met99Datos.sumaGE, this.met99Datos.primaGE, this.met99Datos.epGE);
        this.ConstruyeCobertura(this.met99Datos.selAP, "AP", "Accidentes personales (AP)", this.met99Datos.optSumaAP, this.met99Datos.primaAP, this.met99Datos.epAP);
        this.ConstruyeCobertura(this.met99Datos.selEG, "EG", "Enfermedades graves (EG)", this.met99Datos.sumaEG, this.met99Datos.primaEG, this.met99Datos.epEG);
        this.ConstruyeCobertura(this.met99Datos.selCR, "CR", "Cirug\u00edas (CR)", this.met99Datos.sumaCR, this.met99Datos.primaCR, this.met99Datos.epCR);
        this.ConstruyeCobertura(this.met99Datos.selPHT, "PHT", "Apoyo por Hospitalizaci\u00f3n (PHT)", this.met99Datos.sumaPHT, this.met99Datos.primaPHT, this.met99Datos.epPHT);
        if (this.met99Datos.productoSeleccionado.equals("PT20")) {
            if (this.met99Datos.edadRealTitular <= 69) {
                if (this.met99Datos.optNueva.booleanValue()) {
                    this.ConstruyeCobertura(true, "ET", "Pago anticipado por enfermedad terminal (ET)", 0, 0.0, 0.0);
                } else if (this.met99Datos.selBAS.booleanValue()) {
                    this.ConstruyeCobertura(true, "ET", "Pago anticipado por enfermedad terminal (ET)", 0, 0.0, 0.0);
                }
            }
        } else if (this.met99Datos.optNueva.booleanValue()) {
            this.ConstruyeCobertura(true, "ET", "Pago anticipado por enfermedad terminal (ET)", 0, 0.0, 0.0);
        } else if (this.met99Datos.selBAS.booleanValue()) {
            this.ConstruyeCobertura(true, "ET", "Pago anticipado por enfermedad terminal (ET)", 0, 0.0, 0.0);
        }
        if (this.met99Datos.epVida > 0.0 || this.met99Datos.epInvalidez > 1.0 || this.met99Datos.epAccidentes > 1.0) {
            this.titEP = "* La prima incluye el monto de las extraprimas";
            this.ConstruyeCobertura(true, "EP", this.titEP, 0, 0.0, 0.0);
        }
        if (this.met99Datos.hayConuge.booleanValue() && (tieneCoberturas = Boolean.valueOf(this.met99Datos.selBACY != false || this.met99Datos.selGFC != false)).booleanValue()) {
            this.RenCob = this.tblCoberturas.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getLightBlue());
            this.alturaTblCoberturas = Float.valueOf(this.alturaTblCoberturas.floatValue() + this.alturaRen.floatValue());
            this.RenCob.getCellDefault().getBorder().setWidth(0.0f);
            this.txtConyuge = "C\u00f3nyuge: " + this.met99Datos.nombreConyuge;
            this.txtConyuge = "M".equals(this.met99Datos.sexoConyuge) ? this.txtConyuge + " Sexo: Masculino" : this.txtConyuge + " Sexo: Femenino";
            this.txtConyuge = this.txtConyuge + " Edad: " + Integer.parseInt(this.met99Datos.edadRealConyuge.toString());
            this.RenCob.getCells().add(this.txtConyuge, 9);
            this.RenCob.getCells().add("");
            this.RenCob.getCells().add("");
            this.RenCob.getCells().add("");
            this.ConstruyeCobertura(this.met99Datos.selBACY, "BACY", "Cobertura conyugal (BACY)", this.met99Datos.sumaBACY, this.met99Datos.primaBACY, this.met99Datos.epBACY);
            this.ConstruyeCobertura(this.met99Datos.selGFC, "GFC", "Gastos funerarios (GFC)", this.met99Datos.sumaGFC, this.met99Datos.primaGFC, this.met99Datos.epGFC);
            this.ConstruyeCobertura(this.met99Datos.selBCAC, "BCAC", "C\u00e1ncer plus (BCAC)", this.met99Datos.sumaBCAC, this.met99Datos.primaBCAC, this.met99Datos.epBCAC);
        }
        if (this.met99Datos.selGFH.booleanValue()) {
            this.RenCob = this.tblCoberturas.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getLightBlue());
            this.alturaTblCoberturas = Float.valueOf(this.alturaTblCoberturas.floatValue() + this.alturaRen.floatValue());
            this.RenCob.getCellDefault().getBorder().setWidth(0.0f);
            this.txtHijos = this.met99Datos.numHijos < 3 ? "N\u00famero de hijos asegurados: " + this.met99Datos.numHijos : "N\u00famero de hijos asegurados: 3 o m\u00e1s";
            this.RenCob.getCells().add(this.txtHijos, 6);
            this.RenCob.getCells().add("");
            this.RenCob.getCells().add("");
            this.RenCob.getCells().add("");
            this.ConstruyeCobertura(this.met99Datos.selGFH, "GFH", "Gastos funerarios (GFH)", this.met99Datos.sumaGFH, this.met99Datos.primaGFH, this.met99Datos.epGFH);
        }
        for (int i = 0; i < this.met99Datos.numComp; ++i) {
            tieneCoberturas = this.met99Datos.lstSelAP.get(i) != false || this.met99Datos.lstSelBAC.get(i) != false || this.met99Datos.lstSelBCAC.get(i) != false || this.met99Datos.lstSelCR.get(i) != false || this.met99Datos.lstSelPHX.get(i) != false || this.met99Datos.lstSelEG.get(i) != false || this.met99Datos.lstSelGF.get(i) != false;
            if (!tieneCoberturas.booleanValue()) continue;
            this.RenCob = this.tblCoberturas.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getLightBlue());
            this.alturaTblCoberturas = Float.valueOf(this.alturaTblCoberturas.floatValue() + this.alturaRen.floatValue());
            this.RenCob.getCellDefault().getBorder().setWidth(0.0f);
            this.txtComp = "Complementario: " + this.met99Datos.lstNombreComp.get(i);
            this.txtComp = this.met99Datos.lstSexoComp.get(i) == "M" ? this.txtComp + ", sexo masculino" : this.txtComp + ", sexo femenino";
            this.txtComp = this.txtComp + ", edad " + this.met99Datos.lstEdadComp.get(i);
            this.RenCob.getCells().add(this.txtComp, 6);
            this.RenCob.getCells().add("");
            this.RenCob.getCells().add("");
            this.RenCob.getCells().add("");
            this.ConstruyeCobertura(this.met99Datos.lstSelBAC.get(i), "BAC", "Cobertura complementaria (BAC)", this.met99Datos.lstSumaBAC.get(i), this.met99Datos.lstPrimaBAC.get(i), this.met99Datos.lstEpBAC.get(i));
            this.ConstruyeCobertura(this.met99Datos.lstSelBCAC.get(i), "BCAC", "C\u00e1ncer complementario (CAX)", this.met99Datos.lstSumaBCAC.get(i), this.met99Datos.lstPrimaBCAC.get(i), this.met99Datos.lstEpBCAC.get(i));
            this.ConstruyeCobertura(this.met99Datos.lstSelAP.get(i), "AP", "Accidentes personales (AP)", this.met99Datos.lstOptSumaAP.get(i), this.met99Datos.lstPrimaAP.get(i), this.met99Datos.lstEpAP.get(i));
            this.ConstruyeCobertura(this.met99Datos.lstSelGF.get(i), "GF", "Gastos funerarios (GF)", this.met99Datos.lstSumaGF.get(i), this.met99Datos.lstPrimaGF.get(i), this.met99Datos.lstEpGF.get(i));
            this.ConstruyeCobertura(this.met99Datos.lstSelEG.get(i), "EG", "Enfermedades graves (EG)", this.met99Datos.lstSumaEG.get(i), this.met99Datos.lstPrimaEG.get(i), this.met99Datos.lstEpEG.get(i));
            this.ConstruyeCobertura(this.met99Datos.lstSelCR.get(i), "CR", "Cirug\u00edas (CR)", this.met99Datos.lstSumaCR.get(i), this.met99Datos.lstPrimaCR.get(i), this.met99Datos.lstEpCR.get(i));
            this.ConstruyeCobertura(this.met99Datos.lstSelPHX.get(i), "PHX", "Apoyo por Hospitalizaci\u00f3n (PHX)", this.met99Datos.lstSumaPHX.get(i), this.met99Datos.lstPrimaPHX.get(i), this.met99Datos.lstEpPHX.get(i));
        }
        this.titEP = "";
        this.primaConExc = this.met99Datos.primaAnualTotal + this.met99Datos.primaExcedente;
        this.primaDiaria = this.primaConExc / 360.0;
        switch (this.met99Datos.formaPago) {
            case "Anual": {
                this.primaFPago = this.primaConExc;
                break;
            }
            case "Mensual": {
                this.primaFPago = this.primaConExc / 12.0;
                break;
            }
            case "Quincenal": {
                this.primaFPago = this.primaConExc / 24.0;
            }
        }
        this.ConstruyeCobertura(true, "TOT", "", 0, 0.0, 0.0);
        this.tblCoberturas.getColumns().getColumn2(1).getCellDefault().getBorder().getRight().setWidth(0.1f);
        this.tblCoberturas.getColumns().getColumn2(2).getCellDefault().getBorder().getRight().setWidth(0.1f);
        this.tblCoberturas.getColumns().getColumn2(3).getCellDefault().getBorder().getRight().setWidth(0.1f);
        this.tblCoberturas.getColumns().getColumn2(4).getCellDefault().getBorder().getRight().setWidth(0.1f);
        this.tblCoberturas.getColumns().getColumn2(5).getCellDefault().getBorder().getRight().setWidth(0.1f);
        this.tblCoberturas.getColumns().getColumn2(6).getCellDefault().getBorder().getRight().setWidth(0.1f);
        this.tblCoberturas.getColumns().getColumn2(7).getCellDefault().getBorder().getRight().setWidth(0.1f);
        this.tblCoberturas.getColumns().getColumn2(6).getCellDefault().setAlign(TextAlign.RIGHT);
        this.tblCoberturas.getColumns().getColumn2(7).getCellDefault().setAlign(TextAlign.RIGHT);
        this.tblCoberturas.getColumns().getColumn2(8).getCellDefault().setAlign(TextAlign.RIGHT);
    }

    private void EscribeTablas() throws IOException {
        this.numPag = 0;
        this.PaginaNueva();
        this.tblTitCob.setY(this.currentY.floatValue());
        this.pageMet99.getElements().add(this.tblTitCob);
        this.currentY = this.NuevaCoordenadaY(this.currentY, this.tblTitCob);
        do {
            this.tblCoberturas.setY(this.currentY.floatValue());
            this.pageMet99.getElements().add(this.tblCoberturas);
            this.currentY = this.NuevaCoordenadaY(this.currentY, this.tblCoberturas);
            this.tblCoberturas = this.tblCoberturas.getOverflowRows();
            if (this.tblCoberturas == null) continue;
            this.PaginaNueva();
            this.tblTitCob.setY(this.currentY.floatValue());
            this.pageMet99.getElements().add(this.tblTitCob);
            this.currentY = this.NuevaCoordenadaY(this.currentY, this.tblTitCob);
        } while (this.tblCoberturas != null);
        if (this.met99Datos.optNueva.booleanValue()) {
            this.EscribePry();
        }
        this.EscribeDesCob();
        this.EscribeRequisitos();
        this.EscribeDatosAgente();
        this.DibujaPDF();
    }

    private Float NuevaCoordenadaY(Float yActual, Table2 tabla) {
        Float yNueva = yActual;
        yNueva = Float.valueOf(yActual.floatValue() + tabla.getVisibleHeight());
        return yNueva;
    }

    private void EscribePry() {
        this.currentY = Float.valueOf(this.currentY.floatValue() + this.gapTablas.floatValue());
        this.espacioRestante = Float.valueOf(this.alturaPag.floatValue() - this.currentY.floatValue());
        if (this.espacioRestante.floatValue() > this.tblTitPry.getVisibleHeight() + this.tblPry.getVisibleHeight()) {
            this.tblTitPry.setY(this.currentY.floatValue());
            this.pageMet99.getElements().add(this.tblTitPry);
            this.currentY = this.NuevaCoordenadaY(this.currentY, this.tblTitPry);
            this.tblPry.setY(this.currentY.floatValue());
            this.pageMet99.getElements().add(this.tblPry);
            this.currentY = this.NuevaCoordenadaY(this.currentY, this.tblPry);
        } else {
            if (this.espacioRestante.floatValue() > 80.0f) {
                this.tblTitPry.setY(this.currentY.floatValue());
                this.pageMet99.getElements().add(this.tblTitPry);
                this.currentY = this.NuevaCoordenadaY(this.currentY, this.tblTitPry);
                this.tblPry.setY(this.currentY.floatValue());
                this.tblPry.setHeight(this.espacioRestante.floatValue() - this.tblTitPry.getVisibleHeight());
                this.pageMet99.getElements().add(this.tblPry);
                this.currentY = this.NuevaCoordenadaY(this.currentY, this.tblPry);
                this.tblPry = this.tblPry.getOverflowRows();
            } else {
                this.PaginaNueva();
                this.tblTitPry.setY(this.currentY.floatValue());
                this.pageMet99.getElements().add(this.tblTitPry);
                this.currentY = this.NuevaCoordenadaY(this.currentY, this.tblTitPry);
                this.tblPry.setY(this.currentY.floatValue());
                this.pageMet99.getElements().add(this.tblPry);
                this.currentY = this.NuevaCoordenadaY(this.currentY, this.tblPry);
                this.tblPry = this.tblPry.getOverflowRows();
            }
            if (this.tblPry != null) {
                this.PaginaNueva();
                this.tblTitPry2.setY(this.currentY.floatValue());
                this.pageMet99.getElements().add(this.tblTitPry2);
                this.currentY = this.NuevaCoordenadaY(this.currentY, this.tblTitPry2);
                this.tblPry.setY(this.currentY.floatValue());
                this.tblPry.setHeight(600.0f);
                this.pageMet99.getElements().add(this.tblPry);
                this.currentY = this.NuevaCoordenadaY(this.currentY, this.tblPry);
            }
        }
        this.textoVar = "Esta proyecci\u00f3n emplea una tasa del " + this.met99Datos.tasaPryAnual;
        this.textoVar = this.textoVar + ". Est\u00e1 elaborado con datos estimados por lo que podr\u00e1 variar al momento de la emisi\u00f3n.";
        this.textoVar = this.textoVar + " El comportamiento de los valores puede variar de acuerdo a las tasas reales.";
        this.textoVar = this.textoVar + " Este e un estudio de seguro, en ning\u00fan momento representa obligaci\u00f3n para MetLife";
        this.texto1 = new TextArea("", 0.0f, this.currentY.floatValue() + 3.0f, 500.0f, 30.0f);
        this.texto1.setText(this.textoVar);
        this.texto1.setFontSize(6.0f);
        this.texto1.setHeight(this.texto1.getRequiredHeight());
        this.espacioRestante = Float.valueOf(this.alturaPag.floatValue() - this.currentY.floatValue());
        if (this.espacioRestante.floatValue() < 30.0f) {
            this.PaginaNueva();
        }
        this.texto1.setY(this.currentY.floatValue() + 3.0f);
        this.pageMet99.getElements().add(this.texto1);
        this.currentY = Float.valueOf(this.currentY.floatValue() + this.texto1.getTextHeight());
    }

    private void EscribeDesCob() {
        this.currentY = Float.valueOf(this.currentY.floatValue() + this.gapTablas.floatValue());
        this.espacioRestante = Float.valueOf(this.alturaPag.floatValue() - this.currentY.floatValue());
        if (this.espacioRestante.floatValue() < 55.0f) {
            this.PaginaNueva();
            this.tblTitDesCob.setY(this.currentY.floatValue());
            this.pageMet99.getElements().add(this.tblTitDesCob);
            this.currentY = this.NuevaCoordenadaY(this.currentY, this.tblTitDesCob);
        } else {
            this.tblTitDesCob.setY(this.currentY.floatValue());
            this.pageMet99.getElements().add(this.tblTitDesCob);
            this.currentY = this.NuevaCoordenadaY(this.currentY, this.tblTitDesCob);
        }
        do {
            this.tblDesCob.setY(this.currentY.floatValue());
            this.espacioRestante = Float.valueOf(this.alturaPag.floatValue() - this.currentY.floatValue());
            this.tblDesCob.setHeight(this.espacioRestante.floatValue());
            this.pageMet99.getElements().add(this.tblDesCob);
            this.currentY = this.NuevaCoordenadaY(this.currentY, this.tblDesCob);
            this.tblDesCob = this.tblDesCob.getOverflowRows();
            if (this.tblDesCob == null) continue;
            this.PaginaNueva();
            this.tblTitDesCob2.setY(this.currentY.floatValue());
            this.pageMet99.getElements().add(this.tblTitDesCob2);
            this.currentY = this.NuevaCoordenadaY(this.currentY, this.tblTitDesCob);
        } while (this.tblDesCob != null);
    }

    private void EscribeRequisitos() {
        this.espacioRestante = Float.valueOf(this.alturaPag.floatValue() - this.currentY.floatValue());
        if (this.espacioRestante.floatValue() < this.tblRequisitos.getVisibleHeight()) {
            this.PaginaNueva();
            this.tblRequisitos.setY(this.currentY.floatValue());
            this.pageMet99.getElements().add(this.tblRequisitos);
            this.currentY = this.NuevaCoordenadaY(this.currentY, this.tblRequisitos);
        } else {
            this.tblRequisitos.setY(this.currentY.floatValue());
            this.pageMet99.getElements().add(this.tblRequisitos);
            this.currentY = this.NuevaCoordenadaY(this.currentY, this.tblRequisitos);
        }
    }

    private void EscribeDatosAgente() {
        this.espacioRestante = Float.valueOf(this.alturaPag.floatValue() - this.currentY.floatValue());
        if (this.espacioRestante.floatValue() < this.tblDatosAgente.getVisibleHeight()) {
            this.PaginaNueva();
            this.tblDatosAgente.setY(this.currentY.floatValue() + 5.0f);
            this.pageMet99.getElements().add(this.tblDatosAgente);
            this.currentY = this.NuevaCoordenadaY(this.currentY, this.tblDatosAgente);
        } else {
            this.tblDatosAgente.setY(this.currentY.floatValue() + 5.0f);
            this.pageMet99.getElements().add(this.tblDatosAgente);
            this.currentY = this.NuevaCoordenadaY(this.currentY, this.tblDatosAgente);
        }
    }

    private void PaginaNueva() {
        this.pageMet99 = new Page(this.dimensions);
        this.met99Doc.getPages().add(this.pageMet99);
        this.numPag = this.numPag + 1;
        this.alturaPag = Float.valueOf(this.pageMet99.getDimensions().getBody().getHeight());
        this.currentY = this.posDT;
        this.pageMet99.getElements().add(this.tblDT);
        this.currentY = Float.valueOf(this.NuevaCoordenadaY(this.currentY, this.tblDT).floatValue() + this.gapTablas.floatValue());
    }

    private void DibujaPDF() {
        String nombreArchivo = "Met99.pdf";
        nombreArchivo = this.met99Datos.esVida360 != false ? "Vida360.pdf" : (this.met99Datos.productoSeleccionado == "Met99" ? "Met99.pdf" : (this.met99Datos.productoSeleccionado == "Maestro20" ? "M20.pdf" : "PT20.pdf"));
        this.errorPDF = false;
        String rutaUser = System.getProperty("user.home") + File.separator + nombreArchivo;
        Path pathArchivo = Paths.get(rutaUser, new String[0]);
        if (Files.exists(pathArchivo, new LinkOption[0])) {
            try {
                Files.delete(pathArchivo);
                this.met99Doc.draw(rutaUser);
            }
            catch (IOException x2) {
                System.err.println(x2);
                this.genSubs.MuestraMensaje("Por favor cierre la cotizaci\u00f3n anterior", "Met99");
                this.errorPDF = true;
            }
        } else {
            this.met99Doc.draw(rutaUser);
            this.errorPDF = false;
        }
    }

    private void AbreCotizacion() {
        String nombreArchivo = "";
        nombreArchivo = this.met99Datos.esVida360 != false ? "Vida360.pdf" : (this.met99Datos.productoSeleccionado == "Met99" ? "Met99.pdf" : (this.met99Datos.productoSeleccionado == "Maestro20" ? "M20.pdf" : "PT20.pdf"));
        String rutaUser = System.getProperty("user.home") + File.separator + nombreArchivo;
        if (Desktop.isDesktopSupported()) {
            try {
                File myFile = new File(rutaUser);
                Desktop.getDesktop().open(myFile);
            }
            catch (IOException e2) {
                this.genSubs.MuestraMensaje("Es necesario tener instalado Adobe Acrobat Reader", "Met99");
            }
        }
    }

    private void ConstruyeCobertura(Boolean cobSel, String idCob, String nombreCob, Integer sumaCob, Double primaCob, Double epCob) {
        if (cobSel.booleanValue()) {
            this.RenCob = this.tblCoberturas.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
            this.alturaTblCoberturas = Float.valueOf(this.alturaTblCoberturas.floatValue() + this.alturaRen.floatValue());
            this.RenCob.getCellDefault().getBorder().setWidth(0.0f);
            switch (idCob) {
                case "BIT": {
                    this.RenCob.getCells().add("");
                    this.RenCob.getCells().add(nombreCob, 5);
                    this.RenCob.getCells().add("Cubierto");
                    this.RenCob.getCells().add(this.genSubs.FormatoNumDouble("###,###", this.genSubs.Redondea(primaCob, 0)));
                    this.RenCob.getCells().add(this.genSubs.FormatoNumDouble("###,###", this.genSubs.Redondea(epCob, 0)));
                    break;
                }
                case "AP": {
                    this.RenCob.getCells().add("");
                    this.RenCob.getCells().add(nombreCob, 5);
                    if (sumaCob == 1) {
                        this.RenCob.getCells().add("Plan b\u00e1sico");
                    } else {
                        this.RenCob.getCells().add("Plan extra");
                    }
                    this.RenCob.getCells().add(this.genSubs.FormatoNumDouble("###,###", this.genSubs.Redondea(primaCob, 0)));
                    this.RenCob.getCells().add(this.genSubs.FormatoNumDouble("###,###", this.genSubs.Redondea(epCob, 0)));
                    break;
                }
                case "TOT": {
                    this.RenCob.getCells().add("Prima excedente anual ", 8);
                    this.RenCob.getCells().getCell2(0).setAlign(TextAlign.RIGHT);
                    this.RenCob.getCells().add(this.genSubs.FormatoNumDouble("###,###", this.genSubs.Redondea(this.met99Datos.primaExcedente, 0)));
                    this.RenCob.getCellDefault().getBorder().getTop().setWidth(0.25f);
                    this.RenCob = this.tblCoberturas.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
                    this.alturaTblCoberturas = Float.valueOf(this.alturaTblCoberturas.floatValue() + this.alturaRen.floatValue());
                    this.RenCob.getCellDefault().getBorder().setWidth(0.0f);
                    this.RenCob.getCells().add("Prima total anual ", 8);
                    this.RenCob.getCells().getCell2(0).setAlign(TextAlign.RIGHT);
                    this.RenCob.getCells().add(this.genSubs.FormatoNumDouble("###,###", this.genSubs.Redondea(this.primaConExc, 0)));
                    if (!"Anual".equals(this.met99Datos.formaPago)) {
                        this.RenCob = this.tblCoberturas.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
                        this.alturaTblCoberturas = Float.valueOf(this.alturaTblCoberturas.floatValue() + this.alturaRen.floatValue());
                        this.RenCob.getCellDefault().getBorder().setWidth(0.0f);
                        this.RenCob.getCells().add("Prima " + this.met99Datos.formaPago + " ", 8);
                        this.RenCob.getCells().getCell2(0).setAlign(TextAlign.RIGHT);
                        this.RenCob.getCells().add(this.genSubs.FormatoNumDouble("###,###", this.genSubs.Redondea(this.primaFPago, 0)));
                        this.RenCob = this.tblCoberturas.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
                        this.alturaTblCoberturas = Float.valueOf(this.alturaTblCoberturas.floatValue() + this.alturaRen.floatValue());
                        this.RenCob.getCellDefault().getBorder().setWidth(0.0f);
                        this.RenCob.getCells().add("Prima diaria ", 8);
                        this.RenCob.getCells().getCell2(0).setAlign(TextAlign.RIGHT);
                        this.RenCob.getCells().add(this.genSubs.FormatoNumDouble("###,###", this.genSubs.Redondea(this.primaDiaria, 0)));
                        this.RenCob = this.tblCoberturas.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
                        this.alturaTblCoberturas = Float.valueOf(this.alturaTblCoberturas.floatValue() + this.alturaRen.floatValue());
                        this.RenCob.getCellDefault().getBorder().setWidth(0.0f);
                        this.RenCob.getCells().add("Forma de pago ", 8);
                        this.RenCob.getCells().getCell2(0).setAlign(TextAlign.RIGHT);
                        this.RenCob.getCells().add(this.met99Datos.formaPago);
                        break;
                    }
                    this.RenCob = this.tblCoberturas.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
                    this.alturaTblCoberturas = Float.valueOf(this.alturaTblCoberturas.floatValue() + this.alturaRen.floatValue());
                    this.RenCob.getCellDefault().getBorder().setWidth(0.0f);
                    this.RenCob.getCells().add("Prima diaria ", 8);
                    this.RenCob.getCells().getCell2(0).setAlign(TextAlign.RIGHT);
                    this.RenCob.getCells().add(this.genSubs.FormatoNumDouble("###,###", this.genSubs.Redondea(this.primaDiaria, 0)));
                    this.RenCob = this.tblCoberturas.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
                    this.alturaTblCoberturas = Float.valueOf(this.alturaTblCoberturas.floatValue() + this.alturaRen.floatValue());
                    this.RenCob.getCellDefault().getBorder().setWidth(0.0f);
                    this.RenCob.getCells().add("Forma de pago ", 8);
                    this.RenCob.getCells().getCell2(0).setAlign(TextAlign.RIGHT);
                    this.RenCob.getCells().add(this.met99Datos.formaPago);
                    break;
                }
                case "ET": {
                    this.RenCob.getCells().add("");
                    this.RenCob.getCells().add(nombreCob, 5);
                    this.RenCob.getCells().add("Otorgado");
                    this.RenCob.getCells().add("Sin costo");
                    this.RenCob.getCells().add("Sin costo");
                    break;
                }
                case "EP": {
                    this.RenCob.getCells().add("");
                    this.RenCob.getCells().add(nombreCob, 5);
                    this.RenCob.getCells().add("");
                    this.RenCob.getCells().add("");
                    this.RenCob.getCells().add("");
                    this.alturaTblCoberturas = Float.valueOf(this.alturaTblCoberturas.floatValue() + this.alturaRen.floatValue());
                    break;
                }
                case "PHT": {
                    this.RenCob.getCells().add("");
                    this.RenCob.getCells().add(nombreCob, 5);
                    this.RenCob.getCells().add("Incluido");
                    this.RenCob.getCells().add(this.genSubs.FormatoNumDouble("###,###", this.genSubs.Redondea(primaCob, 0)));
                    this.RenCob.getCells().add(this.genSubs.FormatoNumDouble("###,###", this.genSubs.Redondea(epCob, 0)));
                    break;
                }
                case "PHX": {
                    this.RenCob.getCells().add("");
                    this.RenCob.getCells().add(nombreCob, 5);
                    this.RenCob.getCells().add("Incluido");
                    this.RenCob.getCells().add(this.genSubs.FormatoNumDouble("###,###", this.genSubs.Redondea(primaCob, 0)));
                    this.RenCob.getCells().add(this.genSubs.FormatoNumDouble("###,###", this.genSubs.Redondea(epCob, 0)));
                    break;
                }
                default: {
                    this.RenCob.getCells().add("");
                    this.RenCob.getCells().add(nombreCob, 5);
                    this.RenCob.getCells().add(this.genSubs.FormatoNumInteger("###,###", sumaCob));
                    this.RenCob.getCells().add(this.genSubs.FormatoNumDouble("###,###", this.genSubs.Redondea(primaCob, 0)));
                    this.RenCob.getCells().add(this.genSubs.FormatoNumDouble("###,###", this.genSubs.Redondea(epCob, 0)));
                }
            }
        }
    }

    private Page CreaPaginaMem() {
        Page pagina = new Page(this.dimensionsMem);
        return pagina;
    }

    private void ConstruyeTblPry() {
        this.alturaTblPry = Float.valueOf(0.0f);
        Integer limitePry = this.met99Datos.edadRealTitular < 80 ? Integer.valueOf(21) : Integer.valueOf(20);
        for (int i = 1; i < limitePry; ++i) {
            this.RenPry = this.tblPry.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
            this.alturaTblPry = Float.valueOf(this.alturaTblPry.floatValue() + 10.0f);
            this.RenPry.getCellDefault().getBorder().setWidth(0.0f);
            this.RenPry.getCellDefault().setAlign(TextAlign.CENTER);
            String txtAno = this.genSubs.FormatoNumInteger("##", i);
            String txtSuma = this.genSubs.FormatoNumInteger("###,###", this.met99Datos.sumaBAS);
            String txtPrima = this.genSubs.FormatoNumDouble("###,###", this.genSubs.Redondea(this.met99Datos.primaAnualConExc, 0));
            String txtValEfe = this.genSubs.FormatoNumDouble("###,###", this.met99Datos.valorEfectivo.get(i * 12));
            String txtFondo = this.genSubs.FormatoNumDouble("###,###", this.met99Datos.Fondo.get(i * 12));
            Double valTemp = (double)this.met99Datos.sumaBAS.intValue() + this.met99Datos.valorEfectivo.get(i * 12) + this.met99Datos.Fondo.get(i * 12);
            valTemp = this.genSubs.Redondea(valTemp, 0);
            String txtSumaFallecimiento = this.genSubs.FormatoNumDouble("###,###", valTemp);
            this.RenPry.getCells().add(txtAno);
            this.RenPry.getCells().add(txtSuma);
            this.RenPry.getCells().add(txtPrima);
            this.RenPry.getCells().add(txtValEfe);
            this.RenPry.getCells().add(txtFondo);
            this.RenPry.getCells().add(txtSumaFallecimiento);
        }
    }

    private void ConstruyeTblTitPry() {
        this.RenTitPry = this.tblTitPry.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
        this.RenTitPry.getCellDefault().getBorder().setWidth(0.0f);
        this.RenTitPry.getCellDefault().getBorder().getBottom().setWidth(0.5f);
        this.RenTitPry.getCellDefault().setAlign(TextAlign.CENTER);
        this.RenTitPry.getCells().add("Proyecci\u00f3n financiera del valor en efectivo", 6);
        this.RenTitPry.getCellDefault().setBackgroundColor(RgbColor.getLightBlue());
        this.RenTitPry = this.tblTitPry.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
        this.RenTitPry.getCellDefault().getBorder().setWidth(0.0f);
        this.RenTitPry.getCellDefault().setVAlign(VAlign.CENTER);
        this.RenTitPry.getCellDefault().setAlign(TextAlign.CENTER);
        this.RenTitPry.getCells().add("A\u00f1o de vigencia del seguro");
        this.RenTitPry.getCells().add("Suma asegurada alcanzada");
        this.RenTitPry.getCells().add("Prima anual");
        this.RenTitPry.getCells().add("Valor efectivo final de a\u00f1o");
        this.RenTitPry.getCells().add("Fondo de inversi\u00f3n");
        this.RenTitPry.getCells().add("SA por fallecimiento");
    }

    private void ConstruyeTblTitPry2() {
        this.RenTitPry2 = this.tblTitPry2.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
        this.RenTitPry2.getCellDefault().getBorder().setWidth(0.0f);
        this.RenTitPry2.getCellDefault().getBorder().getBottom().setWidth(0.5f);
        this.RenTitPry2.getCellDefault().setVAlign(VAlign.CENTER);
        this.RenTitPry2.getCells().add("Proyecci\u00f3n financiera del valor en efectivo", 6);
        this.RenTitPry2.getCellDefault().setBackgroundColor(RgbColor.getLightBlue());
        this.RenTitPry2 = this.tblTitPry2.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
        this.RenTitPry2.getCellDefault().getBorder().setWidth(0.0f);
        this.RenTitPry2.getCellDefault().setVAlign(VAlign.CENTER);
        this.RenTitPry2.getCellDefault().setAlign(TextAlign.CENTER);
        this.RenTitPry2.getCells().add("A\u00f1o de vigencia del seguro");
        this.RenTitPry2.getCells().add("Suma asegurada alcanzada");
        this.RenTitPry2.getCells().add("Prima anual");
        this.RenTitPry2.getCells().add("Valor efectivo final de a\u00f1o");
        this.RenTitPry2.getCells().add("Fondo de inversi\u00f3n");
        this.RenTitPry2.getCells().add("SA por fallecimiento");
    }

    private void ConstruyeTblTitDesCob() {
        this.RenTitDesCob = this.tblTitDesCob.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
        this.RenTitDesCob.getCellDefault().getBorder().setWidth(0.0f);
        this.RenTitDesCob.getCellDefault().getBorder().getBottom().setWidth(0.5f);
        this.RenTitDesCob.getCellDefault().setVAlign(VAlign.CENTER);
        this.RenTitDesCob.getCellDefault().setAlign(TextAlign.CENTER);
        this.RenTitDesCob.getCells().add("Breve descripci\u00f3n de los beneficios solicitados");
        this.RenTitDesCob.getCellDefault().setBackgroundColor(RgbColor.getLightBlue());
    }

    private void ConstruyeTblTitDesCob2() {
        this.RenTitDesCob2 = this.tblTitDesCob2.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
        this.RenTitDesCob2.getCellDefault().getBorder().setWidth(0.0f);
        this.RenTitDesCob2.getCellDefault().getBorder().getBottom().setWidth(0.5f);
        this.RenTitDesCob2.getCellDefault().setVAlign(VAlign.CENTER);
        this.RenTitDesCob2.getCellDefault().setAlign(TextAlign.CENTER);
        this.RenTitDesCob2.getCells().add("Breve descripci\u00f3n de los beneficios solicitados");
        this.RenTitDesCob2.getCellDefault().setBackgroundColor(RgbColor.getLightBlue());
    }

    private void ConstruyeTblDesCob() {
        Boolean existeBACcomp = false;
        Boolean existeBCACcomp = false;
        Boolean existeAPcomp = false;
        Boolean existeGFcomp = false;
        Boolean existeEGcomp = false;
        Boolean existeCRcomp = false;
        Boolean existePHXcomp = false;
        if (this.met99Datos.selBAS.booleanValue()) {
            this.SeleccionaDes("BAS");
        }
        if (this.met99Datos.productoSeleccionado.equals("Met99")) {
            if (this.met99Datos.ftpSel == 1) {
                this.SeleccionaDes("PFT");
            }
        } else if (this.met99Datos.productoSeleccionado.equals("Maestro20") && this.met99Datos.ftpSel == 1) {
            this.SeleccionaDes("DPF");
        }
        if (this.met99Datos.productoSeleccionado.equals("PT20")) {
            if (this.met99Datos.edadRealTitular <= 69) {
                if (this.met99Datos.optNueva.booleanValue()) {
                    this.SeleccionaDes("ET");
                } else if (this.met99Datos.selBAS.booleanValue()) {
                    this.SeleccionaDes("ET");
                }
            }
        } else if (this.met99Datos.optNueva.booleanValue()) {
            this.SeleccionaDes("ET");
        } else if (this.met99Datos.selBAS.booleanValue()) {
            this.SeleccionaDes("ET");
        }
        if (this.met99Datos.selBIT.booleanValue()) {
            this.SeleccionaDes("BIT");
        }
        if (this.met99Datos.selCII.booleanValue()) {
            this.SeleccionaDes("CII");
        }
        if (this.met99Datos.selCMA.booleanValue()) {
            this.SeleccionaDes("CMA");
        }
        if (this.met99Datos.selTIBA.booleanValue()) {
            this.SeleccionaDes("TIBA");
        }
        if (this.met99Datos.selCAT.booleanValue()) {
            this.SeleccionaDes("CAT");
        }
        if (this.met99Datos.selGFA.booleanValue()) {
            this.SeleccionaDes("GFA");
        }
        if (this.met99Datos.selGE.booleanValue()) {
            this.SeleccionaDes("GE");
        }
        if (this.met99Datos.selAP.booleanValue()) {
            this.SeleccionaDes("AP");
        }
        if (this.met99Datos.selEG.booleanValue()) {
            this.SeleccionaDes("EG");
        }
        if (this.met99Datos.selCR.booleanValue()) {
            this.SeleccionaDes("CR");
        }
        if (this.met99Datos.selPHT.booleanValue()) {
            this.SeleccionaDes("PHT");
        }
        if (this.met99Datos.selBACY.booleanValue()) {
            this.SeleccionaDes("BACY");
        }
        if (this.met99Datos.selGFC.booleanValue()) {
            this.SeleccionaDes("GFC");
        }
        if (this.met99Datos.selBCAC.booleanValue()) {
            this.SeleccionaDes("BCAC");
        }
        if (this.met99Datos.selGFH.booleanValue()) {
            this.SeleccionaDes("GFH");
        }
        for (int i = 0; i < this.met99Datos.numComp; ++i) {
            if (this.met99Datos.lstSelBAC.get(i).booleanValue()) {
                existeBACcomp = true;
            }
            if (this.met99Datos.lstSelBCAC.get(i).booleanValue()) {
                existeBCACcomp = true;
            }
            if (!this.met99Datos.selAP.booleanValue() && this.met99Datos.lstSelAP.get(i).booleanValue()) {
                existeAPcomp = true;
            }
            if (this.met99Datos.lstSelGF.get(i).booleanValue()) {
                existeGFcomp = true;
            }
            if (this.met99Datos.lstSelEG.get(i).booleanValue()) {
                existeEGcomp = true;
            }
            if (this.met99Datos.lstSelCR.get(i).booleanValue()) {
                existeCRcomp = true;
            }
            if (!this.met99Datos.lstSelPHX.get(i).booleanValue()) continue;
            existePHXcomp = true;
        }
        if (existeBACcomp.booleanValue()) {
            this.SeleccionaDes("BACcomp");
        }
        if (existeBCACcomp.booleanValue()) {
            this.SeleccionaDes("BCACcomp");
        }
        if (existeAPcomp.booleanValue()) {
            this.SeleccionaDes("AP");
        }
        if (existeGFcomp.booleanValue()) {
            this.SeleccionaDes("GFcomp");
        }
        if (existeEGcomp.booleanValue()) {
            this.SeleccionaDes("EGcomp");
        }
        if (existeCRcomp.booleanValue()) {
            this.SeleccionaDes("CRcomp");
        }
        if (existePHXcomp.booleanValue()) {
            this.SeleccionaDes("PHX");
        }
    }

    private void SeleccionaDes(String idCob) {
        this.indiceCobDes = this.genSubs.IndiceCobDes(idCob);
        this.RenDesCob = this.tblDesCob.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
        this.RenDesCob.getCellDefault().getBorder().setWidth(0.0f);
        this.RenDesCob.getCellDefault().setAlign(TextAlign.LEFT);
        if (this.indiceCobDes > -1) {
            String txtDes = this.met99Datos.desCob.get(this.indiceCobDes);
            if (idCob.equals("BIT")) {
                txtDes = txtDes + this.met99Datos.productoSeleccionado + ".";
            }
            this.RenDesCob.getCells().add(txtDes);
        } else {
            this.RenDesCob.getCells().add("No existe desripci\u00f3n para: " + idCob);
        }
    }

    private void ConstruyeTblRequisitos() {
        Integer reqSolicitud = 0;
        Integer reqEMyOrina = 0;
        Integer reqLaboratorio = 0;
        Integer reqEcgReposo = 0;
        Integer reqEcgEsfuerzo = 0;
        Integer reqSalivaTest = 0;
        Integer reqAntigenoProstatico = 0;
        Integer reqSida = 0;
        Integer reqAlcoholDrogas = 0;
        for (int i = 0; i < this.met99Datos.edadIni.size(); ++i) {
            if (this.met99Datos.edadRealTitular < this.met99Datos.edadIni.get(i) || this.met99Datos.edadRealTitular > this.met99Datos.edadFin.get(i) || this.met99Datos.sumaBAS < this.met99Datos.sumaIni.get(i) || this.met99Datos.sumaBAS > this.met99Datos.sumaFin.get(i)) continue;
            reqSolicitud = this.met99Datos.solicitud.get(i);
            reqEMyOrina = this.met99Datos.EMyOrina.get(i);
            reqLaboratorio = this.met99Datos.laboratorio.get(i);
            reqEcgReposo = this.met99Datos.ecgReposo.get(i);
            reqEcgEsfuerzo = this.met99Datos.ecgEsfuerzo.get(i);
            reqSalivaTest = this.met99Datos.salivaTest.get(i);
            reqAntigenoProstatico = this.met99Datos.antigenoProstatico.get(i);
            reqSida = this.met99Datos.sida.get(i);
            reqAlcoholDrogas = this.met99Datos.alcoholDrogas.get(i);
        }
        this.RenRequisitos = this.tblRequisitos.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
        this.RenRequisitos.getCellDefault().getBorder().setWidth(0.0f);
        this.RenRequisitos.getCellDefault().setAlign(TextAlign.LEFT);
        this.RenRequisitos.getCellDefault().getBorder().setWidth(0.0f);
        this.RenRequisitos.getCellDefault().setAlign(TextAlign.LEFT);
        this.RenRequisitos.getCells().add("Requisitos de asegurabilidad");
        this.RenRequisitos.getCells().add("");
        this.RenRequisitos.getCells().add("");
        this.renRequisitos = 1;
        this.colRequisitos = 0;
        this.AgregaRenRequisito();
        if (reqSolicitud == 1) {
            this.AsignaRequisito("solicitud");
        }
        if (reqEMyOrina == 1) {
            this.AsignaRequisito("EMyOrina");
        }
        if (reqLaboratorio == 1) {
            this.AsignaRequisito("laboratorio");
        }
        if (reqEcgReposo == 1) {
            this.AsignaRequisito("ecgReposo");
        }
        if (reqEcgEsfuerzo == 1) {
            this.AsignaRequisito("ecgEsfuerzo");
        }
        if (reqSalivaTest == 1) {
            this.AsignaRequisito("salivaTest");
        }
        if (reqAntigenoProstatico == 1) {
            this.AsignaRequisito("antigenoProstatico");
        }
        if (reqSida == 1) {
            this.AsignaRequisito("sida");
        }
        if (reqAlcoholDrogas == 1) {
            this.AsignaRequisito("alcoholDrogas");
        }
        if (this.met99Datos.sumaBAS >= 5000000 && this.met99Datos.sumaBAS <= 8000000) {
            this.AsignaRequisito("CF");
        }
        if (this.met99Datos.sumaBAS > 8000000 && this.met99Datos.sumaBAS <= 10000000) {
            this.AsignaRequisito("CF");
            this.AsignaRequisito("IC");
        }
        if (this.met99Datos.sumaBAS > 10000000) {
            this.AsignaRequisito("EF");
            this.AsignaRequisito("IC");
        }
        this.RenRequisitos = this.tblRequisitos.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
        this.RenRequisitos.getCellDefault().getBorder().setWidth(0.0f);
        this.RenRequisitos.getCellDefault().setAlign(TextAlign.LEFT);
        this.RenRequisitos.getCellDefault().getBorder().setWidth(0.0f);
        this.RenRequisitos.getCellDefault().setAlign(TextAlign.LEFT);
        this.RenRequisitos.getCells().add("NOTAS:", 3);
        this.RenRequisitos = this.tblRequisitos.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
        this.RenRequisitos.getCellDefault().getBorder().setWidth(0.0f);
        this.RenRequisitos.getCellDefault().setAlign(TextAlign.LEFT);
        this.RenRequisitos.getCellDefault().getBorder().setWidth(0.0f);
        this.RenRequisitos.getCellDefault().setAlign(TextAlign.LEFT);
        String txtNotas = "La presente cotizaci\u00f3n tiene una validez de 30 d\u00edas naturales a partir de la fecha de elaboraci\u00f3n. ";
        txtNotas = txtNotas + "En la cotizaci\u00f3n no se incluyen extraprimas m\u00e9dicas por ser \u00e9stas una valoraci\u00f3n diferente para cada persona. ";
        txtNotas = txtNotas + "De acuerdo a pol\u00edticas de suscripci\u00f3n el monto total de la prima no debe superar el 30% del salario del solicitante";
        this.RenRequisitos.getCells().add(txtNotas, 3);
    }

    private void ConstruyeTblDatosAgente() {
        this.RenDatosAgente = this.tblDatosAgente.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
        this.RenDatosAgente.getCellDefault().getBorder().setWidth(0.0f);
        this.RenDatosAgente.getCellDefault().setAlign(TextAlign.LEFT);
        this.RenDatosAgente.getCellDefault().getBorder().setWidth(0.0f);
        this.RenDatosAgente.getCellDefault().setAlign(TextAlign.LEFT);
        this.RenDatosAgente.getCells().add("", 1);
        this.RenDatosAgente.getCells().add("Agente", 1);
        this.RenDatosAgente.getCells().add("Promotor", 1);
        this.RenDatosAgente.getCells().add("", 1);
        this.RenDatosAgente = this.tblDatosAgente.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
        this.RenDatosAgente.getCellDefault().getBorder().setWidth(0.0f);
        this.RenDatosAgente.getCellDefault().setAlign(TextAlign.LEFT);
        this.RenDatosAgente.getCellDefault().getBorder().setWidth(0.0f);
        this.RenDatosAgente.getCellDefault().setAlign(TextAlign.LEFT);
        this.RenDatosAgente.getCells().add("Nombre", 1);
        this.RenDatosAgente.getCells().add(this.met99Datos.nombreAgente, 1);
        this.RenDatosAgente.getCells().add(this.met99Datos.nombrePromotor, 2);
        this.RenDatosAgente = this.tblDatosAgente.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
        this.RenDatosAgente.getCellDefault().getBorder().setWidth(0.0f);
        this.RenDatosAgente.getCells().add("Tel\u00e9fono", 1);
        this.RenDatosAgente.getCells().add(this.met99Datos.telefonoAgente, 1);
        this.RenDatosAgente.getCells().add(this.met99Datos.telefonoPromotor, 1);
        this.RenDatosAgente.getCells().add("", 1);
        this.RenDatosAgente = this.tblDatosAgente.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
        this.RenDatosAgente.getCellDefault().getBorder().setWidth(0.0f);
        this.RenDatosAgente.getCells().add("Celular", 1);
        this.RenDatosAgente.getCells().add(this.met99Datos.celularAgente, 1);
        this.RenDatosAgente.getCells().add("", 1);
        this.RenDatosAgente.getCells().add("", 1);
        this.RenDatosAgente = this.tblDatosAgente.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
        this.RenDatosAgente.getCellDefault().getBorder().setWidth(0.0f);
        this.RenDatosAgente.getCells().add("Correo", 1);
        this.RenDatosAgente.getCells().add(this.met99Datos.correoAgente, 1);
        this.RenDatosAgente.getCells().add(this.met99Datos.correoPromotor, 1);
        this.RenDatosAgente.getCells().add("", 1);
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        Date date = new Date();
        this.RenDatosAgente = this.tblDatosAgente.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
        this.RenDatosAgente.getCellDefault().getBorder().setWidth(0.0f);
        this.RenDatosAgente.getCells().add("Direcci\u00f3n", 1);
        this.RenDatosAgente.getCells().add(this.met99Datos.direccion1 + ". " + this.met99Datos.direccion2, 2);
        this.RenDatosAgente.getCells().add("Fecha: " + dateFormat.format(date), 1);
        this.RenDatosAgente = this.tblDatosAgente.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
        this.RenDatosAgente.getCellDefault().getBorder().setWidth(0.0f);
        if (this.met99Datos.esVida360.booleanValue()) {
            this.RenDatosAgente.getCells().add(this.met99Datos.idVersion360, 2);
        } else {
            this.RenDatosAgente.getCells().add(this.met99Datos.idVersion, 2);
        }
    }

    private void AsignaRequisito(String requisito) {
        switch (requisito) {
            case "solicitud": {
                this.txtRequisito = "Solicitud completa";
                break;
            }
            case "EMyOrina": {
                this.txtRequisito = "Examen m\u00e9dico y muestra de orina";
                break;
            }
            case "laboratorio": {
                this.txtRequisito = "Laboratorio";
                break;
            }
            case "ecgReposo": {
                this.txtRequisito = "Electrocardiograma de reposo";
                break;
            }
            case "ecgEsfuerzo": {
                this.txtRequisito = "Electrocardiograma de esfuerzo";
                break;
            }
            case "salivaTest": {
                this.txtRequisito = "Prueba de sida simplificada (Salivatest)";
                break;
            }
            case "antigenoProstatico": {
                this.txtRequisito = "Antigeno Prost\u00e1tico";
                break;
            }
            case "sida": {
                this.txtRequisito = "Elisa";
                break;
            }
            case "alcoholDrogas": {
                this.txtRequisito = "Drogas";
                break;
            }
            case "CF": {
                this.txtRequisito = "Cuestionario financiero";
                break;
            }
            case "IC": {
                this.txtRequisito = "Informe confidencial";
                break;
            }
            case "EF": {
                this.txtRequisito = "Declaraci\u00f3n anual/Estados financieros";
            }
        }
        if (this.colRequisitos <= 2) {
            this.AgregaCelRequisito();
            this.colRequisitos = this.colRequisitos + 1;
        } else {
            this.AgregaRenRequisito();
            this.AgregaCelRequisito();
            this.colRequisitos = 1;
        }
    }

    private void AgregaRenRequisito() {
        this.RenRequisitos = this.tblRequisitos.getRows().add(10.0f, Font.getHelvetica(), 8.0f, Grayscale.getBlack(), RgbColor.getWhite());
    }

    private void AgregaCelRequisito() {
        this.RenRequisitos.getCellDefault().getBorder().setWidth(0.0f);
        this.RenRequisitos.getCellDefault().setAlign(TextAlign.LEFT);
        this.RenRequisitos.getCells().add(this.txtRequisito);
    }

    private void ColumnasParaCoberturas() {
        this.anchoCol.set(0, Float.valueOf(0.0f));
        this.anchoCol.set(1, Float.valueOf(60.6f));
        this.anchoCol.set(2, Float.valueOf(52.6f));
        this.anchoCol.set(3, Float.valueOf(42.3f));
        this.anchoCol.set(4, Float.valueOf(46.9f));
        this.anchoCol.set(5, Float.valueOf(65.2f));
        this.anchoCol.set(6, Float.valueOf(55.7f));
        this.anchoCol.set(7, Float.valueOf(56.7f));
        this.anchoCol.set(8, Float.valueOf(56.7f));
        this.anchoCol.set(9, Float.valueOf(56.7f));
    }

    private void ColumnasParaProyeccion() {
        this.anchoCol.set(1, Float.valueOf(80.0f));
        this.anchoCol.set(2, Float.valueOf(80.0f));
        this.anchoCol.set(3, Float.valueOf(80.0f));
        this.anchoCol.set(4, Float.valueOf(80.0f));
        this.anchoCol.set(5, Float.valueOf(80.0f));
        this.anchoCol.set(6, Float.valueOf(80.0f));
    }
}

