/*
 * Decompiled with CFR 0.152.
 */
package provida;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Tab;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import javafx.util.Callback;
import provida.GenSubs;
import provida.Met99Calcula;
import provida.Met99DPerController;
import provida.Met99Datos;
import provida.Met99Imprime;
import provida.Met99Reglas;
import provida.Tablas;

public class Met99CobController
implements Initializable {
    Stage stage;
    Parent root;
    @FXML
    Label lblVersion;
    @FXML
    Label lblNotaAP;
    @FXML
    ImageView logoProducto;
    @FXML
    Label nombreTitular;
    @FXML
    CheckBox chkBAS;
    @FXML
    TextField sumaBAS;
    @FXML
    Label primaBAS;
    @FXML
    CheckBox chkBIT;
    @FXML
    Label primaBIT;
    @FXML
    CheckBox chkCII;
    @FXML
    TextField sumaCII;
    @FXML
    Label primaCII;
    @FXML
    CheckBox chkCMA;
    @FXML
    TextField sumaCMA;
    @FXML
    Label primaCMA;
    @FXML
    CheckBox chkTIBA;
    @FXML
    TextField sumaTIBA;
    @FXML
    Label primaTIBA;
    @FXML
    CheckBox chkCAT;
    @FXML
    TextField sumaCAT;
    @FXML
    Label primaCAT;
    @FXML
    CheckBox chkGFA;
    @FXML
    TextField sumaGFA;
    @FXML
    Label primaGFA;
    @FXML
    CheckBox chkGE;
    @FXML
    TextField sumaGE;
    @FXML
    Label primaGE;
    @FXML
    CheckBox chkAP;
    @FXML
    RadioButton optAPbasica;
    @FXML
    RadioButton optAPextra;
    @FXML
    TextField sumaAP;
    @FXML
    Label primaAP;
    @FXML
    CheckBox chkEG;
    @FXML
    TextField sumaEG;
    @FXML
    Label primaEG;
    @FXML
    CheckBox chkCR;
    @FXML
    TextField sumaCR;
    @FXML
    Label primaCR;
    @FXML
    CheckBox chkPHT;
    @FXML
    Label sumaPHT;
    @FXML
    Label primaPHT;
    @FXML
    Tab tabConyuge;
    @FXML
    Label nombreConyuge;
    @FXML
    CheckBox chkBACY;
    @FXML
    TextField sumaBACY;
    @FXML
    Label primaBACY;
    @FXML
    CheckBox chkGFC;
    @FXML
    TextField sumaGFC;
    @FXML
    Label primaGFC;
    @FXML
    CheckBox chkBCAC;
    @FXML
    TextField sumaBCAC;
    @FXML
    Label primaBCAC;
    @FXML
    Label lblHijos;
    @FXML
    CheckBox chkGFH;
    @FXML
    TextField sumaGFH;
    @FXML
    Label primaGFH;
    @FXML
    RadioButton optUnHijo;
    @FXML
    RadioButton optDosHijos;
    @FXML
    RadioButton optTresHijos;
    @FXML
    Tab tabComp;
    @FXML
    Label lblEdad;
    @FXML
    ComboBox cmbComp;
    @FXML
    CheckBox chkBACcomp;
    @FXML
    CheckBox chkBCACcomp;
    @FXML
    CheckBox chkAPcomp;
    @FXML
    RadioButton optAPbasicaComp;
    @FXML
    RadioButton optAPextraComp;
    @FXML
    CheckBox chkGFcomp;
    @FXML
    CheckBox chkEGcomp;
    @FXML
    CheckBox chkCRcomp;
    @FXML
    TextField sumaBACcomp;
    @FXML
    TextField sumaBCACcomp;
    @FXML
    TextField sumaGFcomp;
    @FXML
    TextField sumaEGcomp;
    @FXML
    TextField sumaCRcomp;
    @FXML
    Label primaBACcomp;
    @FXML
    Label primaBCACcomp;
    @FXML
    TextField sumaAPcomp;
    @FXML
    Label primaAPcomp;
    @FXML
    Label primaGFcomp;
    @FXML
    Label primaEGcomp;
    @FXML
    Label primaCRcomp;
    @FXML
    CheckBox chkPHX;
    @FXML
    Label sumaPHX;
    @FXML
    Label primaPHX;
    @FXML
    TableView<Person> tblComp;
    @FXML
    TableColumn tblNombreComp;
    @FXML
    TableColumn tblBACcomp;
    @FXML
    TableColumn tblBCACcomp;
    @FXML
    TableColumn tblAPcomp;
    @FXML
    TableColumn tblGFcomp;
    @FXML
    TableColumn tblEGcomp;
    @FXML
    TableColumn tblCRcomp;
    @FXML
    TableColumn tblPHXcomp;
    @FXML
    RadioButton optSuma;
    @FXML
    RadioButton optPrima;
    @FXML
    Label lblPFT;
    @FXML
    RadioButton optConDev;
    @FXML
    RadioButton optSinDev;
    @FXML
    RadioButton optNueva;
    @FXML
    RadioButton optIncrementos;
    @FXML
    TextField smDiario;
    @FXML
    Label lblSMdiario;
    @FXML
    Label primaAnualTotal;
    @FXML
    TextField primaExcedente;
    @FXML
    ComboBox cmbFormaPago;
    @FXML
    Label primaFPago;
    @FXML
    TextField primaObjetivo;
    @FXML
    Button btnPrimaObjetivo;
    @FXML
    Label lblFormaPago;
    private Integer indiceCob;
    private Boolean hayError = false;
    private Integer indexComp = -1;
    private final ObservableList<Person> listaComp = FXCollections.observableArrayList();
    Boolean necesitaSumaBASmayor = false;
    Boolean GFfueDeshabilitada = false;
    private String mensaje;
    Image imgLogoProducto;
    Integer numGF;
    Integer maxGF;
    private List<Integer> ctlVisible = new ArrayList<Integer>();
    private List<Integer> ctlPosicionX = new ArrayList<Integer>();
    private List<Integer> ctlPosicionY = new ArrayList<Integer>();
    private Met99Datos met99Datos = Met99Datos.getInstance();
    private Tablas tablas = Tablas.getInstance();
    private Met99Calcula met99Calcula = Met99Calcula.getInstance();
    private Met99Imprime met99Imprime = Met99Imprime.getInstance();
    private Met99Reglas met99Reglas = Met99Reglas.getInstance();
    private GenSubs genSubs = GenSubs.getInstance();

    public void initialize(URL location, ResourceBundle resources) {
        this.tblNombreComp.setCellValueFactory((Callback)new PropertyValueFactory("nombreComp"));
        this.tblBACcomp.setCellValueFactory((Callback)new PropertyValueFactory("bacComp"));
        this.tblBCACcomp.setCellValueFactory((Callback)new PropertyValueFactory("bcacComp"));
        this.tblAPcomp.setCellValueFactory((Callback)new PropertyValueFactory("apComp"));
        this.tblGFcomp.setCellValueFactory((Callback)new PropertyValueFactory("gfComp"));
        this.tblEGcomp.setCellValueFactory((Callback)new PropertyValueFactory("egComp"));
        this.tblCRcomp.setCellValueFactory((Callback)new PropertyValueFactory("crComp"));
        this.tblPHXcomp.setCellValueFactory((Callback)new PropertyValueFactory("phxComp"));
        this.tblComp.setItems(this.listaComp);
        this.cmbComp.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Met99CobController.this.MuestraDatosComp();
            }
        });
        this.cmbFormaPago.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Met99CobController.this.ValidaPrimaExcedente();
            }
        });
        this.sumaBAS.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Met99CobController.this.ValidaCaptura("sumaBAS");
                }
            }
        });
        this.sumaCII.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Met99CobController.this.ValidaCaptura("sumaCII");
                }
            }
        });
        this.sumaCMA.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Met99CobController.this.ValidaCaptura("sumaCMA");
                }
            }
        });
        this.sumaTIBA.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Met99CobController.this.ValidaCaptura("sumaTIBA");
                }
            }
        });
        this.sumaCAT.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Met99CobController.this.ValidaCaptura("sumaCAT");
                }
            }
        });
        this.sumaGFA.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Met99CobController.this.ValidaCaptura("sumaGFA");
                }
            }
        });
        this.sumaGE.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Met99CobController.this.ValidaCaptura("sumaGE");
                }
            }
        });
        this.sumaEG.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Met99CobController.this.ValidaCaptura("sumaEG");
                }
            }
        });
        this.sumaCR.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Met99CobController.this.ValidaCaptura("sumaCR");
                }
            }
        });
        this.sumaBACY.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Met99CobController.this.ValidaCaptura("sumaBACY");
                }
            }
        });
        this.sumaGFC.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Met99CobController.this.ValidaCaptura("sumaGFC");
                }
            }
        });
        this.sumaBCAC.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Met99CobController.this.ValidaCaptura("sumaBCAC");
                }
            }
        });
        this.sumaGFH.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Met99CobController.this.ValidaCaptura("sumaGFH");
                }
            }
        });
        this.sumaBACcomp.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Met99CobController.this.ValidaCaptura("sumaBACcomp");
                }
            }
        });
        this.sumaBCACcomp.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Met99CobController.this.ValidaCaptura("sumaBCACcomp");
                }
            }
        });
        this.sumaAPcomp.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Met99CobController.this.ValidaCaptura("sumaAPcomp");
                }
            }
        });
        this.sumaGFcomp.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Met99CobController.this.ValidaCaptura("sumaGFcomp");
                }
            }
        });
        this.sumaEGcomp.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Met99CobController.this.ValidaCaptura("sumaEGcomp");
                }
            }
        });
        this.sumaCRcomp.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Met99CobController.this.ValidaCaptura("sumaCRcomp");
                }
            }
        });
        this.primaExcedente.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Met99CobController.this.ValidaPrimaExcedente();
                }
            }
        });
        this.primaObjetivo.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Met99CobController.this.ValidaPrimaObjetivo();
                }
            }
        });
        this.sumaBAS.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(9));
        this.sumaCII.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(9));
        this.sumaCMA.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(9));
        this.sumaTIBA.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(9));
        this.sumaCAT.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(9));
        this.sumaGFA.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(9));
        this.sumaGE.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(9));
        this.sumaEG.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(9));
        this.sumaCR.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(9));
        this.sumaBACY.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(9));
        this.sumaGFC.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(9));
        this.sumaBCAC.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(9));
        this.sumaGFH.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(9));
        this.sumaBACcomp.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(9));
        this.sumaBCACcomp.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(9));
        this.sumaGFcomp.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(9));
        this.sumaEGcomp.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(9));
        this.sumaCRcomp.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(9));
        this.primaExcedente.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(9));
        this.primaObjetivo.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(9));
        this.tblBACcomp.setCellFactory((Callback)new Callback<TableColumn, TableCell>(){

            public TableCell call(TableColumn p) {
                TableCell<Met99DPerController.Person, String> cell = new TableCell<Met99DPerController.Person, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(empty ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
                    }
                };
                cell.setAlignment(Pos.CENTER);
                cell.setStyle("-fx-font-size: 18");
                return cell;
            }
        });
        this.tblBCACcomp.setCellFactory((Callback)new Callback<TableColumn, TableCell>(){

            public TableCell call(TableColumn p) {
                TableCell<Met99DPerController.Person, String> cell = new TableCell<Met99DPerController.Person, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(empty ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
                    }
                };
                cell.setAlignment(Pos.CENTER);
                cell.setStyle("-fx-font-size: 18");
                return cell;
            }
        });
        this.tblAPcomp.setCellFactory((Callback)new Callback<TableColumn, TableCell>(){

            public TableCell call(TableColumn p) {
                TableCell<Met99DPerController.Person, String> cell = new TableCell<Met99DPerController.Person, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(empty ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
                    }
                };
                cell.setAlignment(Pos.CENTER);
                cell.setStyle("-fx-font-size: 18");
                return cell;
            }
        });
        this.tblGFcomp.setCellFactory((Callback)new Callback<TableColumn, TableCell>(){

            public TableCell call(TableColumn p) {
                TableCell<Met99DPerController.Person, String> cell = new TableCell<Met99DPerController.Person, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(empty ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
                    }
                };
                cell.setAlignment(Pos.CENTER);
                cell.setStyle("-fx-font-size: 18");
                return cell;
            }
        });
        this.tblEGcomp.setCellFactory((Callback)new Callback<TableColumn, TableCell>(){

            public TableCell call(TableColumn p) {
                TableCell<Met99DPerController.Person, String> cell = new TableCell<Met99DPerController.Person, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(empty ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
                    }
                };
                cell.setAlignment(Pos.CENTER);
                cell.setStyle("-fx-font-size: 18");
                return cell;
            }
        });
        this.tblCRcomp.setCellFactory((Callback)new Callback<TableColumn, TableCell>(){

            public TableCell call(TableColumn p) {
                TableCell<Met99DPerController.Person, String> cell = new TableCell<Met99DPerController.Person, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(empty ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
                    }
                };
                cell.setAlignment(Pos.CENTER);
                cell.setStyle("-fx-font-size: 18");
                return cell;
            }
        });
        this.tblPHXcomp.setCellFactory((Callback)new Callback<TableColumn, TableCell>(){

            public TableCell call(TableColumn p) {
                TableCell<Met99DPerController.Person, String> cell = new TableCell<Met99DPerController.Person, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(empty ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
                    }
                };
                cell.setAlignment(Pos.CENTER);
                cell.setStyle("-fx-font-size: 18");
                return cell;
            }
        });
        this.InicializaVentana();
    }

    private void InicializaVentana() {
        this.InicializaObjetos();
        this.cmbFormaPago.getItems().clear();
        this.cmbFormaPago.getItems().addAll(this.met99Datos.lstFormaPago);
        if (this.met99Datos.optNueva.booleanValue()) {
            this.optNueva.setSelected(true);
            this.chkBAS.setDisable(true);
        } else {
            this.optIncrementos.setSelected(true);
            this.chkBAS.setDisable(false);
        }
        if (this.met99Datos.optSuma.booleanValue()) {
            this.optSuma.setSelected(true);
        } else {
            this.optPrima.setSelected(true);
        }
        this.primaExcedente.setText(this.genSubs.FormatoNumDouble("###.00", this.met99Datos.primaExcedente));
        this.cmbFormaPago.setValue((Object)this.met99Datos.formaPago);
        if (!this.met99Datos.lstNombreComp.isEmpty()) {
            this.tabComp.setDisable(false);
            this.cmbComp.getItems().clear();
            this.cmbComp.getItems().addAll(this.met99Datos.lstNombreComp);
            this.ArmaTablaComp();
            this.cmbComp.setValue((Object)this.met99Datos.lstNombreComp.get(0));
        } else {
            this.tabComp.setDisable(true);
        }
        if (this.met99Datos.productoSeleccionado.equals("Maestro20")) {
            this.tabComp.setDisable(true);
        }
        this.chkBCAC.setVisible(false);
        this.sumaBCAC.setVisible(false);
        this.primaBCAC.setVisible(false);
        this.sumaAP.setVisible(false);
        this.sumaAPcomp.setVisible(false);
        if (this.met99Datos.optSuma.booleanValue()) {
            this.primaObjetivo.setVisible(false);
            this.btnPrimaObjetivo.setVisible(false);
        } else {
            this.primaObjetivo.setVisible(true);
            this.btnPrimaObjetivo.setVisible(true);
            this.primaObjetivo.setText(this.genSubs.FormatoNumDouble("###,###", this.met99Datos.primaObjetivo));
        }
        if (this.met99Datos.ftpSel == 1) {
            this.optConDev.setSelected(true);
        } else {
            this.optSinDev.setSelected(true);
        }
        this.ValidaEdadCoberturas();
        if (this.met99Datos.sumaLimitada.booleanValue()) {
            this.ValidaSumaBAS();
        }
        if (this.met99Datos.edadRealTitular > 70 && this.met99Datos.edadRealTitular < 81) {
            this.ValidaSumaBAS();
        }
        if (this.met99Datos.edadRealConyuge > 70) {
            this.ValidaSumaBACY();
        }
        if ("".equals(this.met99Datos.nombreConyuge)) {
            this.nombreConyuge.setText("Sin c\u00f3nyuge");
            this.chkBACY.setDisable(true);
            this.chkGFC.setDisable(true);
            this.chkBCAC.setDisable(true);
        } else {
            this.nombreConyuge.setText("C\u00f3nyuge: " + this.met99Datos.nombreConyuge);
            this.chkBACY.setDisable(false);
            this.chkGFC.setDisable(false);
            this.chkBCAC.setDisable(false);
        }
        this.RevisaSumaMinGF();
        if (!this.met99Reglas.RangoEdad("AP", this.met99Datos.edadRealTitular).booleanValue()) {
            this.RevisaExclusionAP();
        }
        if (this.met99Datos.esVida360.booleanValue() && this.met99Datos.APactivado == 1) {
            this.met99Datos.optSumaAP = 2;
            this.optAPbasica.setSelected(false);
            this.optAPextra.setSelected(true);
            this.optAPbasica.setDisable(true);
            this.optAPextra.setDisable(true);
            this.optAPbasicaComp.setSelected(false);
            this.optAPextraComp.setSelected(true);
            this.optAPbasicaComp.setDisable(true);
            this.optAPextraComp.setDisable(true);
        }
        this.RevisaSiAplicaGF();
        this.met99Calcula.CalculaPrimas();
        this.RecuperaDatos();
        if (this.met99Datos.optSuma.booleanValue()) {
            this.HabilitaSumasAseguradas(true);
        } else {
            this.HabilitaSumasAseguradas(false);
        }
        this.RevisaRechazos();
        this.RevisaSiHayConyuge();
        this.met99Calcula.CalculaPrimas();
        this.RecuperaDatos();
        if (this.met99Datos.numComp > 0) {
            this.MuestraDatosComp();
        }
        if (this.met99Datos.esVida360.booleanValue()) {
            this.lblVersion.setText(this.met99Datos.idVersion360);
        } else {
            this.lblVersion.setText(this.met99Datos.idVersion);
        }
    }

    private void RecuperaDatos() {
        this.smDiario.setText(this.genSubs.FormatoNumDouble("###.00", this.met99Datos.smDiario));
        this.nombreTitular.setText(this.met99Datos.nombreTitular);
        this.sumaBAS.setText(this.genSubs.FormatoNumInteger("###,###", this.met99Datos.sumaBAS));
        this.primaBAS.setText(this.genSubs.FormatoNumDouble("###,###", this.met99Datos.primaBAS));
        this.RevisaSeleccion(this.met99Datos.selBAS, this.sumaBAS, this.primaBAS, this.chkBAS, this.met99Datos.sumaBAS, this.met99Datos.primaBAS);
        this.RevisaSeleccion(this.met99Datos.selCII, this.sumaCII, this.primaCII, this.chkCII, this.met99Datos.sumaCII, this.met99Datos.primaCII);
        this.RevisaSeleccion(this.met99Datos.selCMA, this.sumaCMA, this.primaCMA, this.chkCMA, this.met99Datos.sumaCMA, this.met99Datos.primaCMA);
        this.RevisaSeleccion(this.met99Datos.selTIBA, this.sumaTIBA, this.primaTIBA, this.chkTIBA, this.met99Datos.sumaTIBA, this.met99Datos.primaTIBA);
        this.RevisaSeleccion(this.met99Datos.selCAT, this.sumaCAT, this.primaCAT, this.chkCAT, this.met99Datos.sumaCAT, this.met99Datos.primaCAT);
        this.RevisaSeleccion(this.met99Datos.selGFA, this.sumaGFA, this.primaGFA, this.chkGFA, this.met99Datos.sumaGFA, this.met99Datos.primaGFA);
        this.RevisaSeleccion(this.met99Datos.selGE, this.sumaGE, this.primaGE, this.chkGE, this.met99Datos.sumaGE, this.met99Datos.primaGE);
        this.RevisaSeleccion(this.met99Datos.selAP, this.sumaAP, this.primaAP, this.chkAP, this.met99Datos.sumaAP, this.met99Datos.primaAP);
        if (this.met99Datos.optSumaAP == 1) {
            this.optAPbasica.setSelected(true);
        } else {
            this.optAPextra.setSelected(true);
        }
        this.RevisaSeleccion(this.met99Datos.selEG, this.sumaEG, this.primaEG, this.chkEG, this.met99Datos.sumaEG, this.met99Datos.primaEG);
        this.RevisaSeleccion(this.met99Datos.selCR, this.sumaCR, this.primaCR, this.chkCR, this.met99Datos.sumaCR, this.met99Datos.primaCR);
        this.RevisaSeleccionPH(this.met99Datos.selPHT, this.sumaPHT, this.primaPHT, this.chkPHT, this.met99Datos.sumaPHT, this.met99Datos.primaPHT);
        this.RevisaSeleccion(this.met99Datos.selBACY, this.sumaBACY, this.primaBACY, this.chkBACY, this.met99Datos.sumaBACY, this.met99Datos.primaBACY);
        this.RevisaSeleccion(this.met99Datos.selGFC, this.sumaGFC, this.primaGFC, this.chkGFC, this.met99Datos.sumaGFC, this.met99Datos.primaGFC);
        this.RevisaSeleccion(this.met99Datos.selBCAC, this.sumaBCAC, this.primaBCAC, this.chkBCAC, this.met99Datos.sumaBCAC, this.met99Datos.primaBCAC);
        this.RevisaSeleccion(this.met99Datos.selGFH, this.sumaGFH, this.primaGFH, this.chkGFH, this.met99Datos.sumaGFH, this.met99Datos.primaGFH);
        if (this.met99Datos.selGFH.booleanValue()) {
            switch (this.met99Datos.numHijos) {
                case 1: {
                    this.optUnHijo.setSelected(true);
                    break;
                }
                case 2: {
                    this.optDosHijos.setSelected(true);
                    break;
                }
                case 3: {
                    this.optTresHijos.setSelected(true);
                }
            }
        }
        if (this.indexComp >= 0) {
            this.RevisaSeleccion(this.met99Datos.lstSelBAC.get(this.indexComp), this.sumaBACcomp, this.primaBACcomp, this.chkBACcomp, this.met99Datos.lstSumaBAC.get(this.indexComp), this.met99Datos.lstPrimaBAC.get(this.indexComp));
            this.RevisaSeleccion(this.met99Datos.lstSelBCAC.get(this.indexComp), this.sumaBCACcomp, this.primaBCACcomp, this.chkBCACcomp, this.met99Datos.lstSumaBCAC.get(this.indexComp), this.met99Datos.lstPrimaBCAC.get(this.indexComp));
            this.RevisaSeleccion(this.met99Datos.lstSelAP.get(this.indexComp), this.sumaAPcomp, this.primaAPcomp, this.chkAPcomp, this.met99Datos.lstSumaAP.get(this.indexComp), this.met99Datos.lstPrimaAP.get(this.indexComp));
            this.RevisaSeleccion(this.met99Datos.lstSelGF.get(this.indexComp), this.sumaGFcomp, this.primaGFcomp, this.chkGFcomp, this.met99Datos.lstSumaGF.get(this.indexComp), this.met99Datos.lstPrimaGF.get(this.indexComp));
            this.RevisaSeleccion(this.met99Datos.lstSelEG.get(this.indexComp), this.sumaEGcomp, this.primaEGcomp, this.chkEGcomp, this.met99Datos.lstSumaEG.get(this.indexComp), this.met99Datos.lstPrimaEG.get(this.indexComp));
            this.RevisaSeleccion(this.met99Datos.lstSelCR.get(this.indexComp), this.sumaCRcomp, this.primaCRcomp, this.chkCRcomp, this.met99Datos.lstSumaCR.get(this.indexComp), this.met99Datos.lstPrimaCR.get(this.indexComp));
            this.RevisaSeleccionPH(this.met99Datos.lstSelPHX.get(this.indexComp), this.sumaPHX, this.primaPHX, this.chkPHX, this.met99Datos.lstSumaPHX.get(this.indexComp), this.met99Datos.lstPrimaPHX.get(this.indexComp));
        }
        if (this.met99Datos.selBIT.booleanValue()) {
            this.primaBIT.setText(this.genSubs.FormatoNumDouble("###,###", this.met99Datos.primaBIT));
            this.chkBIT.setSelected(true);
        } else {
            this.met99Datos.primaBIT = 0.0;
            this.chkBIT.setSelected(false);
            this.primaBIT.setText(null);
            this.primaBIT.setVisible(false);
        }
        this.primaAnualTotal.setText(this.genSubs.FormatoNumDouble("###,###", this.genSubs.Redondea(this.met99Datos.primaAnualTotal, 0)));
        this.primaExcedente.setText(this.genSubs.FormatoNumDouble("###,###", this.genSubs.Redondea(this.met99Datos.primaExcedente, 0)));
        this.primaFPago.setText(this.genSubs.FormatoNumDouble("###,###", this.genSubs.Redondea(this.met99Datos.primaFPago, 0)));
    }

    private void ArmaTablaComp() {
        this.listaComp.clear();
        for (int i = 0; i < this.met99Datos.numComp; ++i) {
            String okBAC = "";
            String okBCAC = "";
            String okAP = "";
            String okGF = "";
            String okEG = "";
            String okCR = "";
            String okPHX = "";
            if (this.met99Datos.lstSelBAC.get(i).booleanValue()) {
                okBAC = "\u2713";
            }
            if (this.met99Datos.lstSelBCAC.get(i).booleanValue()) {
                okBCAC = "\u2713";
            }
            if (this.met99Datos.lstSelAP.get(i).booleanValue()) {
                okAP = "\u2713";
            }
            if (this.met99Datos.lstSelGF.get(i).booleanValue()) {
                okGF = "\u2713";
            }
            if (this.met99Datos.lstSelEG.get(i).booleanValue()) {
                okEG = "\u2713";
            }
            if (this.met99Datos.lstSelCR.get(i).booleanValue()) {
                okCR = "\u2713";
            }
            if (this.met99Datos.lstSelPHX.get(i).booleanValue()) {
                okPHX = "\u2713";
            }
            this.listaComp.add((Object)new Person(this.met99Datos.lstNombreComp.get(i), okBAC, okBCAC, okAP, okGF, okEG, okCR, okPHX));
        }
    }

    private void RevisaSeleccion(Boolean cobSeleccionada, TextField txtSuma, Label lblPrima, CheckBox chkCobertura, Integer sumaCobertura, Double primaCobertura) {
        if (cobSeleccionada.booleanValue()) {
            txtSuma.setText(this.genSubs.FormatoNumInteger("###,###", sumaCobertura));
            lblPrima.setText(this.genSubs.FormatoNumDouble("###,###", this.genSubs.Redondea(primaCobertura, 0)));
            chkCobertura.setSelected(true);
        } else {
            txtSuma.setVisible(false);
            lblPrima.setVisible(false);
            chkCobertura.setSelected(false);
            primaCobertura = 0.0;
            sumaCobertura = 0;
        }
    }

    private void RevisaSeleccionPH(Boolean cobSeleccionada, Label txtSuma, Label lblPrima, CheckBox chkCobertura, Integer sumaCobertura, Double primaCobertura) {
        if (cobSeleccionada.booleanValue()) {
            txtSuma.setText("Incluido");
            lblPrima.setText(this.genSubs.FormatoNumDouble("###,###", this.genSubs.Redondea(primaCobertura, 0)));
            chkCobertura.setSelected(true);
        } else {
            txtSuma.setVisible(false);
            lblPrima.setVisible(false);
            chkCobertura.setSelected(false);
            primaCobertura = 0.0;
            sumaCobertura = 0;
        }
    }

    public void clickBAS() {
        if (!this.met99Datos.optNueva.booleanValue()) {
            this.met99Datos.selBAS = this.chkBAS.isSelected();
            if (!this.met99Datos.optSuma.booleanValue()) {
                this.CalculaSumaConPrimaObjetivo();
                if (this.GFfueDeshabilitada.booleanValue()) {
                    this.genSubs.MuestraMensaje("Se recalcular\u00e1 sin Gastos Funerarios", "Provida");
                    this.CalculaSumaConPrimaObjetivo();
                }
            }
            this.clickCobertura(this.chkBAS, this.sumaBAS, this.primaBAS, "BAS");
        } else {
            if (this.chkBAS.isSelected()) {
                this.met99Datos.selBAS = true;
            } else {
                this.met99Datos.selBAS = false;
                this.met99Datos.sumaBAS = 0;
            }
            this.clickCobertura(this.chkBAS, this.sumaBAS, this.primaBAS, "BAS");
        }
    }

    public void clickCII() {
        this.met99Datos.selCII = this.chkCII.isSelected();
        if (this.met99Datos.optSuma.booleanValue()) {
            this.met99Datos.sumaCII = this.met99Calcula.SumaCobertura("CII", this.met99Datos.selCII, this.met99Datos.sumaBAS, 0);
        } else {
            this.CalculaSumaConPrimaObjetivo();
            if (this.GFfueDeshabilitada.booleanValue()) {
                this.genSubs.MuestraMensaje("Se recalcular\u00e1 sin Gastos Funerarios", "Provida");
                this.CalculaSumaConPrimaObjetivo();
            }
        }
        this.clickCobertura(this.chkCII, this.sumaCII, this.primaCII, "CII");
    }

    public void clickCMA() {
        this.met99Datos.selCMA = this.chkCMA.isSelected();
        if (this.met99Datos.optSuma.booleanValue()) {
            if (this.met99Datos.selCMA.booleanValue()) {
                this.met99Datos.sumaTIBA = 0;
                this.met99Datos.sumaCMA = this.met99Calcula.SumaCobertura("CMA", this.met99Datos.selCMA, this.met99Datos.sumaBAS, 0);
            } else {
                this.met99Datos.sumaCMA = 0;
            }
        } else {
            this.CalculaSumaConPrimaObjetivo();
            if (this.GFfueDeshabilitada.booleanValue()) {
                this.genSubs.MuestraMensaje("Se recalcular\u00e1 sin Gastos Funerarios", "Provida");
                this.CalculaSumaConPrimaObjetivo();
            }
        }
        this.clickCobertura(this.chkCMA, this.sumaCMA, this.primaCMA, "CMA");
        if (this.chkCMA.isSelected()) {
            this.chkTIBA.setSelected(false);
            this.met99Datos.selTIBA = false;
            this.sumaTIBA.setVisible(false);
            this.primaTIBA.setVisible(false);
            this.met99Datos.sumaTIBA = 0;
        }
    }

    public void clickTIBA() {
        this.met99Datos.selTIBA = this.chkTIBA.isSelected();
        if (this.met99Datos.optSuma.booleanValue()) {
            this.met99Datos.sumaTIBA = this.met99Calcula.SumaCobertura("TIBA", this.met99Datos.selTIBA, this.met99Datos.sumaBAS, 0);
        } else {
            this.CalculaSumaConPrimaObjetivo();
            if (this.GFfueDeshabilitada.booleanValue()) {
                this.genSubs.MuestraMensaje("Se recalcular\u00e1 sin Gastos Funerarios", "Provida");
                this.CalculaSumaConPrimaObjetivo();
            }
        }
        this.clickCobertura(this.chkTIBA, this.sumaTIBA, this.primaTIBA, "TIBA");
        if (this.chkTIBA.isSelected()) {
            this.met99Datos.selCMA = false;
            this.chkCMA.setSelected(false);
            this.sumaCMA.setVisible(false);
            this.primaCMA.setVisible(false);
            this.met99Datos.sumaCMA = 0;
        } else {
            this.sumaTIBA.setText("");
            this.primaTIBA.setText("");
        }
    }

    public void clickCAT() {
        this.met99Datos.selCAT = this.chkCAT.isSelected();
        if (this.met99Datos.optSuma.booleanValue()) {
            this.met99Datos.sumaCAT = this.met99Calcula.SumaCobertura("CAT", this.met99Datos.selCAT, this.met99Datos.sumaBAS, 0);
        } else {
            this.CalculaSumaConPrimaObjetivo();
            if (this.GFfueDeshabilitada.booleanValue()) {
                this.genSubs.MuestraMensaje("Se recalcular\u00e1 sin Gastos Funerarios", "Provida");
                this.CalculaSumaConPrimaObjetivo();
            }
        }
        this.clickCobertura(this.chkCAT, this.sumaCAT, this.primaCAT, "CAT");
    }

    public void clickGFA() {
        this.met99Datos.selGFA = this.chkGFA.isSelected();
        if (this.optNueva.isSelected()) {
            if (this.met99Datos.optSuma.booleanValue()) {
                this.met99Datos.sumaGFA = this.met99Calcula.SumaCobertura("GFA", this.met99Datos.selGFA, (int)(0.35 * (double)this.met99Datos.sumaBAS.intValue() + 0.5), 0);
                if (this.met99Datos.sumaLimitada.booleanValue() && this.met99Datos.selGFA.booleanValue()) {
                    this.met99Reglas.SumaGFA();
                    if (this.met99Datos.sumaGFA == 0) {
                        this.genSubs.MuestraMensaje("Excede suma limitada por ocupaci\u00f3n", "GFT");
                        this.chkGFA.setSelected(false);
                        this.met99Datos.selGFA = false;
                    }
                }
            } else {
                this.CalculaSumaConPrimaObjetivo();
                if ((int)(0.35 * (double)this.met99Datos.sumaBAS.intValue() + 0.5) < this.met99Datos.sumaMin.get(this.indiceCob)) {
                    this.genSubs.MuestraMensaje("No es posible enontrar una soluci\u00f3n, intente con otra prima", "Provida");
                    this.CalculaSumaConPrimaObjetivo();
                }
            }
        } else if (!this.met99Datos.optSuma.booleanValue()) {
            this.CalculaSumaConPrimaObjetivo();
            if (this.met99Datos.selBAS.booleanValue() && (int)(0.35 * (double)this.met99Datos.sumaBAS.intValue() + 0.5) < this.met99Datos.sumaMin.get(this.indiceCob)) {
                this.genSubs.MuestraMensaje("No es posible enontrar una soluci\u00f3n, intente con otra prima", "Provida");
                this.CalculaSumaConPrimaObjetivo();
            }
        }
        this.clickCobertura(this.chkGFA, this.sumaGFA, this.primaGFA, "GFA");
    }

    public void clickGE() {
        this.met99Datos.selGE = this.chkGE.isSelected();
        if (this.met99Datos.optSuma.booleanValue()) {
            this.met99Datos.sumaGE = this.met99Calcula.SumaCobertura("GE", this.met99Datos.selGE, this.met99Datos.sumaBAS, 0);
            if (this.met99Datos.sumaLimitada.booleanValue() && this.met99Datos.selGE.booleanValue()) {
                this.met99Reglas.SumaGE();
                if (this.met99Datos.sumaGE == 0) {
                    this.genSubs.MuestraMensaje("Excede suma limitada por ocupaci\u00f3n", "GE");
                    this.chkGE.setSelected(false);
                    this.met99Datos.selGE = false;
                }
            }
        } else {
            this.CalculaSumaConPrimaObjetivo();
            if (this.GFfueDeshabilitada.booleanValue()) {
                this.genSubs.MuestraMensaje("Se recalcular\u00e1 sin Gastos Funerarios", "Provida");
                this.CalculaSumaConPrimaObjetivo();
            }
        }
        this.clickCobertura(this.chkGE, this.sumaGE, this.primaGE, "GE");
    }

    public void clickAP() {
        this.met99Datos.selAP = this.chkAP.isSelected();
        if (this.met99Datos.optSuma.booleanValue()) {
            this.met99Datos.sumaAP = this.met99Calcula.SumaCobertura("AP", this.met99Datos.selAP, this.met99Datos.sumaBAS, 0);
            this.sumaAP.setText(this.genSubs.FormatoNumInteger("###,###", this.met99Datos.sumaAP));
        } else {
            this.CalculaSumaConPrimaObjetivo();
            if (this.GFfueDeshabilitada.booleanValue()) {
                this.genSubs.MuestraMensaje("Se recalcular\u00e1 sin Gastos Funerarios", "Provida");
                this.CalculaSumaConPrimaObjetivo();
            }
        }
        this.clickCobertura(this.chkAP, this.sumaAP, this.primaAP, "AP");
        this.sumaAP.setVisible(false);
        if (this.chkAP.isSelected()) {
            this.optAPbasica.setVisible(true);
            this.optAPextra.setVisible(true);
        } else {
            this.optAPbasica.setVisible(false);
            this.optAPextra.setVisible(false);
        }
    }

    public void clickSumaAP() {
        if (this.optAPbasica.isSelected()) {
            this.met99Datos.optSumaAP = 1;
            this.met99Datos.sumaAP = this.met99Calcula.SumaCobertura("AP", this.met99Datos.selAP, this.met99Datos.sumaBAS, 0);
        } else {
            this.met99Datos.optSumaAP = 2;
            this.met99Datos.sumaAP = this.met99Calcula.SumaCobertura("AP", this.met99Datos.selAP, this.met99Datos.sumaBAS, 0);
        }
        this.sumaAP.setText(this.genSubs.FormatoNumInteger("###,###", this.met99Datos.sumaAP));
        if (this.met99Datos.optSuma.booleanValue()) {
            this.met99Calcula.CalculaPrimas();
        } else {
            this.CalculaSumaConPrimaObjetivo();
            if (this.GFfueDeshabilitada.booleanValue()) {
                this.genSubs.MuestraMensaje("Se recalcular\u00e1 sin Gastos Funerarios", "Provida");
                this.CalculaSumaConPrimaObjetivo();
            }
        }
        this.RecuperaDatos();
    }

    public void clickSumaAPcomp() {
        if (this.optAPbasicaComp.isSelected()) {
            this.met99Datos.lstOptSumaAP.set(this.indexComp, 1);
            this.met99Datos.lstSumaAP.set(this.indexComp, this.met99Datos.sumaAPbasico);
        } else {
            this.met99Datos.lstOptSumaAP.set(this.indexComp, 2);
            this.met99Datos.lstSumaAP.set(this.indexComp, this.met99Datos.sumaAPextra);
        }
        this.sumaAPcomp.setText(this.genSubs.FormatoNumInteger("###,###", this.met99Datos.lstSumaAP.get(this.indexComp)));
        if (this.met99Datos.optSuma.booleanValue()) {
            this.met99Calcula.PrimaAPcomp(this.indexComp);
            this.met99Calcula.CalculaPrimas();
        } else {
            this.CalculaSumaConPrimaObjetivo();
            if (this.GFfueDeshabilitada.booleanValue()) {
                this.genSubs.MuestraMensaje("Se recalcular\u00e1 sin Gastos Funerarios", "Provida");
                this.CalculaSumaConPrimaObjetivo();
            }
        }
        this.RecuperaDatos();
    }

    public void clickEG() {
        this.met99Datos.selEG = this.chkEG.isSelected();
        if (this.met99Datos.optSuma.booleanValue()) {
            this.met99Datos.sumaEG = this.met99Calcula.SumaCobertura("EG", this.met99Datos.selEG, this.met99Datos.sumaBAS, 0);
        } else {
            this.CalculaSumaConPrimaObjetivo();
            if (this.GFfueDeshabilitada.booleanValue()) {
                this.genSubs.MuestraMensaje("Se recalcular\u00e1 sin Gastos Funerarios", "Provida");
                this.CalculaSumaConPrimaObjetivo();
            }
        }
        this.clickCobertura(this.chkEG, this.sumaEG, this.primaEG, "EG");
    }

    public void clickCR() {
        this.met99Datos.selCR = this.chkCR.isSelected();
        if (this.met99Datos.optSuma.booleanValue()) {
            this.met99Datos.sumaCR = this.met99Calcula.SumaCobertura("CR", this.met99Datos.selCR, this.met99Datos.sumaBAS, 0);
        } else {
            this.CalculaSumaConPrimaObjetivo();
            if (this.GFfueDeshabilitada.booleanValue()) {
                this.genSubs.MuestraMensaje("Se recalcular\u00e1 sin Gastos Funerarios", "Provida");
                this.CalculaSumaConPrimaObjetivo();
            }
        }
        this.clickCobertura(this.chkCR, this.sumaCR, this.primaCR, "CR");
    }

    public void clickPHT() {
        this.met99Datos.selPHT = this.chkPHT.isSelected();
        if (this.met99Datos.optSuma.booleanValue()) {
            this.met99Datos.sumaPHT = this.met99Calcula.SumaCobertura("PHT", this.met99Datos.selPHT, this.met99Datos.sumaBAS, 0);
        } else {
            this.CalculaSumaConPrimaObjetivo();
            if (this.GFfueDeshabilitada.booleanValue()) {
                this.genSubs.MuestraMensaje("Se recalcular\u00e1 sin Gastos Funerarios", "Provida");
                this.CalculaSumaConPrimaObjetivo();
            }
        }
        this.clickCoberturaPHT(this.chkPHT, this.sumaPHT, this.primaPHT, "PHT");
    }

    public void clickBACY() {
        this.met99Datos.selBACY = this.chkBACY.isSelected();
        if (this.met99Datos.optSuma.booleanValue()) {
            if (this.met99Datos.optNueva.booleanValue()) {
                this.met99Datos.sumaBACY = this.met99Calcula.SumaCobertura("BACY", this.met99Datos.selBACY, this.met99Datos.sumaBAS, 0);
                if (this.met99Datos.sumaBACY == this.met99Datos.sumaBAS) {
                    this.chkGFC.setDisable(true);
                } else {
                    this.RevisaSumaMinGF();
                }
            } else if (this.met99Datos.sumaBACY > this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("BACY"))) {
                this.met99Datos.sumaBACY = this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("BACY"));
            }
        } else {
            this.CalculaSumaConPrimaObjetivo();
            if (this.GFfueDeshabilitada.booleanValue()) {
                this.genSubs.MuestraMensaje("Se recalcular\u00e1 sin Gastos Funerarios", "Provida");
                this.CalculaSumaConPrimaObjetivo();
            }
        }
        if (this.met99Datos.edadRealConyuge > 70 && this.met99Datos.sumaBACY > 400000) {
            this.met99Datos.sumaBACY = 400000;
        }
        this.clickCobertura(this.chkBACY, this.sumaBACY, this.primaBACY, "BACY");
    }

    public void clickGFC() {
        this.met99Datos.selGFC = this.chkGFC.isSelected();
        if (this.met99Datos.optSuma.booleanValue()) {
            if (this.met99Datos.optNueva.booleanValue()) {
                this.met99Datos.sumaGFC = this.met99Calcula.SumaCobertura("GFC", this.met99Datos.selGFC, this.met99Datos.sumaBAS, 0);
            }
        } else {
            this.CalculaSumaConPrimaObjetivo();
            if (this.met99Datos.selBAS.booleanValue() && (int)(0.35 * (double)this.met99Datos.sumaBAS.intValue() + 0.5) < this.met99Datos.sumaMin.get(this.indiceCob)) {
                this.genSubs.MuestraMensaje("No es posible enontrar una soluci\u00f3n, intente con otra prima", "Provida");
                this.CalculaSumaConPrimaObjetivo();
            }
        }
        this.clickCobertura(this.chkGFC, this.sumaGFC, this.primaGFC, "GFC");
    }

    public void clickBCAC() {
        this.met99Datos.selBCAC = this.chkBCAC.isSelected();
        if (this.met99Datos.optSuma.booleanValue()) {
            this.met99Datos.sumaBCAC = this.met99Calcula.SumaCobertura("BCAC", this.met99Datos.selBCAC, this.met99Datos.sumaBAS, 0);
        } else {
            this.CalculaSumaConPrimaObjetivo();
            if (this.GFfueDeshabilitada.booleanValue()) {
                this.genSubs.MuestraMensaje("Se recalcular\u00e1 sin Gastos Funerarios", "Provida");
                this.CalculaSumaConPrimaObjetivo();
            }
        }
        this.clickCobertura(this.chkBCAC, this.sumaBCAC, this.primaBCAC, "BCAC");
    }

    public void clickGFH() {
        this.met99Datos.selGFH = this.chkGFH.isSelected();
        if (this.met99Datos.optSuma.booleanValue()) {
            this.met99Datos.sumaGFH = this.met99Calcula.SumaCobertura("GFH", this.met99Datos.selGFH, this.met99Datos.sumaBAS, 0);
        } else {
            this.CalculaSumaConPrimaObjetivo();
            if (this.met99Datos.selBAS.booleanValue() && (int)(0.35 * (double)this.met99Datos.sumaBAS.intValue() + 0.5) < this.met99Datos.sumaMin.get(this.indiceCob)) {
                this.genSubs.MuestraMensaje("No es posible enontrar una soluci\u00f3n, intente con otra prima", "Provida");
                this.CalculaSumaConPrimaObjetivo();
            }
        }
        this.met99Datos.numHijos = this.optUnHijo.isSelected() ? Integer.valueOf(1) : (this.optDosHijos.isSelected() ? Integer.valueOf(2) : Integer.valueOf(3));
        this.clickCobertura(this.chkGFH, this.sumaGFH, this.primaGFH, "GFH");
        if (this.chkGFH.isSelected()) {
            this.optUnHijo.setVisible(true);
            this.optDosHijos.setVisible(true);
            this.optTresHijos.setVisible(true);
        } else {
            this.optUnHijo.setVisible(false);
            this.optDosHijos.setVisible(false);
            this.optTresHijos.setVisible(false);
        }
    }

    public void clickNumHijos() {
        this.met99Datos.numHijos = this.optUnHijo.isSelected() ? Integer.valueOf(1) : (this.optDosHijos.isSelected() ? Integer.valueOf(2) : Integer.valueOf(3));
        if (this.met99Datos.optSuma.booleanValue()) {
            this.met99Calcula.CalculaPrimas();
        } else {
            this.CalculaSumaConPrimaObjetivo();
            if (this.GFfueDeshabilitada.booleanValue()) {
                this.genSubs.MuestraMensaje("Se recalcular\u00e1 sin Gastos Funerarios", "Provida");
                this.CalculaSumaConPrimaObjetivo();
            }
        }
        this.RecuperaDatos();
    }

    public void clickBACcomp() {
        this.met99Datos.lstSelBAC.set(this.indexComp, this.chkBACcomp.isSelected());
        if (this.met99Datos.optSuma.booleanValue()) {
            this.met99Datos.lstSumaBAC.set(this.indexComp, this.met99Calcula.SumaCobertura("BACcomp", this.met99Datos.lstSelBAC.get(this.indexComp), this.met99Datos.sumaBAS, this.indexComp));
            if (this.met99Datos.lstEdadComp.get(this.indexComp) > 70 && this.met99Datos.lstSumaBAC.get(this.indexComp) > 400000) {
                this.met99Datos.lstSumaBAC.set(this.indexComp, 400000);
            }
        } else {
            this.CalculaSumaConPrimaObjetivo();
            if (this.GFfueDeshabilitada.booleanValue()) {
                this.genSubs.MuestraMensaje("Se recalcular\u00e1 sin Gastos Funerarios", "Provida");
                this.CalculaSumaConPrimaObjetivo();
            }
        }
        if (this.met99Datos.optNueva.booleanValue()) {
            if (this.met99Datos.optSuma.booleanValue()) {
                if (this.met99Datos.lstSumaBAC.get(this.indexComp) == this.met99Datos.sumaBAS) {
                    this.chkGFcomp.setDisable(true);
                } else {
                    this.RevisaSumaMinGF();
                }
            } else {
                this.chkGFcomp.setDisable(false);
            }
        }
        if (this.numGF >= this.maxGF) {
            this.chkGFcomp.setDisable(true);
        }
        this.clickCoberturaComp(this.chkBACcomp, this.sumaBACcomp, this.primaBACcomp, "BACcomp");
    }

    public void clickBCACcomp() {
        this.met99Datos.lstSelBCAC.set(this.indexComp, this.chkBCACcomp.isSelected());
        if (this.met99Datos.optSuma.booleanValue()) {
            this.met99Datos.lstSumaBCAC.set(this.indexComp, this.met99Calcula.SumaCobertura("BCACcomp", this.met99Datos.lstSelBCAC.get(this.indexComp), this.met99Datos.sumaBAS, this.indexComp));
        } else {
            this.CalculaSumaConPrimaObjetivo();
            if (this.GFfueDeshabilitada.booleanValue()) {
                this.genSubs.MuestraMensaje("Se recalcular\u00e1 sin Gastos Funerarios", "Provida");
                this.CalculaSumaConPrimaObjetivo();
            }
        }
        this.clickCoberturaComp(this.chkBCACcomp, this.sumaBCACcomp, this.primaBCACcomp, "BCACcomp");
    }

    public void clickAPcomp() {
        this.met99Datos.lstSelAP.set(this.indexComp, this.chkAPcomp.isSelected());
        if (this.optAPbasicaComp.isSelected()) {
            this.met99Datos.lstOptSumaAP.set(this.indexComp, 1);
        } else {
            this.met99Datos.lstOptSumaAP.set(this.indexComp, 2);
        }
        if (this.met99Datos.optSuma.booleanValue()) {
            this.met99Datos.lstSumaAP.set(this.indexComp, this.met99Calcula.SumaCobertura("APcomp", this.met99Datos.lstSelAP.get(this.indexComp), this.met99Datos.sumaBAS, this.indexComp));
            this.sumaAPcomp.setText(this.genSubs.FormatoNumInteger("###,###", this.met99Datos.lstSumaAP.get(this.indexComp)));
        } else {
            this.CalculaSumaConPrimaObjetivo();
            if (this.GFfueDeshabilitada.booleanValue()) {
                this.genSubs.MuestraMensaje("Se recalcular\u00e1 sin Gastos Funerarios", "Provida");
                this.CalculaSumaConPrimaObjetivo();
            }
        }
        this.clickCoberturaComp(this.chkAPcomp, this.sumaAPcomp, this.primaAPcomp, "APcomp");
        this.sumaAPcomp.setVisible(false);
        if (this.chkAPcomp.isSelected()) {
            this.optAPbasicaComp.setVisible(true);
            this.optAPextraComp.setVisible(true);
        } else {
            this.optAPbasicaComp.setVisible(false);
            this.optAPextraComp.setVisible(false);
        }
    }

    public void clickGFcomp() {
        this.met99Datos.lstSelGF.set(this.indexComp, this.chkGFcomp.isSelected());
        if (this.met99Datos.optSuma.booleanValue()) {
            this.met99Datos.lstSumaGF.set(this.indexComp, this.met99Calcula.SumaCobertura("GFcomp", this.met99Datos.lstSelGF.get(this.indexComp), this.met99Datos.sumaBAS, this.indexComp));
        } else {
            this.CalculaSumaConPrimaObjetivo();
            if (this.met99Datos.selBAS.booleanValue() && (int)(0.35 * (double)this.met99Datos.sumaBAS.intValue() + 0.5) < this.met99Datos.sumaMin.get(this.indiceCob)) {
                this.genSubs.MuestraMensaje("No es posible enontrar una soluci\u00f3n, intente con otra prima", "Provida");
                this.CalculaSumaConPrimaObjetivo();
            }
        }
        if (this.met99Datos.optNueva.booleanValue()) {
            if (this.met99Datos.lstSumaGF.get(this.indexComp) == this.met99Datos.sumaBAS) {
                this.chkBACcomp.setDisable(true);
            } else if (this.met99Datos.lstEdadComp.get(this.indexComp) > this.met99Datos.edadMax.get(this.genSubs.IndiceCob("BACcomp"))) {
                this.chkBACcomp.setDisable(true);
            } else {
                this.chkBACcomp.setDisable(false);
            }
        }
        for (int i = 0; i < this.met99Datos.numComp; ++i) {
            if (!this.met99Datos.lstSelBAC.get(i).booleanValue() || i == this.indexComp) continue;
            this.chkBACcomp.setDisable(true);
        }
        this.VerificaConyugeComplementario();
        this.clickCoberturaComp(this.chkGFcomp, this.sumaGFcomp, this.primaGFcomp, "GFcomp");
    }

    public void clickEGcomp() {
        this.met99Datos.lstSelEG.set(this.indexComp, this.chkEGcomp.isSelected());
        if (this.met99Datos.optSuma.booleanValue()) {
            this.met99Datos.lstSumaEG.set(this.indexComp, this.met99Calcula.SumaCobertura("EGcomp", this.met99Datos.lstSelEG.get(this.indexComp), this.met99Datos.sumaBAS, this.indexComp));
        } else {
            this.CalculaSumaConPrimaObjetivo();
        }
        this.clickCoberturaComp(this.chkEGcomp, this.sumaEGcomp, this.primaEGcomp, "EGcomp");
    }

    public void clickCRcomp() {
        this.met99Datos.lstSelCR.set(this.indexComp, this.chkCRcomp.isSelected());
        if (this.met99Datos.optSuma.booleanValue()) {
            this.met99Datos.lstSumaCR.set(this.indexComp, this.met99Calcula.SumaCobertura("CRcomp", this.met99Datos.lstSelCR.get(this.indexComp), this.met99Datos.sumaBAS, this.indexComp));
        } else {
            this.CalculaSumaConPrimaObjetivo();
        }
        this.clickCoberturaComp(this.chkCRcomp, this.sumaCRcomp, this.primaCRcomp, "CRcomp");
    }

    public void clickPHXcomp() {
        this.met99Datos.lstSelPHX.set(this.indexComp, this.chkPHX.isSelected());
        if (this.met99Datos.optSuma.booleanValue()) {
            this.met99Datos.lstSumaPHX.set(this.indexComp, this.met99Calcula.SumaCobertura("PHX", this.met99Datos.lstSelPHX.get(this.indexComp), this.met99Datos.sumaBAS, this.indexComp));
        } else {
            this.CalculaSumaConPrimaObjetivo();
        }
        this.clickCoberturaPHX(this.chkPHX, this.sumaPHX, this.primaPHX, "PHcomp");
    }

    public void clickBIT() {
        if (this.chkBIT.isSelected()) {
            this.met99Datos.selBIT = true;
            this.primaBIT.setVisible(true);
            if (this.met99Datos.optSuma.booleanValue()) {
                this.met99Calcula.CalculaPrimas();
            } else {
                this.CalculaSumaConPrimaObjetivo();
                if (this.GFfueDeshabilitada.booleanValue()) {
                    this.genSubs.MuestraMensaje("Se recalcular\u00e1 sin Gastos Funerarios", "Provida");
                    this.CalculaSumaConPrimaObjetivo();
                }
            }
            this.RecuperaDatos();
        } else {
            this.met99Datos.selBIT = false;
            this.primaBIT.setVisible(false);
            this.met99Datos.sumaBIT = 0.0;
            if (this.met99Datos.optSuma.booleanValue()) {
                this.met99Calcula.CalculaPrimas();
            } else {
                this.CalculaSumaConPrimaObjetivo();
                if (this.GFfueDeshabilitada.booleanValue()) {
                    this.genSubs.MuestraMensaje("Se recalcular\u00e1 sin Gastos Funerarios", "Provida");
                    this.CalculaSumaConPrimaObjetivo();
                }
            }
            this.RecuperaDatos();
            this.primaBIT.setText("");
        }
    }

    private void RevisaSumaMinGF() {
        this.indiceCob = this.genSubs.IndiceCob("GF");
        if (this.met99Datos.optNueva.booleanValue()) {
            if ((int)(0.35 * (double)this.met99Datos.sumaBAS.intValue() + 0.5) < this.met99Datos.sumaMin.get(this.indiceCob)) {
                this.met99Datos.selGFA = false;
                this.met99Datos.sumaGFA = 0;
                this.chkGFA.setSelected(false);
                this.chkGFA.setDisable(true);
                this.met99Datos.selGFH = false;
                this.met99Datos.sumaGFH = 0;
                this.chkGFH.setSelected(false);
                this.chkGFH.setDisable(true);
                this.met99Datos.selGFC = false;
                this.met99Datos.sumaGFC = 0;
                this.chkGFC.setSelected(false);
                this.chkGFC.setDisable(true);
                this.necesitaSumaBASmayor = true;
                for (int i = 0; i < this.met99Datos.numComp; ++i) {
                    this.met99Datos.lstSelGF.set(i, false);
                    this.met99Datos.lstSumaGF.set(i, 0);
                    this.met99Datos.lstPrimaGF.set(i, 0.0);
                    this.met99Datos.lstSelGF.set(i, false);
                    this.met99Datos.lstSumaGF.set(i, 0);
                }
                this.chkGFcomp.setSelected(false);
                this.chkGFcomp.setDisable(true);
                this.necesitaSumaBASmayor = true;
                Integer indexCompAnt = this.indexComp;
                this.indexComp = 0;
                while (this.indexComp < this.met99Datos.numComp) {
                    this.ActualizaTablaComp();
                    Integer n = this.indexComp;
                    Integer n2 = this.indexComp = Integer.valueOf(this.indexComp + 1);
                }
                this.indexComp = indexCompAnt;
            } else {
                this.chkGFA.setDisable(false);
                this.chkGFH.setDisable(false);
                if (this.met99Datos.numComp > 0) {
                    this.indexComp = this.cmbComp.getSelectionModel().getSelectedIndex();
                    if (this.met99Datos.lstEdadComp.get(this.indexComp) < this.met99Datos.edadMin.get(this.genSubs.IndiceCob("GFcomp"))) {
                        this.chkGFcomp.setDisable(true);
                    } else {
                        if (this.met99Datos.lstSumaBAC.get(this.indexComp) == this.met99Datos.sumaBAS) {
                            this.chkGFcomp.setDisable(true);
                        }
                        this.chkGFcomp.setDisable(false);
                    }
                } else {
                    this.chkGFcomp.setDisable(true);
                }
                if (this.met99Datos.sumaBACY == 0) {
                    this.chkGFC.setDisable(false);
                } else if (this.met99Datos.sumaGFC > 0 && this.met99Datos.sumaBACY > this.met99Datos.sumaBAS - this.met99Datos.sumaGFC) {
                    this.met99Datos.sumaBACY = this.met99Datos.sumaBAS - this.met99Datos.sumaGFC;
                }
                this.ValidaConsistenciaGFcomp();
                this.necesitaSumaBASmayor = false;
            }
        }
    }

    private void RevisaExclusionAP() {
        if (this.met99Datos.APactivado == 0) {
            this.chkAP.setDisable(true);
            this.optAPbasica.setDisable(true);
            this.optAPextra.setDisable(true);
            this.met99Datos.sumaAP = 0;
            this.met99Datos.selAP = false;
            this.met99Datos.primaAP = 0.0;
            for (int i = 0; i < this.met99Datos.numComp; ++i) {
                this.met99Datos.lstSelAP.set(i, false);
                this.met99Datos.lstSumaAP.set(i, 0);
                this.met99Datos.lstPrimaAP.set(i, 0.0);
                this.ArmaTablaComp();
            }
        } else {
            this.chkAP.setDisable(false);
            this.optAPbasica.setDisable(false);
            this.optAPextra.setDisable(false);
        }
        this.ValidaEdadCoberturas();
    }

    private void ValidaConsistenciaGFcomp() {
        Integer compGF = 0;
        String idConyuge = this.met99Datos.nombreConyuge + this.met99Datos.edadRealConyuge + this.met99Datos.sexoConyuge;
        String idComp = "";
        for (int i = 0; i < this.met99Datos.numComp; ++i) {
            if (!this.met99Datos.lstSelBAC.get(i).booleanValue()) continue;
            compGF = i;
            idComp = this.met99Datos.lstNombreComp.get(i) + this.met99Datos.lstEdadComp.get(i) + this.met99Datos.lstSexoComp.get(i);
        }
        if (compGF > 0 && idConyuge.equals(idComp)) {
            this.chkGFC.setDisable(true);
            this.met99Datos.selGFC = false;
            this.met99Datos.sumaGFC = 0;
        }
    }

    private void clickCoberturaPHT(CheckBox chkCobertura, Label txtSuma, Label lblPrima, String idCobertura) {
        if (chkCobertura.isSelected()) {
            txtSuma.setVisible(true);
            lblPrima.setVisible(true);
        } else {
            txtSuma.setVisible(false);
            lblPrima.setVisible(false);
            txtSuma.setText("");
            lblPrima.setText("");
        }
        this.met99Calcula.CalculaPrimas();
        this.RecuperaDatos();
    }

    private void clickCoberturaPHX(CheckBox chkCobertura, Label txtSuma, Label lblPrima, String idCobertura) {
        if (chkCobertura.isSelected()) {
            txtSuma.setVisible(true);
            lblPrima.setVisible(true);
        } else {
            txtSuma.setVisible(false);
            lblPrima.setVisible(false);
            txtSuma.setText("");
            lblPrima.setText("");
        }
        this.met99Calcula.CalculaPrimas();
        this.RecuperaDatos();
        this.ActualizaTablaComp();
    }

    private void clickCobertura(CheckBox chkCobertura, TextField txtSuma, Label lblPrima, String idCobertura) {
        if (chkCobertura.isSelected()) {
            txtSuma.setVisible(true);
            lblPrima.setVisible(true);
        } else {
            txtSuma.setVisible(false);
            lblPrima.setVisible(false);
            txtSuma.setText("");
            lblPrima.setText("");
        }
        this.met99Calcula.CalculaPrimas();
        this.RecuperaDatos();
    }

    private void clickCoberturaComp(CheckBox chkCobertura, TextField txtSuma, Label lblPrima, String idCobertura) {
        if (chkCobertura.isSelected()) {
            txtSuma.setVisible(true);
            lblPrima.setVisible(true);
        } else {
            txtSuma.setVisible(false);
            lblPrima.setVisible(false);
            txtSuma.setText("");
            lblPrima.setText("");
        }
        switch (idCobertura) {
            case "BACcomp": {
                this.met99Calcula.PrimaBACcomp(this.indexComp);
                break;
            }
            case "BCACcomp": {
                this.met99Calcula.PrimaBCACcomp(this.indexComp);
                break;
            }
            case "APcomp": {
                this.met99Calcula.PrimaAPcomp(this.indexComp);
                break;
            }
            case "GFcomp": {
                this.met99Calcula.PrimaGFcomp(this.indexComp);
                break;
            }
            case "EGcomp": {
                this.met99Calcula.PrimaEGcomp(this.indexComp);
                break;
            }
            case "CRcomp": {
                this.met99Calcula.PrimaCRcomp(this.indexComp);
                break;
            }
            default: {
                this.met99Calcula.CalculaPrimas();
            }
        }
        this.met99Calcula.CalculaPrimas();
        this.RecuperaDatos();
        this.ActualizaTablaComp();
    }

    private void ActualizaTablaComp() {
        String okBAC = "";
        String okBCAC = "";
        String okAP = "";
        String okGF = "";
        String okEG = "";
        String okCR = "";
        String okPHX = "";
        if (this.met99Datos.lstSelBAC.get(this.indexComp).booleanValue()) {
            okBAC = "\u2713";
        }
        if (this.met99Datos.lstSelBCAC.get(this.indexComp).booleanValue()) {
            okBCAC = "\u2713";
        }
        if (this.met99Datos.lstSelAP.get(this.indexComp).booleanValue()) {
            okAP = "\u2713";
        }
        if (this.met99Datos.lstSelGF.get(this.indexComp).booleanValue()) {
            okGF = "\u2713";
        }
        if (this.met99Datos.lstSelEG.get(this.indexComp).booleanValue()) {
            okEG = "\u2713";
        }
        if (this.met99Datos.lstSelCR.get(this.indexComp).booleanValue()) {
            okCR = "\u2713";
        }
        if (this.met99Datos.lstSelPHX.get(this.indexComp).booleanValue()) {
            okPHX = "\u2713";
        }
        this.listaComp.set(this.indexComp.intValue(), (Object)new Person(this.met99Datos.lstNombreComp.get(this.indexComp), okBAC, okBCAC, okAP, okGF, okEG, okCR, okPHX));
    }

    private void ValidaCaptura(String nombreControl) {
        switch (nombreControl) {
            case "sumaBAS": {
                this.ValidaSumaBAS();
                break;
            }
            case "sumaCII": {
                this.ValidaSumaCII();
                break;
            }
            case "sumaCMA": {
                this.ValidaSumaCMA();
                break;
            }
            case "sumaTIBA": {
                this.ValidaSumaTIBA();
                break;
            }
            case "sumaCAT": {
                this.ValidaSumaCAT();
                break;
            }
            case "sumaGFA": {
                this.ValidaSumaGFA();
                break;
            }
            case "sumaGE": {
                this.ValidaSumaGE();
                break;
            }
            case "sumaEG": {
                this.ValidaSumaEG();
                break;
            }
            case "sumaCR": {
                this.ValidaSumaCR();
                break;
            }
            case "sumaBACY": {
                this.ValidaSumaBACY();
                break;
            }
            case "sumaGFC": {
                this.ValidaSumaGFC();
                break;
            }
            case "sumaBCAC": {
                this.ValidaSumaBCAC();
                break;
            }
            case "sumaGFH": {
                this.ValidaSumaGFH();
                break;
            }
            case "sumaBIT": {
                break;
            }
            case "sumaBACcomp": {
                this.ValidaSumaBACcomp();
                break;
            }
            case "sumaBCACcomp": {
                this.ValidaSumaBCACcomp();
                break;
            }
            case "sumaAPcomp": {
                this.ValidaSumaAPcomp();
                break;
            }
            case "sumaGFcomp": {
                this.ValidaSumaGFcomp();
                break;
            }
            case "sumaEGcomp": {
                this.ValidaSumaEGcomp();
                break;
            }
            case "sumaCRcomp": {
                this.ValidaSumaCRcomp();
            }
        }
    }

    private void ValidaSumaBAS() {
        Integer sumaBASant = this.met99Datos.sumaBAS;
        this.hayError = false;
        if (this.sumaBAS.getText().equals("")) {
            this.sumaBAS.setText("0");
        }
        this.sumaBAS.setText(this.genSubs.QuitaComas(this.sumaBAS.getText()));
        if (this.genSubs.EsNumeroEntero(this.sumaBAS.getText()).booleanValue()) {
            this.met99Datos.sumaBAS = Integer.parseInt(this.sumaBAS.getText());
            if (this.met99Datos.optNueva.booleanValue()) {
                this.met99Reglas.SumaBAS();
            }
            if (this.met99Datos.optNueva.booleanValue() && sumaBASant > this.met99Datos.sumaBAS) {
                this.AsignaSumasCoberturas();
                if (this.met99Datos.sumaLimitada.booleanValue()) {
                    this.met99Reglas.SumaGE();
                }
            }
            this.RevisaSumaMinGF();
            this.met99Calcula.CalculaPrimas();
            this.RecuperaDatos();
        } else {
            this.genSubs.MuestraMensaje("Suma asegurada inv\u00e1lida", "sumaBAS");
            this.hayError = true;
            this.genSubs.EnfocaObjeto(this.sumaBAS);
        }
    }

    private void AsignaSumasCoberturas() {
        this.met99Datos.sumaCII = this.met99Calcula.SumaCobertura("CII", this.met99Datos.selCII, this.met99Datos.sumaBAS, 0);
        this.met99Datos.sumaCMA = this.met99Calcula.SumaCobertura("CMA", this.met99Datos.selCMA, this.met99Datos.sumaBAS, 0);
        this.met99Datos.sumaTIBA = this.met99Calcula.SumaCobertura("TIBA", this.met99Datos.selTIBA, this.met99Datos.sumaBAS, 0);
        this.met99Datos.sumaCAT = this.met99Calcula.SumaCobertura("CAT", this.met99Datos.selCAT, this.met99Datos.sumaBAS, 0);
        this.met99Datos.sumaGFA = this.met99Calcula.SumaCobertura("GFA", this.met99Datos.selGFA, (int)(0.35 * (double)this.met99Datos.sumaBAS.intValue() + 0.5), 0);
        this.met99Datos.sumaGE = this.met99Calcula.SumaCobertura("GE", this.met99Datos.selGE, this.met99Datos.sumaBAS, 0);
        this.met99Datos.sumaAP = this.met99Calcula.SumaCobertura("AP", this.met99Datos.selAP, this.met99Datos.sumaBAS, 0);
        this.met99Datos.sumaEG = this.met99Calcula.SumaCobertura("EG", this.met99Datos.selEG, this.met99Datos.sumaBAS, 0);
        this.met99Datos.sumaCR = this.met99Calcula.SumaCobertura("CR", this.met99Datos.selCR, this.met99Datos.sumaBAS, 0);
        this.met99Datos.sumaBACY = this.met99Calcula.SumaCobertura("BACY", this.met99Datos.selBACY, this.met99Datos.sumaBAS, 0);
        this.met99Datos.sumaGFC = this.met99Calcula.SumaCobertura("GFC", this.met99Datos.selGFC, this.met99Datos.sumaBAS, 0);
        this.met99Datos.sumaBCAC = this.met99Calcula.SumaCobertura("BCAC", this.met99Datos.selBCAC, this.met99Datos.sumaBAS, 0);
        this.met99Datos.sumaGFH = this.met99Calcula.SumaCobertura("GFH", this.met99Datos.selGFH, this.met99Datos.sumaBAS, 0);
        for (int i = 0; i < this.met99Datos.numComp; ++i) {
            this.met99Datos.lstSumaBAC.set(i, this.met99Calcula.SumaCobertura("BACcomp", this.met99Datos.lstSelBAC.get(i), this.met99Datos.sumaBAS, i));
            if (this.met99Datos.lstSumaBAC.get(i) == 0) {
                this.met99Datos.lstSelBAC.set(i, false);
            }
            this.met99Datos.lstSumaBCAC.set(i, this.met99Calcula.SumaCobertura("BCACcomp", this.met99Datos.lstSelBCAC.get(i), this.met99Datos.sumaBAS, i));
            this.met99Datos.lstSumaAP.set(i, this.met99Calcula.SumaCobertura("APcomp", this.met99Datos.lstSelAP.get(i), this.met99Datos.sumaBAS, i));
            this.met99Datos.lstSumaGF.set(i, this.met99Calcula.SumaCobertura("GFcomp", this.met99Datos.lstSelGF.get(i), this.met99Datos.sumaBAS, i));
            if (this.met99Datos.lstSumaGF.get(i) == 0) {
                this.met99Datos.lstSelGF.set(i, false);
            }
            this.met99Datos.lstSumaEG.set(i, this.met99Calcula.SumaCobertura("EGcomp", this.met99Datos.lstSelEG.get(i), this.met99Datos.sumaBAS, i));
            this.met99Datos.lstSumaCR.set(i, this.met99Calcula.SumaCobertura("CRcomp", this.met99Datos.lstSelCR.get(i), this.met99Datos.sumaBAS, i));
            this.met99Datos.lstSumaPHX.set(i, this.met99Calcula.SumaCobertura("PHX", this.met99Datos.lstSelPHX.get(i), this.met99Datos.sumaBAS, i));
        }
    }

    private void ValidaSumaCII() {
        this.hayError = false;
        if (this.sumaCII.getText().equals("")) {
            this.sumaCII.setText("0");
        }
        this.sumaCII.setText(this.genSubs.QuitaComas(this.sumaCII.getText()));
        if (this.genSubs.EsNumeroEntero(this.sumaCII.getText()).booleanValue()) {
            this.met99Datos.sumaCII = Integer.parseInt(this.sumaCII.getText());
            if (this.met99Datos.optNueva.booleanValue()) {
                this.met99Reglas.SumaCII();
            }
            this.met99Calcula.CalculaPrimas();
            this.RecuperaDatos();
        } else {
            this.genSubs.MuestraMensaje("Suma asegurada inv\u00e1lida", "sumaCII");
            this.hayError = true;
            this.genSubs.EnfocaObjeto(this.sumaCII);
        }
    }

    private void ValidaSumaCMA() {
        this.hayError = false;
        if (this.sumaCMA.getText().equals("")) {
            this.sumaCMA.setText("0");
        }
        this.sumaCMA.setText(this.genSubs.QuitaComas(this.sumaCMA.getText()));
        if (this.genSubs.EsNumeroEntero(this.sumaCMA.getText()).booleanValue()) {
            this.met99Datos.sumaCMA = Integer.parseInt(this.sumaCMA.getText());
            if (this.optNueva.isSelected() && this.met99Datos.optNueva.booleanValue()) {
                this.met99Reglas.SumaCMA();
            }
            this.met99Calcula.CalculaPrimas();
            this.RecuperaDatos();
        } else {
            this.genSubs.MuestraMensaje("Suma asegurada inv\u00e1lida", "sumaCMA");
            this.hayError = true;
            this.genSubs.EnfocaObjeto(this.sumaCMA);
        }
    }

    private void ValidaSumaTIBA() {
        this.hayError = false;
        if (this.sumaTIBA.getText().equals("")) {
            this.sumaTIBA.setText("0");
        }
        this.sumaTIBA.setText(this.genSubs.QuitaComas(this.sumaTIBA.getText()));
        if (this.genSubs.EsNumeroEntero(this.sumaTIBA.getText()).booleanValue()) {
            this.met99Datos.sumaTIBA = Integer.parseInt(this.sumaTIBA.getText());
            if (this.met99Datos.optNueva.booleanValue()) {
                this.met99Reglas.SumaTIBA();
            }
            this.met99Calcula.CalculaPrimas();
            this.RecuperaDatos();
        } else {
            this.genSubs.MuestraMensaje("Suma asegurada inv\u00e1lida", "sumaTIBA");
            this.hayError = true;
            this.genSubs.EnfocaObjeto(this.sumaTIBA);
        }
    }

    private void ValidaSumaCAT() {
        this.hayError = false;
        if (this.sumaCAT.getText().equals("")) {
            this.sumaCAT.setText("0");
        }
        this.sumaCAT.setText(this.genSubs.QuitaComas(this.sumaCAT.getText()));
        if (this.genSubs.EsNumeroEntero(this.sumaCAT.getText()).booleanValue()) {
            this.met99Datos.sumaCAT = Integer.parseInt(this.sumaCAT.getText());
            if (this.met99Datos.optNueva.booleanValue()) {
                this.met99Reglas.SumaCAT();
            } else if (this.met99Datos.sumaCAT > this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("CAT"))) {
                this.met99Datos.sumaCAT = this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("CAT"));
            }
            this.met99Calcula.CalculaPrimas();
            this.RecuperaDatos();
        } else {
            this.genSubs.MuestraMensaje("Suma asegurada inv\u00e1lida", "sumaCAT");
            this.hayError = true;
            this.genSubs.EnfocaObjeto(this.sumaCAT);
        }
    }

    private void ValidaSumaGFA() {
        this.hayError = false;
        if (this.sumaGFA.getText().equals("")) {
            this.sumaGFA.setText("0");
        }
        this.sumaGFA.setText(this.genSubs.QuitaComas(this.sumaGFA.getText()));
        if (this.genSubs.EsNumeroEntero(this.sumaGFA.getText()).booleanValue()) {
            this.met99Datos.sumaGFA = Integer.parseInt(this.sumaGFA.getText());
            if (this.met99Datos.optNueva.booleanValue()) {
                this.met99Reglas.SumaGFA();
            } else if (this.met99Datos.sumaGFA > this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("GFA"))) {
                this.met99Datos.sumaGFA = this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("GFA"));
            }
            this.met99Calcula.CalculaPrimas();
            this.RecuperaDatos();
        } else {
            this.genSubs.MuestraMensaje("Suma asegurada inv\u00e1lida", "sumaGFA");
            this.hayError = true;
            this.genSubs.EnfocaObjeto(this.sumaGFA);
        }
    }

    private void ValidaSumaGE() {
        this.hayError = false;
        if (this.sumaGE.getText().equals("")) {
            this.sumaGE.setText("0");
        }
        this.sumaGE.setText(this.genSubs.QuitaComas(this.sumaGE.getText()));
        if (this.genSubs.EsNumeroEntero(this.sumaGE.getText()).booleanValue()) {
            this.met99Datos.sumaGE = Integer.parseInt(this.sumaGE.getText());
            if (this.met99Datos.optNueva.booleanValue()) {
                this.met99Reglas.SumaGE();
            }
            this.met99Calcula.CalculaPrimas();
            this.RecuperaDatos();
        } else {
            this.genSubs.MuestraMensaje("Suma asegurada inv\u00e1lida", "sumaGE");
            this.hayError = true;
            this.genSubs.EnfocaObjeto(this.sumaGE);
        }
    }

    private void ValidaSumaEG() {
        this.hayError = false;
        if (this.sumaEG.getText().equals("")) {
            this.sumaEG.setText("0");
        }
        this.sumaEG.setText(this.genSubs.QuitaComas(this.sumaEG.getText()));
        if (this.genSubs.EsNumeroEntero(this.sumaEG.getText()).booleanValue()) {
            this.met99Datos.sumaEG = Integer.parseInt(this.sumaEG.getText());
            if (this.met99Datos.optNueva.booleanValue()) {
                this.met99Reglas.SumaEG();
            } else if (this.met99Datos.sumaEG > this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("EG"))) {
                this.met99Datos.sumaEG = this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("EG"));
            }
            this.met99Calcula.CalculaPrimas();
            this.RecuperaDatos();
        } else {
            this.genSubs.MuestraMensaje("Suma asegurada inv\u00e1lida", "sumaEG");
            this.hayError = true;
            this.genSubs.EnfocaObjeto(this.sumaEG);
        }
    }

    private void ValidaSumaCR() {
        this.hayError = false;
        if (this.sumaCR.getText().equals("")) {
            this.sumaCR.setText("0");
        }
        this.sumaCR.setText(this.genSubs.QuitaComas(this.sumaCR.getText()));
        if (this.genSubs.EsNumeroEntero(this.sumaCR.getText()).booleanValue()) {
            this.met99Datos.sumaCR = Integer.parseInt(this.sumaCR.getText());
            if (this.met99Datos.optNueva.booleanValue()) {
                this.met99Reglas.SumaCR();
                this.met99Calcula.CalculaPrimas();
            } else {
                if (this.met99Datos.sumaCR > this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("CR"))) {
                    this.met99Datos.sumaCR = this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("CR"));
                }
                this.met99Calcula.CalculaPrimas();
            }
            this.RecuperaDatos();
        } else {
            this.genSubs.MuestraMensaje("Suma asegurada inv\u00e1lida", "sumaCR");
            this.hayError = true;
            this.genSubs.EnfocaObjeto(this.sumaCR);
        }
    }

    private void ValidaSumaBACY() {
        this.hayError = false;
        if (this.sumaBACY.getText().equals("")) {
            this.sumaBACY.setText("0");
        }
        this.sumaBACY.setText(this.genSubs.QuitaComas(this.sumaBACY.getText()));
        if (this.genSubs.EsNumeroEntero(this.sumaBACY.getText()).booleanValue()) {
            this.met99Datos.sumaBACY = Integer.parseInt(this.sumaBACY.getText());
            if (this.met99Datos.optNueva.booleanValue()) {
                this.met99Reglas.SumaBACY();
            } else if (this.met99Datos.sumaBACY > this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("BACY"))) {
                this.met99Datos.sumaBACY = this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("BACY"));
            }
            this.met99Calcula.CalculaPrimas();
            this.RecuperaDatos();
            this.RevisaSumaMinGF();
        } else {
            this.genSubs.MuestraMensaje("Suma asegurada inv\u00e1lida", "sumaBACY");
            this.hayError = true;
            this.genSubs.EnfocaObjeto(this.sumaBACY);
        }
    }

    private void ValidaSumaGFC() {
        this.hayError = false;
        if (this.sumaGFC.getText().equals("")) {
            this.sumaGFC.setText("0");
        }
        this.sumaGFC.setText(this.genSubs.QuitaComas(this.sumaGFC.getText()));
        if (this.genSubs.EsNumeroEntero(this.sumaGFC.getText()).booleanValue()) {
            this.met99Datos.sumaGFC = Integer.parseInt(this.sumaGFC.getText());
            if (this.met99Datos.optNueva.booleanValue()) {
                this.met99Reglas.SumaGFC();
            } else if (this.met99Datos.sumaGFC > this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("GFC"))) {
                this.met99Datos.sumaGFC = this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("GFC"));
            }
            this.met99Calcula.CalculaPrimas();
            this.RecuperaDatos();
        } else {
            this.genSubs.MuestraMensaje("Suma asegurada inv\u00e1lida", "sumaGFC");
            this.hayError = true;
            this.genSubs.EnfocaObjeto(this.sumaGFC);
        }
    }

    private void ValidaSumaBCAC() {
        this.hayError = false;
        this.sumaBCAC.setText(this.genSubs.QuitaComas(this.sumaBCAC.getText()));
        if (this.genSubs.EsNumeroEntero(this.sumaBCAC.getText()).booleanValue()) {
            this.met99Datos.sumaBCAC = Integer.parseInt(this.sumaBCAC.getText());
            if (this.met99Datos.optNueva.booleanValue()) {
                this.met99Reglas.SumaBCAC();
            }
            this.met99Calcula.CalculaPrimas();
            this.RecuperaDatos();
        } else {
            this.genSubs.MuestraMensaje("Suma asegurada inv\u00e1lida", "sumaBCAC");
            this.hayError = true;
            this.genSubs.EnfocaObjeto(this.sumaBCAC);
        }
    }

    private void ValidaSumaGFH() {
        this.hayError = false;
        if (this.sumaGFH.getText().equals("")) {
            this.sumaGFH.setText("0");
        }
        this.sumaGFH.setText(this.genSubs.QuitaComas(this.sumaGFH.getText()));
        if (this.genSubs.EsNumeroEntero(this.sumaGFH.getText()).booleanValue()) {
            this.met99Datos.sumaGFH = Integer.parseInt(this.sumaGFH.getText());
            if (this.met99Datos.optNueva.booleanValue()) {
                this.met99Reglas.SumaGFH();
            } else if (this.met99Datos.sumaGFH > this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("GFH"))) {
                this.met99Datos.sumaGFH = this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("GFH"));
            }
            this.met99Calcula.CalculaPrimas();
            this.RecuperaDatos();
        } else {
            this.genSubs.MuestraMensaje("Suma asegurada inv\u00e1lida", "sumaGFH");
            this.hayError = true;
            this.genSubs.EnfocaObjeto(this.sumaGFH);
        }
    }

    private void ValidaSumaBACcomp() {
        Integer sumaFallecimiento = 0;
        this.hayError = false;
        if (this.sumaBACcomp.getText().equals("")) {
            this.sumaBACcomp.setText("0");
        }
        this.sumaBACcomp.setText(this.genSubs.QuitaComas(this.sumaBACcomp.getText()));
        if (this.genSubs.EsNumeroEntero(this.sumaBACcomp.getText()).booleanValue()) {
            this.met99Datos.lstSumaBAC.set(this.indexComp, Integer.parseInt(this.sumaBACcomp.getText()));
            if (this.met99Datos.optNueva.booleanValue()) {
                this.met99Reglas.SumaBACcomp(this.indexComp);
                if (this.met99Datos.lstSumaBAC.get(this.indexComp) >= this.met99Datos.sumaBAS) {
                    this.chkGFcomp.setDisable(true);
                    this.met99Datos.lstSumaGF.set(this.indexComp, 0);
                } else if (0.35 * (double)this.met99Datos.sumaBAS.intValue() < (double)this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFcomp")).intValue()) {
                    this.chkGFcomp.setDisable(true);
                } else {
                    sumaFallecimiento = this.met99Datos.lstSumaBAC.get(this.indexComp) + this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFcomp"));
                    if (sumaFallecimiento > this.met99Datos.sumaBAS) {
                        this.chkGFcomp.setDisable(true);
                    } else {
                        this.chkGFcomp.setDisable(false);
                    }
                }
            }
            this.met99Calcula.CalculaPrimas();
            this.RecuperaDatos();
            this.ActualizaTablaComp();
        } else {
            this.genSubs.MuestraMensaje("Suma asegurada inv\u00e1lida", "sumaBACcomp");
            this.hayError = true;
            this.genSubs.EnfocaObjeto(this.sumaBACcomp);
        }
    }

    private void ValidaSumaBCACcomp() {
        this.hayError = false;
        if (this.sumaBCACcomp.getText().equals("")) {
            this.sumaBCACcomp.setText("0");
        }
        this.sumaBCACcomp.setText(this.genSubs.QuitaComas(this.sumaBCACcomp.getText()));
        if (this.genSubs.EsNumeroEntero(this.sumaBCACcomp.getText()).booleanValue()) {
            this.met99Datos.lstSumaBCAC.set(this.indexComp, Integer.parseInt(this.sumaBCACcomp.getText()));
            if (this.met99Datos.optNueva.booleanValue()) {
                this.met99Reglas.SumaBCACcomp(this.indexComp);
            } else if (this.met99Datos.lstSumaBCAC.get(this.indexComp) > this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("BCACcomp"))) {
                this.met99Datos.lstSumaBCAC.set(this.indexComp, this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("BCACcomp")));
            }
            this.met99Calcula.CalculaPrimas();
            this.RecuperaDatos();
            this.ActualizaTablaComp();
        } else {
            this.genSubs.MuestraMensaje("Suma asegurada inv\u00e1lida", "sumaBCACcomp");
            this.hayError = true;
            this.genSubs.EnfocaObjeto(this.sumaBCACcomp);
        }
    }

    private void ValidaSumaAPcomp() {
        this.hayError = false;
        this.sumaAPcomp.setText(this.genSubs.QuitaComas(this.sumaAPcomp.getText()));
        if (this.genSubs.EsNumeroEntero(this.sumaAPcomp.getText()).booleanValue()) {
            this.met99Datos.lstSumaAP.set(this.indexComp, Integer.parseInt(this.sumaAPcomp.getText()));
            if (this.met99Datos.optNueva.booleanValue()) {
                this.met99Reglas.SumaAPcomp(this.indexComp);
            }
            this.met99Calcula.CalculaPrimas();
            this.RecuperaDatos();
            this.ActualizaTablaComp();
        } else {
            this.genSubs.MuestraMensaje("Suma asegurada inv\u00e1lida", "sumaAPcomp");
            this.hayError = true;
            this.genSubs.EnfocaObjeto(this.sumaAPcomp);
        }
    }

    private void ValidaSumaGFcomp() {
        this.hayError = false;
        if (this.sumaGFcomp.getText().equals("")) {
            this.sumaGFcomp.setText("0");
        }
        this.sumaGFcomp.setText(this.genSubs.QuitaComas(this.sumaGFcomp.getText()));
        if (this.genSubs.EsNumeroEntero(this.sumaGFcomp.getText()).booleanValue()) {
            this.met99Datos.lstSumaGF.set(this.indexComp, Integer.parseInt(this.sumaGFcomp.getText()));
            if (this.met99Datos.optNueva.booleanValue()) {
                this.met99Reglas.SumaGFcomp(this.indexComp);
                if (this.met99Datos.lstSumaBAC.get(this.indexComp) == this.met99Datos.sumaBAS) {
                    this.chkGFcomp.setDisable(true);
                    this.met99Datos.lstSumaGF.set(this.indexComp, 0);
                }
            } else if (this.met99Datos.lstSumaGF.get(this.indexComp) > this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("GFcomp"))) {
                this.met99Datos.lstSumaGF.set(this.indexComp, this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("GFcomp")));
            }
            this.met99Calcula.CalculaPrimas();
            this.RecuperaDatos();
            this.ActualizaTablaComp();
        } else {
            this.genSubs.MuestraMensaje("Suma asegurada inv\u00e1lida", "sumaGFcomp");
            this.hayError = true;
            this.genSubs.EnfocaObjeto(this.sumaGFcomp);
        }
    }

    private void ValidaSumaEGcomp() {
        this.hayError = false;
        if (this.sumaEGcomp.getText().equals("")) {
            this.sumaEGcomp.setText("0");
        }
        this.sumaEGcomp.setText(this.genSubs.QuitaComas(this.sumaEGcomp.getText()));
        if (this.genSubs.EsNumeroEntero(this.sumaEGcomp.getText()).booleanValue()) {
            this.met99Datos.lstSumaEG.set(this.indexComp, Integer.parseInt(this.sumaEGcomp.getText()));
            if (this.met99Datos.optNueva.booleanValue()) {
                this.met99Reglas.SumaEGcomp(this.indexComp);
            } else if (this.met99Datos.lstSumaEG.get(this.indexComp) > this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("EGcomp"))) {
                this.met99Datos.lstSumaEG.set(this.indexComp, this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("EGcomp")));
            }
            this.met99Calcula.CalculaPrimas();
            this.RecuperaDatos();
            this.ActualizaTablaComp();
        } else {
            this.genSubs.MuestraMensaje("Suma asegurada inv\u00e1lida", "sumaEGcomp");
            this.hayError = true;
            this.genSubs.EnfocaObjeto(this.sumaEGcomp);
        }
    }

    private void ValidaSumaCRcomp() {
        this.hayError = false;
        if (this.sumaCRcomp.getText().equals("")) {
            this.sumaCRcomp.setText("0");
        }
        this.sumaCRcomp.setText(this.genSubs.QuitaComas(this.sumaCRcomp.getText()));
        if (this.genSubs.EsNumeroEntero(this.sumaCRcomp.getText()).booleanValue()) {
            this.met99Datos.lstSumaCR.set(this.indexComp, Integer.parseInt(this.sumaCRcomp.getText()));
            if (this.met99Datos.optNueva.booleanValue()) {
                this.met99Reglas.SumaCRcomp(this.indexComp);
            } else if (this.met99Datos.lstSumaCR.get(this.indexComp) > this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("CRcomp"))) {
                this.met99Datos.lstSumaCR.set(this.indexComp, this.met99Datos.sumaMax.get(this.genSubs.IndiceCob("CRcomp")));
            }
            this.met99Calcula.CalculaPrimas();
            this.RecuperaDatos();
            this.ActualizaTablaComp();
        } else {
            this.genSubs.MuestraMensaje("Suma asegurada inv\u00e1lida", "sumaCRcomp");
            this.hayError = true;
            this.genSubs.EnfocaObjeto(this.sumaCRcomp);
        }
    }

    private void ValidaPrimaExcedente() {
        this.hayError = false;
        if ("".equals(this.primaExcedente.getText())) {
            this.primaExcedente.setText("0");
        }
        this.primaExcedente.setText(this.genSubs.QuitaComas(this.primaExcedente.getText()));
        if (this.genSubs.EsNumeroConDecimales(this.primaExcedente.getText()).booleanValue()) {
            this.met99Datos.primaExcedente = Double.parseDouble(this.primaExcedente.getText());
            this.CalculaFormaPago();
            this.met99Calcula.CalculaPrimas();
            this.RecuperaDatos();
        } else {
            this.genSubs.MuestraMensaje("Prima excedente inv\u00e1lida", "primaExcedente");
            this.hayError = true;
            this.genSubs.EnfocaObjeto(this.primaExcedente);
        }
    }

    public void ValidaPrimaObjetivo() {
        this.hayError = false;
        this.primaObjetivo.setText(this.genSubs.QuitaComas(this.primaObjetivo.getText()));
        if (this.genSubs.EsNumeroConDecimales(this.primaObjetivo.getText()).booleanValue()) {
            this.met99Datos.primaObjetivo = Double.parseDouble(this.primaObjetivo.getText());
        } else {
            this.genSubs.MuestraMensaje("Prima objetivo inv\u00e1lida", "primaObjetivo");
            this.hayError = true;
            this.genSubs.EnfocaObjeto(this.primaObjetivo);
        }
    }

    private void MuestraDatosComp() {
        String idComp = "";
        String idConyuge = "";
        Integer numBCAC = 0;
        Integer numAP = 0;
        this.numGF = 0;
        this.maxGF = 3;
        Integer numEG = 0;
        Integer numCR = 0;
        Integer numPHX = 0;
        Integer maxBCAC = 3;
        Integer maxAP = 4;
        Integer maxEG = 3;
        Integer maxCR = 3;
        Integer maxPHX = 3;
        Integer sumaFallecimiento = 0;
        this.indexComp = this.cmbComp.getSelectionModel().getSelectedIndex();
        idComp = this.met99Datos.lstNombreComp.get(this.indexComp) + this.met99Datos.lstEdadComp.get(this.indexComp) + this.met99Datos.lstSexoComp.get(this.indexComp);
        idConyuge = this.met99Datos.nombreConyuge + this.met99Datos.edadRealConyuge + this.met99Datos.sexoConyuge;
        this.chkBACcomp.setSelected(false);
        this.sumaBACcomp.setVisible(false);
        this.primaBACcomp.setVisible(false);
        this.chkBCACcomp.setSelected(false);
        this.sumaBCACcomp.setVisible(false);
        this.primaBCACcomp.setVisible(false);
        this.chkAPcomp.setSelected(false);
        this.sumaAPcomp.setVisible(false);
        this.primaAPcomp.setVisible(false);
        this.chkGFcomp.setSelected(false);
        this.sumaGFcomp.setVisible(false);
        this.primaGFcomp.setVisible(false);
        this.chkEGcomp.setSelected(false);
        this.sumaEGcomp.setVisible(false);
        this.primaEGcomp.setVisible(false);
        this.chkCRcomp.setSelected(false);
        this.sumaCRcomp.setVisible(false);
        this.primaCRcomp.setVisible(false);
        this.chkPHX.setSelected(false);
        this.sumaPHX.setVisible(false);
        this.primaPHX.setVisible(false);
        if (this.met99Datos.lstSelBAC.get(this.indexComp).booleanValue()) {
            this.sumaBACcomp.setVisible(true);
            this.primaBACcomp.setVisible(true);
            this.chkBACcomp.setSelected(true);
            this.sumaBACcomp.setText(this.genSubs.FormatoNumInteger("###,###", this.met99Datos.lstSumaBAC.get(this.indexComp)));
            this.primaBACcomp.setText(this.genSubs.FormatoNumDouble("###,###", this.met99Datos.lstPrimaBAC.get(this.indexComp)));
        }
        if (this.met99Datos.lstSelBCAC.get(this.indexComp).booleanValue()) {
            this.sumaBCACcomp.setVisible(true);
            this.primaBCACcomp.setVisible(true);
            this.chkBCACcomp.setSelected(true);
            this.sumaBCACcomp.setText(this.genSubs.FormatoNumInteger("###,###", this.met99Datos.lstSumaBCAC.get(this.indexComp)));
            this.primaBCACcomp.setText(this.genSubs.FormatoNumDouble("###,###", this.met99Datos.lstPrimaBCAC.get(this.indexComp)));
        }
        if (this.met99Datos.lstSelAP.get(this.indexComp).booleanValue()) {
            this.primaAPcomp.setVisible(true);
            this.chkAPcomp.setSelected(true);
            this.optAPbasicaComp.setVisible(true);
            this.optAPextraComp.setVisible(true);
            if (this.met99Datos.lstOptSumaAP.get(this.indexComp) == 1) {
                this.optAPbasicaComp.setSelected(true);
            } else {
                this.optAPextraComp.setSelected(true);
            }
            this.sumaAPcomp.setText(this.genSubs.FormatoNumInteger("###,###", this.met99Datos.lstSumaAP.get(this.indexComp)));
            this.primaAPcomp.setText(this.genSubs.FormatoNumDouble("###,###", this.met99Datos.lstPrimaAP.get(this.indexComp)));
        } else {
            this.primaAPcomp.setVisible(false);
            this.chkAPcomp.setSelected(false);
            this.optAPbasicaComp.setVisible(false);
            this.optAPextraComp.setVisible(false);
        }
        if (this.met99Datos.lstSelGF.get(this.indexComp).booleanValue()) {
            this.sumaGFcomp.setVisible(true);
            this.primaGFcomp.setVisible(true);
            this.chkGFcomp.setSelected(true);
            this.sumaGFcomp.setText(this.genSubs.FormatoNumInteger("###,###", this.met99Datos.lstSumaGF.get(this.indexComp)));
            this.primaGFcomp.setText(this.genSubs.FormatoNumDouble("###,###", this.met99Datos.lstPrimaGF.get(this.indexComp)));
        }
        if (this.met99Datos.lstSelEG.get(this.indexComp).booleanValue()) {
            this.sumaEGcomp.setVisible(true);
            this.primaEGcomp.setVisible(true);
            this.chkEGcomp.setSelected(true);
            this.sumaEGcomp.setText(this.genSubs.FormatoNumInteger("###,###", this.met99Datos.lstSumaEG.get(this.indexComp)));
            this.primaEGcomp.setText(this.genSubs.FormatoNumDouble("###,###", this.met99Datos.lstPrimaEG.get(this.indexComp)));
            this.sumaPHX.setText("Incluido");
        }
        if (this.met99Datos.lstSelCR.get(this.indexComp).booleanValue()) {
            this.sumaCRcomp.setVisible(true);
            this.primaCRcomp.setVisible(true);
            this.chkCRcomp.setSelected(true);
            this.sumaCRcomp.setText(this.genSubs.FormatoNumInteger("###,###", this.met99Datos.lstSumaCR.get(this.indexComp)));
            this.primaCRcomp.setText(this.genSubs.FormatoNumDouble("###,###", this.met99Datos.lstPrimaCR.get(this.indexComp)));
        }
        if (this.met99Datos.lstSelPHX.get(this.indexComp).booleanValue()) {
            this.sumaPHX.setVisible(true);
            this.primaPHX.setVisible(true);
            this.chkPHX.setSelected(true);
            this.sumaPHX.setText("Incluido");
            this.primaPHX.setText(this.genSubs.FormatoNumDouble("###,###", this.met99Datos.lstPrimaPHX.get(this.indexComp)));
        }
        Boolean esMenor = false;
        this.lblEdad.setText(this.genSubs.FormatoNumInteger("##", this.met99Datos.lstEdadComp.get(this.indexComp)) + " a\u00f1os");
        this.chkBACcomp.setDisable(this.met99Reglas.RangoEdad("BACcomp", this.met99Datos.lstEdadComp.get(this.indexComp)).booleanValue());
        this.chkBCACcomp.setDisable(this.met99Reglas.RangoEdad("BCACcomp", this.met99Datos.lstEdadComp.get(this.indexComp)).booleanValue());
        this.chkAPcomp.setDisable(this.met99Reglas.RangoEdad("APcomp", this.met99Datos.lstEdadComp.get(this.indexComp)).booleanValue());
        this.chkGFcomp.setDisable(this.met99Reglas.RangoEdad("GFcomp", this.met99Datos.lstEdadComp.get(this.indexComp)).booleanValue());
        this.chkPHX.setDisable(this.met99Reglas.RangoEdad("PHX", this.met99Datos.lstEdadComp.get(this.indexComp)).booleanValue());
        esMenor = this.chkGFcomp.isDisabled() ? Boolean.valueOf(true) : Boolean.valueOf(false);
        this.chkEGcomp.setDisable(this.met99Reglas.RangoEdad("EGcomp", this.met99Datos.lstEdadComp.get(this.indexComp)).booleanValue());
        this.chkCRcomp.setDisable(this.met99Reglas.RangoEdad("CRcomp", this.met99Datos.lstEdadComp.get(this.indexComp)).booleanValue());
        this.VerificaConyugeComplementario();
        if (this.met99Datos.optNueva.booleanValue() && !esMenor.booleanValue()) {
            if (0.35 * (double)this.met99Datos.sumaBAS.intValue() >= (double)this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFcomp")).intValue()) {
                if (this.met99Datos.selGFC.booleanValue() && idComp.equals(idConyuge)) {
                    this.chkGFcomp.setDisable(true);
                } else {
                    this.chkGFcomp.setDisable(false);
                }
            } else {
                this.chkGFcomp.setDisable(true);
            }
        }
        if (idComp.equals(idConyuge)) {
            this.chkGFcomp.setDisable(true);
        }
        numBCAC = 0;
        numAP = 0;
        this.numGF = 0;
        numEG = 0;
        numCR = 0;
        numPHX = 0;
        for (int i = 0; i < this.met99Datos.numComp; ++i) {
            if (this.met99Datos.lstSelBCAC.get(i).booleanValue()) {
                numBCAC = numBCAC + 1;
            }
            if (this.met99Datos.lstSelAP.get(i).booleanValue()) {
                numAP = numAP + 1;
            }
            if (this.met99Datos.lstSelGF.get(i).booleanValue()) {
                this.numGF = this.numGF + 1;
            }
            if (this.met99Datos.lstSelEG.get(i).booleanValue()) {
                numEG = numEG + 1;
            }
            if (this.met99Datos.lstSelCR.get(i).booleanValue()) {
                numCR = numCR + 1;
            }
            if (!this.met99Datos.lstSelPHX.get(i).booleanValue()) continue;
            numPHX = numPHX + 1;
        }
        if (this.met99Datos.lstSelBCAC.get(this.indexComp).booleanValue()) {
            this.chkBCACcomp.setDisable(false);
        } else if (numBCAC >= maxBCAC) {
            this.chkBCACcomp.setDisable(true);
        }
        if (this.met99Datos.lstSelAP.get(this.indexComp).booleanValue()) {
            this.chkAPcomp.setDisable(false);
        } else if (numAP >= maxAP) {
            this.chkAPcomp.setDisable(true);
        }
        if (this.met99Datos.lstSelGF.get(this.indexComp).booleanValue()) {
            this.chkGFcomp.setDisable(false);
        } else if (this.numGF >= this.maxGF) {
            this.chkGFcomp.setDisable(true);
        }
        if (this.met99Datos.lstSelEG.get(this.indexComp).booleanValue()) {
            this.chkEGcomp.setDisable(false);
        } else if (numEG >= maxEG) {
            this.chkEGcomp.setDisable(true);
        }
        if (this.met99Datos.lstSelCR.get(this.indexComp).booleanValue()) {
            this.chkCRcomp.setDisable(false);
        } else if (numCR >= maxCR) {
            this.chkCRcomp.setDisable(true);
        }
        if (this.met99Datos.lstSelPHX.get(this.indexComp).booleanValue()) {
            this.chkPHX.setDisable(false);
        } else if (numPHX >= maxPHX) {
            this.chkPHX.setDisable(true);
        }
        if (this.met99Datos.optNueva.booleanValue()) {
            if ((int)(0.35 * (double)this.met99Datos.sumaBAS.intValue() + 0.5) < this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFcomp"))) {
                this.chkGFcomp.setDisable(true);
            }
            if (this.met99Datos.lstSumaBAC.get(this.indexComp) == this.met99Datos.sumaBAS) {
                this.chkGFcomp.setDisable(true);
            } else {
                sumaFallecimiento = this.met99Datos.lstSumaBAC.get(this.indexComp) + this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFcomp"));
                if (sumaFallecimiento > this.met99Datos.sumaBAS) {
                    this.chkGFcomp.setDisable(true);
                }
            }
        }
    }

    private void VerificaConyugeComplementario() {
        block5: {
            block4: {
                String idComp = this.met99Datos.lstNombreComp.get(this.indexComp) + this.met99Datos.lstEdadComp.get(this.indexComp) + this.met99Datos.lstSexoComp.get(this.indexComp);
                String idConyuge = this.met99Datos.nombreConyuge + this.met99Datos.edadRealConyuge + this.met99Datos.sexoConyuge;
                if (!this.met99Datos.selBACY.booleanValue()) break block4;
                if (this.chkBACcomp.isDisabled()) break block5;
                if (idComp.equals(idConyuge)) {
                    this.chkBACcomp.setDisable(true);
                } else {
                    for (int i = 0; i < this.met99Datos.numComp; ++i) {
                        if (!this.met99Datos.lstSelBAC.get(i).booleanValue() || i == this.indexComp) continue;
                        this.chkBACcomp.setDisable(true);
                    }
                }
                break block5;
            }
            for (int i = 0; i < this.met99Datos.numComp; ++i) {
                if (!this.met99Datos.lstSelBAC.get(i).booleanValue() || i == this.indexComp) continue;
                this.chkBACcomp.setDisable(true);
            }
        }
    }

    public void RevisaCoberturasExcluyentesConyuge() {
        if (this.met99Datos.optNueva.booleanValue()) {
            if (this.met99Datos.conyugeEsComplementario.booleanValue() && this.met99Datos.hayConuge.booleanValue()) {
                if (this.met99Datos.lstSelBAC.get(this.met99Datos.indexCompConyuge).booleanValue()) {
                    this.chkBACY.setDisable(true);
                } else {
                    this.chkBACY.setDisable(false);
                }
                if (this.met99Datos.lstSelGF.get(this.met99Datos.indexCompConyuge).booleanValue()) {
                    this.chkGFC.setDisable(true);
                } else if ((int)(0.35 * (double)this.met99Datos.sumaBAS.intValue() + 0.5) < this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFC"))) {
                    this.chkGFC.setDisable(true);
                } else {
                    this.chkGFC.setDisable(false);
                }
            }
            if (!this.met99Datos.hayConuge.booleanValue()) {
                this.chkBACY.setDisable(true);
                this.chkGFC.setDisable(true);
            } else if ((int)(0.35 * (double)this.met99Datos.sumaBAS.intValue() + 0.5) < this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFC"))) {
                this.chkGFC.setDisable(true);
            }
            if (!this.met99Datos.optSuma.booleanValue() && this.met99Datos.hayConuge.booleanValue()) {
                if ((int)(0.35 * (double)this.met99Datos.sumaBAS.intValue() + 0.5) < this.met99Datos.sumaMin.get(this.genSubs.IndiceCob("GFC"))) {
                    if (!this.met99Datos.hayConuge.booleanValue()) {
                        this.chkGFC.setDisable(true);
                    }
                } else if (this.met99Datos.hayConuge.booleanValue()) {
                    this.chkGFC.setDisable(false);
                }
            }
        } else if (this.met99Datos.hayConuge.booleanValue()) {
            this.chkGFC.setDisable(false);
            if (this.met99Datos.conyugeEsComplementario.booleanValue()) {
                if (this.met99Datos.lstSelBAC.get(this.met99Datos.indexCompConyuge).booleanValue()) {
                    this.chkBACY.setDisable(true);
                } else {
                    this.chkBACY.setDisable(false);
                }
            }
            this.chkGFH.setDisable(false);
        } else {
            this.chkBACY.setDisable(true);
            this.chkGFC.setDisable(true);
        }
        this.lblNotaAP.setVisible(false);
    }

    public void RevisaCoberturaExcluyenteComp() {
        Integer sumaFallecimiento = 0;
        if (this.met99Datos.optNueva.booleanValue()) {
            if (this.met99Datos.conyugeEsComplementario.booleanValue()) {
                this.indexComp = this.cmbComp.getSelectionModel().getSelectedIndex();
                if (this.met99Datos.selBACY.booleanValue()) {
                    if (this.met99Datos.indexCompConyuge == this.indexComp) {
                        this.chkBACcomp.setDisable(true);
                    } else if (this.met99Datos.lstEdadComp.get(this.indexComp) >= this.met99Datos.edadMin.get(this.genSubs.IndiceCob("BACcomp"))) {
                        this.chkBACcomp.setDisable(false);
                    } else {
                        this.chkBACcomp.setDisable(true);
                    }
                } else if (this.met99Datos.lstEdadComp.get(this.indexComp) >= this.met99Datos.edadMin.get(this.genSubs.IndiceCob("BACcomp"))) {
                    this.chkBACcomp.setDisable(false);
                    for (int i = 0; i < this.met99Datos.numComp; ++i) {
                        if (!this.met99Datos.lstSelBAC.get(i).booleanValue() || i == this.indexComp) continue;
                        this.chkBACcomp.setDisable(true);
                    }
                } else {
                    this.chkBACcomp.setDisable(true);
                }
                if (this.met99Datos.selGFC.booleanValue()) {
                    if (this.met99Datos.indexCompConyuge == this.indexComp) {
                        this.chkGFcomp.setDisable(true);
                    } else if (this.met99Datos.lstEdadComp.get(this.indexComp) >= this.met99Datos.edadMin.get(this.genSubs.IndiceCob("GFcomp"))) {
                        if ((int)(0.35 * (double)this.met99Datos.sumaBAS.intValue() + 0.5) < this.met99Datos.sumaMin.get(this.indiceCob)) {
                            this.chkGFcomp.setDisable(true);
                        } else {
                            this.chkGFcomp.setDisable(false);
                        }
                    } else {
                        this.chkGFcomp.setDisable(true);
                    }
                } else if (this.met99Datos.lstEdadComp.get(this.indexComp) >= this.met99Datos.edadMin.get(this.genSubs.IndiceCob("GFcomp"))) {
                    if ((int)(0.35 * (double)this.met99Datos.sumaBAS.intValue() + 0.5) < this.met99Datos.sumaMin.get(this.indiceCob)) {
                        this.chkGFcomp.setDisable(true);
                    } else {
                        this.chkGFcomp.setDisable(false);
                    }
                } else {
                    this.chkGFcomp.setDisable(true);
                }
            }
            if (this.met99Datos.indexCompConyuge == this.indexComp) {
                this.chkGFcomp.setDisable(true);
            }
        } else {
            if (this.met99Datos.indexCompConyuge == this.indexComp) {
                this.chkGFcomp.setDisable(true);
            }
            if (this.met99Datos.selBACY.booleanValue() && this.met99Datos.indexCompConyuge == this.indexComp) {
                this.chkBACcomp.setDisable(true);
            } else {
                this.chkBACcomp.setDisable(false);
            }
        }
        if (!this.met99Datos.hayConuge.booleanValue()) {
            this.chkGFC.setDisable(true);
        }
        if (this.met99Datos.productoSeleccionado.equals("Met99")) {
            this.lblNotaAP.setVisible(true);
        } else {
            this.lblNotaAP.setVisible(false);
        }
        this.MuestraDatosComp();
    }

    public void RevisaTabTitular() {
        try {
            if (this.met99Datos.productoSeleccionado.equals("Met99")) {
                this.lblNotaAP.setVisible(true);
            } else {
                this.lblNotaAP.setVisible(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void CalculaPFT() {
        this.met99Datos.ftpSel = this.optConDev.isSelected() ? Integer.valueOf(1) : Integer.valueOf(2);
        this.CargaTarifasProducto();
        if (this.met99Datos.optSuma.booleanValue()) {
            this.met99Calcula.CalculaPrimas();
        } else {
            this.CalculaSumaConPrimaObjetivo();
        }
        this.RecuperaDatos();
        this.ValidaEdadCoberturas();
    }

    private void CalculaFormaPago() {
        this.met99Datos.formaPago = this.cmbFormaPago.getValue().toString();
        if (this.cmbFormaPago.getValue() == "Anual") {
            this.lblFormaPago.setText("Prima total anual");
            this.met99Datos.primaFPago = this.met99Datos.primaAnualTotal + this.met99Datos.primaExcedente;
        } else if (this.cmbFormaPago.getValue() == "Mensual") {
            this.lblFormaPago.setText("Prima total mensual");
            this.met99Datos.primaFPago = (this.met99Datos.primaAnualTotal + this.met99Datos.primaExcedente) / 12.0;
        } else {
            this.lblFormaPago.setText("Prima total quincenal");
            this.met99Datos.primaFPago = (this.met99Datos.primaAnualTotal + this.met99Datos.primaExcedente) / 24.0;
        }
        this.primaFPago.setText(this.genSubs.FormatoNumDouble("###,###", this.genSubs.Redondea(this.met99Datos.primaFPago, 0)));
    }

    public void RevisaOpcionesCalculo() {
        if (this.optNueva.isSelected()) {
            this.met99Datos.optNueva = true;
            this.chkBAS.setDisable(true);
            this.chkBAS.setSelected(true);
            this.met99Datos.selBAS = true;
            this.sumaBAS.setVisible(true);
            this.primaBAS.setVisible(true);
            this.met99Datos.sumaBAS = 100000;
            if (this.optSuma.isSelected()) {
                this.met99Datos.optSuma = true;
                this.primaObjetivo.setVisible(false);
                this.btnPrimaObjetivo.setVisible(false);
                this.sumaBAS.setVisible(true);
                this.primaBAS.setVisible(true);
                this.sumaBAS.setText("100,000");
                this.HabilitaSumasAseguradas(true);
                this.CambioOptCalculo();
                this.met99Datos.selBAS = true;
                this.RevisaSumaMinGF();
                this.ValidaSumaBAS();
            } else {
                this.met99Datos.optSuma = false;
                this.primaObjetivo.setText("500.00");
                this.met99Datos.primaObjetivo = 500.0;
                this.primaObjetivo.setVisible(true);
                this.btnPrimaObjetivo.setVisible(true);
                this.HabilitaSumasAseguradas(false);
                this.CambioOptCalculo();
            }
        } else {
            this.met99Datos.optNueva = false;
            this.met99Datos.sumaBAS = 100000;
            if (this.optSuma.isSelected()) {
                this.met99Datos.optSuma = true;
                this.primaObjetivo.setVisible(false);
                this.btnPrimaObjetivo.setVisible(false);
                this.sumaBAS.setText("100,000");
                this.HabilitaSumasAseguradas(true);
                this.CambioOptCalculo();
                this.chkBAS.setSelected(true);
                this.chkBAS.setDisable(false);
            } else {
                this.met99Datos.optSuma = false;
                this.primaObjetivo.setText("500.00");
                this.met99Datos.primaObjetivo = 500.0;
                this.primaObjetivo.setVisible(true);
                this.btnPrimaObjetivo.setVisible(true);
                this.chkBAS.setDisable(false);
                this.HabilitaSumasAseguradas(false);
                this.CambioOptCalculo();
            }
        }
        this.ValidaEdadCoberturas();
        if (this.met99Datos.numComp > 0) {
            String idConyuge;
            String idComp = this.met99Datos.lstNombreComp.get(this.indexComp) + this.met99Datos.lstEdadComp.get(this.indexComp) + this.met99Datos.lstSexoComp.get(this.indexComp);
            if (idComp.equals(idConyuge = this.met99Datos.nombreConyuge + this.met99Datos.edadRealConyuge + this.met99Datos.sexoConyuge)) {
                this.chkGFcomp.setDisable(true);
            } else {
                this.chkGFcomp.setDisable(false);
            }
        }
        if (!this.met99Datos.hayConuge.booleanValue()) {
            this.chkBACY.setDisable(true);
            this.chkGFC.setDisable(true);
        }
        this.RevisaRechazos();
        if (!this.met99Datos.optSuma.booleanValue()) {
            this.CalculaSumaConPrimaObjetivo();
        }
        this.RevisaExclusionAP();
    }

    private void OpcionCalculo() {
        if (this.optSuma.isSelected()) {
            this.met99Datos.optSuma = true;
            this.primaObjetivo.setVisible(false);
            this.btnPrimaObjetivo.setVisible(false);
            this.HabilitaSumasAseguradas(true);
            this.CambioOptCalculo();
            this.chkBAS.setDisable(true);
            this.chkBAS.setSelected(true);
        } else {
            this.met99Datos.optSuma = false;
            this.primaObjetivo.setText("500.00");
            this.met99Datos.primaObjetivo = 500.0;
            this.primaObjetivo.setVisible(true);
            this.btnPrimaObjetivo.setVisible(true);
            this.HabilitaSumasAseguradas(false);
            this.CambioOptCalculo();
            if (this.optIncrementos.isSelected()) {
                this.chkBAS.setDisable(false);
                this.chkBAS.setSelected(true);
            } else {
                this.chkBAS.setDisable(true);
            }
        }
    }

    private void TipoCotizacion() {
        this.met99Datos.optNueva = this.optNueva.isSelected();
        if (this.met99Datos.optNueva.booleanValue()) {
            this.chkBAS.setDisable(true);
            this.chkBAS.setSelected(true);
            this.ValidaEdadCoberturas();
            this.RevisaSumaMinGF();
        } else {
            this.chkBAS.setDisable(false);
            this.ValidaEdadCoberturas();
            this.RevisaSumaMinGF();
        }
        this.met99Datos.selBIT = false;
        this.met99Datos.selCII = false;
        this.met99Datos.selCMA = false;
        this.met99Datos.selTIBA = false;
        this.met99Datos.selCAT = false;
        this.met99Datos.selGFA = false;
        this.met99Datos.selGE = false;
        this.met99Datos.selAP = false;
        this.met99Datos.selEG = false;
        this.met99Datos.selCR = false;
        this.met99Datos.selPHT = false;
        this.met99Datos.selBACY = false;
        this.met99Datos.selGFC = false;
        this.met99Datos.selBCAC = false;
        this.met99Datos.selGFH = false;
        this.chkBACcomp.setSelected(false);
        this.chkBCACcomp.setSelected(false);
        this.chkAPcomp.setSelected(false);
        this.chkGFcomp.setSelected(false);
        this.chkEGcomp.setSelected(false);
        this.chkCRcomp.setSelected(false);
        for (int i = 0; i < this.met99Datos.numComp; ++i) {
            this.met99Datos.lstSelBAC.set(i, false);
            this.met99Datos.lstSelBCAC.set(i, false);
            this.met99Datos.lstSelAP.set(i, false);
            this.met99Datos.lstSelGF.set(i, false);
            this.met99Datos.lstSelEG.set(i, false);
            this.met99Datos.lstSelCR.set(i, false);
            this.met99Datos.lstSelPHX.set(i, false);
        }
        this.RecuperaDatos();
        if (this.met99Datos.numComp > 0) {
            this.MuestraDatosComp();
        }
    }

    private void HabilitaSumasAseguradas(Boolean estadoCtl) {
        this.sumaBAS.setEditable(estadoCtl.booleanValue());
        this.sumaCII.setEditable(estadoCtl.booleanValue());
        this.sumaCMA.setEditable(estadoCtl.booleanValue());
        this.sumaTIBA.setEditable(estadoCtl.booleanValue());
        this.sumaCAT.setEditable(estadoCtl.booleanValue());
        this.sumaGFA.setEditable(estadoCtl.booleanValue());
        this.sumaGE.setEditable(estadoCtl.booleanValue());
        this.sumaEG.setEditable(estadoCtl.booleanValue());
        this.sumaCR.setEditable(estadoCtl.booleanValue());
        this.sumaBACY.setEditable(estadoCtl.booleanValue());
        this.sumaGFC.setEditable(estadoCtl.booleanValue());
        this.sumaBCAC.setEditable(estadoCtl.booleanValue());
        this.sumaGFH.setEditable(estadoCtl.booleanValue());
        this.sumaBACcomp.setEditable(estadoCtl.booleanValue());
        this.sumaBCACcomp.setEditable(estadoCtl.booleanValue());
        this.sumaGFcomp.setEditable(estadoCtl.booleanValue());
        this.sumaEGcomp.setEditable(estadoCtl.booleanValue());
        this.sumaCRcomp.setEditable(estadoCtl.booleanValue());
    }

    private void CambioOptCalculo() {
        int i;
        this.chkGFA.setDisable(false);
        this.chkGFC.setDisable(false);
        this.chkGFH.setDisable(false);
        this.chkGFcomp.setDisable(false);
        this.chkBIT.setSelected(false);
        this.chkCII.setSelected(false);
        this.chkCMA.setSelected(false);
        this.chkTIBA.setSelected(false);
        this.chkCAT.setSelected(false);
        this.chkGFA.setSelected(false);
        this.chkGE.setSelected(false);
        this.chkAP.setSelected(false);
        this.chkEG.setSelected(false);
        this.chkCR.setSelected(false);
        this.chkBACY.setSelected(false);
        this.chkGFC.setSelected(false);
        this.chkGFH.setSelected(false);
        this.chkBACcomp.setSelected(false);
        this.chkBCACcomp.setSelected(false);
        this.chkAPcomp.setSelected(false);
        this.chkGFcomp.setSelected(false);
        this.chkEGcomp.setSelected(false);
        this.chkCRcomp.setSelected(false);
        this.sumaCII.setText("");
        this.sumaCMA.setText("");
        this.sumaTIBA.setText("");
        this.sumaCAT.setText("");
        this.sumaGFA.setText("");
        this.sumaGE.setText("");
        this.sumaAP.setText("");
        this.sumaEG.setText("");
        this.sumaCR.setText("");
        this.sumaBACY.setText("");
        this.sumaGFC.setText("");
        this.sumaGFH.setText("");
        this.sumaBACcomp.setText("");
        this.sumaBCACcomp.setText("");
        this.sumaAPcomp.setText("");
        this.sumaGFcomp.setText("");
        this.sumaEGcomp.setText("");
        this.sumaCRcomp.setText("");
        this.sumaCII.setVisible(false);
        this.sumaCMA.setVisible(false);
        this.sumaTIBA.setVisible(false);
        this.sumaCAT.setVisible(false);
        this.sumaGFA.setVisible(false);
        this.sumaGE.setVisible(false);
        this.sumaAP.setVisible(false);
        this.sumaEG.setVisible(false);
        this.sumaCR.setVisible(false);
        this.sumaBACY.setVisible(false);
        this.sumaGFC.setVisible(false);
        this.sumaGFH.setVisible(false);
        this.sumaBACcomp.setVisible(false);
        this.sumaBCACcomp.setVisible(false);
        this.sumaAPcomp.setVisible(false);
        this.sumaGFcomp.setVisible(false);
        this.sumaEGcomp.setVisible(false);
        this.sumaCRcomp.setVisible(false);
        this.primaCII.setVisible(false);
        this.primaCMA.setVisible(false);
        this.primaTIBA.setVisible(false);
        this.primaCAT.setVisible(false);
        this.primaGFA.setVisible(false);
        this.primaGE.setVisible(false);
        this.primaAP.setVisible(false);
        this.primaEG.setVisible(false);
        this.primaCR.setVisible(false);
        this.primaBACY.setVisible(false);
        this.primaGFC.setVisible(false);
        this.primaGFH.setVisible(false);
        this.primaBACcomp.setVisible(false);
        this.primaBCACcomp.setVisible(false);
        this.primaAPcomp.setVisible(false);
        this.primaGFcomp.setVisible(false);
        this.primaEGcomp.setVisible(false);
        this.primaCRcomp.setVisible(false);
        this.primaBIT.setText("");
        this.primaCII.setText("");
        this.primaCMA.setText("");
        this.primaTIBA.setText("");
        this.primaCAT.setText("");
        this.primaGFA.setText("");
        this.primaGE.setText("");
        this.primaAP.setText("");
        this.primaEG.setText("");
        this.primaCR.setText("");
        this.primaBACY.setText("");
        this.primaGFC.setText("");
        this.primaGFH.setText("");
        this.primaBACcomp.setText("");
        this.primaBCACcomp.setText("");
        this.primaAPcomp.setText("");
        this.primaGFcomp.setText("");
        this.primaEGcomp.setText("");
        this.primaCRcomp.setText("");
        this.met99Datos.selBIT = false;
        this.met99Datos.selCII = false;
        this.met99Datos.selCMA = false;
        this.met99Datos.selTIBA = false;
        this.met99Datos.selCAT = false;
        this.met99Datos.selGFA = false;
        this.met99Datos.selGE = false;
        this.met99Datos.selAP = false;
        this.met99Datos.selEG = false;
        this.met99Datos.selCR = false;
        this.met99Datos.selPHT = false;
        this.met99Datos.selBACY = false;
        this.met99Datos.selGFC = false;
        this.met99Datos.selGFH = false;
        for (i = 0; i < this.met99Datos.numComp; ++i) {
            this.met99Datos.lstSelBAC.set(i, false);
            this.met99Datos.lstSelBCAC.set(i, false);
            this.met99Datos.lstSelAP.set(i, false);
            this.met99Datos.lstSelGF.set(i, false);
            this.met99Datos.lstSelEG.set(i, false);
            this.met99Datos.lstSelCR.set(i, false);
            this.met99Datos.lstSelPHX.set(i, false);
        }
        this.met99Datos.sumaBIT = 0.0;
        this.met99Datos.sumaCII = 0;
        this.met99Datos.sumaCMA = 0;
        this.met99Datos.sumaTIBA = 0;
        this.met99Datos.sumaCAT = 0;
        this.met99Datos.sumaGFA = 0;
        this.met99Datos.sumaGE = 0;
        this.met99Datos.sumaAP = 0;
        this.met99Datos.sumaEG = 0;
        this.met99Datos.sumaCR = 0;
        this.met99Datos.sumaBACY = 0;
        this.met99Datos.sumaGFC = 0;
        this.met99Datos.sumaGFH = 0;
        for (i = 0; i < this.met99Datos.numComp; ++i) {
            this.met99Datos.lstSumaBAC.set(i, 0);
            this.met99Datos.lstSumaBCAC.set(i, 0);
            this.met99Datos.lstSumaAP.set(i, 0);
            this.met99Datos.lstSumaGF.set(i, 0);
            this.met99Datos.lstSumaEG.set(i, 0);
            this.met99Datos.lstSumaCR.set(i, 0);
            this.met99Datos.lstSumaPHX.set(i, 0);
        }
        this.met99Datos.primaBIT = 0.0;
        this.met99Datos.primaCII = 0.0;
        this.met99Datos.primaCMA = 0.0;
        this.met99Datos.primaTIBA = 0.0;
        this.met99Datos.primaCAT = 0.0;
        this.met99Datos.primaGFA = 0.0;
        this.met99Datos.primaGE = 0.0;
        this.met99Datos.primaAP = 0.0;
        this.met99Datos.primaEG = 0.0;
        this.met99Datos.primaCR = 0.0;
        this.met99Datos.primaBACY = 0.0;
        this.met99Datos.primaGFC = 0.0;
        this.met99Datos.primaGFH = 0.0;
        for (i = 0; i < this.met99Datos.numComp; ++i) {
            this.met99Datos.lstPrimaBAC.set(i, 0.0);
            this.met99Datos.lstPrimaBCAC.set(i, 0.0);
            this.met99Datos.lstPrimaAP.set(i, 0.0);
            this.met99Datos.lstPrimaGF.set(i, 0.0);
            this.met99Datos.lstPrimaEG.set(i, 0.0);
            this.met99Datos.lstPrimaCR.set(i, 0.0);
            this.met99Datos.lstPrimaPHX.set(i, 0.0);
        }
        for (i = 0; i < this.met99Datos.numComp; ++i) {
            this.listaComp.set(i, (Object)new Person(this.met99Datos.lstNombreComp.get(i), "", "", "", "", "", "", ""));
        }
    }

    public void VerCotizacion() {
        this.ValidaPrimaExcedente();
        this.ValidaCoberturasComplementarios();
        if (!this.met99Datos.optNueva.booleanValue()) {
            this.ValidaSumaCero();
            if (!this.mensaje.equals("")) {
                this.genSubs.MuestraMensaje(this.mensaje, "Incrementos");
                this.hayError = true;
            }
        }
        if (!this.hayError.booleanValue()) {
            this.met99Calcula.CalculaPrimas();
            if (this.met99Datos.productoSeleccionado.equals("Maestro20")) {
                this.tablas.ConectaBD();
                this.tablas.CargaQxMaestro20();
                this.tablas.CargaFacInv();
                this.tablas.CargaFacGadm();
                this.tablas.CierraBD();
            }
            this.met99Calcula.Proyecta();
            try {
                this.met99Imprime.GeneraCotizacion();
            }
            catch (Exception e2) {
                System.out.println("Error en rutina de generaci\u00f3n pdf: " + e2);
            }
        }
    }

    private void ValidaCoberturasComplementarios() {
    }

    private void ValidaSumaCero() {
        this.mensaje = "";
        if (this.chkBAS.isSelected() && this.met99Datos.sumaBAS == 0) {
            this.mensaje = this.mensaje + "Indique la suma asegurada de la cobertura BAS\r";
        }
        if (this.chkCII.isSelected() && this.met99Datos.sumaCII == 0) {
            this.mensaje = this.mensaje + "Indique la suma asegurada de la cobertura CII\r";
        }
        if (this.chkCMA.isSelected() && this.met99Datos.sumaCMA == 0) {
            this.mensaje = this.mensaje + "Indique la suma asegurada de la cobertura CMA\r";
        }
        if (this.chkTIBA.isSelected() && this.met99Datos.sumaTIBA == 0) {
            this.mensaje = this.mensaje + "Indique la suma asegurada de la cobertura TIBA\r";
        }
        if (this.chkCAT.isSelected() && this.met99Datos.sumaCAT == 0) {
            this.mensaje = this.mensaje + "Indique la suma asegurada de la cobertura CAT\r";
        }
        if (this.chkGFA.isSelected() && this.met99Datos.sumaGFA == 0) {
            this.mensaje = this.mensaje + "Indique la suma asegurada de la cobertura GFT\r";
        }
        if (this.chkGE.isSelected() && this.met99Datos.sumaGE == 0) {
            this.mensaje = this.mensaje + "Indique la suma asegurada de la cobertura GE\r";
        }
        if (this.chkEG.isSelected() && this.met99Datos.sumaEG == 0) {
            this.mensaje = this.mensaje + "Indique la suma asegurada de la cobertura EGT\r";
        }
        if (this.chkCR.isSelected() && this.met99Datos.sumaCR == 0) {
            this.mensaje = this.mensaje + "Indique la suma asegurada de la cobertura CRT\r";
        }
        if (this.chkBACY.isSelected() && this.met99Datos.sumaBACY == 0) {
            this.mensaje = this.mensaje + "Indique la suma asegurada de la cobertura BACY\r";
        }
        if (this.chkGFC.isSelected() && this.met99Datos.sumaGFC == 0) {
            this.mensaje = this.mensaje + "Indique la suma asegurada de la cobertura GFC\r";
        }
        if (this.chkGFH.isSelected() && this.met99Datos.sumaGFH == 0) {
            this.mensaje = this.mensaje + "Indique la suma asegurada de la cobertura GFH\r";
        }
        if (this.met99Datos.numComp > 0) {
            for (int i = 0; i < this.met99Datos.numComp; ++i) {
                if (this.met99Datos.lstSelBAC.get(i).booleanValue() && this.met99Datos.lstSumaBAC.get(i) == 0) {
                    this.mensaje = this.mensaje + "Indique la suma asegurada de la cobertura BAC\r";
                }
                if (this.met99Datos.lstSelBCAC.get(i).booleanValue() && this.met99Datos.lstSumaBCAC.get(i) == 0) {
                    this.mensaje = this.mensaje + "Indique la suma asegurada de la cobertura CAX\r";
                }
                if (this.met99Datos.lstSelGF.get(i).booleanValue() && this.met99Datos.lstSumaGF.get(i) == 0) {
                    this.mensaje = this.mensaje + "Indique la suma asegurada de la cobertura GFX\r";
                }
                if (this.met99Datos.lstSelEG.get(i).booleanValue() && this.met99Datos.lstSumaEG.get(i) == 0) {
                    this.mensaje = this.mensaje + "Indique la suma asegurada de la cobertura EGX\r";
                }
                if (!this.met99Datos.lstSelCR.get(i).booleanValue() || this.met99Datos.lstSumaCR.get(i) != 0) continue;
                this.mensaje = this.mensaje + "Indique la suma asegurada de la cobertura CRX\r";
            }
        }
        if (this.chkBIT.isSelected() && this.met99Datos.primaBIT == 0.0) {
            this.mensaje = this.mensaje + "La cobertura BIT no aplica a ninguna de las coberturas seleccionadas\r";
        }
    }

    public void MuestraDatosPersonales() {
        this.stage = (Stage)this.lblVersion.getScene().getWindow();
        this.MuestraVentana("Met99DPer.fxml");
    }

    public void RegresaInicio() {
        this.GuardaDatosCambioProducto();
        this.stage = (Stage)this.lblVersion.getScene().getWindow();
        this.MuestraVentana("Provida.fxml");
    }

    private void GuardaDatosCambioProducto() {
        this.GuardaDatosTitularTmp();
        if (this.met99Datos.productoSeleccionado.equals("Met99")) {
            this.GuardaDatosConyugeTmp();
            this.GuardaDatosCompTmp();
            this.genSubs.GuardaCoberturasMet99();
        } else if (this.met99Datos.productoSeleccionado.equals("Maestro20")) {
            this.genSubs.GuardaCoberturasMaestro20();
        } else {
            this.GuardaDatosConyugeTmp();
            this.GuardaDatosCompTmp();
            this.genSubs.GuardaCoberturasPT20();
        }
    }

    private void GuardaDatosConyugeTmp() {
        this.met99Datos.nombreConyugeTmp = this.met99Datos.nombreConyuge;
        this.met99Datos.edadRealConyugeTmp = this.met99Datos.edadRealConyuge;
        this.met99Datos.sexoConyugeTmp = this.met99Datos.sexoConyuge;
    }

    private void GuardaDatosCompTmp() {
        this.met99Datos.lstNombreCompTmp.clear();
        this.met99Datos.lstEdadCompTmp.clear();
        this.met99Datos.lstSexoCompTmp.clear();
        for (int i = 0; i < this.met99Datos.numComp; ++i) {
            this.met99Datos.lstNombreCompTmp.add(this.met99Datos.lstNombreComp.get(i));
            this.met99Datos.lstEdadCompTmp.add(this.met99Datos.lstEdadComp.get(i));
            this.met99Datos.lstSexoCompTmp.add(this.met99Datos.lstSexoComp.get(i));
        }
    }

    private void GuardaDatosTitularTmp() {
        this.met99Datos.nombreTitularTmp = this.met99Datos.nombreTitular;
        this.met99Datos.edadRealTitularTmp = this.met99Datos.edadRealTitular;
        this.met99Datos.edadCalculoTitularTmp = this.met99Datos.edadCalculoTitular;
        this.met99Datos.epVidaTmp = this.met99Datos.epVida;
        this.met99Datos.epAccidentesTmp = this.met99Datos.epAccidentes;
        this.met99Datos.epInvalidezTmp = this.met99Datos.epInvalidez;
        this.met99Datos.sexoTitularTmp = this.met99Datos.sexoTitular;
        this.met99Datos.fumaTitularTmp = this.met99Datos.fumaTitular;
        this.met99Datos.ocupacionSelTmp = this.met99Datos.ocupacionSel;
    }

    private void CoberturasVisibles() {
        this.chkBAS.setDisable(false);
        this.chkBIT.setDisable(false);
        this.chkCII.setDisable(false);
        this.chkCMA.setDisable(false);
        this.chkTIBA.setDisable(false);
        this.chkCAT.setDisable(false);
        this.chkGFA.setDisable(false);
        this.chkGE.setDisable(false);
        this.chkAP.setDisable(false);
        this.chkEG.setDisable(false);
        this.chkCR.setDisable(false);
        this.chkBACY.setDisable(false);
        this.chkGFC.setDisable(false);
        this.chkGFH.setDisable(false);
        this.chkBACcomp.setDisable(false);
        this.chkBCACcomp.setDisable(false);
        this.chkAPcomp.setDisable(false);
        this.chkGFcomp.setDisable(false);
        this.chkEGcomp.setDisable(false);
        this.chkCRcomp.setDisable(false);
    }

    private void InicializaObjetos() {
        this.ctlVisible.clear();
        switch (this.met99Datos.productoSeleccionado) {
            case "Met99": {
                this.tabConyuge.setDisable(false);
                this.ctlVisible = this.met99Datos.esVida360 != false ? this.met99Datos.Vida360Visible : this.met99Datos.Met99Visible;
                this.lblPFT.setVisible(true);
                this.lblPFT.setText("Con devoluci\u00f3n de primas (PFT)");
                this.optConDev.setVisible(true);
                this.optSinDev.setVisible(true);
                try {
                    this.imgLogoProducto = this.met99Datos.esVida360 != false ? new Image("Img/LogoMetLifeVida360.jpg") : new Image("Img/LogoMetLifeMet99.jpg");
                    this.logoProducto.setImage(this.imgLogoProducto);
                }
                catch (Exception e2) {
                    System.out.println("No enuentra imagen, error: " + e2);
                }
                this.tabConyuge.setText("C\u00f3nyuge e hijos");
                this.tabComp.setText("Complementarios");
                this.lblNotaAP.setVisible(true);
                this.lblHijos.setVisible(true);
                break;
            }
            case "Maestro20": {
                this.tabConyuge.setDisable(true);
                this.tabComp.setDisable(true);
                this.ctlVisible = this.met99Datos.Maestro20Visible;
                this.lblPFT.setVisible(true);
                this.lblPFT.setText("Con devoluci\u00f3n de primas (DPF)");
                this.optConDev.setVisible(true);
                this.optSinDev.setVisible(true);
                try {
                    this.imgLogoProducto = new Image("Img/LogoMetLifeMaestro20.jpg");
                    this.logoProducto.setImage(this.imgLogoProducto);
                }
                catch (Exception e3) {
                    System.out.println("No enuentra imagen, error: " + e3);
                }
                this.tabConyuge.setText("");
                this.tabComp.setText("");
                this.lblNotaAP.setVisible(false);
                break;
            }
            case "PT20": {
                this.tabConyuge.setDisable(false);
                this.ctlVisible = this.met99Datos.PT20Visible;
                this.met99Datos.ftpSel = 1;
                this.lblPFT.setVisible(false);
                this.optConDev.setVisible(false);
                this.optSinDev.setVisible(false);
                try {
                    this.imgLogoProducto = new Image("Img/LogoMetLifePT20.jpg");
                    this.logoProducto.setImage(this.imgLogoProducto);
                }
                catch (Exception e4) {
                    System.out.println("No enuentra imagen, error: " + e4);
                }
                this.tabConyuge.setText("C\u00f3nyuge e hijos");
                this.tabComp.setText("Complementarios");
                this.lblNotaAP.setVisible(false);
                this.lblHijos.setVisible(false);
            }
        }
        this.AsignaVisible(this.chkBAS, this.sumaBAS, this.primaBAS, "BAS");
        this.AsignaVisible(this.chkBIT, this.sumaBAS, this.primaBIT, "BIT");
        this.AsignaVisible(this.chkCII, this.sumaCII, this.primaCII, "CII");
        this.AsignaVisible(this.chkCMA, this.sumaCMA, this.primaCMA, "CMA");
        this.AsignaVisible(this.chkTIBA, this.sumaTIBA, this.primaTIBA, "TIBA");
        this.AsignaVisible(this.chkCAT, this.sumaCAT, this.primaCAT, "CAT");
        this.AsignaVisible(this.chkGFA, this.sumaGFA, this.primaGFA, "GFA");
        this.AsignaVisible(this.chkGE, this.sumaGE, this.primaGE, "GE");
        this.AsignaVisible(this.chkAP, this.sumaAP, this.primaAP, "AP");
        this.AsignaVisible(this.chkEG, this.sumaEG, this.primaEG, "EG");
        this.AsignaVisible(this.chkCR, this.sumaCR, this.primaCR, "CR");
        this.AsignaVisiblePH(this.chkPHT, this.sumaPHT, this.primaPHT, "PHT");
        this.AsignaVisible(this.chkBACY, this.sumaBACY, this.primaBACY, "BACY");
        this.AsignaVisible(this.chkGFC, this.sumaGFC, this.primaGFC, "GFC");
        this.AsignaVisible(this.chkGFH, this.sumaGFH, this.primaGFH, "GFH");
        if (this.chkGFH.isSelected()) {
            this.optUnHijo.setVisible(true);
            this.optDosHijos.setVisible(true);
            this.optTresHijos.setVisible(true);
        } else {
            this.optUnHijo.setVisible(false);
            this.optDosHijos.setVisible(false);
            this.optTresHijos.setVisible(false);
        }
        this.AsignaVisible(this.chkBACcomp, this.sumaBACcomp, this.primaBACcomp, "BACcomp");
        this.AsignaVisible(this.chkBCACcomp, this.sumaBCAC, this.primaBCAC, "BCAC");
        this.AsignaVisible(this.chkAPcomp, this.sumaAPcomp, this.primaAPcomp, "APcomp");
        this.AsignaVisible(this.chkGFcomp, this.sumaGFcomp, this.primaGFcomp, "GFcomp");
        this.AsignaVisible(this.chkEGcomp, this.sumaEGcomp, this.primaEGcomp, "EGcomp");
        this.AsignaVisible(this.chkCRcomp, this.sumaCRcomp, this.primaCRcomp, "CRcomp");
        this.AsignaVisiblePH(this.chkPHX, this.sumaPHX, this.primaPHX, "PHX");
        this.PosicionaControles();
        this.ModificaColumnasTblComp();
    }

    private void PosicionaControles() {
        this.ctlPosicionX.clear();
        this.ctlPosicionY.clear();
        switch (this.met99Datos.productoSeleccionado) {
            case "Met99": {
                if (this.met99Datos.esVida360.booleanValue()) {
                    this.ctlPosicionX = this.met99Datos.Vida360X;
                    this.ctlPosicionY = this.met99Datos.Vida360Y;
                    break;
                }
                this.ctlPosicionX = this.met99Datos.Met99X;
                this.ctlPosicionY = this.met99Datos.Met99Y;
                break;
            }
            case "Maestro20": {
                this.ctlPosicionX = this.met99Datos.Maestro20X;
                this.ctlPosicionY = this.met99Datos.Maestro20Y;
                break;
            }
            case "PT20": {
                this.ctlPosicionX = this.met99Datos.PT20X;
                this.ctlPosicionY = this.met99Datos.PT20Y;
            }
        }
        if (this.chkCII.isVisible()) {
            this.Posicion(this.chkCII, this.sumaCII, this.primaCII, "chkCII", "sumaCII", "primaCII");
        }
        if (this.chkCMA.isVisible()) {
            this.Posicion(this.chkCMA, this.sumaCMA, this.primaCMA, "chkCMA", "sumaCMA", "primaCMA");
        }
        if (this.chkTIBA.isVisible()) {
            this.Posicion(this.chkTIBA, this.sumaTIBA, this.primaTIBA, "chkTIBA", "sumaTIBA", "primaTIBA");
        }
        if (this.chkCAT.isVisible()) {
            this.Posicion(this.chkCAT, this.sumaCAT, this.primaCAT, "chkCAT", "sumaCAT", "primaCAT");
        }
        if (this.chkGFA.isVisible()) {
            this.Posicion(this.chkGFA, this.sumaGFA, this.primaGFA, "chkGFA", "sumaGFA", "primaGFA");
        }
        if (this.chkGE.isVisible()) {
            this.Posicion(this.chkGE, this.sumaGE, this.primaGE, "chkGE", "sumaGE", "primaGE");
        }
        if (this.chkAP.isVisible()) {
            this.Posicion(this.chkAP, this.sumaAP, this.primaAP, "chkAP", "sumaAP", "primaAP");
        }
        if (this.chkEG.isVisible()) {
            this.Posicion(this.chkEG, this.sumaEG, this.primaEG, "chkEG", "sumaEG", "primaEG");
        }
        if (this.chkCR.isVisible()) {
            this.Posicion(this.chkCR, this.sumaCR, this.primaCR, "chkCR", "sumaCR", "primaCR");
        }
        if (this.chkPHT.isVisible()) {
            this.PosicionPH(this.chkPHT, this.sumaPHT, this.primaPHT, "chkPHT", "sumaPHT", "primaPHT");
        }
        if (this.chkBACY.isVisible()) {
            this.Posicion(this.chkBACY, this.sumaBACY, this.primaBACY, "chkBACY", "sumaBACY", "primaBACY");
        }
        if (this.chkGFC.isVisible()) {
            this.Posicion(this.chkGFC, this.sumaGFC, this.primaGFC, "chkGFC", "sumaGFC", "primaGFC");
        }
        if (this.chkGFH.isVisible()) {
            this.Posicion(this.chkGFH, this.sumaGFH, this.primaGFH, "chkGFH", "sumaGFH", "primaGFH");
        }
        if (this.chkBACcomp.isVisible()) {
            this.Posicion(this.chkBACcomp, this.sumaBACcomp, this.primaBACcomp, "chkBACcomp", "sumaBACcomp", "primaBACcomp");
        }
        if (this.chkBCACcomp.isVisible()) {
            this.Posicion(this.chkBCACcomp, this.sumaBCACcomp, this.primaBCACcomp, "chkBCACcomp", "sumaBCACcomp", "primaBCACcomp");
        }
        if (this.chkAPcomp.isVisible()) {
            this.Posicion(this.chkAPcomp, this.sumaAPcomp, this.primaAPcomp, "chkAPcomp", "sumaAPcomp", "primaAPcomp");
        }
        if (this.chkGFcomp.isVisible()) {
            this.Posicion(this.chkGFcomp, this.sumaGFcomp, this.primaGFcomp, "chkGFcomp", "sumaGFcomp", "primaGFcomp");
        }
        if (this.chkEGcomp.isVisible()) {
            this.Posicion(this.chkEGcomp, this.sumaEGcomp, this.primaEGcomp, "chkEGcomp", "sumaEGcomp", "primaEGcomp");
        }
        if (this.chkCRcomp.isVisible()) {
            this.Posicion(this.chkCRcomp, this.sumaCRcomp, this.primaCRcomp, "chkCRcomp", "sumaCRcomp", "primaCRcomp");
        }
        if (this.chkPHX.isVisible()) {
            this.PosicionPH(this.chkPHX, this.sumaPHX, this.primaPHX, "chkPHX", "sumaPHX", "primaPHX");
        }
    }

    private void Posicion(CheckBox ctlChk, TextField ctlSuma, Label ctlPrima, String idChk, String idSuma, String idPrima) {
        ctlChk.layoutXProperty().setValue((Number)this.ctlPosicionX.get(this.genSubs.IndiceCtlPosicion(idChk)));
        ctlChk.layoutYProperty().setValue((Number)this.ctlPosicionY.get(this.genSubs.IndiceCtlPosicion(idChk)));
        ctlSuma.layoutXProperty().setValue((Number)this.ctlPosicionX.get(this.genSubs.IndiceCtlPosicion(idSuma)));
        ctlSuma.layoutYProperty().setValue((Number)this.ctlPosicionY.get(this.genSubs.IndiceCtlPosicion(idSuma)));
        ctlPrima.layoutXProperty().setValue((Number)this.ctlPosicionX.get(this.genSubs.IndiceCtlPosicion(idPrima)));
        ctlPrima.layoutYProperty().setValue((Number)this.ctlPosicionY.get(this.genSubs.IndiceCtlPosicion(idPrima)));
        if (idChk.equals("chkGFH")) {
            this.optUnHijo.layoutXProperty().setValue((Number)this.ctlPosicionX.get(this.genSubs.IndiceCtlPosicion("optUnHijo")));
            this.optUnHijo.layoutYProperty().setValue((Number)this.ctlPosicionY.get(this.genSubs.IndiceCtlPosicion("optUnHijo")));
            this.optDosHijos.layoutXProperty().setValue((Number)this.ctlPosicionX.get(this.genSubs.IndiceCtlPosicion("optDosHijos")));
            this.optDosHijos.layoutYProperty().setValue((Number)this.ctlPosicionY.get(this.genSubs.IndiceCtlPosicion("optDosHijos")));
            this.optTresHijos.layoutXProperty().setValue((Number)this.ctlPosicionX.get(this.genSubs.IndiceCtlPosicion("optTresHijos")));
            this.optTresHijos.layoutYProperty().setValue((Number)this.ctlPosicionY.get(this.genSubs.IndiceCtlPosicion("optTresHijos")));
        }
    }

    private void PosicionPH(CheckBox ctlChk, Label ctlSuma, Label ctlPrima, String idChk, String idSuma, String idPrima) {
        ctlChk.layoutXProperty().setValue((Number)this.ctlPosicionX.get(this.genSubs.IndiceCtlPosicion(idChk)));
        ctlChk.layoutYProperty().setValue((Number)this.ctlPosicionY.get(this.genSubs.IndiceCtlPosicion(idChk)));
        ctlSuma.layoutXProperty().setValue((Number)this.ctlPosicionX.get(this.genSubs.IndiceCtlPosicion(idSuma)));
        ctlSuma.layoutYProperty().setValue((Number)this.ctlPosicionY.get(this.genSubs.IndiceCtlPosicion(idSuma)));
        ctlPrima.layoutXProperty().setValue((Number)this.ctlPosicionX.get(this.genSubs.IndiceCtlPosicion(idPrima)));
        ctlPrima.layoutYProperty().setValue((Number)this.ctlPosicionY.get(this.genSubs.IndiceCtlPosicion(idPrima)));
    }

    private void ModificaColumnasTblComp() {
        switch (this.met99Datos.productoSeleccionado) {
            case "Met99": {
                this.tblBACcomp.setVisible(true);
                this.tblBCACcomp.setVisible(true);
                this.tblAPcomp.setVisible(true);
                this.tblGFcomp.setVisible(true);
                this.tblEGcomp.setVisible(true);
                this.tblCRcomp.setVisible(true);
                this.tblPHXcomp.setVisible(true);
                break;
            }
            case "Maestro20": {
                this.tblBACcomp.setVisible(false);
                this.tblBCACcomp.setVisible(false);
                this.tblAPcomp.setVisible(false);
                this.tblGFcomp.setVisible(true);
                this.tblEGcomp.setVisible(false);
                this.tblCRcomp.setVisible(false);
                this.tblPHXcomp.setVisible(false);
                break;
            }
            case "PT20": {
                this.tblBACcomp.setVisible(true);
                this.tblBCACcomp.setVisible(false);
                this.tblAPcomp.setVisible(false);
                this.tblGFcomp.setVisible(false);
                this.tblEGcomp.setVisible(false);
                this.tblCRcomp.setVisible(false);
                this.tblPHXcomp.setVisible(false);
            }
        }
    }

    private void InicializaObjetosAnt() {
        this.primaBIT.setVisible(false);
        this.sumaCII.setVisible(false);
        this.primaCII.setVisible(false);
        this.sumaCMA.setVisible(false);
        this.primaCMA.setVisible(false);
        this.sumaTIBA.setVisible(false);
        this.primaTIBA.setVisible(false);
        this.sumaCAT.setVisible(false);
        this.primaCAT.setVisible(false);
        this.sumaGFA.setVisible(false);
        this.primaGFA.setVisible(false);
        this.sumaGE.setVisible(false);
        this.primaGE.setVisible(false);
        this.sumaAP.setVisible(false);
        this.optAPbasica.setVisible(false);
        this.optAPextra.setVisible(false);
        this.primaAP.setVisible(false);
        this.sumaEG.setVisible(false);
        this.primaEG.setVisible(false);
        this.sumaCR.setVisible(false);
        this.primaCR.setVisible(false);
        this.sumaBACY.setVisible(false);
        this.primaBACY.setVisible(false);
        this.sumaGFC.setVisible(false);
        this.primaGFC.setVisible(false);
        this.sumaBCAC.setVisible(false);
        this.primaBCAC.setVisible(false);
        this.sumaGFH.setVisible(false);
        this.primaGFH.setVisible(false);
        this.optUnHijo.setVisible(false);
        this.optDosHijos.setVisible(false);
        this.optTresHijos.setVisible(false);
        this.sumaBACcomp.setVisible(false);
        this.primaBACcomp.setVisible(false);
        this.sumaBCACcomp.setVisible(false);
        this.primaBCACcomp.setVisible(false);
        this.sumaAPcomp.setVisible(false);
        this.primaAPcomp.setVisible(false);
        this.optAPbasicaComp.setVisible(false);
        this.optAPextraComp.setVisible(false);
        this.sumaGFcomp.setVisible(false);
        this.primaGFcomp.setVisible(false);
        this.sumaEGcomp.setVisible(false);
        this.primaEGcomp.setVisible(false);
        this.sumaCRcomp.setVisible(false);
        this.primaCRcomp.setVisible(false);
    }

    private void AsignaVisible(CheckBox chkCob, TextField txtSuma, Label lblPrima, String idCob) {
        Integer visible = this.ctlVisible.get(this.genSubs.IndiceCtlVisible(idCob));
        if (visible == 1) {
            chkCob.setVisible(true);
            if (!idCob.equals("BIT")) {
                txtSuma.setVisible(true);
            }
            lblPrima.setVisible(true);
        } else {
            chkCob.setVisible(false);
            txtSuma.setVisible(false);
            lblPrima.setVisible(false);
        }
        if (idCob == "AP") {
            if (visible == 1) {
                this.optAPbasica.setVisible(true);
                this.optAPextra.setVisible(true);
            } else {
                this.optAPbasica.setVisible(false);
                this.optAPextra.setVisible(false);
            }
        }
        if (idCob == "GFH") {
            if (visible == 1) {
                this.optUnHijo.setVisible(true);
                this.optDosHijos.setVisible(true);
                this.optTresHijos.setVisible(true);
            } else {
                this.optUnHijo.setVisible(false);
                this.optDosHijos.setVisible(false);
                this.optTresHijos.setVisible(false);
            }
        }
    }

    private void AsignaVisiblePH(CheckBox chkCob, Label txtSuma, Label lblPrima, String idCob) {
        Integer visible = this.ctlVisible.get(this.genSubs.IndiceCtlVisible(idCob));
        if (visible == 1) {
            chkCob.setVisible(true);
            txtSuma.setVisible(true);
            lblPrima.setVisible(true);
        } else {
            chkCob.setVisible(false);
            txtSuma.setVisible(false);
            lblPrima.setVisible(false);
        }
    }

    private void MuestraVentana(String nombreVentana) {
        try {
            this.root = (Parent)FXMLLoader.load((URL)this.getClass().getResource(nombreVentana));
        }
        catch (Exception e2) {
            System.out.println("No pudo cargar " + nombreVentana);
        }
        Scene scene = new Scene(this.root);
        this.stage.setScene(scene);
        this.stage.show();
    }

    public void CalculaSumaConPrimaObjetivo() {
        this.ValidaPrimaObjetivo();
        if (!this.hayError.booleanValue()) {
            this.met99Calcula.CalculaSumaObjetivo();
            this.RecuperaDatos();
            this.GFfueDeshabilitada = false;
            if (this.met99Datos.selBAS.booleanValue()) {
                this.RevisaSiAplicaGF();
            }
        }
    }

    private void RevisaSiAplicaGF() {
        if ((int)(0.35 * (double)this.met99Datos.sumaBAS.intValue() + 0.5) < this.met99Datos.sumaMin.get(this.indiceCob)) {
            int i;
            if (this.met99Datos.selGFA.booleanValue() || this.met99Datos.selGFC.booleanValue() || this.met99Datos.selGFH.booleanValue()) {
                this.GFfueDeshabilitada = true;
            }
            this.chkGFA.setSelected(false);
            this.met99Datos.selGFA = false;
            this.chkGFA.setDisable(true);
            this.met99Datos.sumaGFA = 0;
            this.met99Datos.primaGFA = 0.0;
            this.sumaGFA.setVisible(false);
            this.primaGFA.setVisible(false);
            this.chkGFC.setSelected(false);
            this.met99Datos.selGFC = false;
            this.chkGFC.setDisable(true);
            this.met99Datos.sumaGFC = 0;
            this.met99Datos.primaGFC = 0.0;
            this.sumaGFC.setVisible(false);
            this.primaGFC.setVisible(false);
            this.chkGFH.setSelected(false);
            this.met99Datos.selGFH = false;
            this.chkGFH.setDisable(true);
            this.met99Datos.sumaGFH = 0;
            this.met99Datos.primaGFH = 0.0;
            this.sumaGFH.setVisible(false);
            this.primaGFH.setVisible(false);
            this.optUnHijo.setVisible(false);
            this.optDosHijos.setVisible(false);
            this.optTresHijos.setVisible(false);
            for (i = 0; i < this.met99Datos.numComp; ++i) {
                if (!this.met99Datos.lstSelGF.get(i).booleanValue()) continue;
                this.GFfueDeshabilitada = true;
            }
            this.chkGFcomp.setDisable(true);
            this.chkGFcomp.setSelected(false);
            for (i = 0; i < this.met99Datos.numComp; ++i) {
                this.met99Datos.lstSelGF.set(i, false);
                this.met99Datos.lstSumaGF.set(i, 0);
                this.met99Datos.lstPrimaGF.set(i, 0.0);
            }
            this.sumaGFcomp.setVisible(false);
            this.primaGFcomp.setVisible(false);
        } else {
            this.chkGFA.setDisable(false);
            if (this.met99Datos.selGFA.booleanValue()) {
                this.sumaGFA.setVisible(true);
                this.primaGFA.setVisible(true);
            } else {
                this.sumaGFA.setVisible(false);
                this.primaGFA.setVisible(false);
            }
            if (this.met99Datos.hayConuge.booleanValue()) {
                this.chkGFC.setDisable(false);
                if (this.met99Datos.selGFC.booleanValue()) {
                    this.sumaGFC.setVisible(true);
                    this.primaGFC.setVisible(true);
                } else {
                    this.sumaGFC.setVisible(false);
                    this.primaGFC.setVisible(false);
                }
            } else {
                this.chkGFC.setDisable(true);
            }
            this.chkGFH.setDisable(false);
            if (this.met99Datos.selGFH.booleanValue()) {
                this.sumaGFH.setVisible(true);
                this.primaGFH.setVisible(true);
                this.optUnHijo.setVisible(true);
                this.optDosHijos.setVisible(true);
                this.optTresHijos.setVisible(true);
            } else {
                this.sumaGFH.setVisible(false);
                this.primaGFH.setVisible(false);
                this.optUnHijo.setVisible(false);
                this.optDosHijos.setVisible(false);
                this.optTresHijos.setVisible(false);
            }
            if (this.met99Datos.numComp > 0) {
                this.chkGFcomp.setDisable(false);
                this.MuestraDatosComp();
            }
        }
    }

    private void ValidaEdadCoberturas() {
        this.chkBIT.setDisable(this.met99Reglas.RangoEdad("BIT", this.met99Datos.edadRealTitular).booleanValue());
        if (this.chkBIT.isDisabled()) {
            this.met99Datos.selBIT = false;
            this.met99Datos.primaBIT = 0.0;
            this.chkBIT.setSelected(false);
            this.primaBIT.setVisible(false);
        }
        this.chkCII.setDisable(this.met99Reglas.RangoEdad("CII", this.met99Datos.edadRealTitular).booleanValue());
        if (this.chkCII.isDisable()) {
            this.met99Datos.selCII = false;
            this.met99Datos.primaCII = 0.0;
            this.chkCII.setSelected(false);
            this.sumaCII.setVisible(false);
            this.primaCII.setVisible(false);
        }
        this.chkCMA.setDisable(this.met99Reglas.RangoEdad("CMA", this.met99Datos.edadRealTitular).booleanValue());
        if (this.chkCMA.isDisable()) {
            this.met99Datos.selCMA = false;
            this.met99Datos.primaCMA = 0.0;
            this.chkCMA.setSelected(false);
            this.sumaCMA.setVisible(false);
            this.primaCMA.setVisible(false);
        }
        this.chkTIBA.setDisable(this.met99Reglas.RangoEdad("TIBA", this.met99Datos.edadRealTitular).booleanValue());
        if (this.chkTIBA.isDisable()) {
            this.met99Datos.selTIBA = false;
            this.met99Datos.primaTIBA = 0.0;
            this.chkTIBA.setSelected(false);
            this.sumaTIBA.setVisible(false);
            this.primaTIBA.setVisible(false);
        }
        this.chkCAT.setDisable(this.met99Reglas.RangoEdad("CAT", this.met99Datos.edadRealTitular).booleanValue());
        if (this.chkCAT.isDisable()) {
            this.met99Datos.selCAT = false;
            this.met99Datos.primaCAT = 0.0;
            this.chkCAT.setSelected(false);
            this.sumaCAT.setVisible(false);
            this.primaCAT.setVisible(false);
        }
        this.chkGFA.setDisable(this.met99Reglas.RangoEdad("GFA", this.met99Datos.edadRealTitular).booleanValue());
        if (this.chkGFA.isDisable()) {
            this.met99Datos.selGFA = false;
            this.met99Datos.primaGFA = 0.0;
            this.chkGFA.setSelected(false);
            this.sumaGFA.setVisible(false);
            this.primaGFA.setVisible(false);
        }
        this.chkGE.setDisable(this.met99Reglas.RangoEdad("GE", this.met99Datos.edadRealTitular).booleanValue());
        if (this.chkGE.isDisable()) {
            this.met99Datos.selGE = false;
            this.met99Datos.primaGE = 0.0;
            this.chkGE.setSelected(false);
            this.sumaGE.setVisible(false);
            this.primaGE.setVisible(false);
        }
        this.chkAP.setDisable(this.met99Reglas.RangoEdad("AP", this.met99Datos.edadRealTitular).booleanValue());
        if (this.chkAP.isDisable()) {
            this.met99Datos.selAP = false;
            this.met99Datos.primaAP = 0.0;
            this.chkAP.setSelected(false);
            this.sumaAP.setVisible(false);
            this.primaAP.setVisible(false);
            this.optAPbasica.setVisible(false);
            this.optAPextra.setVisible(false);
        }
        this.chkEG.setDisable(this.met99Reglas.RangoEdad("EG", this.met99Datos.edadRealTitular).booleanValue());
        if (this.chkEG.isDisable()) {
            this.met99Datos.selEG = false;
            this.met99Datos.primaEG = 0.0;
            this.chkEG.setSelected(false);
            this.sumaEG.setVisible(false);
            this.primaEG.setVisible(false);
        }
        this.chkCR.setDisable(this.met99Reglas.RangoEdad("CR", this.met99Datos.edadRealTitular).booleanValue());
        if (this.chkCR.isDisable()) {
            this.met99Datos.selCR = false;
            this.met99Datos.primaCR = 0.0;
            this.chkCR.setSelected(false);
            this.sumaCR.setVisible(false);
            this.primaCR.setVisible(false);
        }
        if (this.met99Datos.productoSeleccionado == "Met99") {
            this.chkPHT.setDisable(this.met99Reglas.RangoEdad("PHT", this.met99Datos.edadRealTitular).booleanValue());
            if (this.chkPHT.isDisable()) {
                this.met99Datos.selPHT = false;
                this.met99Datos.primaPHT = 0.0;
                this.chkPHT.setSelected(false);
                this.sumaPHT.setVisible(false);
                this.primaPHT.setVisible(false);
            }
        }
        if (this.met99Datos.numComp > 0) {
            this.indexComp = this.cmbComp.getSelectionModel().getSelectedIndex();
            this.chkGFcomp.setDisable(this.met99Reglas.RangoEdad("GFcomp", this.met99Datos.lstEdadComp.get(this.indexComp)).booleanValue());
            this.chkPHX.setDisable(this.met99Reglas.RangoEdad("PHX", this.met99Datos.lstEdadComp.get(this.indexComp)).booleanValue());
        }
    }

    private void RevisaRechazos() {
        if (this.met99Datos.rechazoAccidentes.booleanValue()) {
            this.chkCMA.setDisable(true);
            this.chkTIBA.setDisable(true);
            this.met99Datos.sumaCMA = 0;
            this.met99Datos.primaCMA = 0.0;
            this.met99Datos.selCMA = false;
            this.chkCMA.setSelected(false);
            this.met99Datos.sumaTIBA = 0;
            this.met99Datos.primaTIBA = 0.0;
            this.met99Datos.selTIBA = false;
            this.chkTIBA.setSelected(false);
        }
        if (this.met99Datos.rechazoInvalidez.booleanValue()) {
            this.chkBIT.setDisable(true);
            this.chkCII.setDisable(true);
            this.met99Datos.sumaBIT = 0.0;
            this.met99Datos.primaBIT = 0.0;
            this.met99Datos.selBIT = false;
            this.chkBIT.setSelected(false);
            this.met99Datos.sumaCII = 0;
            this.met99Datos.primaCII = 0.0;
            this.met99Datos.selCII = false;
            this.chkCII.setSelected(false);
        }
    }

    private void RevisaSiHayConyuge() {
        if (!this.met99Datos.hayConuge.booleanValue()) {
            this.met99Datos.selBACY = false;
            this.met99Datos.selGFC = false;
        }
    }

    private void CargaTarifasProducto() {
        switch (this.met99Datos.productoSeleccionado) {
            case "Met99": {
                this.tablas.CargaTarifasMet99();
                break;
            }
            case "Maestro20": {
                this.tablas.CargaTarifasMaestro20();
                break;
            }
            case "PT20": {
                this.tablas.CargaTarifasPT20();
            }
        }
    }

    public void Salir() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Provida");
        alert.setHeaderText("");
        alert.setContentText("\u00bfEst\u00e1 seguro de salir del cotizador?");
        Optional result = alert.showAndWait();
        if (result.get() == ButtonType.OK) {
            Platform.exit();
        }
    }

    public static class Person {
        private SimpleStringProperty nombreComp = new SimpleStringProperty();
        private SimpleStringProperty bacComp = new SimpleStringProperty();
        private SimpleStringProperty bcacComp = new SimpleStringProperty();
        private SimpleStringProperty apComp = new SimpleStringProperty();
        private SimpleStringProperty gfComp = new SimpleStringProperty();
        private SimpleStringProperty egComp = new SimpleStringProperty();
        private SimpleStringProperty crComp = new SimpleStringProperty();
        private SimpleStringProperty phxComp = new SimpleStringProperty();

        public SimpleStringProperty nombreCompProperty() {
            return this.nombreComp;
        }

        public void setNombre(String value) {
            this.nombreComp.set(value);
        }

        public String getNombre() {
            return this.nombreComp.get();
        }

        public SimpleStringProperty bacCompProperty() {
            return this.bacComp;
        }

        public void setBAC(String value) {
            this.bacComp.set(value);
        }

        public String getBAC() {
            return this.bacComp.get();
        }

        public SimpleStringProperty bcacCompProperty() {
            return this.bcacComp;
        }

        public void setBCAC(String value) {
            this.bcacComp.set(value);
        }

        public String getBCAC() {
            return this.bcacComp.get();
        }

        public SimpleStringProperty apCompProperty() {
            return this.apComp;
        }

        public void setAP(String value) {
            this.apComp.set(value);
        }

        public String getAP() {
            return this.apComp.get();
        }

        public SimpleStringProperty gfCompProperty() {
            return this.gfComp;
        }

        public void setGF(String value) {
            this.gfComp.set(value);
        }

        public String getGF() {
            return this.gfComp.get();
        }

        public SimpleStringProperty egCompProperty() {
            return this.egComp;
        }

        public void setEG(String value) {
            this.egComp.set(value);
        }

        public String getEG() {
            return this.egComp.get();
        }

        public SimpleStringProperty crCompProperty() {
            return this.crComp;
        }

        public void setCR(String value) {
            this.crComp.set(value);
        }

        public String getCR() {
            return this.crComp.get();
        }

        public SimpleStringProperty phxCompProperty() {
            return this.phxComp;
        }

        public void setPHX(String value) {
            this.phxComp.set(value);
        }

        public String getPHX() {
            return this.phxComp.get();
        }

        private Person(String nombre, String bac, String bcac, String ap, String gf, String eg, String cr, String phx) {
            this.nombreComp = new SimpleStringProperty(nombre);
            this.bacComp = new SimpleStringProperty(bac);
            this.bcacComp = new SimpleStringProperty(bcac);
            this.apComp = new SimpleStringProperty(ap);
            this.gfComp = new SimpleStringProperty(gf);
            this.apComp = new SimpleStringProperty(ap);
            this.egComp = new SimpleStringProperty(eg);
            this.crComp = new SimpleStringProperty(cr);
            this.phxComp = new SimpleStringProperty(phx);
        }
    }
}

