/*
 * Decompiled with CFR 0.152.
 */
package provida;

import com.cete.dynamicpdf.Font;
import com.cete.dynamicpdf.Grayscale;
import com.cete.dynamicpdf.RgbColor;
import com.cete.dynamicpdf.TextAlign;
import com.cete.dynamicpdf.pageelements.Row2;
import com.cete.dynamicpdf.pageelements.Table2;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import javafx.event.EventHandler;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import provida.Met99Datos;

public class GenSubs {
    private static GenSubs genSubs = new GenSubs();
    private static Met99Datos met99Datos = Met99Datos.getInstance();

    private GenSubs() {
    }

    public static GenSubs getInstance() {
        return genSubs;
    }

    public String FormatoNumDouble(String Formato, Double valor) {
        DecimalFormat miFormato = new DecimalFormat(Formato);
        String valorConFormato = miFormato.format(valor);
        return valorConFormato;
    }

    public String FormatoNumInteger(String Formato, Integer valor) {
        DecimalFormat miFormato = new DecimalFormat(Formato);
        String valorConFormato = miFormato.format(valor);
        return valorConFormato;
    }

    public String QuitaComas(String string) {
        string = string.replaceAll(",", "");
        return string;
    }

    public Boolean EsNumeroEntero(String txtDato) {
        if ("".equals(txtDato)) {
            return true;
        }
        try {
            int valor = Integer.parseInt(txtDato);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public Boolean EsNumeroConDecimales(String txtDato) {
        if ("".equals(txtDato)) {
            return true;
        }
        try {
            Double valor = Double.parseDouble(txtDato);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public void EnfocaObjeto(TextField txtField) {
        txtField.requestFocus();
        txtField.selectAll();
    }

    public void EnfocaCombo(ComboBox combo) {
        combo.requestFocus();
    }

    public void MuestraMensaje(String txtMensaje, String txtDato) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("");
        alert.setHeaderText("");
        alert.setContentText(txtMensaje);
        alert.showAndWait();
    }

    public Integer IndiceCob(String idCob) {
        int indiceCob = -1;
        for (int i = 0; i < GenSubs.met99Datos.numCob; ++i) {
            if (!GenSubs.met99Datos.idCobertura.get(i).equals(idCob)) continue;
            indiceCob = GenSubs.met99Datos.indexCobertura.get(i);
        }
        if (indiceCob == -1) {
            this.MuestraMensaje("No encuentra posicion IndiceCob de " + idCob, "");
        }
        return indiceCob;
    }

    public Integer IndiceCtlVisible(String idCob) {
        int indiceCtlVisible = -1;
        for (int i = 0; i < GenSubs.met99Datos.numCtlVisibles; ++i) {
            if (!GenSubs.met99Datos.nombreControl.get(i).equals(idCob)) continue;
            indiceCtlVisible = GenSubs.met99Datos.indexCtlVisibles.get(i);
        }
        return indiceCtlVisible;
    }

    public Integer IndiceCtlPosicion(String idCob) {
        int indiceCtlPosicion = -1;
        for (int i = 0; i < GenSubs.met99Datos.numCtlPosicion; ++i) {
            if (!GenSubs.met99Datos.nombreControlPos.get(i).equals(idCob)) continue;
            indiceCtlPosicion = GenSubs.met99Datos.indexCtlPosicion.get(i);
        }
        if (indiceCtlPosicion == -1) {
            this.MuestraMensaje("No encuentra posicion IndiceCtlPosicion de " + idCob, "");
        }
        return indiceCtlPosicion;
    }

    public Integer IndiceCtlPosicionTar(String idCob) {
        int indiceCtlPosicion = -1;
        for (int i = 0; i < GenSubs.met99Datos.numCtlPosicionTar; ++i) {
            if (!GenSubs.met99Datos.nombreControlPosTar.get(i).equals(idCob)) continue;
            indiceCtlPosicion = GenSubs.met99Datos.indexCtlPosicionTar.get(i);
        }
        if (indiceCtlPosicion == -1) {
            this.MuestraMensaje("No encuentra posicion IndiceCtlPosicionTar de " + idCob, "");
        }
        return indiceCtlPosicion;
    }

    public Integer IndiceCtlVisibleTar(String idCob) {
        int indiceCtlVisible = -1;
        for (int i = 0; i < GenSubs.met99Datos.numCtlVisiblesTar; ++i) {
            if (!GenSubs.met99Datos.nombreControlTar.get(i).equals(idCob)) continue;
            indiceCtlVisible = GenSubs.met99Datos.indexCtlVisiblesTar.get(i);
        }
        if (indiceCtlVisible == -1) {
            this.MuestraMensaje("No encuentra visible IndiceVisibleTar en Tar" + idCob, "");
        }
        return indiceCtlVisible;
    }

    public Integer IndiceCobDes(String idCob) {
        int indiceCobDes = -1;
        for (int i = 0; i < GenSubs.met99Datos.numText; ++i) {
            if (!GenSubs.met99Datos.idCobTexto.get(i).equals(idCob)) continue;
            indiceCobDes = GenSubs.met99Datos.indexTexto.get(i);
        }
        return indiceCobDes;
    }

    public Double Redondea(Double valor, Integer numDecimales) {
        double multipicationFactor = Math.pow(10.0, numDecimales.intValue());
        double interestedInZeroDPs = valor * multipicationFactor;
        return (double)Math.round(interestedInZeroDPs) / multipicationFactor;
    }

    public Double RedondeaAnt(Double valor, Integer numDecimales) {
        DecimalFormat df;
        Double valorRedondeado = valor;
        switch (numDecimales) {
            case 0: {
                df = new DecimalFormat("###");
                df.setRoundingMode(RoundingMode.CEILING);
                break;
            }
            case 1: {
                df = new DecimalFormat("#.#");
                df.setRoundingMode(RoundingMode.CEILING);
                break;
            }
            case 2: {
                df = new DecimalFormat("#.##");
                df.setRoundingMode(RoundingMode.CEILING);
                break;
            }
            case 3: {
                df = new DecimalFormat("#.###");
                df.setRoundingMode(RoundingMode.CEILING);
                break;
            }
            case 4: {
                df = new DecimalFormat("#.####");
                df.setRoundingMode(RoundingMode.CEILING);
                break;
            }
            case 6: {
                df = new DecimalFormat("#.######");
                df.setRoundingMode(RoundingMode.CEILING);
                break;
            }
            case 7: {
                df = new DecimalFormat("#.#######");
                df.setRoundingMode(RoundingMode.CEILING);
                break;
            }
            case 9: {
                df = new DecimalFormat("#.#########");
                df.setRoundingMode(RoundingMode.CEILING);
                break;
            }
            default: {
                df = new DecimalFormat("#.##");
                df.setRoundingMode(RoundingMode.CEILING);
            }
        }
        df.format(valor);
        return valorRedondeado;
    }

    public Table2 CreaTablaEstandar(Float ancho, Float alto) {
        Table2 tbl = new Table2(0.0f, 0.0f, ancho.floatValue(), alto.floatValue());
        tbl.getCellDefault().getPadding().setValue(2.0f);
        tbl.setCellSpacing(0.0f);
        tbl.getBorder().setWidth(0.0f);
        tbl.getBorder().getTop().setColor(RgbColor.getBlack());
        tbl.getBorder().getBottom().setColor(RgbColor.getBlack());
        tbl.getBorder().getTop().setWidth(0.5f);
        tbl.getBorder().getBottom().setWidth(0.5f);
        return tbl;
    }

    public Row2 CreaRenglonEstandar(Table2 tbl, Float fontSize) {
        Row2 ren = tbl.getRows().add(fontSize.floatValue() + 1.0f, Font.getHelvetica(), fontSize.floatValue(), Grayscale.getBlack(), RgbColor.getWhite());
        ren.getCellDefault().getBorder().setWidth(0.0f);
        ren.getCellDefault().setAlign(TextAlign.LEFT);
        ren.getCellDefault().getPadding().setBottom(0.0f);
        ren.getCellDefault().getPadding().setTop(0.5f);
        return ren;
    }

    public EventHandler<KeyEvent> ValidaLetras(final Integer max_Lengh) {
        return new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                TextField txt_TextField = (TextField)e.getSource();
                if (txt_TextField.getText().length() >= max_Lengh) {
                    e.consume();
                }
                if (!e.getCharacter().matches("[\u00e1\u00e9\u00ed\u00f3\u00fa\u00f1\u00d1a-zA-Z ]")) {
                    e.consume();
                }
            }
        };
    }

    public EventHandler<KeyEvent> ValidaNumeros2Digitos() {
        return new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                TextField txt_TextField = (TextField)e.getSource();
                if (e.getCharacter().matches("[0-9]")) {
                    if (txt_TextField.getLength() >= 2) {
                        e.consume();
                    }
                } else {
                    e.consume();
                }
            }
        };
    }

    public EventHandler<KeyEvent> ValidaNumerosNdigitos(final Integer numDig) {
        return new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                TextField txt_TextField = (TextField)e.getSource();
                if (e.getCharacter().matches("[0-9]") || e.getCharacter().matches("[.]")) {
                    if (txt_TextField.getLength() >= numDig) {
                        e.consume();
                    }
                } else {
                    e.consume();
                }
            }
        };
    }

    public void GuardaCoberturasMet99() {
        GenSubs.met99Datos.selBAStmp = GenSubs.met99Datos.selBAS;
        GenSubs.met99Datos.selBITtmp = GenSubs.met99Datos.selBIT;
        GenSubs.met99Datos.selCIItmp = GenSubs.met99Datos.selCII;
        GenSubs.met99Datos.selCMAtmp = GenSubs.met99Datos.selCMA;
        GenSubs.met99Datos.selTIBAtmp = GenSubs.met99Datos.selTIBA;
        GenSubs.met99Datos.selCATtmp = GenSubs.met99Datos.selCAT;
        GenSubs.met99Datos.selGFAtmp = GenSubs.met99Datos.selGFA;
        GenSubs.met99Datos.selGEtmp = GenSubs.met99Datos.selGE;
        GenSubs.met99Datos.selAPtmp = GenSubs.met99Datos.selAP;
        GenSubs.met99Datos.selEGtmp = GenSubs.met99Datos.selEG;
        GenSubs.met99Datos.selCRtmp = GenSubs.met99Datos.selCR;
        GenSubs.met99Datos.sumaBAStmp = GenSubs.met99Datos.sumaBAS;
        GenSubs.met99Datos.sumaBITtmp = GenSubs.met99Datos.sumaBIT;
        GenSubs.met99Datos.sumaCIItmp = GenSubs.met99Datos.sumaCII;
        GenSubs.met99Datos.sumaCMAtmp = GenSubs.met99Datos.sumaCMA;
        GenSubs.met99Datos.sumaTIBAtmp = GenSubs.met99Datos.sumaTIBA;
        GenSubs.met99Datos.sumaCATtmp = GenSubs.met99Datos.sumaCAT;
        GenSubs.met99Datos.sumaGFAtmp = GenSubs.met99Datos.sumaGFA;
        GenSubs.met99Datos.sumaGEtmp = GenSubs.met99Datos.sumaGE;
        GenSubs.met99Datos.sumaAPtmp = GenSubs.met99Datos.sumaAP;
        GenSubs.met99Datos.sumaEGtmp = GenSubs.met99Datos.sumaEG;
        GenSubs.met99Datos.sumaCRtmp = GenSubs.met99Datos.sumaCR;
        GenSubs.met99Datos.optSumaAPtmp = GenSubs.met99Datos.optSumaAP;
        GenSubs.met99Datos.selBACYtmp = GenSubs.met99Datos.selBACY;
        GenSubs.met99Datos.selGFCtmp = GenSubs.met99Datos.selGFC;
        GenSubs.met99Datos.selBCACtmp = GenSubs.met99Datos.selBCAC;
        GenSubs.met99Datos.selGFHtmp = GenSubs.met99Datos.selGFH;
        GenSubs.met99Datos.numHijosTmp = GenSubs.met99Datos.numHijos;
        GenSubs.met99Datos.sumaBACYtmp = GenSubs.met99Datos.sumaBACY;
        GenSubs.met99Datos.sumaGFCtmp = GenSubs.met99Datos.sumaGFC;
        GenSubs.met99Datos.sumaBCACtmp = GenSubs.met99Datos.sumaBCAC;
        GenSubs.met99Datos.sumaGFHtmp = GenSubs.met99Datos.sumaGFH;
        GenSubs.met99Datos.lstSelBACtmp.clear();
        GenSubs.met99Datos.lstSelBCACtmp.clear();
        GenSubs.met99Datos.lstSelAPtmp.clear();
        GenSubs.met99Datos.lstSelGFtmp.clear();
        GenSubs.met99Datos.lstSelEGtmp.clear();
        GenSubs.met99Datos.lstSelCRtmp.clear();
        GenSubs.met99Datos.lstSelPHXtmp.clear();
        GenSubs.met99Datos.lstTarBACtmp.clear();
        GenSubs.met99Datos.lstTarBCACtmp.clear();
        GenSubs.met99Datos.lstOptSumaAPtmp.clear();
        GenSubs.met99Datos.lstTarGFtmp.clear();
        GenSubs.met99Datos.lstTarEGtmp.clear();
        GenSubs.met99Datos.lstTarCRtmp.clear();
        GenSubs.met99Datos.lstTarPHXtmp.clear();
        GenSubs.met99Datos.lstSumaBACtmp.clear();
        GenSubs.met99Datos.lstSumaBCACtmp.clear();
        GenSubs.met99Datos.lstSumaAPtmp.clear();
        GenSubs.met99Datos.lstSumaGFtmp.clear();
        GenSubs.met99Datos.lstSumaEGtmp.clear();
        GenSubs.met99Datos.lstSumaCRtmp.clear();
        GenSubs.met99Datos.lstSumaPHXtmp.clear();
        GenSubs.met99Datos.lstPrimaBACtmp.clear();
        GenSubs.met99Datos.lstPrimaBCACtmp.clear();
        GenSubs.met99Datos.lstPrimaAPtmp.clear();
        GenSubs.met99Datos.lstPrimaGFtmp.clear();
        GenSubs.met99Datos.lstPrimaEGtmp.clear();
        GenSubs.met99Datos.lstPrimaCRtmp.clear();
        GenSubs.met99Datos.lstPrimaPHXtmp.clear();
        GenSubs.met99Datos.lstEpBACtmp.clear();
        GenSubs.met99Datos.lstEpBCACtmp.clear();
        GenSubs.met99Datos.lstEpAPtmp.clear();
        GenSubs.met99Datos.lstEpGFtmp.clear();
        GenSubs.met99Datos.lstEpEGtmp.clear();
        GenSubs.met99Datos.lstEpCRtmp.clear();
        GenSubs.met99Datos.lstEpPHXtmp.clear();
        for (int i = 0; i < GenSubs.met99Datos.lstNombreComp.size(); ++i) {
            if (GenSubs.met99Datos.lstSelBAC.size() <= 0) continue;
            GenSubs.met99Datos.lstSelBACtmp.add(GenSubs.met99Datos.lstSelBAC.get(i));
            GenSubs.met99Datos.lstSelBCACtmp.add(GenSubs.met99Datos.lstSelBCAC.get(i));
            GenSubs.met99Datos.lstSelAPtmp.add(GenSubs.met99Datos.lstSelAP.get(i));
            GenSubs.met99Datos.lstSelGFtmp.add(GenSubs.met99Datos.lstSelGF.get(i));
            GenSubs.met99Datos.lstSelEGtmp.add(GenSubs.met99Datos.lstSelEG.get(i));
            GenSubs.met99Datos.lstSelCRtmp.add(GenSubs.met99Datos.lstSelCR.get(i));
            GenSubs.met99Datos.lstSelPHXtmp.add(GenSubs.met99Datos.lstSelPHX.get(i));
            GenSubs.met99Datos.lstTarBACtmp.add(GenSubs.met99Datos.lstTarBAC.get(i));
            GenSubs.met99Datos.lstTarBCACtmp.add(GenSubs.met99Datos.lstTarBCAC.get(i));
            GenSubs.met99Datos.lstOptSumaAPtmp.add(GenSubs.met99Datos.lstOptSumaAP.get(i));
            GenSubs.met99Datos.lstTarGFtmp.add(GenSubs.met99Datos.lstTarGF.get(i));
            GenSubs.met99Datos.lstTarEGtmp.add(GenSubs.met99Datos.lstTarEG.get(i));
            GenSubs.met99Datos.lstTarCRtmp.add(GenSubs.met99Datos.lstTarCR.get(i));
            GenSubs.met99Datos.lstTarPHXtmp.add(GenSubs.met99Datos.lstTarPHX.get(i));
            GenSubs.met99Datos.lstSumaBACtmp.add(GenSubs.met99Datos.lstSumaBAC.get(i));
            GenSubs.met99Datos.lstSumaBCACtmp.add(GenSubs.met99Datos.lstSumaBCAC.get(i));
            GenSubs.met99Datos.lstSumaAPtmp.add(GenSubs.met99Datos.lstSumaAP.get(i));
            GenSubs.met99Datos.lstSumaGFtmp.add(GenSubs.met99Datos.lstSumaGF.get(i));
            GenSubs.met99Datos.lstSumaEGtmp.add(GenSubs.met99Datos.lstSumaEG.get(i));
            GenSubs.met99Datos.lstSumaCRtmp.add(GenSubs.met99Datos.lstSumaCR.get(i));
            GenSubs.met99Datos.lstSumaPHXtmp.add(GenSubs.met99Datos.lstSumaPHX.get(i));
            GenSubs.met99Datos.lstPrimaBACtmp.add(GenSubs.met99Datos.lstPrimaBAC.get(i));
            GenSubs.met99Datos.lstPrimaBCACtmp.add(GenSubs.met99Datos.lstPrimaBCAC.get(i));
            GenSubs.met99Datos.lstPrimaAPtmp.add(GenSubs.met99Datos.lstPrimaAP.get(i));
            GenSubs.met99Datos.lstPrimaGFtmp.add(GenSubs.met99Datos.lstPrimaGF.get(i));
            GenSubs.met99Datos.lstPrimaEGtmp.add(GenSubs.met99Datos.lstPrimaEG.get(i));
            GenSubs.met99Datos.lstPrimaCRtmp.add(GenSubs.met99Datos.lstPrimaCR.get(i));
            GenSubs.met99Datos.lstPrimaPHXtmp.add(GenSubs.met99Datos.lstPrimaPHX.get(i));
            GenSubs.met99Datos.lstEpBACtmp.add(GenSubs.met99Datos.lstEpBAC.get(i));
            GenSubs.met99Datos.lstEpBCACtmp.add(GenSubs.met99Datos.lstEpBCAC.get(i));
            GenSubs.met99Datos.lstEpAPtmp.add(GenSubs.met99Datos.lstEpAP.get(i));
            GenSubs.met99Datos.lstEpGFtmp.add(GenSubs.met99Datos.lstEpGF.get(i));
            GenSubs.met99Datos.lstEpEGtmp.add(GenSubs.met99Datos.lstEpEG.get(i));
            GenSubs.met99Datos.lstEpCRtmp.add(GenSubs.met99Datos.lstEpCR.get(i));
            GenSubs.met99Datos.lstEpPHXtmp.add(GenSubs.met99Datos.lstEpPHX.get(i));
        }
    }

    public void GuardaCoberturasMaestro20() {
        GenSubs.met99Datos.selBAStmp = GenSubs.met99Datos.selBAS;
        GenSubs.met99Datos.selBITtmp = GenSubs.met99Datos.selBIT;
        GenSubs.met99Datos.selTIBAtmp = GenSubs.met99Datos.selTIBA;
        GenSubs.met99Datos.selGFAtmp = GenSubs.met99Datos.selGFA;
        GenSubs.met99Datos.sumaBAStmp = GenSubs.met99Datos.sumaBAS;
        GenSubs.met99Datos.sumaBITtmp = GenSubs.met99Datos.sumaBIT;
        GenSubs.met99Datos.sumaTIBAtmp = GenSubs.met99Datos.sumaTIBA;
        GenSubs.met99Datos.sumaGFAtmp = GenSubs.met99Datos.sumaGFA;
    }

    public void GuardaCoberturasPT20() {
        GenSubs.met99Datos.selBAStmp = GenSubs.met99Datos.selBAS;
        GenSubs.met99Datos.selBITtmp = GenSubs.met99Datos.selBIT;
        GenSubs.met99Datos.selTIBAtmp = GenSubs.met99Datos.selTIBA;
        GenSubs.met99Datos.selCIItmp = GenSubs.met99Datos.selCII;
        GenSubs.met99Datos.sumaBAStmp = GenSubs.met99Datos.sumaBAS;
        GenSubs.met99Datos.sumaBITtmp = GenSubs.met99Datos.sumaBIT;
        GenSubs.met99Datos.sumaTIBAtmp = GenSubs.met99Datos.sumaTIBA;
        GenSubs.met99Datos.sumaCIItmp = GenSubs.met99Datos.sumaCII;
        GenSubs.met99Datos.selGFCtmp = GenSubs.met99Datos.selGFC;
        GenSubs.met99Datos.sumaGFCtmp = GenSubs.met99Datos.sumaGFC;
        GenSubs.met99Datos.selGFHtmp = GenSubs.met99Datos.selGFH;
        GenSubs.met99Datos.numHijosTmp = GenSubs.met99Datos.numHijos;
        GenSubs.met99Datos.sumaGFHtmp = GenSubs.met99Datos.sumaGFH;
        GenSubs.met99Datos.lstSelBACtmp.clear();
        GenSubs.met99Datos.lstSelBCACtmp.clear();
        GenSubs.met99Datos.lstSelAPtmp.clear();
        GenSubs.met99Datos.lstSelGFtmp.clear();
        GenSubs.met99Datos.lstSelEGtmp.clear();
        GenSubs.met99Datos.lstSelCRtmp.clear();
        GenSubs.met99Datos.lstSelPHXtmp.clear();
        GenSubs.met99Datos.lstEpBACtmp.clear();
        GenSubs.met99Datos.lstEpGFtmp.clear();
        for (int i = 0; i < GenSubs.met99Datos.lstNombreComp.size(); ++i) {
            if (GenSubs.met99Datos.lstSelBAC.size() <= 0) continue;
            GenSubs.met99Datos.lstSelBCACtmp.add(false);
            GenSubs.met99Datos.lstSelAPtmp.add(false);
            GenSubs.met99Datos.lstSelEGtmp.add(false);
            GenSubs.met99Datos.lstSelCRtmp.add(false);
            GenSubs.met99Datos.lstSelGFtmp.add(false);
            GenSubs.met99Datos.lstSelPHXtmp.add(false);
            GenSubs.met99Datos.lstTarBCACtmp.add(0.0);
            GenSubs.met99Datos.lstTarEGtmp.add(0.0);
            GenSubs.met99Datos.lstTarCRtmp.add(0.0);
            GenSubs.met99Datos.lstTarGFtmp.add(0.0);
            GenSubs.met99Datos.lstTarPHXtmp.add(0.0);
            GenSubs.met99Datos.lstSumaBCACtmp.add(0);
            GenSubs.met99Datos.lstSumaAPtmp.add(0);
            GenSubs.met99Datos.lstSumaEGtmp.add(0);
            GenSubs.met99Datos.lstSumaCRtmp.add(0);
            GenSubs.met99Datos.lstSumaGFtmp.add(0);
            GenSubs.met99Datos.lstSumaPHXtmp.add(0);
            GenSubs.met99Datos.lstEpBCACtmp.add(0.0);
            GenSubs.met99Datos.lstEpAPtmp.add(0.0);
            GenSubs.met99Datos.lstEpEGtmp.add(0.0);
            GenSubs.met99Datos.lstEpCRtmp.add(0.0);
            GenSubs.met99Datos.lstEpGFtmp.add(0.0);
            GenSubs.met99Datos.lstEpPHXtmp.add(0.0);
            GenSubs.met99Datos.lstSelBACtmp.add(GenSubs.met99Datos.lstSelBAC.get(i));
            GenSubs.met99Datos.lstTarBACtmp.add(GenSubs.met99Datos.lstTarBAC.get(i));
            GenSubs.met99Datos.lstSumaBACtmp.add(GenSubs.met99Datos.lstSumaBAC.get(i));
            GenSubs.met99Datos.lstPrimaBACtmp.add(GenSubs.met99Datos.lstPrimaBAC.get(i));
            GenSubs.met99Datos.lstEpBACtmp.add(GenSubs.met99Datos.lstEpBAC.get(i));
        }
    }

    public String TextoTipoTitulo(String txtOriginal) {
        String[] txtSplit = txtOriginal.split(" ");
        StringBuffer sb = new StringBuffer();
        for (String word : txtSplit) {
            sb.append(word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase());
            sb.append(" ");
        }
        String txtNuevo = sb.toString();
        return txtNuevo;
    }
}

