/*
 * Decompiled with CFR 0.152.
 */
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;

public class PersonalizaController
implements Initializable {
    private DatosVI datosvi = DatosVI.getInstance();
    private Datos datos = Datos.getInstance();
    private Tablas tablas = Tablas.getInstance();
    private GenSubs genSubs = GenSubs.getInstance();
    Stage stage;
    Parent root;
    @FXML
    TextField nombrePromotor;
    @FXML
    TextField direccion1Promotor;
    @FXML
    TextField direccion2Promotor;
    @FXML
    TextField telefonoPromotor;
    @FXML
    TextField correoPromotor;
    @FXML
    TextField nombreAgente;
    @FXML
    TextField telefonoAgente;
    @FXML
    TextField correoAgente;
    @FXML
    ImageView imgLogo;
    @FXML
    Label lblSeleccionaLogo;
    @FXML
    ComboBox cmbPromotorias;
    @FXML
    Label lblVersion;
    String txtMensaje;

    public void initialize(URL url, ResourceBundle rb) {
        this.ValoresIniciales();
        this.cmbPromotorias.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                PersonalizaController.this.RevisaPromotoriaSeleccionada();
            }
        });
    }

    private void ValoresIniciales() {
        this.lblVersion.setText(this.datosvi.idVersion + this.datosvi.textoLegal);
        this.nombrePromotor.setText(this.datosvi.nombrePromotor);
        this.direccion1Promotor.setText(this.datosvi.direccion1Promotor);
        this.direccion2Promotor.setText(this.datosvi.direccion2Promotor);
        this.telefonoPromotor.setText(this.datosvi.telefonoPromotor);
        this.correoPromotor.setText(this.datosvi.correoPromotor);
        this.nombreAgente.setText(this.datosvi.nombreAgente);
        this.telefonoAgente.setText(this.datosvi.telefonoAgente);
        this.correoAgente.setText(this.datosvi.correoAgente);
        this.LlenaCmbPromotorias();
        this.RevisaPromotoriaSeleccionada();
        this.lblSeleccionaLogo.setVisible(false);
        this.cmbPromotorias.setVisible(false);
        this.imgLogo.setVisible(false);
    }

    private void LlenaCmbPromotorias() {
        String aliasPromotor = this.genSubs.VlookUpIntStr(this.datosvi.idPromotor, this.datosvi.lstIdPromotor, this.datosvi.lstNombrePromotor);
        this.cmbPromotorias.getItems().clear();
        this.cmbPromotorias.getItems().addAll(this.datosvi.lstNombrePromotor);
        this.cmbPromotorias.setValue((Object)aliasPromotor);
    }

    private void RevisaPromotoriaSeleccionada() {
        if (this.cmbPromotorias.getItems().size() > 0) {
            String aliasPromotor = this.cmbPromotorias.getValue().toString();
            this.datosvi.idPromotor = this.genSubs.VlookUpStrInt(aliasPromotor, this.datosvi.lstNombrePromotor, this.datosvi.lstIdPromotor);
            this.datosvi.nombreLogo = this.genSubs.VlookUpIntStr(this.datosvi.idPromotor, this.datosvi.lstIdPromotor, this.datosvi.lstNombreLogo);
            this.BuscaLogo();
        }
    }

    public void GuardaDatosPromotoria() {
        this.datosvi.nombrePromotor = this.nombrePromotor.getText().toString();
        this.datosvi.direccion1Promotor = this.direccion1Promotor.getText().toString();
        this.datosvi.direccion2Promotor = this.direccion2Promotor.getText().toString();
        this.datosvi.telefonoPromotor = this.telefonoPromotor.getText().toString();
        this.datosvi.correoPromotor = this.correoPromotor.getText().toString();
        this.datosvi.nombreAgente = this.nombreAgente.getText().toString();
        this.datosvi.telefonoAgente = this.telefonoAgente.getText().toString();
        this.datosvi.correoAgente = this.correoAgente.getText().toString();
        this.tablas.GuardaPromotoria();
        this.txtMensaje = "La informaci\u00f3n ha sigo guardada.";
        this.genSubs.MuestraMensajeOK(this.txtMensaje);
        this.RegresaInicio();
    }

    private void BuscaLogo() {
        Image imgLogoPromotor = null;
        String archivoLogo = "";
        archivoLogo = "Logos/" + this.datosvi.nombreLogo + ".jpg";
        try {
            imgLogoPromotor = new Image(archivoLogo);
            this.imgLogo.setImage(imgLogoPromotor);
        }
        catch (Exception e2) {
            System.out.println("Mensaje: " + e2);
            this.genSubs.MuestraMensaje("No encuentra imagen " + archivoLogo);
            this.datosvi.nombreLogo = "MetLife";
            archivoLogo = "Logos/" + this.datosvi.nombreLogo + ".jpg";
            this.imgLogo.setImage(imgLogoPromotor);
        }
    }

    public void RegresaInicio() {
        this.stage = (Stage)this.lblVersion.getScene().getWindow();
        this.MuestraVentana("Inicio.fxml");
    }

    private void MuestraVentana(String nombreVentana) {
        try {
            this.root = (Parent)FXMLLoader.load((URL)this.getClass().getResource(nombreVentana));
            Scene scene = new Scene(this.root);
            this.stage.setScene(scene);
            scene.getStylesheets().add((Object)"cssBase.css");
            this.stage.show();
        }
        catch (Exception e2) {
            System.out.println("No pudo cargar " + nombreVentana);
        }
    }
}

