/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.net.URL;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class MetaRep
implements Initializable {
    private Datos datos = Datos.getInstance();
    private DatosVI datosvi = DatosVI.getInstance();
    private GenSubs genSubs = GenSubs.getInstance();
    Stage stage;
    Parent root;
    @FXML
    Label lblVersion;
    @FXML
    DatePicker calVigenciaInicial;
    @FXML
    DatePicker calFechaCambio;
    @FXML
    TextField fondoBasActual;
    @FXML
    TextField fondoAdiActual;
    @FXML
    TextField sumaOriginal;
    @FXML
    TextField sumaNueva;
    @FXML
    CheckBox chkAcompa\u00f1amiento;
    Double tmpDouble;
    String txtMensaje;
    long dias;

    public void initialize(URL url, ResourceBundle rb) {
        this.ValoresIniciales();
        this.InicializaVentana();
        this.sumaOriginal.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    MetaRep.this.ValidaSumaOriginal();
                }
            }
        });
        this.sumaNueva.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    MetaRep.this.ValidaSumaNueva();
                }
            }
        });
        this.fondoBasActual.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    MetaRep.this.ValidaFondoBas();
                }
            }
        });
        this.fondoAdiActual.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    MetaRep.this.ValidaFondoAdi();
                }
            }
        });
    }

    private void ValidaSumaOriginal() {
        if (this.sumaOriginal.getText().equals("")) {
            this.sumaOriginal.setText("0");
        }
        this.datos.sumaOriginal = this.tmpDouble = Double.valueOf(Double.parseDouble(this.genSubs.QuitaComas(this.sumaOriginal.getText().toString())));
        this.sumaOriginal.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.sumaOriginal));
    }

    private void ValidaSumaNueva() {
        if (this.sumaNueva.getText().equals("")) {
            this.sumaNueva.setText("0");
        }
        this.datos.sumaNueva = this.tmpDouble = Double.valueOf(Double.parseDouble(this.genSubs.QuitaComas(this.sumaNueva.getText().toString())));
        this.sumaNueva.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.sumaNueva));
    }

    private void ValidaFondoBas() {
        if (this.fondoBasActual.getText().equals("")) {
            this.fondoBasActual.setText("0");
        }
        this.datos.fondoBasActual = this.tmpDouble = Double.valueOf(Double.parseDouble(this.genSubs.QuitaComas(this.fondoBasActual.getText().toString())));
        this.fondoBasActual.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.fondoBasActual));
    }

    private void ValidaFondoAdi() {
        if (this.fondoAdiActual.getText().equals("")) {
            this.fondoAdiActual.setText("0");
        }
        this.datos.fondoAdiActual = this.tmpDouble = Double.valueOf(Double.parseDouble(this.genSubs.QuitaComas(this.fondoAdiActual.getText().toString())));
        this.fondoAdiActual.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.fondoAdiActual));
    }

    public void Continuar() {
        this.datos.vigenciaInicial = (LocalDate)this.calVigenciaInicial.getValue();
        this.datos.fechaCambio = (LocalDate)this.calFechaCambio.getValue();
        this.datos.anoInicial = this.datos.vigenciaInicial.getYear();
        this.datos.mesInicial = this.datos.vigenciaInicial.getMonthValue();
        this.datos.diaInicial = this.datos.vigenciaInicial.getDayOfMonth();
        this.datos.anoCambio = this.datos.fechaCambio.getYear();
        this.datos.mesCambio = this.datos.fechaCambio.getMonthValue();
        this.datos.diaCambio = this.datos.fechaCambio.getDayOfMonth();
        Boolean errorDatos = false;
        this.txtMensaje = "";
        if (this.datos.fechaCambio.isBefore(this.datos.vigenciaInicial)) {
            errorDatos = true;
            this.txtMensaje = this.txtMensaje + "La fecha de cambio debe ser posterior a la fecha inicial\r";
        } else {
            long mesesEntre = ChronoUnit.MONTHS.between(this.datos.vigenciaInicial.withDayOfMonth(1), this.datos.fechaCambio.withDayOfMonth(1));
            if (mesesEntre < 2L) {
                errorDatos = true;
                this.txtMensaje = this.txtMensaje + "La diferencia en fechas debe ser mayor a 2 meses\r";
            }
        }
        if (this.datos.sumaOriginal == 0.0) {
            errorDatos = true;
            this.txtMensaje = this.txtMensaje + "La suma asegurada origina debe ser mayor a cero";
        }
        this.datos.nuevosRecargos = this.datos.vigenciaInicial.isBefore(this.datos.fechaNuevosRecargos) ? Boolean.valueOf(false) : Boolean.valueOf(true);
        this.ModificaRecargos();
        if (errorDatos.booleanValue()) {
            this.genSubs.MuestraMensaje(this.txtMensaje);
        } else {
            this.CalculaMesModificacion();
            this.MetaLife();
        }
    }

    private void CalculaMesModificacion() {
        long mesesEntre = ChronoUnit.MONTHS.between(this.datos.vigenciaInicial.withDayOfMonth(1), this.datos.fechaCambio.withDayOfMonth(1));
        this.datos.mesModificacion = (int)mesesEntre + 1;
    }

    public void MetaLife() {
        this.stage = (Stage)this.lblVersion.getScene().getWindow();
        this.MuestraVentana("Info.fxml");
    }

    private void MuestraVentana(String nombreVentana) {
        try {
            this.root = (Parent)FXMLLoader.load((URL)this.getClass().getResource(nombreVentana));
            Scene scene = new Scene(this.root);
            this.stage.setScene(scene);
            this.stage.setResizable(true);
            scene.getStylesheets().add((Object)"cssBase.css");
            this.stage.show();
        }
        catch (Exception e2) {
            System.out.println(e2 + "...No pudo cargar ventana");
        }
    }

    private void ValoresIniciales() {
        this.lblVersion.setText(this.datosvi.idVersion + this.datosvi.textoLegal);
        this.datos.plazoPago = 20;
        this.datos.actualPath = "";
        try {
            System.out.println(new File(".").getCanonicalPath());
            this.datos.actualPath = new File(".").getCanonicalPath();
        }
        catch (Exception e2) {
            System.out.println("Error: " + e2);
        }
        this.calFechaCambio.setValue((Object)this.datos.fechaCambio);
        this.calVigenciaInicial.setValue((Object)this.datos.vigenciaInicial);
        this.fondoBasActual.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.fondoBasActual));
        this.fondoAdiActual.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.fondoAdiActual));
        this.sumaOriginal.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.sumaOriginal));
        this.sumaNueva.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.sumaNueva));
        this.chkAcompa\u00f1amiento.setSelected(false);
        this.datos.conAcompa\u00f1amiento = false;
    }

    private void ModificaRecargos() {
        if (this.datos.nuevosRecargos.booleanValue()) {
            this.datos.recFijoIniPesos = 1300.0;
            this.datos.recFijoIniDls = 130.0;
        } else {
            this.datos.recFijoIniPesos = 1000.0;
            this.datos.recFijoIniDls = 100.0;
        }
    }

    private void InicializaVentana() {
    }

    public void RegresaInicio() {
        this.datos.nuevosRecargos = true;
        this.stage = (Stage)this.lblVersion.getScene().getWindow();
        this.MuestraVentana("Inicio.fxml");
    }

    public void ClicAcompa\u00f1amiento() {
        this.datos.conAcompa\u00f1amiento = this.chkAcompa\u00f1amiento.isSelected();
    }
}

