/*
 * Decompiled with CFR 0.152.
 */
import java.net.URL;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Accordion;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Separator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.util.Callback;

public class InfoController
implements Initializable {
    Stage stage;
    Parent root;
    private Datos datos = Datos.getInstance();
    private DatosVI datosvi = DatosVI.getInstance();
    private GenSubs genSubs = GenSubs.getInstance();
    private Calculos calculos = Calculos.getInstance();
    private Tablas tablas = Tablas.getInstance();
    private Cotiz cotiz = Cotiz.getInstance();
    private Presentacion presentacion = Presentacion.getInstance();
    private MemoriaCalculo memoriaCalculo = MemoriaCalculo.getInstance();
    private ReporteRobot reporteRobot = ReporteRobot.getInstance();
    private RutinasDB rutinasDB = new RutinasDB();
    private CotizMixMetaLife cotizMixMetaLife = CotizMixMetaLife.getInstance();
    private DatosPrimor datosPrimor = DatosPrimor.getInstance();
    @FXML
    Label lblVersion;
    @FXML
    Accordion accMetaLife;
    @FXML
    TitledPane paneDatosPersonales;
    @FXML
    TitledPane paneMetas;
    @FXML
    TitledPane paneCotizacion;
    @FXML
    ComboBox cmbMetas;
    @FXML
    TextField txtOtraMeta;
    @FXML
    TextField txtNombre;
    @FXML
    TextField txtEdad;
    @FXML
    RadioButton optMasculino;
    @FXML
    RadioButton optFemenino;
    @FXML
    RadioButton optFuma;
    @FXML
    RadioButton optNoFuma;
    @FXML
    RadioButton optPesos;
    @FXML
    RadioButton optDolares;
    @FXML
    RadioButton optCoberturaA;
    @FXML
    RadioButton optCoberturaB;
    @FXML
    RadioButton optInvOptimista;
    @FXML
    RadioButton optInvPromedio;
    @FXML
    RadioButton optInvConservador;
    @FXML
    RadioButton optInvOptimistaVar;
    @FXML
    RadioButton optInvPromedioVar;
    @FXML
    RadioButton optInvConservadorVar;
    @FXML
    TextField txtPorFondoFijo;
    @FXML
    TextField txtPorPPRfijo;
    @FXML
    TextField txtPorCPEAfijo;
    @FXML
    TextField txtPorFondoVariable;
    @FXML
    TextField txtPorPPRvariable;
    @FXML
    TextField txtPorCPEAvariable;
    @FXML
    Button btnVectores;
    @FXML
    Label titOpciones;
    @FXML
    TextField txtImporteOpcion;
    @FXML
    TextField txtPlazoMeta;
    @FXML
    TextField nombreMenor;
    @FXML
    TextField edadMenor;
    @FXML
    TextField ingresoAnual;
    @FXML
    Label lblAyuda;
    @FXML
    AnchorPane paneEscenario;
    @FXML
    Label lblReproyeccionDatosPer;
    @FXML
    Label lblSumaNueva;
    @FXML
    Label titSumaOriginal;
    @FXML
    Label lblSumaOriginal;
    @FXML
    TextField txtAnoMeta;
    @FXML
    TextField txtImporteMeta;
    @FXML
    TextField txtImporteAportacion;
    @FXML
    TextField txtAnoAportacion;
    @FXML
    TextField txtRetiroProgramado;
    @FXML
    TextField txtIniRetiroProgramado;
    @FXML
    TextField txtFinRetiroProgramado;
    @FXML
    TextField txtAptAnual;
    @FXML
    TableView<Meta> tblMetas;
    @FXML
    TableColumn tblAnoMeta;
    @FXML
    TableColumn tblNombreMeta;
    @FXML
    TableColumn tblImporteMeta;
    @FXML
    TableView<Aportacion> tblAportacion;
    @FXML
    TableColumn tblAnoAportacion;
    @FXML
    TableColumn tblImporteAportacion;
    @FXML
    Label lblAhorro;
    @FXML
    TextField txtAhorro;
    @FXML
    ComboBox cmbFormaPago;
    @FXML
    ComboBox cmbPlazoPago;
    @FXML
    Label lblPlazoPago;
    @FXML
    ComboBox cmbPaquete;
    @FXML
    Label lblPaquete;
    @FXML
    RadioButton optFondoFijo;
    @FXML
    RadioButton optFondoVariable;
    @FXML
    CheckBox chkEP;
    @FXML
    CheckBox chkPASI;
    @FXML
    CheckBox chkMA;
    @FXML
    CheckBox chkDI;
    @FXML
    CheckBox chkTI;
    @FXML
    CheckBox chkGE;
    @FXML
    Label lblPrimaBAS;
    @FXML
    Label lblPrimaEP;
    @FXML
    Label lblPrimaPASI;
    @FXML
    Label lblPrimaMA;
    @FXML
    Label lblPrimaDI;
    @FXML
    Label lblPrimaTI;
    @FXML
    Label lblPrimaGE;
    @FXML
    Label lblPrimaAnualCoberturas;
    @FXML
    Label titAportacionAdicional;
    @FXML
    Label lblAportacionAdicionalAnual;
    @FXML
    Label lblAportacionFPago;
    @FXML
    Label lblFondoFijo;
    @FXML
    Label lblPPRfijo;
    @FXML
    Label lblCPEAfijo;
    @FXML
    Label lblFondoVar;
    @FXML
    Label lblPPRvar;
    @FXML
    Label lblCPEAvar;
    @FXML
    CheckBox chkReporteEspecial;
    @FXML
    CheckBox chkRendimientos;
    @FXML
    CheckBox conCostoSeguro;
    @FXML
    Label lblReproyeccion;
    @FXML
    Label lblSumaInicial;
    @FXML
    TextField txtSumaInicial;
    @FXML
    Label lblSumaEP;
    @FXML
    Label lblSumaPASI;
    @FXML
    Label lblSumaMA;
    @FXML
    Label lblSumaDI;
    @FXML
    Label lblSumaTI;
    @FXML
    Label lblSumaGE;
    @FXML
    Label titAportacionProgramada;
    @FXML
    Label lblAportacionProgramada;
    @FXML
    Label lblPrimaFPago;
    @FXML
    Label lblAportacionAnualTotal;
    @FXML
    Label titAportacionAnualTotal;
    @FXML
    Button btnAgregarMetas;
    @FXML
    Button btnModificarMetas;
    @FXML
    Button btnEliminarMetas;
    @FXML
    Button btnRobot;
    @FXML
    Button btnReporte;
    @FXML
    Button btnPresentacion;
    @FXML
    TextField epMillarBAS;
    @FXML
    TextField epPorBAS;
    @FXML
    TextField epPorACC;
    @FXML
    TextField epPorINV;
    @FXML
    Label epEquivBAS;
    @FXML
    Button btnCalcularEP;
    @FXML
    Label titExtraprima;
    @FXML
    Label titEPmillar;
    @FXML
    Label titEPporcentaje;
    @FXML
    Label titEPequivalente;
    @FXML
    Separator lineaExtraprima;
    @FXML
    Label titEPvida;
    @FXML
    Label titEPinvalidez;
    @FXML
    Label titEPaccidentes;
    @FXML
    Button btnCotizCombinada;
    @FXML
    Button btnPrimordial;
    String metaSeleccionada;
    String fpagoSeleccionado;
    Boolean metaValida;
    String txtMensaje = "";
    String nombreMeta;
    String anoCapturado;
    String metaCapturada;
    String importeMetaCapturado;
    String anoAportacionCapturado;
    String importeAportacionCapturado;
    private final ObservableList<Meta> listaMetas = FXCollections.observableArrayList();
    private final ObservableList<Aportacion> listaAportaciones = FXCollections.observableArrayList();
    Boolean aportacionValida;
    String paneCerrado;
    Boolean hayError;
    Double valTemp;
    String txtTemp;
    Integer plazoMetaPrincipal;
    Double posX;
    Double posY;
    Integer aportacionAno5;
    Integer retirosAno5;
    ResultSet rs = null;
    Double tarBASmodificada;
    Boolean modificarTarBAS = false;

    public void initialize(URL url, ResourceBundle rb) {
        this.tblAnoMeta.setCellValueFactory((Callback)new PropertyValueFactory("anoMeta"));
        this.tblNombreMeta.setCellValueFactory((Callback)new PropertyValueFactory("nombreMeta"));
        this.tblImporteMeta.setCellValueFactory((Callback)new PropertyValueFactory("importeMeta"));
        this.tblMetas.setItems(this.listaMetas);
        this.tblAnoAportacion.setCellValueFactory((Callback)new PropertyValueFactory("anoAportacion"));
        this.tblImporteAportacion.setCellValueFactory((Callback)new PropertyValueFactory("importeAportacion"));
        this.tblAportacion.setItems(this.listaAportaciones);
        this.cmbMetas.setValue((Object)"Hogar");
        this.InicializaVentana();
        if (!this.datos.primeraVez.booleanValue()) {
            this.CargaDatosPrevios();
        } else {
            this.ValoresIniciales();
        }
        this.ValoresReproyeccion();
        this.TituloOpcionCalculo();
        if (this.datosPrimor.combinaPrimordial.booleanValue()) {
            Integer indexTitular = 0;
            for (int i = 0; i < this.datosPrimor.listaAseg.size(); ++i) {
                if (((Aseg)this.datosPrimor.listaAseg.get(i)).getParentescoAseg() != "Titular") continue;
                indexTitular = i;
            }
            this.txtNombre.setText(((Aseg)this.datosPrimor.listaAseg.get(indexTitular.intValue())).getNombreAseg());
            if (((Aseg)this.datosPrimor.listaAseg.get(indexTitular.intValue())).getSexoAseg() == "M") {
                this.optMasculino.setSelected(true);
            } else {
                this.optFemenino.setSelected(true);
            }
            this.txtEdad.setText(((Aseg)this.datosPrimor.listaAseg.get(indexTitular.intValue())).getEdadAseg());
            this.datos.nombre = this.txtNombre.getText();
            this.datos.edad = Integer.parseInt(this.txtEdad.getText().toString());
            this.datos.sexo = this.optMasculino.isSelected() ? "M" : "F";
            this.datos.indexFormaPago = this.datosPrimor.indexFormaPago > 1 ? (this.datosPrimor.indexFormaPago == 3 ? 2 : 3) : this.datosPrimor.indexFormaPago;
            this.optPesos.setSelected(true);
            this.datos.moneda = "P";
            this.cmbFormaPago.getSelectionModel().select(this.datos.indexFormaPago);
            this.fpagoSeleccionado = this.datos.formaPago = this.cmbFormaPago.getItems().get(this.datos.indexFormaPago).toString();
            this.RevisaFPagoSeleccionado();
            this.txtNombre.setDisable(true);
            this.txtEdad.setDisable(true);
            this.optMasculino.setDisable(true);
            this.optFemenino.setDisable(true);
            this.btnCotizCombinada.setVisible(true);
            this.btnPrimordial.setVisible(true);
        } else {
            this.txtNombre.setDisable(false);
            this.txtEdad.setDisable(false);
            this.optMasculino.setDisable(false);
            this.optFemenino.setDisable(false);
            this.btnCotizCombinada.setVisible(false);
            this.btnPrimordial.setVisible(false);
        }
        this.datos.primeraVez = false;
        this.accMetaLife.setExpandedPane(this.paneDatosPersonales);
        this.cmbMetas.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                InfoController.this.metaSeleccionada = newValue;
                InfoController.this.RevisaMetaSeleccionada();
            }
        });
        this.cmbFormaPago.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                InfoController.this.fpagoSeleccionado = newValue;
                InfoController.this.RevisaFPagoSeleccionado();
            }
        });
        this.cmbPaquete.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                ((InfoController)InfoController.this).datos.paqueteSeleccionado = newValue;
                InfoController.this.RevisaPaqueteSeleccionado();
            }
        });
        this.cmbPlazoPago.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null) {
                    ((InfoController)InfoController.this).datos.txtPlazoPago = newValue;
                }
                InfoController.this.RevisaPlazoPagoSeleccionado();
            }
        });
        this.txtNombre.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    InfoController.this.FormatoTituloNombre();
                }
            }
        });
        this.txtEdad.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    InfoController.this.ArmaCmbPlazoPago();
                }
            }
        });
        this.txtImporteMeta.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    InfoController.this.FormatoImporte("txtImporteMeta");
                }
            }
        });
        this.txtImporteOpcion.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    InfoController.this.FormatoImporte("txtImporteOpcion");
                }
            }
        });
        this.txtImporteAportacion.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    InfoController.this.FormatoImporte("txtAportacion");
                }
            }
        });
        this.txtRetiroProgramado.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    InfoController.this.FormatoImporte("txtRetiroProgramado");
                }
            }
        });
        this.txtAptAnual.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    InfoController.this.FormatoImporte("txtAptAnual");
                }
            }
        });
        this.txtAhorro.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    InfoController.this.FormatoImporte("txtAhorro");
                }
            }
        });
        this.txtSumaInicial.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    InfoController.this.FormatoImporte("txtSumaInicial");
                }
            }
        });
        this.ingresoAnual.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    InfoController.this.FormatoImporte("ingresoAnual");
                }
            }
        });
        this.epMillarBAS.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    InfoController.this.RevisaExtraPrimas();
                }
            }
        });
        this.epPorBAS.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    InfoController.this.RevisaExtraPrimas();
                }
            }
        });
        this.epPorINV.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    InfoController.this.RevisaExtraPrimas();
                }
            }
        });
        this.epPorACC.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    InfoController.this.RevisaExtraPrimas();
                }
            }
        });
        this.paneDatosPersonales.expandedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!InfoController.this.paneDatosPersonales.isExpanded()) {
                    InfoController.this.paneCerrado = "DatosPersonales";
                }
            }
        });
        this.paneMetas.expandedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!InfoController.this.paneMetas.isExpanded()) {
                    InfoController.this.paneCerrado = "Metas";
                }
            }
        });
        this.paneCotizacion.expandedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!InfoController.this.paneCotizacion.isExpanded()) {
                    InfoController.this.paneCerrado = "Cotizacion";
                }
            }
        });
        this.txtNombre.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaLetras(100));
        this.txtEdad.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(2));
        this.txtPorFondoFijo.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(3));
        this.txtPorPPRfijo.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(3));
        this.txtPorCPEAfijo.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(3));
        this.txtPorFondoVariable.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(3));
        this.txtPorPPRvariable.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(3));
        this.txtPorCPEAvariable.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(3));
        this.txtAnoMeta.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(2));
        this.txtImporteMeta.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumeros());
        this.txtImporteOpcion.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumeros());
        this.txtPlazoMeta.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumeros());
        this.txtImporteAportacion.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumeros());
        this.txtAnoAportacion.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(2));
        this.txtRetiroProgramado.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumeros());
        this.txtIniRetiroProgramado.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(2));
        this.txtFinRetiroProgramado.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(2));
        this.edadMenor.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(2));
        this.ingresoAnual.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumeros());
        this.epMillarBAS.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(6));
        this.epPorBAS.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(6));
        this.epPorINV.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(6));
        this.epPorACC.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(6));
    }

    private void RevisaMetaSeleccionada() {
        if (this.metaSeleccionada.equals("Otra")) {
            this.txtOtraMeta.setVisible(true);
        } else {
            this.txtOtraMeta.setVisible(false);
        }
    }

    private void RevisaFPagoSeleccionado() {
        this.datos.indexFormaPago = this.cmbFormaPago.getSelectionModel().getSelectedIndex();
        this.datos.formaPago = this.fpagoSeleccionado;
        this.lblAhorro.setText("Ahorro adicional anual");
    }

    private void RevisaPaqueteSeleccionado() {
        this.txtPorFondoFijo.setText("100");
        this.txtPorFondoVariable.setText("0");
        this.txtPorPPRfijo.setText("0");
        this.txtPorPPRvariable.setText("0");
        this.txtPorCPEAfijo.setText("0");
        this.txtPorCPEAvariable.setText("0");
        if (this.optPesos.isSelected()) {
            if (this.datos.paqueteSeleccionado.equals("Retiro")) {
                this.txtPorFondoFijo.setDisable(false);
                this.txtPorFondoVariable.setDisable(false);
                this.txtPorPPRfijo.setDisable(false);
                this.txtPorPPRvariable.setDisable(false);
                this.txtPorCPEAfijo.setDisable(false);
                this.txtPorCPEAvariable.setDisable(false);
            } else {
                this.txtPorFondoFijo.setDisable(false);
                this.txtPorFondoVariable.setDisable(false);
                this.txtPorPPRfijo.setDisable(true);
                this.txtPorPPRvariable.setDisable(true);
                this.txtPorCPEAfijo.setDisable(true);
                this.txtPorCPEAvariable.setDisable(true);
            }
        } else if (this.datos.paqueteSeleccionado.equals("Retiro")) {
            this.txtPorFondoFijo.setDisable(false);
            this.txtPorFondoVariable.setDisable(true);
            this.txtPorPPRfijo.setDisable(false);
            this.txtPorPPRvariable.setDisable(true);
            this.txtPorCPEAfijo.setDisable(false);
            this.txtPorCPEAvariable.setDisable(true);
        } else {
            this.txtPorFondoFijo.setDisable(false);
            this.txtPorFondoVariable.setDisable(true);
            this.txtPorPPRfijo.setDisable(true);
            this.txtPorPPRvariable.setDisable(true);
            this.txtPorCPEAfijo.setDisable(true);
            this.txtPorCPEAvariable.setDisable(true);
        }
        this.nombreMenor.setVisible(false);
        this.edadMenor.setVisible(false);
        this.ingresoAnual.setVisible(false);
        if (this.datos.paqueteSeleccionado.equals("Retiro")) {
            this.ingresoAnual.setVisible(true);
        } else if (this.datos.paqueteSeleccionado.equals("Educaci\u00f3n")) {
            this.nombreMenor.setVisible(true);
            this.edadMenor.setVisible(true);
        }
    }

    private void RevisaPlazoPagoSeleccionado() {
        this.cmbFormaPago.setDisable(false);
        this.datos.edadAlcanzada = false;
        switch (this.datos.txtPlazoPago) {
            case "5 a\u00f1os": {
                this.datos.plazoPago = 5;
                break;
            }
            case "10 a\u00f1os": {
                this.datos.plazoPago = 10;
                break;
            }
            case "15 a\u00f1os": {
                this.datos.plazoPago = 15;
                break;
            }
            case "20 a\u00f1os": {
                this.datos.plazoPago = 20;
                break;
            }
            case "edad 60": {
                this.datos.plazoPago = 60 - this.datos.edad;
                this.datos.edadAlcanzada = true;
                break;
            }
            case "edad 65": {
                this.datos.plazoPago = 65 - this.datos.edad;
                this.datos.edadAlcanzada = true;
                break;
            }
            case "vitalicio": {
                this.datos.plazoPago = 99;
                this.datos.primaAhorro = 0.0;
                break;
            }
            case "One Shot": {
                this.datos.plazoPago = 99;
                this.cmbFormaPago.setValue((Object)"Anual");
                this.datos.formaPago = "Anual";
                this.fpagoSeleccionado = "Anual";
                this.cmbFormaPago.setDisable(true);
                this.lblAhorro.setText("Ahorro adicional \u00fanico");
            }
        }
        if (this.datos.plazoPago < 99 || this.datos.txtPlazoPago == "One Shot") {
            this.lblAhorro.setVisible(true);
            this.txtAhorro.setVisible(true);
        } else {
            this.lblAhorro.setVisible(false);
            this.txtAhorro.setVisible(false);
        }
    }

    public void RegresaInicio() {
        this.BorraMetas();
        this.GuardaDatos();
        this.RecuperaDatos();
        this.stage = (Stage)this.lblVersion.getScene().getWindow();
        if (this.datos.reproyectaMetaLife.booleanValue()) {
            this.MuestraVentana("MetaRep");
        } else {
            this.MuestraVentana("MetaLife");
        }
    }

    private void BorraMetas() {
        this.datos.lstAnoMeta.clear();
        this.datos.lstNombreMeta.clear();
        this.datos.lstImporteMeta.clear();
        this.listaMetas.clear();
        this.datos.lstAnoAportacion.clear();
        this.datos.lstImporteAportacion.clear();
        this.listaAportaciones.clear();
        this.datos.impAptAnual = 0.0;
        this.txtAptAnual.setText("");
        this.datos.retiroProgramado = 0;
        this.datos.iniRetiroProgramado = 0;
        this.datos.finRetiroProgramado = 0;
        this.txtRetiroProgramado.setText("");
        this.txtIniRetiroProgramado.setText("");
        this.txtFinRetiroProgramado.setText("");
    }

    private void MuestraVentana(String nombreVentana) {
        try {
            this.root = (Parent)FXMLLoader.load((URL)this.getClass().getResource(nombreVentana + ".fxml"));
        }
        catch (Exception e2) {
            System.out.println("No pudo cargar " + nombreVentana);
        }
        Scene scene = new Scene(this.root);
        this.stage.setScene(scene);
        scene.getStylesheets().add((Object)"cssBase.css");
        this.stage.show();
    }

    public void AgregarMetas() {
        this.ValidaMeta();
        if (this.metaValida.booleanValue()) {
            this.anoCapturado = this.txtAnoMeta.getText().toString();
            this.metaCapturada = this.nombreMeta;
            this.importeMetaCapturado = this.txtImporteMeta.getText().toString();
            this.listaMetas.add((Object)new Meta(this.anoCapturado, this.metaCapturada, this.importeMetaCapturado));
            this.txtAnoMeta.clear();
            this.txtImporteMeta.clear();
            this.ActualizaVectorMetas();
        } else {
            this.genSubs.MuestraMensaje(this.txtMensaje);
        }
    }

    private void ValidaMeta() {
        this.metaSeleccionada = this.cmbMetas.getSelectionModel().getSelectedItem().toString();
        this.metaValida = true;
        this.txtMensaje = "";
        if ("Otra".equals(this.metaSeleccionada)) {
            this.nombreMeta = this.txtOtraMeta.getText();
            if (this.txtOtraMeta.getText().equals("")) {
                this.metaValida = false;
                this.txtMensaje = this.txtMensaje + "La meta no debe estar en blanco\r";
            }
        } else {
            this.nombreMeta = this.metaSeleccionada;
        }
        if (this.txtImporteMeta.getText().equals("") || this.txtAnoMeta.getText().equals("")) {
            this.metaValida = false;
            this.txtMensaje = this.txtMensaje + "Proporcionar a\u00f1o e importe de meta\r";
        } else {
            this.anoCapturado = this.txtAnoMeta.getText().toString();
            if (Integer.parseInt(this.anoCapturado) < 6) {
                this.ValidaMetaVSaportaciones();
                if (!this.metaValida.booleanValue()) {
                    this.txtMensaje = this.txtMensaje + "Aportaciones insuficientes\r";
                }
            }
        }
    }

    private void ValidaMetaVSaportaciones() {
        this.CalculaAportacionesAlAno5();
        this.CalculaRetirosAlAno5();
        Integer metaCapturada = Integer.parseInt(this.genSubs.QuitaComas(this.txtImporteMeta.getText().toString()));
        this.metaValida = this.retirosAno5 + metaCapturada <= this.aportacionAno5 ? Boolean.valueOf(true) : Boolean.valueOf(false);
    }

    private void CalculaAportacionesAlAno5() {
        this.aportacionAno5 = 0;
        for (int i = 0; i < this.datos.lstAnoAportacion.size(); ++i) {
            this.aportacionAno5 = this.aportacionAno5 + this.datos.lstImporteAportacion.get(i);
        }
        Double tmpDouble = this.datos.impAptAnual * 5.0;
        this.aportacionAno5 = this.aportacionAno5 + tmpDouble.intValue();
    }

    private void CalculaRetirosAlAno5() {
        this.retirosAno5 = 0;
        for (int i = 0; i < this.datos.lstAnoMeta.size(); ++i) {
            if (this.datos.lstAnoMeta.get(i) >= 6) continue;
            this.retirosAno5 = this.retirosAno5 + this.datos.lstImporteMeta.get(i);
        }
    }

    public void ModificaMeta() {
        if (this.tblMetas.getSelectionModel().getSelectedItem() != null) {
            Meta meta = (Meta)this.tblMetas.getSelectionModel().getSelectedItem();
            this.txtAnoMeta.setText(meta.getAnoMeta());
            this.txtImporteMeta.setText(meta.getImporteMeta());
            this.listaMetas.remove((Object)meta);
            this.datos.numMetas = this.listaMetas.size();
            this.ActualizaVectorMetas();
        } else {
            this.genSubs.MuestraMensaje("Debe seleccionar una meta");
        }
    }

    public void EliminaMeta() {
        if (this.tblMetas.getSelectionModel().getSelectedItem() != null) {
            Meta meta = (Meta)this.tblMetas.getSelectionModel().getSelectedItem();
            this.listaMetas.remove((Object)meta);
            this.datos.numMetas = this.listaMetas.size();
            this.ActualizaVectorMetas();
        } else {
            this.genSubs.MuestraMensaje("Debe seleccionar una meta");
        }
    }

    private void ActualizaVectorMetas() {
        this.datos.lstAnoMeta.clear();
        this.datos.lstNombreMeta.clear();
        this.datos.lstImporteMeta.clear();
        if (this.listaMetas.size() > 0) {
            for (int i = 0; i < this.listaMetas.size(); ++i) {
                this.datos.lstAnoMeta.add(i, Integer.parseInt(((Meta)this.listaMetas.get(i)).getAnoMeta().toString()));
                this.datos.lstNombreMeta.add(i, ((Meta)this.listaMetas.get(i)).getNombreMeta());
                this.datos.lstImporteMeta.add(i, Integer.parseInt(this.genSubs.QuitaComas(((Meta)this.listaMetas.get(i)).getImporteMeta().toString())));
            }
        }
    }

    private void ActualizaVectorAportaciones() {
        this.datos.lstAnoAportacion.clear();
        this.datos.lstImporteAportacion.clear();
        if (this.listaAportaciones.size() > 0) {
            for (int i = 0; i < this.listaAportaciones.size(); ++i) {
                this.datos.lstAnoAportacion.add(i, Integer.parseInt(((Aportacion)this.listaAportaciones.get(i)).getAnoAportacion().toString()));
                this.datos.lstImporteAportacion.add(i, Integer.parseInt(this.genSubs.QuitaComas(((Aportacion)this.listaAportaciones.get(i)).getImporteAportacion().toString())));
            }
        }
    }

    public void AgregarAportaciones() {
        this.ValidaAportacion();
        if (this.aportacionValida.booleanValue()) {
            this.anoAportacionCapturado = this.txtAnoAportacion.getText().toString();
            this.importeAportacionCapturado = this.txtImporteAportacion.getText().toString();
            this.listaAportaciones.add((Object)new Aportacion(this.anoAportacionCapturado, this.importeAportacionCapturado));
            this.txtAnoAportacion.clear();
            this.txtImporteAportacion.clear();
            this.ActualizaVectorAportaciones();
        }
    }

    public void ModificaAportacion() {
        if (this.tblAportacion.getSelectionModel().getSelectedItem() != null) {
            Aportacion aportacion = (Aportacion)this.tblAportacion.getSelectionModel().getSelectedItem();
            this.txtAnoAportacion.setText(aportacion.getAnoAportacion());
            this.txtImporteAportacion.setText(aportacion.getImporteAportacion());
            this.listaAportaciones.remove((Object)aportacion);
            this.datos.numAportaciones = this.listaAportaciones.size();
            this.ActualizaVectorAportaciones();
        } else {
            this.genSubs.MuestraMensaje("Debe seleccionar una aportaci\u00f3n");
        }
    }

    public void EliminaAportacion() {
        if (this.tblAportacion.getSelectionModel().getSelectedItem() != null) {
            Aportacion aportacion = (Aportacion)this.tblAportacion.getSelectionModel().getSelectedItem();
            String tmpString = aportacion.getImporteAportacion();
            Integer aportacionEliminada = Integer.parseInt(this.genSubs.QuitaComas(tmpString));
            this.CalculaRetirosAlAno5();
            this.CalculaAportacionesAlAno5();
            this.aportacionAno5 = this.aportacionAno5 - aportacionEliminada;
            if (this.retirosAno5 <= this.aportacionAno5) {
                this.listaAportaciones.remove((Object)aportacion);
                this.datos.numAportaciones = this.listaAportaciones.size();
                this.ActualizaVectorAportaciones();
            } else {
                this.genSubs.MuestraMensaje("Los retiros son mayores a aportaciones");
            }
        } else {
            this.genSubs.MuestraMensaje("Debe seleccionar una aportaci\u00f3n");
        }
    }

    private void ValidaAportacion() {
        this.aportacionValida = true;
        if (this.txtAnoAportacion.getText().equals("") || this.txtImporteAportacion.getText().equals("")) {
            this.aportacionValida = false;
            this.txtMensaje = this.txtMensaje + "La aportaci\u00f3n y a\u00f1o no deben estar en blanco\r";
        }
    }

    public void ClicDatosPersonales() {
        if (this.paneCerrado.equals("Metas")) {
            this.ValidaMetas();
        } else {
            this.ValidaCotizacion();
        }
    }

    public void ClicMetas() {
        if (this.paneCerrado.equals("DatosPersonales")) {
            this.ValidaDatosPersonales();
        } else {
            this.ValidaCotizacion();
        }
        if (this.txtMensaje.equals("")) {
            this.GuardaDatos();
            this.btnAgregarMetas.setDisable(false);
            this.btnModificarMetas.setDisable(false);
            this.btnEliminarMetas.setDisable(false);
            this.txtRetiroProgramado.setDisable(false);
            this.txtIniRetiroProgramado.setDisable(false);
            this.txtFinRetiroProgramado.setDisable(false);
        }
    }

    public void clicCotizacion() {
        if (this.paneCerrado.equals("DatosPersonales")) {
            this.ValidaDatosPersonales();
        } else {
            this.ValidaMetas();
        }
        if (this.txtMensaje.equals("")) {
            this.GuardaDatos();
            this.Cotiza();
        }
    }

    private void ValidaDatosPersonales() {
        this.txtMensaje = "";
        this.ValidaNombre();
        this.ValidaEdad();
        this.ValidaDistribucionFondos();
        if (this.datos.optOpcionCalculo.equals("Meta")) {
            this.ValidaMetaPrincipal();
        }
        if (this.datos.optOpcionCalculo.equals("Suma")) {
            if (this.txtImporteOpcion.getText().equals("")) {
                this.txtMensaje = this.txtMensaje + "Proporcione la suma asegurada\r";
            } else {
                this.DeterminaSumaMin();
                if (Double.parseDouble(this.genSubs.QuitaComas(this.txtImporteOpcion.getText())) < (double)this.datos.sumaMinBAS.intValue()) {
                    this.txtMensaje = this.txtMensaje + "La suma asegurda debe ser superior o igual a " + this.datos.sumaMinBAS + "\r";
                }
            }
        }
        if (this.datos.optOpcionCalculo.equals("Prima") && (this.txtImporteOpcion.getText().equals("") || this.txtImporteOpcion.getText().equals("0"))) {
            this.txtMensaje = this.txtMensaje + "Proporcione la prima\r";
        }
        if (!this.txtMensaje.isEmpty()) {
            this.hayError = true;
            this.accMetaLife.setExpandedPane(this.paneDatosPersonales);
            this.genSubs.MuestraMensaje(this.txtMensaje);
        } else if (this.datos.optOpcionCalculo.equals("Meta")) {
            this.anoCapturado = this.txtPlazoMeta.getText().toString();
            this.metaCapturada = "Principal";
            this.importeMetaCapturado = this.txtImporteOpcion.getText().toString();
            if (this.datos.lstAnoMeta.size() > 0) {
                for (int i = 0; i < this.datos.lstAnoMeta.size(); ++i) {
                    if (!((Meta)this.listaMetas.get(i)).getNombreMeta().equals("Principal")) continue;
                    this.listaMetas.remove(i);
                    break;
                }
            }
            this.listaMetas.add((Object)new Meta(this.anoCapturado, this.metaCapturada, this.importeMetaCapturado));
        }
        this.DeterminaCoberturasValidas();
    }

    private void DeterminaCoberturasValidas() {
        if (this.HabilitarCob("EP").booleanValue()) {
            this.chkEP.setDisable(false);
        } else {
            this.chkEP.setSelected(false);
            this.chkEP.setDisable(true);
        }
        if (this.HabilitarCob("PASI").booleanValue()) {
            this.chkPASI.setDisable(false);
        } else {
            this.chkPASI.setSelected(false);
            this.chkPASI.setDisable(true);
        }
        if (this.HabilitarCob("MA").booleanValue()) {
            this.chkMA.setDisable(false);
        } else {
            this.chkMA.setSelected(false);
            this.chkMA.setDisable(true);
        }
        if (this.HabilitarCob("DI").booleanValue()) {
            this.chkDI.setDisable(false);
        } else {
            this.chkDI.setSelected(false);
            this.chkDI.setDisable(true);
        }
        if (this.HabilitarCob("TI").booleanValue()) {
            this.chkTI.setDisable(false);
        } else {
            this.chkTI.setSelected(false);
            this.chkTI.setDisable(true);
        }
        if (this.HabilitarCob("GE").booleanValue()) {
            this.chkGE.setDisable(false);
        } else {
            this.chkGE.setSelected(false);
            this.chkGE.setDisable(true);
        }
    }

    private Boolean HabilitarCob(String idCob) {
        Integer edadMin = this.datos.lstEdadMinCob.get(this.genSubs.IndiceCob(idCob, "P"));
        Integer edadMax = this.datos.lstEdadMaxCob.get(this.genSubs.IndiceCob(idCob, "P"));
        Boolean habilitar = this.datos.edad < edadMin || this.datos.edad > edadMax ? Boolean.valueOf(false) : Boolean.valueOf(true);
        return habilitar;
    }

    private void DeterminaSumaMin() {
        this.datos.sumaMinBAS = this.optPesos.isSelected() ? this.datos.lstSumaMinCob.get(this.genSubs.IndiceCob("BAS", "P")) : this.datos.lstSumaMinCob.get(this.genSubs.IndiceCob("BAS", "D"));
    }

    private void ValidaMetaPrincipal() {
        if (this.txtPlazoMeta.getText().equals("")) {
            this.txtPlazoMeta.setText("0");
        }
        this.plazoMetaPrincipal = Integer.parseInt(this.txtPlazoMeta.getText().toString());
        if (this.txtImporteOpcion.getText().equals("") || this.txtImporteOpcion.getText().equals("0")) {
            this.txtMensaje = this.txtMensaje + "Especifique importe de la meta y plazo\r";
        } else if (this.plazoMetaPrincipal == 0) {
            this.txtMensaje = this.txtMensaje + "Especifique importe de la meta y plazo\r";
        }
        this.ValidaPlazoMaximo(this.datos.edad, this.plazoMetaPrincipal);
    }

    private void ValidaCotizacion() {
    }

    private void ValidaMetas() {
        this.txtMensaje = "";
        if (!this.datos.txtPlazoPago.equals("One Shot")) {
            this.RevisaPlazoMetas();
        }
        this.ValidaRetiroProgramado();
        if (!this.txtMensaje.isEmpty()) {
            this.accMetaLife.setExpandedPane(this.paneMetas);
            this.genSubs.MuestraMensaje(this.txtMensaje);
        }
        this.CalculaAportacionesAlAno5();
        this.CalculaRetirosAlAno5();
        this.metaValida = this.retirosAno5 <= this.aportacionAno5 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        if (!this.metaValida.booleanValue()) {
            this.accMetaLife.setExpandedPane(this.paneMetas);
            this.txtMensaje = this.txtMensaje + "Aportaciones insuficientes";
            this.genSubs.MuestraMensaje(this.txtMensaje);
        }
    }

    private void GuardaDatos() {
        this.datos.nombre = this.txtNombre.getText().toString();
        this.datos.edad = this.txtEdad.getText().equals("") ? Integer.valueOf(0) : Integer.valueOf(Integer.parseInt(this.txtEdad.getText().toString()));
        this.datos.fuma = this.optFuma.isSelected() ? "S" : "N";
        this.datos.sexo = this.optMasculino.isSelected() ? "M" : "F";
        this.datos.moneda = this.optPesos.isSelected() ? "P" : "D";
        this.datos.cobertura = this.optCoberturaA.isSelected() ? "A" : "B";
        this.datos.escenario = this.optInvOptimista.isSelected() ? "O" : (this.optInvPromedio.isSelected() ? "P" : "C");
        this.datos.escenarioVar = this.optInvOptimistaVar.isSelected() ? "O" : (this.optInvPromedioVar.isSelected() ? "P" : "C");
        this.ActualizaVectorMetas();
        this.ActualizaVectorAportaciones();
        this.datos.lstAnoAportacion.clear();
        this.datos.lstImporteAportacion.clear();
        if (this.listaAportaciones.size() > 0) {
            for (int i = 0; i < this.listaAportaciones.size(); ++i) {
                this.datos.lstAnoAportacion.add(i, Integer.parseInt(((Aportacion)this.listaAportaciones.get(i)).getAnoAportacion().toString()));
                this.datos.lstImporteAportacion.add(i, Integer.parseInt(this.genSubs.QuitaComas(((Aportacion)this.listaAportaciones.get(i)).getImporteAportacion().toString())));
            }
        }
        if (this.txtRetiroProgramado.getText().equals("") || this.txtRetiroProgramado.getText().equals("0")) {
            this.datos.retiroProgramado = 0;
            this.datos.iniRetiroProgramado = 0;
            this.datos.finRetiroProgramado = 0;
        } else {
            this.datos.retiroProgramado = Integer.parseInt(this.genSubs.QuitaComas(this.txtRetiroProgramado.getText().toString()));
            this.datos.iniRetiroProgramado = Integer.parseInt(this.txtIniRetiroProgramado.getText().toString());
            this.datos.finRetiroProgramado = Integer.parseInt(this.txtFinRetiroProgramado.getText().toString());
        }
        this.datos.impAptAnual = this.txtAptAnual.getText().equals("") ? Double.valueOf(0.0) : Double.valueOf(Double.parseDouble(this.genSubs.QuitaComas(this.txtAptAnual.getText())));
        if (this.ingresoAnual.getText().equals("")) {
            this.ingresoAnual.setText("0");
        }
        String valTemp = this.genSubs.QuitaComas(this.ingresoAnual.getText());
        this.datos.ingresoAnual = Double.parseDouble(valTemp);
        this.datos.conCostoSeguro = this.conCostoSeguro.isSelected();
        if (this.txtAhorro.getText().equals("")) {
            this.txtAhorro.setText("0");
        }
        valTemp = this.genSubs.QuitaComas(this.txtAhorro.getText());
        this.datos.primaAhorro = Double.parseDouble(valTemp);
        this.datos.nombreMenor = this.nombreMenor.getText().toString();
        if (this.edadMenor.getText().equals("")) {
            this.edadMenor.setText("0");
        }
        this.datos.edadMenor = Integer.parseInt(this.edadMenor.getText().toString());
        this.datos.selEP = this.chkEP.isSelected();
        this.datos.selPASI = this.chkEP.isSelected();
        this.datos.selMA = this.chkMA.isSelected();
        this.datos.selDI = this.chkDI.isSelected();
        this.datos.selTI = this.chkTI.isSelected();
        this.datos.selGE = this.chkGE.isSelected();
        if (!this.datos.optOpcionCalculo.equals("Meta")) {
            if (this.datos.optOpcionCalculo.equals("Suma")) {
                if (this.txtImporteOpcion.getText().equals("")) {
                    this.datos.sumaInicial = 0.0;
                } else {
                    this.datos.sumaNueva = this.datos.sumaInicial = Double.valueOf(Double.parseDouble(this.genSubs.QuitaComas(this.txtImporteOpcion.getText())));
                }
            } else {
                if (this.txtImporteOpcion.getText().equals("")) {
                    this.txtImporteOpcion.setText("0");
                }
                valTemp = this.genSubs.QuitaComas(this.txtImporteOpcion.getText());
                this.datos.primaFPago = Double.parseDouble(valTemp);
                if (this.datos.txtPlazoPago.equals("One Shot")) {
                    this.datos.primaOneShot = Double.parseDouble(valTemp);
                }
            }
        }
        this.datos.optInvFondo = this.optFondoFijo.isSelected() ? "invFondoFijo" : "invFondoVar";
        if (this.optPesos.isSelected()) {
            this.datos.tasaAdiPesosFija = this.optInvOptimista.isSelected() ? this.datos.tasaFija.get(0) : (this.optInvPromedio.isSelected() ? this.datos.tasaFija.get(2) : this.datos.tasaFija.get(4));
            this.datos.tasaAdiPesosVar = this.optInvOptimistaVar.isSelected() ? this.datos.tasaVar.get(0) : (this.optInvPromedioVar.isSelected() ? this.datos.tasaVar.get(2) : this.datos.tasaVar.get(4));
            this.datos.tasaBasePesos = this.datos.tasaAdiPesosFija;
        } else {
            this.datos.tasaAdiDlsFija = this.optInvOptimista.isSelected() ? this.datos.tasaFija.get(1) : (this.optInvPromedio.isSelected() ? this.datos.tasaFija.get(3) : this.datos.tasaFija.get(5));
            this.datos.tasaAdiDlsVar = this.optInvOptimistaVar.isSelected() ? this.datos.tasaVar.get(1) : (this.optInvPromedioVar.isSelected() ? this.datos.tasaVar.get(3) : this.datos.tasaVar.get(5));
            this.datos.tasaBaseDls = this.datos.tasaAdiDlsFija;
        }
        this.datos.hayRetiros = this.datos.lstAnoMeta.size() > 1 || this.datos.retiroProgramado > 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        this.GuardaExtraprimas();
    }

    public void Cotiza() {
        Boolean continuar = false;
        this.CalculaAportacionesAlAno5();
        this.CalculaRetirosAlAno5();
        if (this.retirosAno5 <= this.aportacionAno5) {
            continuar = true;
        } else {
            this.hayError = true;
            this.accMetaLife.setExpandedPane(this.paneDatosPersonales);
            this.genSubs.MuestraMensaje("Apoortciones insuficientes");
            continuar = false;
        }
        if (continuar.booleanValue()) {
            this.RecuperaDatos();
            Datos datos = this.datos;
            datos.tarMetaLife = datos.tarMetaLife + this.datos.epMillarBAS;
            if (this.modificarTarBAS.booleanValue()) {
                this.datos.tarMetaLife = this.tarBASmodificada;
            }
            if (this.datos.optOpcionCalculo.equals("Suma")) {
                this.datos.sumaInicial = Double.parseDouble(this.genSubs.QuitaComas(this.txtImporteOpcion.getText()));
            } else if (this.datos.optOpcionCalculo.equals("Prima")) {
                if (this.txtImporteOpcion.getText().equals("")) {
                    this.txtImporteOpcion.setText("0");
                }
                String valTemp = this.genSubs.QuitaComas(this.txtImporteOpcion.getText());
                this.datos.primaFPago = Double.parseDouble(valTemp);
            }
            if (this.datos.optOpcionCalculo.equals("Meta")) {
                this.calculos.CalculaPorMeta();
            } else if (this.datos.optOpcionCalculo.equals("Suma")) {
                this.calculos.CalculaPorSuma();
            } else {
                this.calculos.CalculaPorPrima();
            }
            if (!this.datos.calculoCorrecto.booleanValue()) {
                this.hayError = true;
                this.accMetaLife.setExpandedPane(this.paneDatosPersonales);
                this.genSubs.MuestraMensaje("La prima no es suficiente para suma asegurada m\u00ednima: " + this.datos.sumaMinBAS);
            } else {
                if (this.datos.txtPlazoPago.equals("One Shot") && !this.datos.encontr\u00f3Soluci\u00f3n.booleanValue()) {
                    this.genSubs.MuestraMensaje(this.datos.msgCalculos);
                }
                this.MuestraResultados();
            }
        }
    }

    public void RevisaMA() {
        if (this.chkMA.isSelected()) {
            this.chkDI.setSelected(false);
            this.chkTI.setSelected(false);
        }
        this.Cotiza();
    }

    public void RevisaDI() {
        if (this.chkDI.isSelected()) {
            this.chkMA.setSelected(false);
            this.chkTI.setSelected(false);
        }
        this.Cotiza();
    }

    public void RevisaTI() {
        if (this.chkTI.isSelected()) {
            this.chkMA.setSelected(false);
            this.chkDI.setSelected(false);
        }
        this.Cotiza();
    }

    public void RevisaMoneda() {
        this.RevisaPaqueteSeleccionado();
    }

    private void MuestraResultados() {
        String txtFondo = this.genSubs.FormatoNumDouble("##0", this.datos.porFondoFijo * 100.0);
        this.lblFondoFijo.setText(txtFondo);
        txtFondo = this.genSubs.FormatoNumDouble("##0", this.datos.porPPRfijo * 100.0);
        this.lblPPRfijo.setText(txtFondo);
        txtFondo = this.genSubs.FormatoNumDouble("##0", this.datos.porCPEAfijo * 100.0);
        this.lblCPEAfijo.setText(txtFondo);
        txtFondo = this.genSubs.FormatoNumDouble("##0", this.datos.porFondoVar * 100.0);
        this.lblFondoVar.setText(txtFondo);
        txtFondo = this.genSubs.FormatoNumDouble("##0", this.datos.porPPRvar * 100.0);
        this.lblPPRvar.setText(txtFondo);
        txtFondo = this.genSubs.FormatoNumDouble("##0", this.datos.porCPEAvar * 100.0);
        this.lblCPEAvar.setText(txtFondo);
        this.lblPrimaBAS.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datos.primaMetaLife));
        this.lblAportacionAdicionalAnual.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datos.primaAdicional + this.datos.primaAhorro));
        if (this.datos.selEP.booleanValue()) {
            this.lblSumaEP.setVisible(false);
            this.lblPrimaEP.setVisible(true);
            this.lblSumaEP.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.sumaEP));
            this.lblPrimaEP.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datos.primaEP));
        } else {
            this.lblSumaEP.setVisible(false);
            this.lblPrimaEP.setVisible(false);
        }
        if (this.datos.selPASI.booleanValue()) {
            this.lblSumaPASI.setVisible(true);
            this.lblPrimaPASI.setVisible(true);
            this.lblSumaPASI.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.sumaPASI));
            this.lblPrimaPASI.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datos.primaPASI));
        } else {
            this.lblSumaPASI.setVisible(false);
            this.lblPrimaPASI.setVisible(false);
        }
        if (this.datos.selMA.booleanValue()) {
            this.lblSumaMA.setVisible(true);
            this.lblPrimaMA.setVisible(true);
            this.lblSumaMA.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.sumaMA));
            this.lblPrimaMA.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datos.primaMA));
        } else {
            this.lblSumaMA.setVisible(false);
            this.lblPrimaMA.setVisible(false);
        }
        if (this.datos.selDI.booleanValue()) {
            this.lblSumaDI.setVisible(true);
            this.lblPrimaDI.setVisible(true);
            this.lblSumaDI.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.sumaDI));
            this.lblPrimaDI.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datos.primaDI));
        } else {
            this.lblSumaDI.setVisible(false);
            this.lblPrimaDI.setVisible(false);
        }
        if (this.datos.selTI.booleanValue()) {
            this.lblSumaTI.setVisible(true);
            this.lblPrimaTI.setVisible(true);
            this.lblSumaTI.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.sumaTI));
            this.lblPrimaTI.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datos.primaTI));
        } else {
            this.lblSumaTI.setVisible(false);
            this.lblPrimaTI.setVisible(false);
        }
        if (this.datos.selGE.booleanValue()) {
            this.lblSumaGE.setVisible(true);
            this.lblPrimaGE.setVisible(true);
            this.lblSumaGE.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.sumaGE));
            this.lblPrimaGE.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datos.primaGE));
        } else {
            this.lblSumaGE.setVisible(false);
            this.lblPrimaGE.setVisible(false);
        }
        this.datos.primaAnualCoberturas = this.datos.primaMetaLife + this.datos.primaEP + this.datos.primaPASI + this.datos.primaMA + this.datos.primaDI + this.datos.primaTI + this.datos.primaGE;
        this.lblPrimaAnualCoberturas.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datos.primaAnualCoberturas));
        switch (this.datos.formaPago) {
            case "Anual": {
                this.datos.fraccionFPago = 1;
                break;
            }
            case "Semestral": {
                this.datos.fraccionFPago = 2;
                break;
            }
            case "Trimestral": {
                this.datos.fraccionFPago = 4;
                break;
            }
            case "Mensual": {
                this.datos.fraccionFPago = 12;
            }
        }
        if (this.datos.impAptAnual > 0.0) {
            this.titAportacionProgramada.setVisible(true);
            this.lblAportacionProgramada.setVisible(true);
            this.lblAportacionProgramada.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datos.impAptAnual));
        } else {
            this.titAportacionProgramada.setVisible(false);
            this.lblAportacionProgramada.setVisible(false);
            this.lblAportacionProgramada.setText("");
        }
        this.datos.primaFPago = (this.datos.primaAnualCoberturas + this.datos.primaAdicional + this.datos.impAptAnual) / (double)this.datos.fraccionFPago.intValue();
        this.lblAportacionFPago.setVisible(true);
        this.lblAportacionFPago.setText("Aportaci\u00f3n " + this.datos.formaPago + " de:");
        this.lblPrimaFPago.setVisible(true);
        if (this.datos.optOpcionCalculo.equals("Meta")) {
            if (this.datos.txtPlazoPago.equals("One Shot")) {
                this.lblSumaInicial.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.sumaInicial));
                this.valTemp = this.datos.primaUnica - this.datos.primaAnualCoberturas + this.datos.primaAhorro;
                this.lblAportacionAdicionalAnual.setText(this.genSubs.FormatoNumDouble("###,###.00", this.valTemp));
                this.titAportacionAnualTotal.setText("Aportaci\u00f3n \u00fanica total");
                this.lblAportacionAnualTotal.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datos.primaUnica + this.datos.primaAhorro));
                this.lblAportacionFPago.setVisible(false);
                this.lblPrimaFPago.setVisible(false);
            } else {
                this.lblSumaInicial.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.sumaInicial));
                this.lblPrimaFPago.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datos.primaFPago + this.datos.primaAhorro * this.datos.facFPago));
            }
        } else if (this.datos.txtPlazoPago.equals("One Shot")) {
            this.lblSumaInicial.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.sumaInicial));
            this.valTemp = this.datos.primaUnica - this.datos.primaAnualCoberturas + this.datos.primaAhorro;
            this.lblAportacionAdicionalAnual.setText(this.genSubs.FormatoNumDouble("###,###.00", this.valTemp));
            this.titAportacionAnualTotal.setText("Aportaci\u00f3n \u00fanica total");
            this.lblAportacionAnualTotal.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datos.primaUnica + this.datos.primaAhorro));
            this.lblAportacionFPago.setVisible(false);
            this.lblPrimaFPago.setVisible(false);
        } else if (this.datos.optOpcionCalculo.equals("Suma")) {
            this.lblSumaInicial.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.sumaInicial));
            this.lblPrimaFPago.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datos.primaFPago + this.datos.primaAhorro * this.datos.facFPago));
        } else {
            this.lblSumaInicial.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.sumaInicial));
            this.lblPrimaFPago.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datos.primaFPago + this.datos.primaAhorro * this.datos.facFPago));
        }
        if (!this.datos.txtPlazoPago.equals("One Shot")) {
            this.datos.aportacionAnualTotal = this.datos.primaAnualCoberturas + this.datos.impAptAnual + this.datos.primaAdicional + this.datos.primaAhorro;
            this.lblAportacionAnualTotal.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datos.aportacionAnualTotal));
        }
        this.txtSumaInicial.setText(this.lblSumaInicial.getText());
        if (this.datos.optOpcionCalculo.equals("Prima") && this.datos.txtPlazoPago.equals("One Shot")) {
            this.lblSumaInicial.setVisible(false);
            this.txtSumaInicial.setLayoutX(630.0);
            this.txtSumaInicial.setLayoutY(50.0);
            this.txtSumaInicial.setVisible(true);
        } else {
            this.lblSumaInicial.setVisible(true);
            this.txtSumaInicial.setVisible(false);
        }
    }

    private void ValidaNombre() {
        if (this.txtNombre.getText().equals("")) {
            this.txtMensaje = this.txtMensaje + "El nombre no debe estar en blanco\r";
        }
    }

    private void ValidaEdad() {
        this.datos.moneda = this.optPesos.isSelected() ? "P" : "D";
        Integer edadMin = this.datos.lstEdadMinCob.get(this.genSubs.IndiceCob("BAS", this.datos.moneda));
        Integer edadMax = this.datos.lstEdadMaxCob.get(this.genSubs.IndiceCob("BAS", this.datos.moneda));
        if (this.txtEdad.getText().equals("")) {
            this.datos.edad = 0;
            this.txtMensaje = this.txtMensaje + "La edad no debe estar en blanco\r";
        } else {
            this.datos.edad = Integer.parseInt(this.txtEdad.getText().toString());
            if (this.datos.edad < edadMin || this.datos.edad > edadMax) {
                this.txtMensaje = this.txtMensaje + "Edad fuera de rango\r";
            }
        }
    }

    private void ValidaDistribucionFondos() {
        if (this.txtPorFondoFijo.getText().equals("")) {
            this.txtPorFondoFijo.setText("0");
        }
        if (this.txtPorPPRfijo.getText().equals("")) {
            this.txtPorPPRfijo.setText("0");
        }
        if (this.txtPorCPEAfijo.getText().equals("")) {
            this.txtPorCPEAfijo.setText("0");
        }
        if (this.txtPorFondoVariable.getText().equals("")) {
            this.txtPorFondoVariable.setText("0");
        }
        if (this.txtPorPPRvariable.getText().equals("")) {
            this.txtPorPPRvariable.setText("0");
        }
        if (this.txtPorCPEAvariable.getText().equals("")) {
            this.txtPorCPEAvariable.setText("0");
        }
        this.datos.porFondoFijo = Double.parseDouble(this.txtPorFondoFijo.getText());
        this.datos.porPPRfijo = Double.parseDouble(this.txtPorPPRfijo.getText());
        this.datos.porCPEAfijo = Double.parseDouble(this.txtPorCPEAfijo.getText());
        this.datos.porFondoVar = Double.parseDouble(this.txtPorFondoVariable.getText());
        this.datos.porPPRvar = Double.parseDouble(this.txtPorPPRvariable.getText());
        this.datos.porCPEAvar = Double.parseDouble(this.txtPorCPEAvariable.getText());
        if (this.datos.porFondoFijo + this.datos.porPPRfijo + this.datos.porCPEAfijo + this.datos.porFondoVar + this.datos.porPPRvar + this.datos.porCPEAvar != 100.0) {
            this.txtMensaje = this.txtMensaje + "La distribuci\u00f3n de fondos debe sumar 100%\r";
        } else {
            this.datos.porFondoFijo = this.datos.porFondoFijo / 100.0;
            this.datos.porPPRfijo = this.datos.porPPRfijo / 100.0;
            this.datos.porCPEAfijo = this.datos.porCPEAfijo / 100.0;
            this.datos.porFondoFijoTot = this.datos.porFondoFijo + this.datos.porPPRfijo + this.datos.porCPEAfijo;
            this.datos.porFondoVar = this.datos.porFondoVar / 100.0;
            this.datos.porPPRvar = this.datos.porPPRvar / 100.0;
            this.datos.porCPEAvar = this.datos.porCPEAvar / 100.0;
            this.datos.porFondoVarTot = this.datos.porFondoVar + this.datos.porPPRvar + this.datos.porCPEAvar;
        }
    }

    private void RevisaPlazoMetas() {
        Integer plazoMayor = 0;
        if (this.listaMetas.size() > 0) {
            for (int i = 0; i < this.listaMetas.size(); ++i) {
                if (Integer.parseInt(((Meta)this.listaMetas.get(i)).getAnoMeta().toString()) <= plazoMayor) continue;
                plazoMayor = Integer.parseInt(((Meta)this.listaMetas.get(i)).getAnoMeta().toString());
            }
            Integer edadTemp = this.txtEdad.getText().toString().equals("") ? Integer.valueOf(0) : Integer.valueOf(Integer.parseInt(this.txtEdad.getText().toString()));
            this.ValidaPlazoMaximo(edadTemp, plazoMayor);
        } else if (this.datos.optOpcionCalculo.equals("Meta")) {
            this.txtMensaje = this.txtMensaje + "Debe existir al menos una meta con plazo mayor o igual a 10 a\u00f1os";
        }
    }

    private void ValidaPlazoMaximo(Integer edadTmp, Integer plazoTmp) {
        if (plazoTmp < 10) {
            this.txtMensaje = this.txtMensaje + "El plazo debe ser mayor o igual a 10 a\u00f1os\r";
        } else if (plazoTmp > 20) {
            if (edadTmp > 45) {
                this.txtMensaje = this.txtMensaje + "El plazo debe estar entre 10 y 20\r";
            } else if (edadTmp + plazoTmp > 65) {
                this.txtMensaje = this.txtMensaje + "La edad mas el plazo mayor debe ser menor o igual a 65\r";
            }
        }
    }

    private void ValidaRetiroProgramado() {
        if (!this.txtRetiroProgramado.getText().equals("")) {
            if (this.txtIniRetiroProgramado.getText().equals("") || this.txtFinRetiroProgramado.getText().equals("")) {
                this.txtMensaje = this.txtMensaje + "Capturar inicio y fin de retiro programado\r";
            }
        } else if (!this.txtIniRetiroProgramado.getText().equals("") || !this.txtFinRetiroProgramado.getText().equals("")) {
            this.txtMensaje = this.txtMensaje + "Capturar retiro programado\r";
        }
        if (this.txtIniRetiroProgramado.getText().equals("")) {
            this.datos.iniRetiroProgramado = 0;
        } else {
            this.datos.iniRetiroProgramado = Integer.parseInt(this.txtIniRetiroProgramado.getText());
            if (this.datos.iniRetiroProgramado < 6) {
                this.txtMensaje = this.txtMensaje + "El a\u00f1o de inicio del retiro programado debe ser al menos 6";
            }
        }
        this.datos.finRetiroProgramado = this.txtFinRetiroProgramado.getText().equals("") ? Integer.valueOf(0) : Integer.valueOf(Integer.parseInt(this.txtFinRetiroProgramado.getText()));
        if (this.datos.finRetiroProgramado < this.datos.iniRetiroProgramado) {
            this.txtMensaje = this.txtMensaje + "El a\u00f1o final de retiro programado debe ser mayor al inicial\r";
        }
    }

    private void RecuperaDatos() {
        this.DeterminaMetaSuperior();
        this.DeterminaBanda();
        this.tablas.CargaTarifasMetaLife();
        if (this.datos.edad < 66) {
            this.tablas.CargaRecargoBeneficios();
        } else {
            this.datos.recargoPrimaEPms = 0.0;
            this.datos.recargoPrimaEPmn = 0.0;
            this.datos.recargoPrimaEPfs = 0.0;
            this.datos.recargoPrimaEPfn = 0.0;
            this.datos.recargoPrimaPASIms = 0.0;
            this.datos.recargoPrimaPASImn = 0.0;
            this.datos.recargoPrimaPASIfs = 0.0;
            this.datos.recargoPrimaPASIfn = 0.0;
            this.datos.recargoPrimaMA = 0.0;
            this.datos.recargoPrimaDI = 0.0;
            this.datos.recargoPrimaTI = 0.0;
        }
        this.tablas.CargaRecargoGE();
        this.datos.recargoPrimaGE = this.datos.edad < 66 ? (this.datos.sexo.equals("M") ? (this.datos.fuma.equals("S") ? this.datos.recargoPrimaGEms.get(this.datos.edad) : this.datos.recargoPrimaGEmn.get(this.datos.edad)) : (this.datos.fuma.equals("S") ? this.datos.recargoPrimaGEfs.get(this.datos.edad) : this.datos.recargoPrimaGEfn.get(this.datos.edad))) : Double.valueOf(0.0);
        if (this.optCoberturaB.isSelected()) {
            this.datos.tarMetaLife = this.genSubs.Redondea(this.datos.tarMetaLife * 1.1, 2);
        }
        this.tablas.CargaTarifasPerfect();
        this.tablas.CargaTarifasBeneficios();
        this.tablas.CargaComisiones();
        this.tablas.CargaISR();
        if (this.datos.formaPago.equals("Anual") || this.datos.txtPlazoPago.equals("One Shot")) {
            this.datos.facFPago = 1.0;
        }
        if (this.datos.formaPago.equals("Semestral")) {
            this.datos.facFPago = 0.5;
        }
        if (this.datos.formaPago.equals("Trimestral")) {
            this.datos.facFPago = 0.25;
        }
        if (this.datos.formaPago.equals("Mensual")) {
            this.datos.facFPago = 0.0833333333333333;
        }
        this.datos.facSinRecFP = this.datos.facFPago;
        if (this.datos.moneda.equals("P")) {
            this.datos.recFijoMetaLife = 1000.0;
        }
        if (this.datos.moneda.equals("D")) {
            this.datos.recFijoMetaLife = 100.0;
        }
        this.datos.edadMinBAS = this.datos.lstEdadMinCob.get(this.genSubs.IndiceCob("BAS", "P"));
        this.datos.edadMinEP = this.datos.lstEdadMinCob.get(this.genSubs.IndiceCob("EP", "P"));
        this.datos.edadMinPASI = this.datos.lstEdadMinCob.get(this.genSubs.IndiceCob("PASI", "P"));
        this.datos.edadMinMA = this.datos.lstEdadMinCob.get(this.genSubs.IndiceCob("MA", "P"));
        this.datos.edadMinDI = this.datos.lstEdadMinCob.get(this.genSubs.IndiceCob("DI", "P"));
        this.datos.edadMinTI = this.datos.lstEdadMinCob.get(this.genSubs.IndiceCob("TI", "P"));
        this.datos.edadMinGE = this.datos.lstEdadMinCob.get(this.genSubs.IndiceCob("GE", "P"));
        this.datos.edadMaxBAS = this.datos.lstEdadMaxCob.get(this.genSubs.IndiceCob("BAS", "P"));
        this.datos.edadMaxEP = this.datos.lstEdadMaxCob.get(this.genSubs.IndiceCob("EP", "P"));
        this.datos.edadMaxPASI = this.datos.lstEdadMaxCob.get(this.genSubs.IndiceCob("PASI", "P"));
        this.datos.edadMaxMA = this.datos.lstEdadMaxCob.get(this.genSubs.IndiceCob("MA", "P"));
        this.datos.edadMaxDI = this.datos.lstEdadMaxCob.get(this.genSubs.IndiceCob("DI", "P"));
        this.datos.edadMaxTI = this.datos.lstEdadMaxCob.get(this.genSubs.IndiceCob("TI", "P"));
        this.datos.edadMaxGE = this.datos.lstEdadMaxCob.get(this.genSubs.IndiceCob("GE", "P"));
        this.datos.edadCanBAS = this.datos.lstEdadCanCob.get(this.genSubs.IndiceCob("BAS", "P"));
        this.datos.edadCanEP = this.datos.lstEdadCanCob.get(this.genSubs.IndiceCob("EP", "P"));
        this.datos.edadCanPASI = this.datos.lstEdadCanCob.get(this.genSubs.IndiceCob("PASI", "P"));
        this.datos.edadCanMA = this.datos.lstEdadCanCob.get(this.genSubs.IndiceCob("MA", "P"));
        this.datos.edadCanDI = this.datos.lstEdadCanCob.get(this.genSubs.IndiceCob("DI", "P"));
        this.datos.edadCanTI = this.datos.lstEdadCanCob.get(this.genSubs.IndiceCob("TI", "P"));
        this.datos.edadCanGE = this.datos.lstEdadCanCob.get(this.genSubs.IndiceCob("GE", "P"));
        if (this.datos.moneda.equals("P")) {
            this.datos.sumaMinBAS = this.datos.lstSumaMinCob.get(this.genSubs.IndiceCob("BAS", "P"));
            this.datos.sumaMinEP = this.datos.lstSumaMinCob.get(this.genSubs.IndiceCob("EP", "P"));
            this.datos.sumaMinPASI = this.datos.lstSumaMinCob.get(this.genSubs.IndiceCob("PASI", "P"));
            this.datos.sumaMinMA = this.datos.lstSumaMinCob.get(this.genSubs.IndiceCob("MA", "P"));
            this.datos.sumaMinDI = this.datos.lstSumaMinCob.get(this.genSubs.IndiceCob("DI", "P"));
            this.datos.sumaMinTI = this.datos.lstSumaMinCob.get(this.genSubs.IndiceCob("TI", "P"));
            this.datos.sumaMinGE = this.datos.lstSumaMinCob.get(this.genSubs.IndiceCob("GE", "P"));
        } else {
            this.datos.sumaMinBAS = this.datos.lstSumaMinCob.get(this.genSubs.IndiceCob("BAS", "D"));
            this.datos.sumaMinEP = this.datos.lstSumaMinCob.get(this.genSubs.IndiceCob("EP", "D"));
            this.datos.sumaMinPASI = this.datos.lstSumaMinCob.get(this.genSubs.IndiceCob("PASI", "D"));
            this.datos.sumaMinMA = this.datos.lstSumaMinCob.get(this.genSubs.IndiceCob("MA", "D"));
            this.datos.sumaMinDI = this.datos.lstSumaMinCob.get(this.genSubs.IndiceCob("DI", "D"));
            this.datos.sumaMinTI = this.datos.lstSumaMinCob.get(this.genSubs.IndiceCob("TI", "D"));
            this.datos.sumaMinGE = this.datos.lstSumaMinCob.get(this.genSubs.IndiceCob("GE", "D"));
        }
        this.datos.selEP = this.chkEP.isSelected();
        this.datos.selPASI = this.chkPASI.isSelected();
        this.datos.selMA = this.chkMA.isSelected();
        this.datos.selDI = this.chkDI.isSelected();
        this.datos.selTI = this.chkTI.isSelected();
        this.datos.selGE = this.chkGE.isSelected();
        this.AsignaValoresCoi();
        if (this.datos.optOpcionCalculo.equals("Suma")) {
            this.datos.primaAdicional = 0.0;
        }
        if (this.datos.optOpcionCalculo.equals("Prima")) {
            this.datos.primaAdicional = 0.0;
        }
    }

    private void AsignaValoresCoi() {
        this.datos.lstCoiBAS.clear();
        this.datos.lstCoiEP.clear();
        this.datos.lstCoiPASI.clear();
        this.datos.lstCoiMA.clear();
        this.datos.lstCoiDI.clear();
        this.datos.lstCoiTI.clear();
        this.datos.lstCoiGE.clear();
        if (this.datos.sexo.equals("M")) {
            if (this.datos.fuma.equals("S")) {
                this.datos.lstCoiBAS = this.AsignaCoi(this.datos.coiBASms);
                if (this.datos.moneda.equals("P")) {
                    this.datos.lstCoiEP = this.AsignaCoi(this.datos.coiEPpms);
                    this.datos.lstCoiPASI = this.AsignaCoi(this.datos.coiPASIpms);
                    this.datos.lstCoiGE = this.AsignaCoi(this.datos.coiGEpms);
                } else {
                    this.datos.lstCoiEP = this.AsignaCoi(this.datos.coiEPdms);
                    this.datos.lstCoiPASI = this.AsignaCoi(this.datos.coiPASIdms);
                    this.datos.lstCoiGE = this.AsignaCoi(this.datos.coiGEdms);
                }
            } else {
                this.datos.lstCoiBAS = this.AsignaCoi(this.datos.coiBASmn);
                if (this.datos.moneda.equals("P")) {
                    this.datos.lstCoiEP = this.AsignaCoi(this.datos.coiEPpmn);
                    this.datos.lstCoiPASI = this.AsignaCoi(this.datos.coiPASIpmn);
                    this.datos.lstCoiGE = this.AsignaCoi(this.datos.coiGEpmn);
                } else {
                    this.datos.lstCoiEP = this.AsignaCoi(this.datos.coiEPdmn);
                    this.datos.lstCoiPASI = this.AsignaCoi(this.datos.coiPASIdmn);
                    this.datos.lstCoiGE = this.AsignaCoi(this.datos.coiGEdmn);
                }
            }
        } else if (this.datos.fuma.equals("S")) {
            this.datos.lstCoiBAS = this.AsignaCoi(this.datos.coiBASfs);
            if (this.datos.moneda.equals("P")) {
                this.datos.lstCoiEP = this.AsignaCoi(this.datos.coiEPpfs);
                this.datos.lstCoiPASI = this.AsignaCoi(this.datos.coiPASIpfs);
                this.datos.lstCoiGE = this.AsignaCoi(this.datos.coiGEpfs);
            } else {
                this.datos.lstCoiEP = this.AsignaCoi(this.datos.coiEPdfs);
                this.datos.lstCoiPASI = this.AsignaCoi(this.datos.coiPASIdfs);
                this.datos.lstCoiGE = this.AsignaCoi(this.datos.coiGEdfs);
            }
        } else {
            this.datos.lstCoiBAS = this.AsignaCoi(this.datos.coiBASfn);
            if (this.datos.moneda.equals("P")) {
                this.datos.lstCoiEP = this.AsignaCoi(this.datos.coiEPpfn);
                this.datos.lstCoiPASI = this.AsignaCoi(this.datos.coiPASIpfn);
                this.datos.lstCoiGE = this.AsignaCoi(this.datos.coiGEpfn);
            } else {
                this.datos.lstCoiEP = this.AsignaCoi(this.datos.coiEPdfn);
                this.datos.lstCoiPASI = this.AsignaCoi(this.datos.coiPASIdfn);
                this.datos.lstCoiGE = this.AsignaCoi(this.datos.coiGEdfn);
            }
        }
        for (int i = 0; i < 71; ++i) {
            this.datos.lstCoiMA.add(0.0);
            this.datos.lstCoiDI.add(0.0);
            this.datos.lstCoiTI.add(0.0);
        }
    }

    private List AsignaCoi(List<Double> lstCoi) {
        int i;
        ArrayList<Double> vecCoi = new ArrayList<Double>();
        vecCoi.clear();
        for (i = 0; i < 18; ++i) {
            vecCoi.add(0.0);
        }
        for (i = 18; i < lstCoi.size(); ++i) {
            vecCoi.add(lstCoi.get(i));
        }
        return vecCoi;
    }

    private void DeterminaMetaSuperior() {
        this.datos.anoMaxMeta = 0;
        this.datos.indiceAnoMax = 0;
        if (this.listaMetas.size() > 0) {
            for (int i = 0; i < this.datos.lstAnoMeta.size(); ++i) {
                if (this.datos.lstAnoMeta.get(i) <= this.datos.anoMaxMeta) continue;
                this.datos.indiceAnoMax = i;
                this.datos.anoMaxMeta = this.datos.lstAnoMeta.get(i);
            }
            this.datos.anoMaxMeta = this.datos.lstAnoMeta.get(this.datos.indiceAnoMax);
            this.datos.metaMaxima = this.datos.lstImporteMeta.get(this.datos.indiceAnoMax);
            this.datos.plazoPefect = this.datos.anoMaxMeta;
        } else {
            this.datos.indiceAnoMax = -1;
            this.datos.metaMaxima = 0;
            this.datos.anoMaxMeta = 0;
        }
    }

    private void DeterminaBanda() {
        this.datos.banda = this.optPesos.isSelected() ? (this.datos.metaMaxima < 499999 ? Integer.valueOf(0) : (this.datos.metaMaxima < 999999 ? Integer.valueOf(1) : (this.datos.metaMaxima < 1499999 ? Integer.valueOf(2) : Integer.valueOf(3)))) : (this.datos.metaMaxima < 49999 ? Integer.valueOf(0) : (this.datos.metaMaxima < 99999 ? Integer.valueOf(1) : (this.datos.metaMaxima < 149999 ? Integer.valueOf(2) : Integer.valueOf(3))));
    }

    public void ClicTipoCobertura() {
        this.datos.coberturaA = this.optCoberturaA.isSelected();
    }

    public void GeneraReporte() {
        this.datos.conReporteEspecial = this.chkReporteEspecial.isSelected();
        this.datos.conRendimientos = this.chkRendimientos.isSelected();
        this.datos.conCostoSeguro = this.conCostoSeguro.isSelected();
        this.cotiz.ImprimeCotizacion();
        if (this.datos.conMemoriaCalculo.booleanValue()) {
            this.memoriaCalculo.GeneraMemoria();
        }
    }

    public void GeneraPresentacion() {
        this.presentacion.ImprimePresentacion();
    }

    private void FormatoTituloNombre() {
        String[] arr = this.txtNombre.getText().split(" ");
        StringBuffer sb = new StringBuffer();
        if (!this.txtNombre.getText().equals("")) {
            for (int i = 0; i < arr.length; ++i) {
                sb.append(Character.toUpperCase(arr[i].charAt(0))).append(arr[i].substring(1)).append(" ");
                this.txtNombre.setText(sb.toString().trim());
            }
        }
    }

    private void ArmaCmbPlazoPago() {
        Integer tmpEdad = this.txtEdad.getText().equals("") ? Integer.valueOf(0) : Integer.valueOf(Integer.parseInt(this.txtEdad.getText().toString()));
        this.datos.edad = tmpEdad;
        this.cmbPlazoPago.getItems().clear();
        this.datos.lstPlazoPago.clear();
        if (this.datos.optOpcionCalculo.equals("Meta")) {
            this.datos.lstPlazoPago.clear();
            this.datos.lstPlazoPago.add("vitalicio");
            this.cmbPlazoPago.getItems().addAll(this.datos.lstPlazoPago);
            this.cmbPlazoPago.setValue((Object)"vitalicio");
            this.datos.txtPlazoPago = "vitalicio";
            this.datos.plazoPago = 99;
        } else if (tmpEdad <= 55) {
            this.datos.lstPlazoPago.add("5 a\u00f1os");
            this.datos.lstPlazoPago.add("10 a\u00f1os");
            this.datos.lstPlazoPago.add("15 a\u00f1os");
            this.datos.lstPlazoPago.add("20 a\u00f1os");
            this.datos.lstPlazoPago.add("edad 60");
            this.datos.lstPlazoPago.add("edad 65");
            this.datos.lstPlazoPago.add("vitalicio");
            if (this.datos.optOpcionCalculo.equals("Prima")) {
                this.datos.lstPlazoPago.add("One Shot");
            }
        } else if (tmpEdad <= 60) {
            this.datos.lstPlazoPago.add("5 a\u00f1os");
            this.datos.lstPlazoPago.add("10 a\u00f1os");
            this.datos.lstPlazoPago.add("15 a\u00f1os");
            this.datos.lstPlazoPago.add("20 a\u00f1os");
            this.datos.lstPlazoPago.add("edad 65");
            this.datos.lstPlazoPago.add("vitalicio");
            if (this.datos.optOpcionCalculo.equals("Prima")) {
                this.datos.lstPlazoPago.add("One Shot");
            }
        } else {
            this.datos.lstPlazoPago.add("5 a\u00f1os");
            this.datos.lstPlazoPago.add("10 a\u00f1os");
            this.datos.lstPlazoPago.add("15 a\u00f1os");
            this.datos.lstPlazoPago.add("20 a\u00f1os");
            this.datos.lstPlazoPago.add("vitalicio");
            if (this.datos.optOpcionCalculo.equals("Prima")) {
                this.datos.lstPlazoPago.add("One Shot");
            }
        }
        this.cmbPlazoPago.getItems().addAll(this.datos.lstPlazoPago);
        this.cmbPlazoPago.setValue((Object)"vitalicio");
        this.datos.plazoPago = 99;
    }

    private void FormatoImporte(String txtImporte) {
        switch (txtImporte) {
            case "txtImporteMeta": {
                this.txtImporteMeta.setText(this.FormatoNum(this.txtImporteMeta));
                break;
            }
            case "txtImporteOpcion": {
                this.txtImporteOpcion.setText(this.FormatoNum(this.txtImporteOpcion));
                break;
            }
            case "txtAportacion": {
                this.txtImporteAportacion.setText(this.FormatoNum(this.txtImporteAportacion));
                break;
            }
            case "txtRetiroProgramado": {
                this.txtRetiroProgramado.setText(this.FormatoNum(this.txtRetiroProgramado));
                break;
            }
            case "txtAptAnual": {
                this.txtAptAnual.setText(this.FormatoNum(this.txtAptAnual));
                if (this.txtAptAnual.getText().equals("")) {
                    this.datos.impAptAnual = 0.0;
                    break;
                }
                this.datos.impAptAnual = Double.parseDouble(this.genSubs.QuitaComas(this.txtAptAnual.getText()));
                break;
            }
            case "ingresoAnual": {
                this.ingresoAnual.setText(this.FormatoNum(this.ingresoAnual));
                break;
            }
            case "txtSumaInicial": {
                this.txtSumaInicial.setText(this.FormatoNum(this.txtSumaInicial));
                this.ProcesaCambioDeSuma();
            }
            case "txtAhorro": {
                this.txtAhorro.setText(this.FormatoNum(this.txtAhorro));
            }
        }
    }

    private String FormatoNum(TextField txtField) {
        String txtConFormato = "";
        if (!txtField.getText().toString().equals("")) {
            Integer intVal = Integer.parseInt(this.genSubs.QuitaComas(txtField.getText()));
            txtConFormato = this.genSubs.FormatoNumInteger("###,###", intVal);
        }
        return txtConFormato;
    }

    private void CargaDatosPrevios() {
        int i;
        this.txtNombre.setText(this.datos.nombre);
        if (this.datos.edad == 0) {
            this.txtEdad.setText("");
        } else {
            this.txtEdad.setText(this.datos.edad.toString());
        }
        if (this.datos.fuma.equals("S")) {
            this.optFuma.setSelected(true);
            this.optNoFuma.setSelected(false);
        } else {
            this.optNoFuma.setSelected(true);
            this.optFuma.setSelected(false);
        }
        if (this.datos.sexo.equals("M")) {
            this.optMasculino.setSelected(true);
            this.optFemenino.setSelected(false);
        } else {
            this.optFemenino.setSelected(true);
            this.optMasculino.setSelected(false);
        }
        if (this.datos.moneda.equals("P")) {
            this.optPesos.setSelected(true);
            this.optDolares.setSelected(false);
        } else {
            this.optDolares.setSelected(true);
            this.optPesos.setSelected(false);
        }
        if (this.datos.cobertura.equals("A")) {
            this.optCoberturaA.setSelected(true);
            this.optCoberturaB.setSelected(false);
        } else {
            this.optCoberturaB.setSelected(true);
            this.optCoberturaA.setSelected(false);
        }
        if (this.datos.escenario.equals("O")) {
            this.optInvOptimista.setSelected(true);
        } else if (this.datos.escenario.equals("P")) {
            this.optInvPromedio.setSelected(true);
        } else {
            this.optInvConservador.setSelected(true);
        }
        this.listaMetas.clear();
        if (this.datos.lstAnoMeta.size() > 0) {
            for (i = 0; i < this.datos.lstAnoMeta.size(); ++i) {
                this.anoCapturado = this.datos.lstAnoMeta.get(i).toString();
                this.metaCapturada = this.datos.lstNombreMeta.get(i);
                this.importeMetaCapturado = this.datos.lstImporteMeta.get(i).toString();
                this.listaMetas.add((Object)new Meta(this.anoCapturado, this.metaCapturada, this.importeMetaCapturado));
            }
        }
        if (this.datos.optOpcionCalculo.equals("Meta")) {
            if (this.datos.lstImporteMeta.size() > 0) {
                this.txtImporteOpcion.setText(this.genSubs.FormatoNumInteger("###,###", this.datos.lstImporteMeta.get(this.datos.indiceAnoMax)));
                this.txtPlazoMeta.setText(this.datos.lstAnoMeta.get(this.datos.indiceAnoMax).toString());
            } else {
                this.txtImporteOpcion.setText("");
                this.txtPlazoMeta.setText("");
            }
        } else if (this.datos.optOpcionCalculo.equals("Suma")) {
            this.txtImporteOpcion.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.sumaInicial));
        } else {
            this.txtImporteOpcion.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.primaMetaLife));
        }
        this.listaAportaciones.clear();
        if (this.datos.lstAnoAportacion.size() > 0) {
            for (i = 0; i < this.datos.lstAnoAportacion.size(); ++i) {
                this.anoAportacionCapturado = this.datos.lstAnoAportacion.get(i).toString();
                this.importeAportacionCapturado = this.datos.lstImporteAportacion.get(i).toString();
                this.listaAportaciones.add((Object)new Aportacion(this.anoAportacionCapturado, this.importeAportacionCapturado));
            }
        }
        if (this.datos.retiroProgramado > 0) {
            this.txtRetiroProgramado.setText(this.genSubs.FormatoNumInteger("###,###", this.datos.retiroProgramado));
            this.txtIniRetiroProgramado.setText(this.datos.iniRetiroProgramado.toString());
            this.txtFinRetiroProgramado.setText(this.datos.finRetiroProgramado.toString());
        } else {
            this.txtRetiroProgramado.setText("");
            this.txtIniRetiroProgramado.setText("");
            this.txtFinRetiroProgramado.setText("");
        }
        if (this.datos.impAptAnual > 0.0) {
            this.lblAportacionProgramada.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datos.impAptAnual));
        } else {
            this.lblAportacionProgramada.setText("");
        }
        if (this.datos.impAptAnual > 0.0) {
            this.txtAptAnual.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.impAptAnual));
        } else {
            this.txtAptAnual.setText("");
        }
        if (this.datos.primaAhorro > 0.0) {
            this.txtAhorro.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.primaAhorro));
        } else {
            this.txtAhorro.setText("");
        }
        this.txtImporteMeta.setText("");
        this.txtImporteAportacion.setText("");
        this.ingresoAnual.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.ingresoAnual));
        this.nombreMenor.setText(this.datos.nombreMenor);
        this.edadMenor.setText(this.genSubs.FormatoNumInteger("##", this.datos.edadMenor));
        this.chkEP.setSelected(this.datos.selEP.booleanValue());
        this.chkPASI.setSelected(this.datos.selPASI.booleanValue());
        this.chkMA.setSelected(this.datos.selMA.booleanValue());
        this.chkDI.setSelected(this.datos.selDI.booleanValue());
        this.chkTI.setSelected(this.datos.selTI.booleanValue());
        this.chkGE.setSelected(this.datos.selGE.booleanValue());
        if (this.datos.optInvFondo.equals("invFondoFijo")) {
            this.optFondoFijo.setSelected(true);
        } else {
            this.optFondoVariable.setSelected(true);
        }
        Double valTemp = this.datos.porFondoFijo * 100.0;
        this.txtPorFondoFijo.setText(valTemp.toString());
        valTemp = this.datos.porPPRfijo * 100.0;
        this.txtPorPPRfijo.setText(valTemp.toString());
        valTemp = this.datos.porCPEAfijo * 100.0;
        this.txtPorCPEAfijo.setText(valTemp.toString());
        valTemp = this.datos.porPPRfijo * 100.0;
        this.txtPorPPRfijo.setText(valTemp.toString());
        valTemp = this.datos.porCPEAfijo * 100.0;
        this.txtPorCPEAfijo.setText(valTemp.toString());
        valTemp = this.datos.porFondoVar * 100.0;
        this.txtPorFondoVariable.setText(valTemp.toString());
        valTemp = this.datos.porPPRvar * 100.0;
        this.txtPorPPRvariable.setText(valTemp.toString());
        valTemp = this.datos.porCPEAvar * 100.0;
        this.txtPorCPEAvariable.setText(valTemp.toString());
        this.lblVersion.setText(this.datosvi.idVersion + this.datosvi.textoLegal);
        this.cmbMetas.getItems().clear();
        this.cmbMetas.getItems().addAll(this.datos.lstMetas);
        this.cmbMetas.setValue((Object)"Hogar");
        this.txtOtraMeta.setVisible(false);
        this.cmbFormaPago.getItems().clear();
        this.cmbFormaPago.getItems().addAll(this.datos.lstFormaPago);
        this.cmbFormaPago.setValue((Object)this.datos.formaPago);
        this.optFondoFijo.setVisible(false);
        this.optFondoVariable.setVisible(false);
        this.lblPrimaEP.setVisible(this.datos.selEP.booleanValue());
        this.lblPrimaPASI.setVisible(this.datos.selPASI.booleanValue());
        this.lblPrimaMA.setVisible(this.datos.selMA.booleanValue());
        this.lblPrimaDI.setVisible(this.datos.selDI.booleanValue());
        this.lblPrimaTI.setVisible(this.datos.selTI.booleanValue());
        this.lblPrimaGE.setVisible(this.datos.selGE.booleanValue());
        this.lblSumaEP.setVisible(this.datos.selEP.booleanValue());
        this.lblSumaPASI.setVisible(this.datos.selPASI.booleanValue());
        this.lblSumaMA.setVisible(this.datos.selMA.booleanValue());
        this.lblSumaDI.setVisible(this.datos.selDI.booleanValue());
        this.lblSumaTI.setVisible(this.datos.selTI.booleanValue());
        this.lblSumaGE.setVisible(this.datos.selGE.booleanValue());
        this.cmbFormaPago.getItems().clear();
        this.datos.lstFormaPago.clear();
        this.datos.lstFormaPago.add("Anual");
        this.datos.lstFormaPago.add("Semestral");
        this.datos.lstFormaPago.add("Trimestral");
        this.datos.lstFormaPago.add("Mensual");
        this.cmbFormaPago.getItems().addAll(this.datos.lstFormaPago);
        if (this.datos.versionBase.booleanValue()) {
            this.cmbFormaPago.setValue((Object)"Anual");
            this.datos.formaPago = "Anual";
            this.cmbFormaPago.setDisable(false);
        } else if (this.datos.optOpcionCalculo.equals("Prima")) {
            this.cmbPlazoPago.setValue((Object)"One Shot");
            this.datos.txtPlazoPago = "One Shot";
            this.cmbFormaPago.setDisable(true);
            this.cmbPlazoPago.setDisable(true);
        } else {
            this.cmbFormaPago.setValue((Object)"Anual");
            this.datos.formaPago = "Anual";
            this.cmbFormaPago.setDisable(false);
        }
        this.cmbPlazoPago.getItems().clear();
        this.datos.lstPlazoPago.clear();
        if (this.datos.optOpcionCalculo.equals("Meta")) {
            this.datos.lstPlazoPago.clear();
            this.datos.lstPlazoPago.add("vitalicio");
            this.cmbPlazoPago.getItems().addAll(this.datos.lstPlazoPago);
            this.cmbPlazoPago.setValue((Object)"vitalicio");
            this.datos.txtPlazoPago = "vitalicio";
            this.datos.plazoPago = 99;
        } else {
            this.datos.lstPlazoPago.add("5 a\u00f1os");
            this.datos.lstPlazoPago.add("10 a\u00f1os");
            this.datos.lstPlazoPago.add("15 a\u00f1os");
            this.datos.lstPlazoPago.add("20 a\u00f1os");
            this.datos.lstPlazoPago.add("edad 60");
            this.datos.lstPlazoPago.add("edad 65");
            this.datos.lstPlazoPago.add("vitalicio");
            if (this.datos.optOpcionCalculo.equals("Prima")) {
                this.datos.lstPlazoPago.add("One Shot");
            }
            this.cmbPlazoPago.getItems().addAll(this.datos.lstPlazoPago);
            this.cmbPlazoPago.setValue((Object)"vitalicio");
            this.datos.txtPlazoPago = "vitalicio";
            this.datos.plazoPago = 99;
        }
        this.cmbPaquete.getItems().clear();
        this.datos.lstPaquete.clear();
        this.datos.lstPaquete.add("Retiro");
        this.datos.lstPaquete.add("Tu futuro");
        this.datos.lstPaquete.add("Mujer");
        this.datos.lstPaquete.add("Educaci\u00f3n");
        this.cmbPaquete.getItems().addAll(this.datos.lstPaquete);
        this.cmbPaquete.setValue((Object)"Retiro");
        this.datos.paqueteSeleccionado = "Retiro";
        this.nombreMenor.setVisible(false);
        this.edadMenor.setVisible(false);
        this.ingresoAnual.setVisible(true);
        if (this.datos.ingresoAnual == 0.0) {
            this.ingresoAnual.setText("");
        } else {
            this.ingresoAnual.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.ingresoAnual));
        }
        this.epMillarBAS.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datos.epMillarBAS));
        if (this.datos.epPorBAS > 0.0) {
            this.epPorBAS.setText(this.genSubs.FormatoNumDouble("###,###", (this.datos.epPorBAS + 1.0) * 100.0));
        } else {
            this.epPorBAS.setText("");
        }
        this.epPorACC.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.epPorACC));
        this.epPorINV.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.epPorINV));
        this.epEquivBAS.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.epEquivBAS));
        if (this.datos.epMillarBAS + this.datos.epPorBAS + this.datos.epPorACC + this.datos.epPorINV > 0.0) {
            this.btnCalcularEP.setVisible(true);
        } else {
            this.btnCalcularEP.setVisible(false);
        }
        this.lblAyuda.setVisible(false);
        this.PosicionOpcionesCalculo();
    }

    private void ProcesaCambioDeSuma() {
        Double sumaInicialNueva = Double.parseDouble(this.genSubs.QuitaComas(this.txtSumaInicial.getText()));
        if (sumaInicialNueva > this.datos.sumaInicial) {
            this.genSubs.MuestraMensaje("La suma asegurada nueva debe ser menor");
            this.txtSumaInicial.setText(this.lblSumaInicial.getText());
        } else if (sumaInicialNueva < (double)this.datos.sumaMinBAS.intValue()) {
            this.genSubs.MuestraMensaje("La suma asegurada nueva debe ser mayor a " + this.datos.sumaMinBAS);
            this.txtSumaInicial.setText(this.lblSumaInicial.getText());
        } else {
            this.datos.sumaInicial = sumaInicialNueva;
            this.calculos.CalculaPrimasIniciales();
            this.calculos.ProyectaFondo();
            this.MuestraResultados();
        }
    }

    private void RevisaExtraPrimas() {
        this.ExtraprimaAnumero();
        this.txtMensaje = "";
        if (this.datos.epPorBAS < 100.0 && this.datos.epPorBAS > 0.0) {
            this.txtMensaje = this.txtMensaje + "La extraprima por millar b\u00e1sica debe ser mayor a cero";
        }
        if (this.datos.epPorACC < 100.0 && this.datos.epPorACC > 0.0) {
            this.txtMensaje = this.txtMensaje + "La extraprima por millar por accidentes debe ser mayor a cero";
        }
        if (this.datos.epPorINV < 100.0 && this.datos.epPorINV > 0.0) {
            this.txtMensaje = this.txtMensaje + "La extraprima por millar por invalidez debe ser mayor a cero";
        }
        if (this.txtMensaje == "") {
            this.btnCalcularEP.setVisible(true);
            this.btnReporte.setDisable(true);
            this.btnPresentacion.setDisable(true);
        } else {
            this.btnCalcularEP.setVisible(false);
            this.btnReporte.setDisable(false);
            this.btnPresentacion.setDisable(false);
            this.genSubs.MuestraMensaje(this.txtMensaje);
        }
        this.datos.hayExtraprimas = this.datos.epMillarBAS + this.datos.epPorBAS + this.datos.epPorACC + this.datos.epPorINV > 0.0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        this.epEquivBAS.setText("");
    }

    public void EPequivalente() {
        this.GuardaExtraprimas();
        Boolean hayError = false;
        Double tarBASoriginal = this.datos.tarMetaLife;
        this.tarBASmodificada = 0.0;
        this.modificarTarBAS = false;
        Integer casoVectores = 0;
        Double tasaAdiPesosFijaTemp = this.datos.tasaAdiPesosFija;
        Boolean coberturaAtemp = this.datos.coberturaA;
        this.datos.epPorBAStmp = 0.0;
        this.datos.epMillarBAStmp = this.datos.epMillarBAS;
        if (this.datos.hayExtraprimas.booleanValue() && this.datos.epPorBAS > 0.0) {
            int i;
            this.datos.coberturaA = true;
            this.datos.tasaAdiPesosFija = 0.02;
            this.datos.epPorBAStmp = this.datos.epPorBAS;
            this.datos.epMillarBAStmp = this.datos.epMillarBAS;
            this.datos.epPorBAS = 0.0;
            this.datos.epMillarBAS = 0.0;
            this.Cotiza();
            tarBASoriginal = this.datos.tarMetaLife;
            Double fondoObjetivo = this.datos.sumaFinal;
            int iterMax = 30;
            Double cotaInferior = this.datos.tarMetaLife;
            Double cotaSuperior = this.datos.tarMetaLife * 2.0;
            this.datos.epPorBAS = this.datos.epPorBAStmp;
            this.datos.epMillarBAS = this.datos.epMillarBAStmp;
            for (i = 1; i <= iterMax; ++i) {
                this.tarBASmodificada = cotaSuperior = Double.valueOf(this.datos.tarMetaLife * (double)(i + 1));
                this.modificarTarBAS = true;
                this.Cotiza();
                if (this.datos.fondoFinal >= fondoObjetivo) break;
            }
            if (i > iterMax) {
                hayError = true;
            } else {
                for (i = 1; i <= iterMax; ++i) {
                    this.tarBASmodificada = (cotaSuperior + cotaInferior) / 2.0;
                    this.Cotiza();
                    if (this.datos.fondoFinal - fondoObjetivo > 0.0 && this.datos.fondoFinal - fondoObjetivo < 1000.0) {
                        this.Cotiza();
                        break;
                    }
                    if (this.datos.fondoFinal > fondoObjetivo) {
                        cotaSuperior = this.tarBASmodificada;
                        continue;
                    }
                    cotaInferior = this.tarBASmodificada;
                }
                if (i > iterMax) {
                    hayError = true;
                }
            }
            if (hayError.booleanValue()) {
                this.btnReporte.setDisable(true);
                this.btnPresentacion.setDisable(true);
                this.txtMensaje = "No se logr\u00f3 el objetivo\r";
                this.txtMensaje = this.txtMensaje + "Fondo Final: " + this.datos.fondoFinal + "\r";
                this.txtMensaje = this.txtMensaje + "Fondo Objetivo: " + fondoObjetivo;
                this.genSubs.MuestraMensaje(this.txtMensaje);
                this.epEquivBAS.setText("");
            } else {
                this.btnReporte.setDisable(false);
                this.btnPresentacion.setDisable(false);
                this.datos.epEquivBAS = (this.datos.primaMetaLife - this.datos.recFijoMetaLife) * 1000.0 / this.datos.sumaInicial - tarBASoriginal;
                this.datos.epEquivBAS = this.genSubs.Redondea(this.datos.epEquivBAS, 2);
                this.epEquivBAS.setText(this.genSubs.FormatoNumDouble("#0.00", this.datos.epEquivBAS));
                this.txtMensaje = "";
                if (this.datos.epMillarBAS > 0.0) {
                    this.txtMensaje = "La extraprima " + this.epPorBAS.getText() + "%\r";
                    this.txtMensaje = this.txtMensaje + "es equivalente a " + this.genSubs.FormatoNumDouble("#0.00", this.datos.epEquivBAS) + " por millar\r";
                    this.txtMensaje = this.txtMensaje + "y se agrega a la extraprima por millar capturada";
                } else {
                    this.txtMensaje = "La extraprima " + this.epPorBAS.getText() + "%\r";
                    this.txtMensaje = this.txtMensaje + "es equivalente a " + this.genSubs.FormatoNumDouble("#0.00", this.datos.epEquivBAS) + " por millar";
                }
                this.genSubs.MuestraMensaje(this.txtMensaje);
                String epMillarTotal = "";
                epMillarTotal = this.genSubs.FormatoNumDouble("###.##", this.datos.epMillarBAS + this.datos.epEquivBAS);
                this.epMillarBAS.setText(epMillarTotal);
                this.modificarTarBAS = false;
                this.epPorBAS.setText("");
                this.GuardaExtraprimas();
                this.datos.tasaAdiPesosFija = tasaAdiPesosFijaTemp;
                this.datos.coberturaA = coberturaAtemp;
                this.Cotiza();
            }
        } else {
            this.datos.tasaBasePesos = this.datos.tasaAdiPesosFija;
            this.Cotiza();
            this.btnReporte.setDisable(false);
            this.btnPresentacion.setDisable(false);
        }
    }

    private void GuardaExtraprimas() {
        this.ExtraprimaAnumero();
        if (this.datos.epPorBAS > 0.0) {
            this.datos.epPorBAS = this.datos.epPorBAS / 100.0 - 1.0;
        }
        if (this.datos.epPorACC > 0.0) {
            this.datos.epPorACC = this.datos.epPorACC / 100.0 - 1.0;
        }
        if (this.datos.epPorINV > 0.0) {
            this.datos.epPorINV = this.datos.epPorINV / 100.0 - 1.0;
        }
    }

    private void ExtraprimaAnumero() {
        this.datos.epMillarBAS = this.epMillarBAS.getText().equals("") ? Double.valueOf(0.0) : Double.valueOf(Double.parseDouble(this.genSubs.QuitaComas(this.epMillarBAS.getText())));
        this.datos.epPorBAS = this.epPorBAS.getText().equals("") ? Double.valueOf(0.0) : Double.valueOf(Double.parseDouble(this.genSubs.QuitaComas(this.epPorBAS.getText())));
        this.datos.epPorACC = this.epPorACC.getText().equals("") ? Double.valueOf(0.0) : Double.valueOf(Double.parseDouble(this.genSubs.QuitaComas(this.epPorACC.getText())));
        this.datos.epPorINV = this.epPorINV.getText().equals("") ? Double.valueOf(0.0) : Double.valueOf(Double.parseDouble(this.genSubs.QuitaComas(this.epPorINV.getText())));
    }

    private void ValoresIniciales() {
        this.lblVersion.setText(this.datosvi.idVersion + this.datosvi.textoLegal);
        this.cmbMetas.getItems().clear();
        this.datos.lstMetas.clear();
        this.datos.lstMetas.add("Hogar");
        this.datos.lstMetas.add("Coche");
        this.datos.lstMetas.add("Educaci\u00f3n");
        this.datos.lstMetas.add("Negocio");
        this.datos.lstMetas.add("Viaje");
        this.datos.lstMetas.add("Retiro");
        this.datos.lstMetas.add("Otra");
        this.cmbMetas.getItems().addAll(this.datos.lstMetas);
        this.cmbMetas.setValue((Object)"Hogar");
        this.metaSeleccionada = "Hogar";
        this.txtOtraMeta.setVisible(false);
        this.datos.sumaInicial = 0.0;
        this.datos.primaMetaLife = 0.0;
        this.cmbPlazoPago.getItems().clear();
        if (this.datos.optOpcionCalculo.equals("Meta")) {
            this.datos.lstPlazoPago.clear();
            this.datos.lstPlazoPago.add("vitalicio");
            this.cmbPlazoPago.getItems().addAll(this.datos.lstPlazoPago);
            this.cmbPlazoPago.setValue((Object)"vitalicio");
            this.datos.txtPlazoPago = "vitalicio";
            this.datos.plazoPago = 99;
        } else {
            this.datos.lstPlazoPago.clear();
            this.datos.lstPlazoPago.add("5 a\u00f1os");
            this.datos.lstPlazoPago.add("10 a\u00f1os");
            this.datos.lstPlazoPago.add("15 a\u00f1os");
            this.datos.lstPlazoPago.add("20 a\u00f1os");
            this.datos.lstPlazoPago.add("edad 60");
            this.datos.lstPlazoPago.add("edad 65");
            this.datos.lstPlazoPago.add("vitalicio");
            if (this.datos.optOpcionCalculo.equals("Prima")) {
                this.datos.lstPlazoPago.add("One Shot");
            }
            this.cmbPlazoPago.getItems().addAll(this.datos.lstPlazoPago);
            this.cmbPlazoPago.setValue((Object)"vitalicio");
            this.datos.txtPlazoPago = "vitalicio";
            this.datos.plazoPago = 99;
            this.lblPlazoPago.setVisible(true);
            this.cmbPlazoPago.setVisible(true);
            this.datos.txtPlazoPago = "vitalicio";
            this.datos.plazoPago = 99;
        }
        this.datos.conCostoSeguro = false;
        this.conCostoSeguro.setSelected(false);
        this.cmbFormaPago.getItems().clear();
        this.datos.lstFormaPago.clear();
        this.datos.lstFormaPago.add("Anual");
        this.datos.lstFormaPago.add("Semestral");
        this.datos.lstFormaPago.add("Trimestral");
        this.datos.lstFormaPago.add("Mensual");
        this.cmbFormaPago.getItems().addAll(this.datos.lstFormaPago);
        if (this.datos.versionBase.booleanValue()) {
            this.cmbFormaPago.setValue((Object)"Anual");
            this.datos.formaPago = "Anual";
            this.cmbFormaPago.setDisable(false);
            this.datos.fraccionFPago = 1;
        } else if (this.datos.optOpcionCalculo.equals("Prima")) {
            this.cmbPlazoPago.setValue((Object)"One Shot");
            this.datos.txtPlazoPago = "One Shot";
            this.cmbFormaPago.setDisable(true);
        } else {
            this.cmbFormaPago.setValue((Object)"Anual");
            this.datos.formaPago = "Anual";
            this.cmbFormaPago.setDisable(false);
        }
        this.datos.indexFormaPago = 0;
        this.cmbPaquete.getItems().clear();
        this.datos.lstPaquete.clear();
        this.datos.lstPaquete.add("Retiro");
        this.datos.lstPaquete.add("Tu futuro");
        this.datos.lstPaquete.add("Mujer");
        this.datos.lstPaquete.add("Educaci\u00f3n");
        this.cmbPaquete.getItems().addAll(this.datos.lstPaquete);
        this.cmbPaquete.setValue((Object)"Retiro");
        this.datos.paqueteSeleccionado = "Retiro";
        this.optFondoFijo.setVisible(false);
        this.optFondoVariable.setVisible(false);
        this.listaMetas.clear();
        this.datos.lstAnoMeta.clear();
        this.datos.lstNombreMeta.clear();
        this.datos.lstImporteMeta.clear();
        this.datos.lstAnoAportacion.clear();
        this.datos.lstImporteAportacion.clear();
        this.txtAptAnual.setText("");
        this.txtRetiroProgramado.setText("");
        this.txtIniRetiroProgramado.setText("");
        this.txtFinRetiroProgramado.setText("");
        this.datos.impAptAnual = 0.0;
        this.txtNombre.requestFocus();
        Boolean tieneFoco = this.txtNombre.isFocused();
        this.txtNombre.setText("");
        this.txtNombre.requestFocus();
        this.txtEdad.setText("35");
        this.datos.edad = 35;
        this.optMasculino.setSelected(true);
        this.optFuma.setSelected(true);
        this.optPesos.setSelected(true);
        this.optCoberturaA.setSelected(true);
        this.datos.coberturaA = true;
        this.optInvOptimista.setSelected(true);
        this.txtPorFondoFijo.setText("100");
        this.txtPorPPRfijo.setText("0");
        this.txtPorCPEAfijo.setText("0");
        this.datos.porFondoFijo = 1.0;
        this.datos.porPPRfijo = 0.0;
        this.datos.porCPEAfijo = 0.0;
        this.txtPorFondoVariable.setText("0");
        this.txtPorPPRvariable.setText("0");
        this.txtPorCPEAvariable.setText("0");
        this.datos.porFondoVar = 0.0;
        this.datos.porPPRvar = 0.0;
        this.datos.porCPEAvar = 0.0;
        this.txtAnoMeta.setText("");
        this.txtImporteMeta.setText("");
        this.txtImporteAportacion.setText("");
        this.txtAnoAportacion.setText("");
        this.txtRetiroProgramado.setText("");
        this.txtIniRetiroProgramado.setText("");
        this.txtFinRetiroProgramado.setText("");
        this.ingresoAnual.setText("");
        this.nombreMenor.setText("");
        this.edadMenor.setText("");
        this.datos.primaAhorro = 0.0;
        this.txtAhorro.setText("");
        this.optFondoFijo.setSelected(true);
        this.chkEP.setSelected(false);
        this.chkPASI.setSelected(false);
        this.chkMA.setSelected(false);
        this.chkDI.setSelected(false);
        this.chkTI.setSelected(false);
        this.chkGE.setSelected(false);
        this.lblPrimaEP.setVisible(false);
        this.lblPrimaPASI.setVisible(false);
        this.lblPrimaMA.setVisible(false);
        this.lblPrimaDI.setVisible(false);
        this.lblPrimaTI.setVisible(false);
        this.lblPrimaGE.setVisible(false);
        this.lblSumaEP.setVisible(false);
        this.lblSumaPASI.setVisible(false);
        this.lblSumaMA.setVisible(false);
        this.lblSumaDI.setVisible(false);
        this.lblSumaTI.setVisible(false);
        this.lblSumaGE.setVisible(false);
        this.lblAportacionFPago.setText("Aportaci\u00f3n Anual de:");
        this.lblAportacionProgramada.setText("");
        this.datos.impAptAnual = 0.0;
        this.tblImporteMeta.setStyle("-fx-alignment: CENTER-RIGHT");
        this.tblImporteAportacion.setStyle("-fx-alignment: CENTER-RIGHT");
        this.PosicionOpcionesCalculo();
        this.datos.recargoPrimaBAS = 0.12;
        this.datos.recargoAsset = 0.01;
        this.tablas.CargaCoiBAS();
        this.tablas.CargaCoiBeneficios();
        this.tablas.CargaFacSel();
        this.tablas.CargaReglas();
        this.tablas.CargaCastigoRescate();
        this.tablas.CargaRecargoPoliza();
        this.datos.coiMA = 0.067;
        this.datos.coiDI = 0.088;
        this.datos.coiTI = 0.12;
        this.datos.comisGEpesos = 0.2;
        this.datos.comisGEdls = 0.16;
        this.datos.tasaBasePesos = 0.055;
        this.datos.tasaBaseDls = 0.04;
        this.datos.tasaFija.clear();
        this.datos.tasaVar.clear();
        this.datos.tasaFija.add(0.065);
        this.datos.tasaFija.add(0.04);
        this.datos.tasaFija.add(0.035);
        this.datos.tasaFija.add(0.03);
        this.datos.tasaFija.add(0.02);
        this.datos.tasaFija.add(0.02);
        this.datos.tasaVar.add(0.12);
        this.datos.tasaVar.add(0.04);
        this.datos.tasaVar.add(0.08);
        this.datos.tasaVar.add(0.03);
        this.datos.tasaVar.add(0.02);
        this.datos.tasaVar.add(0.02);
        this.datos.porIncSuma = 0.05;
        this.datos.txtAyuda = "";
        this.lblAyuda.setVisible(false);
        this.nombreMenor.setVisible(false);
        this.edadMenor.setVisible(false);
        this.ingresoAnual.setVisible(true);
        this.datos.hayExtraprimas = false;
        this.datos.epMillarBAS = 0.0;
        this.datos.epPorBAS = 0.0;
        this.datos.epPorACC = 0.0;
        this.datos.epPorINV = 0.0;
        this.datos.epEquivBAS = 0.0;
        this.epMillarBAS.setText("");
        this.epPorBAS.setText("");
        this.epPorACC.setText("");
        this.epPorINV.setText("");
        this.epEquivBAS.setText("");
        this.btnCalcularEP.setVisible(false);
    }

    public void MixMetaLife() {
        this.datosPrimor.mixMeta = true;
        this.cotizMixMetaLife.ImprimeCotizacion();
    }

    public void RegresaPrimordial() {
        this.datosvi.planSel = "Primordial";
        this.datosvi.prodSel = "Primordial";
        this.ValoresInicialesPrimordial();
        this.stage = (Stage)this.lblVersion.getScene().getWindow();
        this.MuestraVentana("PrimorCob");
    }

    private void ValoresInicialesPrimordial() {
        this.datosPrimor.indexPlan = 0;
    }

    private void MuestraPrimordial(String nombreVentana) {
        try {
            this.root = (Parent)FXMLLoader.load((URL)this.getClass().getResource(nombreVentana + ".fxml"));
        }
        catch (Exception e2) {
            System.out.println("No pudo cargar " + nombreVentana);
        }
        Scene scene = new Scene(this.root);
        this.stage.setScene(scene);
        scene.getStylesheets().add((Object)"cssBase.css");
        this.stage.show();
    }

    private void MuestraInfo(String nombreVentana) {
        this.stage = (Stage)this.lblVersion.getScene().getWindow();
        if (this.datosvi.planSel == "EducaLife") {
            this.datosvi.idPlanSelAnt = this.datosvi.idPlanSel = this.genSubs.VlookUpStrInt("B\u00e1sico EducaLife", this.datosvi.lstNombrePlan, this.datosvi.lstIdPlan);
        } else {
            this.datosvi.idPlanSel = this.genSubs.VlookUpStrInt(this.datosvi.planSel, this.datosvi.lstNombrePlan, this.datosvi.lstIdPlan);
        }
        this.MuestraVentana(nombreVentana);
    }

    private void ValoresReproyeccion() {
        if (this.datos.reproyectaMetaLife.booleanValue()) {
            this.txtImporteOpcion.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.sumaNueva));
            this.lblSumaOriginal.setText(this.genSubs.FormatoNumDouble("###,###", this.datos.sumaOriginal));
        }
        if (this.datos.reproyectaMetaLife.booleanValue() && !this.datos.nuevosRecargos.booleanValue()) {
            this.datos.tasaFija.add(0.055);
        } else {
            this.datos.tasaFija.add(0.065);
        }
    }

    private void InicializaVentana() {
        if (this.datos.reproyectaMetaLife.booleanValue()) {
            this.lblPaquete.setVisible(false);
            this.cmbPaquete.setVisible(false);
            this.paneMetas.setDisable(true);
            this.chkRendimientos.setVisible(false);
            this.btnPresentacion.setVisible(false);
            this.lblReproyeccion.setVisible(true);
            this.lblReproyeccionDatosPer.setVisible(true);
            this.lblSumaNueva.setVisible(true);
            this.ingresoAnual.setVisible(false);
            this.lblSumaOriginal.setVisible(true);
            this.titSumaOriginal.setVisible(true);
            this.txtImporteOpcion.setDisable(true);
        } else {
            this.lblPaquete.setVisible(true);
            this.cmbPaquete.setVisible(true);
            this.paneMetas.setDisable(false);
            this.conCostoSeguro.setVisible(true);
            this.chkRendimientos.setVisible(true);
            this.btnPresentacion.setVisible(true);
            this.lblReproyeccion.setVisible(false);
            this.lblReproyeccionDatosPer.setVisible(false);
            this.lblSumaNueva.setVisible(false);
            this.ingresoAnual.setVisible(true);
            this.lblSumaOriginal.setVisible(false);
            this.titSumaOriginal.setVisible(false);
            this.txtImporteOpcion.setDisable(false);
        }
        if (!this.datos.conEPmetalife.booleanValue()) {
            this.OcultaExtraprimas();
        }
    }

    private void OcultaExtraprimas() {
        this.epMillarBAS.setVisible(false);
        this.epPorBAS.setVisible(false);
        this.epPorACC.setVisible(false);
        this.epPorINV.setVisible(false);
        this.epEquivBAS.setVisible(false);
        this.btnCalcularEP.setVisible(false);
        this.titExtraprima.setVisible(false);
        this.titEPmillar.setVisible(false);
        this.titEPporcentaje.setVisible(false);
        this.titEPequivalente.setVisible(false);
        this.lineaExtraprima.setVisible(false);
        this.titEPvida.setVisible(false);
        this.titEPaccidentes.setVisible(false);
        this.titEPinvalidez.setVisible(false);
    }

    private void TituloOpcionCalculo() {
        if (this.datos.optOpcionCalculo.equals("Meta")) {
            this.paneDatosPersonales.setText("Datos personales y dise\u00f1o del plan. Cotizaci\u00f3n por Meta de Ahorro.");
        } else if (this.datos.optOpcionCalculo.equals("Suma")) {
            this.paneDatosPersonales.setText("Datos personales y dise\u00f1o del plan. Cotizaci\u00f3n por Suma Asegurada.");
        } else {
            this.paneDatosPersonales.setText("Datos personales y dise\u00f1o del plan. Cotizaci\u00f3n por Prima.");
        }
    }

    private void PosicionOpcionesCalculo() {
        switch (this.datos.optOpcionCalculo) {
            case "Meta": {
                this.titOpciones.setText("Meta de Ahorro");
                this.txtPlazoMeta.setVisible(true);
                break;
            }
            case "Suma": {
                this.titOpciones.setText("Suma Asegurada");
                this.txtPlazoMeta.setVisible(false);
                break;
            }
            case "Prima": {
                if (this.datos.txtPlazoPago.equals("One Shot")) {
                    this.titOpciones.setText("Prima \u00fanica a pagar");
                } else {
                    this.titOpciones.setText("Prima a pagar");
                }
                this.txtPlazoMeta.setVisible(false);
            }
        }
        if (this.datos.conVectores.booleanValue()) {
            this.btnVectores.setVisible(true);
        } else {
            this.btnVectores.setVisible(false);
        }
    }

    public void MuestraAyudaOptimista() {
        this.datos.txtAyuda = this.optPesos.isSelected() ? "Tasa de inversi\u00f3n en fondo fijo 6.5%" : "Tasa de inversi\u00f3n en fondo fijo 4%";
        this.posX = this.optInvOptimista.getLayoutX() + this.optInvOptimista.getWidth() + 15.0;
        this.posY = this.paneEscenario.getLayoutY();
        this.posY = this.posY + this.optInvOptimista.getLayoutY();
        this.lblAyuda.relocate(this.posX.doubleValue(), this.posY.doubleValue());
        this.lblAyuda.setText(this.datos.txtAyuda);
        this.lblAyuda.setVisible(true);
    }

    public void MuestraAyudaOptimistaVar() {
        this.datos.txtAyuda = this.optPesos.isSelected() ? "Tasa de inversi\u00f3n en fondo variable 12%" : "Tasa de inversi\u00f3n en fondo variable 4%";
        this.posX = this.optInvOptimistaVar.getLayoutX() + this.optInvOptimistaVar.getWidth() + 15.0;
        this.posY = this.paneEscenario.getLayoutY();
        this.posY = this.posY + this.optInvOptimistaVar.getLayoutY();
        this.lblAyuda.relocate(this.posX.doubleValue(), this.posY.doubleValue());
        this.lblAyuda.setText(this.datos.txtAyuda);
        this.lblAyuda.setVisible(true);
    }

    public void OcultaAyuda() {
        this.lblAyuda.setVisible(false);
    }

    public void MuestraAyudaPromedio() {
        this.datos.txtAyuda = this.optPesos.isSelected() ? "Tasa de inversi\u00f3n en fondo fijo 3.5%" : "Tasa de inversi\u00f3n en fondo fijo 3%";
        this.posX = this.optInvPromedio.getLayoutX() + this.optInvPromedio.getWidth() + 15.0;
        this.posY = this.paneEscenario.getLayoutY();
        this.posY = this.posY + this.optInvPromedio.getLayoutY();
        this.lblAyuda.relocate(this.posX.doubleValue(), this.posY.doubleValue());
        this.lblAyuda.setText(this.datos.txtAyuda);
        this.lblAyuda.setVisible(true);
    }

    public void MuestraAyudaPromedioVar() {
        this.datos.txtAyuda = this.optPesos.isSelected() ? "Tasa de inversi\u00f3n en fondo variable 8%" : "Tasa de inversi\u00f3n en fondo variable 3%";
        this.posX = this.optInvPromedioVar.getLayoutX() + this.optInvPromedioVar.getWidth() + 15.0;
        this.posY = this.paneEscenario.getLayoutY();
        this.posY = this.posY + this.optInvPromedioVar.getLayoutY();
        this.lblAyuda.relocate(this.posX.doubleValue(), this.posY.doubleValue());
        this.lblAyuda.setText(this.datos.txtAyuda);
        this.lblAyuda.setVisible(true);
    }

    public void MuestraAyudaConservador() {
        this.datos.txtAyuda = this.optPesos.isSelected() ? "Tasa de inversi\u00f3n en fondo fijo 2%" : "Tasa de inversi\u00f3n en fondo fijo 2%";
        this.posX = this.optInvConservador.getLayoutX() + this.optInvConservador.getWidth() + 15.0;
        this.posY = this.paneEscenario.getLayoutY();
        this.posY = this.posY + this.optInvConservador.getLayoutY();
        this.lblAyuda.relocate(this.posX.doubleValue(), this.posY.doubleValue());
        this.lblAyuda.setText(this.datos.txtAyuda);
        this.lblAyuda.setVisible(true);
    }

    public void MuestraAyudaConservadorVar() {
        this.datos.txtAyuda = this.optPesos.isSelected() ? "Tasa de inversi\u00f3n en fondo variable 2%" : "Tasa de inversi\u00f3n en fondo variable 2%";
        this.posX = this.optInvConservadorVar.getLayoutX() + this.optInvConservadorVar.getWidth() + 15.0;
        this.posY = this.paneEscenario.getLayoutY();
        this.posY = this.posY + this.optInvConservadorVar.getLayoutY();
        this.lblAyuda.relocate(this.posX.doubleValue(), this.posY.doubleValue());
        this.lblAyuda.setText(this.datos.txtAyuda);
        this.lblAyuda.setVisible(true);
    }

    public void ImprimeVectores() {
        this.datos.myStage = this.stage = (Stage)this.lblVersion.getScene().getWindow();
        this.MuestraVentana("Vectores");
    }

    public void Robot() {
        ResultSet rs = null;
        this.reporteRobot.EliminaArchivoAnterior();
        this.reporteRobot.RenTitulos();
        rs = this.datos.optOpcionCalculo.equals("Prima") ? this.tablas.CargaCasoMeta("MetaPruebasPrima") : (this.datos.optOpcionCalculo.equals("Meta") ? this.tablas.CargaCasoMeta("MetaPruebasMeta") : this.tablas.CargaCasoMeta("MetaPruebasSuma"));
        try {
            while (rs.next()) {
                this.listaMetas.clear();
                this.datos.lstAnoMeta.clear();
                this.datos.lstNombreMeta.clear();
                this.datos.lstImporteMeta.clear();
                this.listaAportaciones.clear();
                this.datos.lstAnoAportacion.clear();
                this.datos.lstImporteAportacion.clear();
                this.accMetaLife.setExpandedPane(this.paneDatosPersonales);
                this.datos.ID = rs.getInt("ID");
                if (this.datos.ID == 13) {
                    this.txtMensaje = "";
                }
                this.txtNombre.setText(rs.getString("nombre"));
                this.txtEdad.setText(rs.getString("edad"));
                if (rs.getString("sexo").equals("M")) {
                    this.optMasculino.setSelected(true);
                    this.optFemenino.setSelected(false);
                } else {
                    this.optMasculino.setSelected(false);
                    this.optFemenino.setSelected(true);
                }
                if (rs.getString("fuma").equals("S")) {
                    this.optFuma.setSelected(true);
                    this.optNoFuma.setSelected(false);
                } else {
                    this.optFuma.setSelected(false);
                    this.optNoFuma.setSelected(true);
                }
                if (rs.getString("coberturaA").equals("S")) {
                    this.optCoberturaA.setSelected(true);
                    this.optCoberturaB.setSelected(false);
                    this.datos.coberturaA = true;
                } else {
                    this.optCoberturaA.setSelected(false);
                    this.optCoberturaB.setSelected(true);
                    this.datos.coberturaA = false;
                }
                if (rs.getString("moneda").equals("P")) {
                    this.optPesos.setSelected(true);
                    this.optDolares.setSelected(false);
                } else {
                    this.optPesos.setSelected(false);
                    this.optDolares.setSelected(true);
                }
                if (rs.getString("optInversion").equals("O")) {
                    this.optInvOptimista.setSelected(true);
                    this.optInvPromedio.setSelected(false);
                    this.optInvConservador.setSelected(false);
                } else if (rs.getString("optInversion").equals("P")) {
                    this.optInvOptimista.setSelected(false);
                    this.optInvPromedio.setSelected(true);
                    this.optInvConservador.setSelected(false);
                } else {
                    this.optInvOptimista.setSelected(false);
                    this.optInvPromedio.setSelected(false);
                    this.optInvConservador.setSelected(true);
                }
                this.txtImporteOpcion.setText(rs.getString("importeOpcion"));
                if (this.datos.optOpcionCalculo.equals("Meta")) {
                    this.txtPlazoMeta.setText(rs.getString("plazoMeta"));
                }
                this.txtPorFondoFijo.setText(rs.getString("porFondoFijo"));
                this.txtPorPPRfijo.setText(rs.getString("porPPRfijo"));
                this.txtPorCPEAfijo.setText(rs.getString("porCPEAfijo"));
                this.txtPorFondoVariable.setText(rs.getString("porFondoVariable"));
                this.txtPorPPRvariable.setText(rs.getString("porPPRvariable"));
                this.txtPorCPEAvariable.setText(rs.getString("porCPEAvariable"));
                if (rs.getInt("plazoPago") == 1) {
                    this.cmbPlazoPago.setValue((Object)"One Shot");
                } else if (rs.getInt("plazoPago") < 99) {
                    this.cmbPlazoPago.setValue((Object)(rs.getInt("plazoPago") + " a\u00f1os"));
                } else {
                    this.cmbPlazoPago.setValue((Object)"vitalicio");
                }
                this.cmbFormaPago.setValue((Object)rs.getString("formaPago"));
                this.accMetaLife.setExpandedPane(this.paneMetas);
                this.cmbMetas.setValue((Object)rs.getString("nombreMeta"));
                Integer tmpInt = rs.getInt("anoMeta");
                this.txtAnoMeta.setText(this.genSubs.FormatoNumInteger("###", tmpInt));
                tmpInt = rs.getInt("importeMeta");
                this.txtImporteMeta.setText(this.genSubs.FormatoNumInteger("###", tmpInt));
                this.AgregarMetas();
                tmpInt = rs.getInt("anoAportacion");
                this.txtAnoAportacion.setText(this.genSubs.FormatoNumInteger("###", tmpInt));
                tmpInt = rs.getInt("importeAportacion");
                this.txtImporteAportacion.setText(this.genSubs.FormatoNumInteger("###", tmpInt));
                this.AgregarAportaciones();
                tmpInt = rs.getInt("aptAnual");
                this.txtAptAnual.setText(this.genSubs.FormatoNumInteger("###", tmpInt));
                tmpInt = rs.getInt("retiroProgramado");
                this.txtRetiroProgramado.setText(this.genSubs.FormatoNumInteger("###", tmpInt));
                tmpInt = rs.getInt("iniRetiroProgramado");
                this.txtIniRetiroProgramado.setText(this.genSubs.FormatoNumInteger("###", tmpInt));
                tmpInt = rs.getInt("finRetiroProgramado");
                this.txtFinRetiroProgramado.setText(this.genSubs.FormatoNumInteger("###", tmpInt));
                this.clicCotizacion();
                this.accMetaLife.setExpandedPane(this.paneCotizacion);
                this.chkEP.setSelected(!this.chkEP.isDisable());
                this.datos.selEP = this.chkEP.isSelected();
                this.chkPASI.setSelected(!this.chkPASI.isDisable());
                this.datos.selPASI = this.chkPASI.isSelected();
                this.chkMA.setSelected(!this.chkMA.isDisable());
                this.datos.selMA = this.chkMA.isSelected();
                this.chkGE.setSelected(!this.chkGE.isDisable());
                this.datos.selGE = this.chkGE.isSelected();
                this.Cotiza();
                this.reporteRobot.RenResultado();
            }
            rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " tarPerfect: " + e2.getMessage());
        }
        this.reporteRobot.EscribeArchivo();
    }

    public static class Aportacion {
        private SimpleStringProperty anoAportacion = new SimpleStringProperty();
        private SimpleStringProperty importeAportacion = new SimpleStringProperty();

        public SimpleStringProperty anoAportacionProperty() {
            return this.anoAportacion;
        }

        public void setAnoAportacion(String value) {
            this.anoAportacion.set(value);
        }

        public String getAnoAportacion() {
            return this.anoAportacion.get();
        }

        public SimpleStringProperty importeAportacionProperty() {
            return this.importeAportacion;
        }

        public void setImporteAportacion(String value) {
            this.importeAportacion.set(value);
        }

        public String getImporteAportacion() {
            return this.importeAportacion.get();
        }

        private Aportacion(String ano, String importe) {
            this.anoAportacion = new SimpleStringProperty(ano);
            this.importeAportacion = new SimpleStringProperty(importe);
        }
    }

    public static class Meta {
        private SimpleStringProperty anoMeta = new SimpleStringProperty();
        private SimpleStringProperty nombreMeta = new SimpleStringProperty();
        private SimpleStringProperty importeMeta = new SimpleStringProperty();

        public SimpleStringProperty anoMetaProperty() {
            return this.anoMeta;
        }

        public void setAnoMeta(String value) {
            this.anoMeta.set(value);
        }

        public String getAnoMeta() {
            return this.anoMeta.get();
        }

        public SimpleStringProperty nombreMetaProperty() {
            return this.nombreMeta;
        }

        public void setNombreMeta(String value) {
            this.nombreMeta.set(value);
        }

        public String getNombreMeta() {
            return this.nombreMeta.get();
        }

        public SimpleStringProperty importeMetaProperty() {
            return this.importeMeta;
        }

        public void setImporteMeta(String value) {
            this.importeMeta.set(value);
        }

        public String getImporteMeta() {
            return this.importeMeta.get();
        }

        private Meta(String ano, String meta, String importe) {
            this.anoMeta = new SimpleStringProperty(ano);
            this.nombreMeta = new SimpleStringProperty(meta);
            this.importeMeta = new SimpleStringProperty(importe);
        }
    }
}

