/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDate;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;

public class MetaLifeController
implements Initializable {
    private Datos datos = Datos.getInstance();
    private DatosVI datosvi = DatosVI.getInstance();
    private DatosPrimor datosPrimor = DatosPrimor.getInstance();
    private GenSubs genSubs = GenSubs.getInstance();
    Stage stage;
    Parent root;
    @FXML
    Label lblOpciones;
    @FXML
    Label lblQueEs;
    @FXML
    Label lblBeneficios;
    @FXML
    Label lblCaracteristicas;
    @FXML
    Label lblComplementos;
    @FXML
    Label lblAsistencias;
    @FXML
    Label lblPorMeta;
    @FXML
    Label txtPorMeta;
    @FXML
    Button btnPorMeta;
    @FXML
    Label lblPorPrima;
    @FXML
    Label lblPorSuma;
    @FXML
    Label txtPorSuma;
    @FXML
    Button btnPorSuma;
    @FXML
    Label lblVersion;
    @FXML
    WebView browser;
    @FXML
    AnchorPane paneOpciones;
    @FXML
    Button btnPorPrima;
    @FXML
    Button btnReproyeccion;
    WebEngine webEngine;
    String idTexto;
    String bkgGrisClaro;
    String bkgNulo;
    String textoSubrayado;
    String textoNoSubrayado;

    public void initialize(URL url, ResourceBundle rb) {
        this.ValoresIniciales();
        this.InicializaVentana();
        this.lblOpciones.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new MyEventHandler());
        this.lblQueEs.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new MyEventHandler());
        this.lblBeneficios.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new MyEventHandler());
        this.lblCaracteristicas.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new MyEventHandler());
        this.lblComplementos.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new MyEventHandler());
        this.lblAsistencias.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new MyEventHandler());
    }

    private void InicializaVentana() {
        this.MuestraTexto("lblOpciones");
        this.lblOpciones.setStyle(this.textoSubrayado);
        this.btnReproyeccion.setVisible(false);
    }

    public void MuestraTexto(String idTexto) {
        if (idTexto.equalsIgnoreCase("lblOpciones")) {
            this.browser.setVisible(false);
            this.paneOpciones.setVisible(true);
        } else {
            this.browser.setVisible(true);
            this.paneOpciones.setVisible(false);
        }
        switch (idTexto) {
            case "lblOpciones": {
                this.lblQueEs.setStyle(this.textoNoSubrayado);
                this.lblOpciones.setStyle(this.textoSubrayado);
                this.lblBeneficios.setStyle(this.textoNoSubrayado);
                this.lblCaracteristicas.setStyle(this.textoNoSubrayado);
                this.lblComplementos.setStyle(this.textoNoSubrayado);
                this.lblAsistencias.setStyle(this.textoNoSubrayado);
                break;
            }
            case "lblQueEs": {
                this.lblQueEs.setStyle(this.textoSubrayado);
                this.lblOpciones.setStyle(this.textoNoSubrayado);
                this.lblBeneficios.setStyle(this.textoNoSubrayado);
                this.lblCaracteristicas.setStyle(this.textoNoSubrayado);
                this.lblComplementos.setStyle(this.textoNoSubrayado);
                this.lblAsistencias.setStyle(this.textoNoSubrayado);
                break;
            }
            case "lblBeneficios": {
                this.lblBeneficios.setStyle(this.textoSubrayado);
                this.lblQueEs.setStyle(this.textoNoSubrayado);
                this.lblOpciones.setStyle(this.textoNoSubrayado);
                this.lblCaracteristicas.setStyle(this.textoNoSubrayado);
                this.lblComplementos.setStyle(this.textoNoSubrayado);
                this.lblAsistencias.setStyle(this.textoNoSubrayado);
                break;
            }
            case "lblCaracteristicas": {
                this.lblCaracteristicas.setStyle(this.textoSubrayado);
                this.lblQueEs.setStyle(this.textoNoSubrayado);
                this.lblOpciones.setStyle(this.textoNoSubrayado);
                this.lblBeneficios.setStyle(this.textoNoSubrayado);
                this.lblComplementos.setStyle(this.textoNoSubrayado);
                this.lblAsistencias.setStyle(this.textoNoSubrayado);
                break;
            }
            case "lblComplementos": {
                this.lblComplementos.setStyle(this.textoSubrayado);
                this.lblQueEs.setStyle(this.textoNoSubrayado);
                this.lblOpciones.setStyle(this.textoNoSubrayado);
                this.lblBeneficios.setStyle(this.textoNoSubrayado);
                this.lblCaracteristicas.setStyle(this.textoNoSubrayado);
                this.lblAsistencias.setStyle(this.textoNoSubrayado);
                break;
            }
            case "lblAsistencias": {
                this.lblAsistencias.setStyle(this.textoSubrayado);
                this.lblQueEs.setStyle(this.textoNoSubrayado);
                this.lblOpciones.setStyle(this.textoNoSubrayado);
                this.lblBeneficios.setStyle(this.textoNoSubrayado);
                this.lblCaracteristicas.setStyle(this.textoNoSubrayado);
                this.lblComplementos.setStyle(this.textoNoSubrayado);
            }
        }
        if (!idTexto.equalsIgnoreCase("lblOpciones")) {
            try {
                File file = new File(this.datos.actualPath + "/src/Textos/" + idTexto + ".html");
                if (file.exists()) {
                    URL url = file.toURI().toURL();
                    this.webEngine.load(url.toString());
                } else {
                    System.out.println("No encuentra el archivo");
                }
            }
            catch (MalformedURLException e2) {
                e2.printStackTrace();
            }
        }
    }

    public void OpcionMeta() {
        this.datos.optOpcionCalculo = "Meta";
        this.datos.reproyectaMetaLife = false;
        this.MuestraInfo();
    }

    public void OpcionPrima() {
        this.datos.optOpcionCalculo = "Prima";
        this.datos.reproyectaMetaLife = false;
        this.MuestraInfo();
    }

    public void OpcionSuma() {
        this.datos.optOpcionCalculo = "Suma";
        this.datos.reproyectaMetaLife = false;
        this.MuestraInfo();
    }

    public void OpcionReproyeccion() {
        this.datos.optOpcionCalculo = "Suma";
        this.datos.reproyectaMetaLife = true;
        try {
            this.root = (Parent)FXMLLoader.load((URL)this.getClass().getResource("MetaRep.fxml"));
        }
        catch (Exception e2) {
            System.out.println("No pudo cargar Metarep");
        }
        Scene scene = new Scene(this.root);
        this.stage.setScene(scene);
        this.stage.setResizable(true);
        scene.getStylesheets().add((Object)"cssBase.css");
        this.stage.show();
    }

    private void MuestraInfo() {
        this.stage = (Stage)this.lblVersion.getScene().getWindow();
        this.MuestraVentana();
    }

    private void MuestraInfo(String nombreVentana) {
        this.stage = (Stage)this.lblVersion.getScene().getWindow();
        if (this.datosvi.planSel == "EducaLife") {
            this.datosvi.idPlanSelAnt = this.datosvi.idPlanSel = this.genSubs.VlookUpStrInt("B\u00e1sico EducaLife", this.datosvi.lstNombrePlan, this.datosvi.lstIdPlan);
        } else {
            this.datosvi.idPlanSel = this.genSubs.VlookUpStrInt(this.datosvi.planSel, this.datosvi.lstNombrePlan, this.datosvi.lstIdPlan);
        }
        this.MuestraVentana(nombreVentana);
    }

    private void MuestraVentana() {
        try {
            this.root = (Parent)FXMLLoader.load((URL)this.getClass().getResource("Info.fxml"));
        }
        catch (Exception e2) {
            System.out.println("No pudo cargar Info");
        }
        Scene scene = new Scene(this.root);
        this.stage.setScene(scene);
        this.stage.setResizable(true);
        scene.getStylesheets().add((Object)"cssBase.css");
        this.stage.show();
    }

    private void ValoresIniciales() {
        this.lblVersion.setText(this.datosvi.idVersion + this.datosvi.textoLegal);
        if (this.datos.versionBase.booleanValue()) {
            this.lblPorPrima.setText("Cotizaci\u00f3n por Prima");
            this.lblPorSuma.setVisible(true);
            this.txtPorSuma.setVisible(true);
            this.btnPorSuma.setVisible(true);
            this.lblPorMeta.setVisible(true);
            this.txtPorMeta.setVisible(true);
            this.btnPorMeta.setVisible(true);
        } else {
            this.lblPorPrima.setText("One Shot");
            this.lblPorSuma.setVisible(false);
            this.txtPorSuma.setVisible(false);
            this.btnPorSuma.setVisible(false);
            this.lblPorMeta.setVisible(false);
            this.txtPorMeta.setVisible(false);
            this.btnPorMeta.setVisible(false);
        }
        this.datos.actualPath = "";
        try {
            System.out.println(new File(".").getCanonicalPath());
            this.datos.actualPath = new File(".").getCanonicalPath();
        }
        catch (Exception e2) {
            System.out.println("Error: " + e2);
        }
        this.webEngine = this.browser.getEngine();
        this.bkgGrisClaro = "-fx-background-color: lightgrey";
        this.bkgNulo = "-fx-background-color: null";
        this.textoSubrayado = "-fx-underline: true";
        this.textoNoSubrayado = "-fx-underline: false";
        this.datos.plazoPago = 20;
        if (this.datos.nuevosRecargos.booleanValue()) {
            this.datos.recFijoIniPesos = 1300.0;
            this.datos.recFijoIniDls = 130.0;
        } else {
            this.datos.recFijoIniPesos = 1000.0;
            this.datos.recFijoIniDls = 100.0;
        }
        this.datos.fechaCambio = LocalDate.of((int)this.datos.anoCambio, this.datos.mesCambio, (int)this.datos.diaCambio);
        this.datos.vigenciaInicial = LocalDate.of((int)this.datos.anoInicial, this.datos.mesInicial, (int)this.datos.diaInicial);
    }

    public void Salir() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("MetaLife");
        alert.setHeaderText("");
        alert.setContentText("\u00bfEst\u00e1 seguro de salir del cotizador?");
        Optional result = alert.showAndWait();
        if (result.get() == ButtonType.OK) {
            Platform.exit();
        }
    }

    public void RegresaInicio() {
        this.stage = (Stage)this.lblVersion.getScene().getWindow();
        this.MuestraVentana("Inicio.fxml");
    }

    private void MuestraVentana(String nombreVentana) {
        try {
            this.root = (Parent)FXMLLoader.load((URL)this.getClass().getResource(nombreVentana));
            Scene scene = new Scene(this.root);
            this.stage.setScene(scene);
            scene.getStylesheets().add((Object)"cssBase.css");
            this.stage.show();
        }
        catch (Exception e2) {
            System.out.println("No pudo cargar " + nombreVentana);
        }
    }

    private class MyEventHandler
    implements EventHandler<Event> {
        private MyEventHandler() {
        }

        public void handle(Event evt) {
            MetaLifeController.this.idTexto = ((Control)evt.getSource()).getId();
            MetaLifeController.this.MuestraTexto(MetaLifeController.this.idTexto);
        }
    }
}

