/*
 * Decompiled with CFR 0.152.
 */
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import javafx.util.Callback;

public class MetPlusCobController
implements Initializable {
    private GenSubs genSubs = GenSubs.getInstance();
    private DatosMetPlus datosMetPlus = DatosMetPlus.getInstance();
    private CalculosMetPlus calculosMetPlus = CalculosMetPlus.getInstance();
    private DatosVI datosvi = DatosVI.getInstance();
    private DatosGM datosGM = DatosGM.getInstance();
    private CotizMetPlus cotizMetPlus = CotizMetPlus.getInstance();
    Stage stage;
    Parent root;
    @FXML
    Label lblVersion;
    @FXML
    Label lblPlanSel;
    @FXML
    TextField nombre;
    @FXML
    ComboBox cmbParentesco;
    @FXML
    ComboBox cmbSumaBasica;
    @FXML
    RadioButton optMasculino;
    @FXML
    RadioButton optFemenino;
    @FXML
    TextField edad;
    @FXML
    CheckBox chkMujer;
    @FXML
    CheckBox chkPlus;
    @FXML
    CheckBox chkFamiliar;
    @FXML
    Button btnCotiz;
    @FXML
    TableView<AsegMetPlus> tblAseg;
    @FXML
    TableColumn tblNombreAseg;
    @FXML
    TableColumn tblParentescoAseg;
    @FXML
    TableColumn tblEdadAseg;
    @FXML
    TableColumn tblSexoAseg;
    @FXML
    TableColumn tblBasicoAseg;
    @FXML
    TableColumn tblMujerAseg;
    @FXML
    TableColumn tblPlusAseg;
    @FXML
    TableColumn tblFamiliarAseg;
    @FXML
    TableColumn tblPrimaAseg;
    @FXML
    ComboBox cmbFormaPago;
    @FXML
    Label lblPrimaNeta;
    @FXML
    Label lblRecargoFP;
    @FXML
    Label lblDerPol;
    @FXML
    Label lblSubTotal;
    @FXML
    Label lblIVA;
    @FXML
    Label lblPrimaTotal;
    @FXML
    Label lblPrimerPago;
    @FXML
    Label lblSubsecuentes;
    @FXML
    Label titPrimerPago;
    @FXML
    Label titSubsecuentes;
    String txtMensaje;
    String txtNombre;
    String txtParentesco;
    String txtEdad;
    String txtSexo;
    String txtBasico;
    String txtMujer;
    String txtPlus;
    String txtFamiliar;
    String txtPrima;
    Boolean asegValido;
    Integer edadMin;
    Integer edadMax;
    Boolean informacionValida;
    Boolean paqueteMujer = false;

    public void initialize(URL url, ResourceBundle rb) {
        this.tblNombreAseg.setCellValueFactory((Callback)new PropertyValueFactory("nombreAseg"));
        this.tblParentescoAseg.setCellValueFactory((Callback)new PropertyValueFactory("parentescoAseg"));
        this.tblEdadAseg.setCellValueFactory((Callback)new PropertyValueFactory("edadAseg"));
        this.tblSexoAseg.setCellValueFactory((Callback)new PropertyValueFactory("sexoAseg"));
        this.tblBasicoAseg.setCellValueFactory((Callback)new PropertyValueFactory("basicoAseg"));
        this.tblMujerAseg.setCellValueFactory((Callback)new PropertyValueFactory("mujerAseg"));
        this.tblPlusAseg.setCellValueFactory((Callback)new PropertyValueFactory("plusAseg"));
        this.tblFamiliarAseg.setCellValueFactory((Callback)new PropertyValueFactory("familiarAseg"));
        this.tblPrimaAseg.setCellValueFactory((Callback)new PropertyValueFactory("primaAseg"));
        this.tblAseg.setItems(this.datosMetPlus.listaAseg);
        this.InicializaVentana();
        this.ValoresIniciales();
        this.cmbParentesco.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                MetPlusCobController.this.RevisaParentescoSeleccionado();
            }
        });
        this.cmbFormaPago.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                MetPlusCobController.this.RevisaFormaPagoSeleccionado();
            }
        });
        this.cmbSumaBasica.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                MetPlusCobController.this.RevisaSumaBasica();
            }
        });
        this.nombre.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    MetPlusCobController.this.FormatoTituloNombre();
                }
            }
        });
        this.nombre.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaLetras(100));
        this.edad.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(3));
    }

    private void RevisaParentescoSeleccionado() {
        this.datosMetPlus.indexParentesco = this.cmbParentesco.getSelectionModel().getSelectedIndex();
        if (this.datosMetPlus.indexParentesco == 0) {
            this.cmbSumaBasica.setDisable(false);
        } else {
            this.cmbSumaBasica.setDisable(true);
        }
    }

    private void RevisaFormaPagoSeleccionado() {
        this.datosMetPlus.indexFormaPago = this.cmbFormaPago.getSelectionModel().getSelectedIndex();
        this.calculosMetPlus.CalculaPrimas();
        this.EscribeTotales();
    }

    private void RevisaSumaBasica() {
        this.datosMetPlus.indexSumaBasica = this.cmbSumaBasica.getSelectionModel().getSelectedIndex();
        switch (this.datosMetPlus.indexSumaBasica) {
            case 0: {
                this.datosMetPlus.sumaBasico = 500000;
                break;
            }
            case 1: {
                this.datosMetPlus.sumaBasico = 1000000;
                break;
            }
            case 2: {
                this.datosMetPlus.sumaBasico = 3000000;
                break;
            }
            case 3: {
                this.datosMetPlus.sumaBasico = 5000000;
            }
        }
    }

    public void AgregaAseg() {
        this.txtMensaje = "";
        Boolean continuar = true;
        if (continuar.booleanValue()) {
            Integer edadCapturada;
            int i;
            this.txtNombre = this.nombre.getText().toString();
            this.txtParentesco = this.datosMetPlus.lstParentesco.get(this.datosMetPlus.indexParentesco);
            if (this.edad.getText().equals("")) {
                this.edad.setText("0");
            }
            this.txtEdad = this.edad.getText().toString();
            this.txtSexo = this.optMasculino.isSelected() ? "M" : "F";
            this.asegValido = true;
            this.txtMensaje = "";
            if (this.txtNombre == "") {
                this.asegValido = false;
                this.txtMensaje = "Falta nombre del solicitante\r";
            }
            if (this.datosMetPlus.indexParentesco == 0 && this.datosMetPlus.listaAseg.size() > 0) {
                for (i = 0; i < this.datosMetPlus.listaAseg.size(); ++i) {
                    if (((AsegMetPlus)this.datosMetPlus.listaAseg.get(i)).getParentescoAseg() == "Titular") {
                        this.asegValido = false;
                    }
                    if (this.asegValido.booleanValue()) continue;
                    this.txtMensaje = this.txtMensaje + "Ya exite el titular";
                }
            }
            if (this.datosMetPlus.indexParentesco == 1 && this.datosMetPlus.listaAseg.size() > 0) {
                for (i = 0; i < this.datosMetPlus.listaAseg.size(); ++i) {
                    if (((AsegMetPlus)this.datosMetPlus.listaAseg.get(i)).getParentescoAseg() == "C\u00f3nyuge") {
                        this.asegValido = false;
                    }
                    if (this.asegValido.booleanValue()) continue;
                    this.txtMensaje = this.txtMensaje + "Ya exite C\u00f3nyuge";
                }
            }
            if ((edadCapturada = Integer.valueOf(Integer.parseInt(this.txtEdad))) > this.edadMax || edadCapturada < this.edadMin) {
                this.txtMensaje = "Edad fuera de rango v\u00e1lido";
                this.asegValido = false;
            }
            if (this.txtParentesco == "Hijo" && edadCapturada > 24) {
                this.txtMensaje = "La edad de los hijos debe ser menor a 25";
                this.asegValido = false;
            }
            if (this.asegValido.booleanValue()) {
                this.txtBasico = "Incluido";
                this.txtMujer = "";
                this.txtPlus = "";
                this.txtFamiliar = "";
                this.paqueteMujer = this.chkMujer.isSelected();
                if (this.chkMujer.isSelected()) {
                    this.txtMujer = "Incluido";
                }
                if (this.chkPlus.isSelected()) {
                    this.txtPlus = "Incluido";
                }
                if (this.chkFamiliar.isSelected()) {
                    this.txtFamiliar = "Incluido";
                }
                this.txtPrima = "$$";
                this.datosMetPlus.listaAseg.add((Object)new AsegMetPlus(this.txtNombre, this.txtParentesco, this.txtEdad, this.txtSexo, this.txtBasico, this.txtMujer, this.txtPlus, this.txtFamiliar, this.txtPrima));
                this.CalculaPrimas();
                this.nombre.setText("");
                this.edad.setText("");
                this.chkMujer.setSelected(false);
                this.chkPlus.setSelected(false);
                this.chkFamiliar.setSelected(false);
            } else {
                this.genSubs.MuestraMensaje(this.txtMensaje);
            }
        }
    }

    public void EliminaAseg() {
        if (this.tblAseg.getSelectionModel().getSelectedItem() != null) {
            AsegMetPlus asegMetPlus = (AsegMetPlus)this.tblAseg.getSelectionModel().getSelectedItem();
            this.datosMetPlus.listaAseg.remove((Object)asegMetPlus);
            this.CalculaPrimas();
        } else {
            this.genSubs.MuestraMensaje("Debe seleccionar un solicitante");
        }
    }

    public void ModificaAseg() {
        if (this.tblAseg.getSelectionModel().getSelectedItem() != null) {
            AsegMetPlus asegMetPlus = (AsegMetPlus)this.tblAseg.getSelectionModel().getSelectedItem();
            this.txtNombre = asegMetPlus.getNombreAseg();
            this.txtParentesco = asegMetPlus.getParentescoAseg();
            this.txtSexo = asegMetPlus.getSexoAseg();
            this.txtEdad = asegMetPlus.getEdadAseg();
            this.txtMujer = asegMetPlus.getMujerAseg();
            this.txtPlus = asegMetPlus.getPlusAseg();
            this.txtFamiliar = asegMetPlus.getFamiliarAseg();
            int index = this.txtParentesco == "Titular" ? 0 : (this.txtParentesco == "C\u00f3nyuge" ? 1 : (this.txtParentesco == "Hijo" ? 2 : 3));
            if (this.txtSexo == "M") {
                this.optMasculino.setSelected(true);
                this.chkMujer.setSelected(false);
                this.chkMujer.setDisable(true);
            } else {
                this.optFemenino.setSelected(true);
                this.chkMujer.setDisable(false);
            }
            if (this.txtMujer == "Incluido") {
                this.chkMujer.setSelected(true);
            } else {
                this.chkMujer.setSelected(false);
            }
            if (this.txtPlus == "Incluido") {
                this.chkPlus.setSelected(true);
            } else {
                this.chkPlus.setSelected(false);
            }
            if (this.txtFamiliar == "Incluido") {
                this.chkFamiliar.setSelected(true);
            } else {
                this.chkFamiliar.setSelected(false);
            }
            this.nombre.setText(this.txtNombre);
            this.edad.setText(this.txtEdad);
            this.cmbParentesco.getSelectionModel().select(index);
            this.EliminaAseg();
        }
    }

    private void CalculaPrimas() {
        if (this.datosMetPlus.listaAseg.size() > 0) {
            this.calculosMetPlus.CalculaPrimas();
            this.EscribeTotales();
        }
    }

    private void EscribeTotales() {
        this.lblPrimaNeta.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosMetPlus.primaNeta));
        this.lblRecargoFP.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosMetPlus.recargoFP));
        this.lblDerPol.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosMetPlus.derPolTotal));
        this.lblSubTotal.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosMetPlus.subTotal));
        this.lblIVA.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosMetPlus.IVA));
        this.lblPrimaTotal.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosMetPlus.primaTotal));
        if (this.datosMetPlus.indexFormaPago > 0) {
            this.titPrimerPago.setVisible(true);
            this.titSubsecuentes.setVisible(true);
            this.lblPrimerPago.setVisible(true);
            this.lblSubsecuentes.setVisible(true);
            this.lblPrimerPago.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosMetPlus.primerPago));
            this.lblSubsecuentes.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosMetPlus.subsecuentes));
        } else {
            this.titPrimerPago.setVisible(false);
            this.titSubsecuentes.setVisible(false);
            this.lblPrimerPago.setVisible(false);
            this.lblSubsecuentes.setVisible(false);
        }
    }

    public void VerCotizacion() {
        this.ValidaInformacion();
        if (this.informacionValida.booleanValue()) {
            this.cotizMetPlus.ImprimeCotizacion();
        } else {
            this.genSubs.MuestraMensaje(this.txtMensaje);
        }
    }

    private void ValidaInformacion() {
        this.informacionValida = true;
        this.txtMensaje = "";
        if (this.datosMetPlus.listaAseg.size() == 0) {
            this.txtMensaje = this.txtMensaje + "No hay asegurados";
            this.informacionValida = false;
        } else {
            this.datosMetPlus.nombreTitular = "";
            for (int i = 0; i < this.datosMetPlus.listaAseg.size(); ++i) {
                if (!((AsegMetPlus)this.datosMetPlus.listaAseg.get(i)).getParentescoAseg().equals("Titular")) continue;
                this.datosMetPlus.nombreTitular = ((AsegMetPlus)this.datosMetPlus.listaAseg.get(i)).getNombreAseg();
                this.datosMetPlus.edadTitular = Integer.parseInt(((AsegMetPlus)this.datosMetPlus.listaAseg.get(i)).getEdadAseg().toString());
                this.datosMetPlus.sexoTitular = ((AsegMetPlus)this.datosMetPlus.listaAseg.get(i)).getSexoAseg();
            }
            if (this.datosMetPlus.nombreTitular.equals("")) {
                this.txtMensaje = this.txtMensaje + "No hay titular";
                this.informacionValida = false;
            }
        }
    }

    private void FormatoTituloNombre() {
        String[] arr = this.nombre.getText().split(" ");
        StringBuffer sb = new StringBuffer();
        if (!this.nombre.getText().equals("")) {
            for (int i = 0; i < arr.length; ++i) {
                sb.append(Character.toUpperCase(arr[i].charAt(0))).append(arr[i].substring(1)).append(" ");
                this.nombre.setText(sb.toString().trim());
            }
        }
    }

    public void RevisaPaquetes() {
    }

    public void ClicSexo() {
        if (this.optMasculino.isSelected()) {
            this.chkMujer.setSelected(false);
            this.chkMujer.setDisable(true);
        } else {
            this.chkMujer.setDisable(false);
        }
    }

    private void InicializaVentana() {
        this.lblVersion.setText(this.datosvi.idVersion + this.datosvi.textoLegal);
        this.lblPlanSel.setText(this.datosvi.planSel);
        this.chkMujer.setDisable(true);
        this.LlenaCombos();
        this.tblParentescoAseg.getStyleClass().add((Object)"alineadoCentro2");
        this.tblEdadAseg.getStyleClass().add((Object)"alineadoCentro2");
        this.tblSexoAseg.getStyleClass().add((Object)"alineadoCentro2");
        this.tblPrimaAseg.getStyleClass().add((Object)"alineadoDerecha2");
    }

    private void ValoresIniciales() {
        this.datosMetPlus.indexParentesco = 0;
        this.datosMetPlus.indexFormaPago = 0;
        this.datosMetPlus.indexSumaBasica = 0;
        this.cmbParentesco.getSelectionModel().select(this.datosMetPlus.indexParentesco);
        this.cmbFormaPago.getSelectionModel().select(this.datosMetPlus.indexFormaPago);
        this.cmbSumaBasica.getSelectionModel().select(this.datosMetPlus.indexSumaBasica);
        this.datosMetPlus.primaNeta = 0.0;
        this.datosMetPlus.derPolTotal = 0.0;
        this.datosMetPlus.recargoFP = 0.0;
        this.datosMetPlus.subTotal = 0.0;
        this.datosMetPlus.IVA = 0.0;
        this.datosMetPlus.primaTotal = 0.0;
        this.datosMetPlus.primerPago = 0.0;
        this.datosMetPlus.subsecuentes = 0.0;
        this.RevisaSumaBasica();
        this.edadMin = 0;
        this.edadMax = 69;
        this.datosMetPlus.tarifaAcc = 2.3387302;
        this.datosMetPlus.tarifaAsistencia = 158.0;
        this.datosMetPlus.derPolAseg = 100.0;
        this.EscribeTotales();
    }

    private void LlenaCombos() {
        this.cmbFormaPago.getItems().clear();
        this.cmbFormaPago.getItems().addAll(this.datosGM.lstFormaPago);
        this.datosMetPlus.lstParentesco.clear();
        this.datosMetPlus.lstParentesco.add("Titular");
        this.datosMetPlus.lstParentesco.add("C\u00f3nyuge");
        this.datosMetPlus.lstParentesco.add("Hijo");
        this.datosMetPlus.lstParentesco.add("Otro");
        this.cmbParentesco.getItems().clear();
        this.cmbParentesco.getItems().addAll(this.datosMetPlus.lstParentesco);
        this.datosMetPlus.lstSumaBasica.clear();
        this.datosMetPlus.lstSumaBasica.add("500,000");
        this.datosMetPlus.lstSumaBasica.add("1,000,000");
        this.datosMetPlus.lstSumaBasica.add("3,000,000");
        this.datosMetPlus.lstSumaBasica.add("5,000,000");
        this.cmbSumaBasica.getItems().clear();
        this.cmbSumaBasica.getItems().addAll(this.datosMetPlus.lstSumaBasica);
    }

    public void RegresaInicio() {
        this.stage = (Stage)this.lblVersion.getScene().getWindow();
        this.MuestraVentana("Inicio.fxml");
    }

    private void MuestraVentana(String nombreVentana) {
        try {
            this.root = (Parent)FXMLLoader.load((URL)this.getClass().getResource(nombreVentana));
            Scene scene = new Scene(this.root);
            this.stage.setScene(scene);
            scene.getStylesheets().add((Object)"cssBase.css");
            this.stage.show();
        }
        catch (Exception e2) {
            System.out.println("No pudo cargar " + nombreVentana);
        }
    }
}

