/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;
import javafx.event.EventHandler;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;

public class GenSubs {
    private static GenSubs genSubs = new GenSubs();
    private Datos datos = Datos.getInstance();

    private GenSubs() {
    }

    public static GenSubs getInstance() {
        return genSubs;
    }

    public EventHandler<KeyEvent> ValidaLetras(final Integer max_Lengh) {
        return new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e2) {
                TextField txt_TextField = (TextField)e2.getSource();
                if (txt_TextField.getText().length() >= max_Lengh) {
                    e2.consume();
                }
                if (!e2.getCharacter().matches("[\u00e1\u00e9\u00ed\u00f3\u00fa\u00f1\u00d1a-zA-Z ]")) {
                    e2.consume();
                }
            }
        };
    }

    public EventHandler<KeyEvent> ValidaNumeros() {
        return new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e2) {
                TextField txt_TextField = (TextField)e2.getSource();
                if (!e2.getCharacter().matches("[0-9]")) {
                    e2.consume();
                }
            }
        };
    }

    public EventHandler<KeyEvent> ValidaNumerosNdigitos(final Integer numDig) {
        return new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e2) {
                TextField txt_TextField = (TextField)e2.getSource();
                if (e2.getCharacter().matches("[0-9]") || e2.getCharacter().matches("[.]")) {
                    if (txt_TextField.getLength() >= numDig) {
                        e2.consume();
                    }
                } else {
                    e2.consume();
                }
            }
        };
    }

    public String FormatoNumDouble(String Formato, Double valor) {
        DecimalFormat miFormato = new DecimalFormat(Formato);
        String valorConFormato = miFormato.format(valor);
        return valorConFormato;
    }

    public String FormatoNumInteger(String Formato, Integer valor) {
        DecimalFormat miFormato = new DecimalFormat(Formato);
        String valorConFormato = miFormato.format(valor);
        return valorConFormato;
    }

    public String QuitaComas(String string) {
        string = string.replaceAll(",", "");
        return string;
    }

    public void MuestraMensaje(String txtMensaje) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("");
        alert.setHeaderText("");
        alert.setContentText(txtMensaje);
        alert.showAndWait();
    }

    public String MuestraOkCancel(String txtMensaje) {
        String respuesta = "";
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("");
        alert.setHeaderText("");
        alert.setContentText(txtMensaje);
        Optional result = alert.showAndWait();
        respuesta = result.get() == ButtonType.OK ? "OK" : "Cancel";
        alert.showAndWait();
        return respuesta;
    }

    public void MuestraMensajeOK(String txtMensaje) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle("");
        alert.setHeaderText("");
        alert.setContentText(txtMensaje);
        alert.showAndWait();
    }

    public Integer IndiceCob(String idCob, String mon) {
        Integer indCob = -1;
        for (int i = 0; i < this.datos.lstIdCob.size(); ++i) {
            if (!this.datos.lstIdCob.get(i).equals(idCob) || !this.datos.lstMonCob.get(i).equals(mon)) continue;
            indCob = i;
        }
        if (indCob == -1) {
            System.out.println("NO encuentra indiceCob");
        }
        return indCob;
    }

    public Double Redondea(Double valor, Integer numDecimales) {
        double multipicationFactor = Math.pow(10.0, numDecimales.intValue());
        double interestedInZeroDPs = valor * multipicationFactor;
        return (double)Math.round(interestedInZeroDPs) / multipicationFactor;
    }

    public Integer VlookUpStrInt(String txtBuscado, List<String> lstBusqueda, List<Integer> lstValores) {
        Integer valor = 999;
        for (int i = 0; i < lstBusqueda.size(); ++i) {
            if (!txtBuscado.equals(lstBusqueda.get(i))) continue;
            valor = lstValores.get(i);
            break;
        }
        return valor;
    }

    public String VlookUpStrStr(String txtBuscado, List<String> lstBusqueda, List<String> lstValores) {
        String valor = "NA";
        for (int i = 0; i < lstBusqueda.size(); ++i) {
            if (!txtBuscado.equals(lstBusqueda.get(i))) continue;
            valor = lstValores.get(i);
            break;
        }
        return valor;
    }

    public Integer VlookUpStrIntInt(String txtBuscado, Integer intBuscado, List<String> lstBusquedaStr, List<Integer> lstBusquedaInt, List<Integer> lstValores) {
        Integer valor = 999;
        for (int i = 0; i < lstBusquedaStr.size(); ++i) {
            if (!txtBuscado.equals(lstBusquedaStr.get(i)) || intBuscado != lstBusquedaInt.get(i)) continue;
            valor = lstValores.get(i);
            break;
        }
        return valor;
    }

    public String VlookUpIntStr(Integer intBuscado, List<Integer> lstBusqueda, List<String> lstValores) {
        String valor = "NA";
        for (int i = 0; i < lstBusqueda.size(); ++i) {
            if (intBuscado != lstBusqueda.get(i)) continue;
            valor = lstValores.get(i);
            break;
        }
        return valor;
    }

    public Integer VlookUpIntInt(Integer intBuscado, List<Integer> lstBusqueda, List<Integer> lstValores) {
        Integer valor = 99;
        for (int i = 0; i < lstBusqueda.size(); ++i) {
            if (intBuscado != lstBusqueda.get(i)) continue;
            valor = lstValores.get(i);
            break;
        }
        return valor;
    }

    public Integer VlookUp2IntInt(Integer intBuscado1, Integer intBuscado2, List<Integer> lstBusqueda1, List<Integer> lstBusqueda2, List<Integer> lstValores) {
        Integer valor = 99;
        for (int i = 0; i < lstBusqueda1.size(); ++i) {
            if (intBuscado1 != lstBusqueda1.get(i) || intBuscado2 != lstBusqueda2.get(i)) continue;
            valor = lstValores.get(i);
            break;
        }
        return valor;
    }

    public Double VlookUp2IntDbl(Integer intBuscado1, Integer intBuscado2, List<Integer> lstBusqueda1, List<Integer> lstBusqueda2, List<Double> lstValores) {
        Double valor = 99.9;
        for (int i = 0; i < lstBusqueda1.size(); ++i) {
            if (intBuscado1 != lstBusqueda1.get(i) || intBuscado2 != lstBusqueda2.get(i)) continue;
            valor = lstValores.get(i);
            break;
        }
        return valor;
    }

    public Integer VlookUp3IntInt(Integer intBuscado1, Integer intBuscado2, Integer intBuscado3, List<Integer> lstBusqueda1, List<Integer> lstBusqueda2, List<Integer> lstBusqueda3, List<Integer> lstValores) {
        Integer valor = 99;
        for (int i = 0; i < lstBusqueda1.size(); ++i) {
            if (intBuscado1 != lstBusqueda1.get(i) || intBuscado2 != lstBusqueda2.get(i) || intBuscado3 != lstBusqueda3.get(i)) continue;
            valor = lstValores.get(i);
            break;
        }
        return valor;
    }

    public String VlookUp3IntStr(Integer intBuscado1, Integer intBuscado2, Integer intBuscado3, String txtBuscado, List<Integer> lstBusqueda1, List<Integer> lstBusqueda2, List<Integer> lstBusqueda3, List<String> lstBusquedaStr, List<String> lstValores) {
        String valor = "NA";
        for (int i = 0; i < lstBusqueda1.size(); ++i) {
            if (intBuscado1 != lstBusqueda1.get(i) || intBuscado2 != lstBusqueda2.get(i) || intBuscado3 != lstBusqueda3.get(i) || !txtBuscado.equals(lstBusquedaStr.get(i))) continue;
            valor = lstValores.get(i);
            break;
        }
        return valor;
    }

    public String VlookUp4IntStr(Integer intBuscado1, Integer intBuscado2, Integer intBuscado3, Integer intBuscado4, List<Integer> lstBusqueda1, List<Integer> lstBusqueda2, List<Integer> lstBusqueda3, List<Integer> lstBusqueda4, List<String> lstValores) {
        String valor = "NA";
        for (int i = 0; i < lstBusqueda1.size(); ++i) {
            if (intBuscado1 != lstBusqueda1.get(i) || intBuscado2 != lstBusqueda2.get(i) || intBuscado3 != lstBusqueda3.get(i) || !intBuscado4.equals(lstBusqueda4.get(i))) continue;
            valor = lstValores.get(i);
            break;
        }
        return valor;
    }

    public Integer VlookUp4IntInt(Integer intBuscado1, Integer intBuscado2, Integer intBuscado3, Integer intBuscado4, List<Integer> lstBusqueda1, List<Integer> lstBusqueda2, List<Integer> lstBusqueda3, List<Integer> lstBusqueda4, List<Integer> lstValores) {
        Integer valor = 999;
        for (int i = 0; i < lstBusqueda1.size(); ++i) {
            if (intBuscado1 != lstBusqueda1.get(i) || intBuscado2 != lstBusqueda2.get(i) || intBuscado3 != lstBusqueda3.get(i) || !intBuscado4.equals(lstBusqueda4.get(i))) continue;
            valor = lstValores.get(i);
            break;
        }
        return valor;
    }

    public Integer VlookUp3IntStrInt(Integer intBuscado1, Integer intBuscado2, Integer intBuscado3, String txtBuscado, List<Integer> lstBusqueda1, List<Integer> lstBusqueda2, List<Integer> lstBusqueda3, List<String> lstBusquedaStr, List<Integer> lstValores) {
        Integer valor = 999;
        for (int i = 0; i < lstBusqueda1.size(); ++i) {
            if (intBuscado1 != lstBusqueda1.get(i) || intBuscado2 != lstBusqueda2.get(i) || intBuscado3 != lstBusqueda3.get(i) || !txtBuscado.equals(lstBusquedaStr.get(i))) continue;
            valor = lstValores.get(i);
            break;
        }
        return valor;
    }

    public Integer VlookUp2IntStrInt(Integer intBuscado1, Integer intBuscado2, String txtBuscado, List<Integer> lstBusqueda1, List<Integer> lstBusqueda2, List<String> lstBusquedaStr, List<Integer> lstValores) {
        Integer valor = 999;
        for (int i = 0; i < lstBusqueda1.size(); ++i) {
            if (intBuscado1 != lstBusqueda1.get(i) || intBuscado2 != lstBusqueda2.get(i) || !txtBuscado.equals(lstBusquedaStr.get(i))) continue;
            valor = lstValores.get(i);
            break;
        }
        return valor;
    }

    public Double VlookUp3IntDbl(Integer intBuscado1, Integer intBuscado2, Integer intBuscado3, List<Integer> lstBusqueda1, List<Integer> lstBusqueda2, List<Integer> lstBusqueda3, List<Double> lstValores) {
        Double valor = 0.0;
        for (int i = 0; i < lstBusqueda1.size(); ++i) {
            if (intBuscado1 != lstBusqueda1.get(i) || intBuscado2 != lstBusqueda2.get(i) || intBuscado3 != lstBusqueda3.get(i)) continue;
            valor = lstValores.get(i);
            break;
        }
        return valor;
    }

    public Integer VlookUpIntStrInt(Integer intBuscado, String txtBuscado, List<Integer> lstBusquedaInt, List<String> lstBusquedaStr, List<Integer> lstValores) {
        Integer valor = 999;
        for (int i = 0; i < lstBusquedaStr.size(); ++i) {
            if (!txtBuscado.equals(lstBusquedaStr.get(i)) || intBuscado != lstBusquedaInt.get(i)) continue;
            valor = lstValores.get(i);
            break;
        }
        return valor;
    }

    public Integer VlookUpRango2IntInt(Integer intBuscado1, Integer intBuscado2, List<Integer> lstBusqueda1, List<Integer> lstBusqueda2, List<Integer> lstBusqueda3, List<Integer> lstBusqueda4, List<Integer> lstValores) {
        Integer valor = 99;
        for (int i = 0; i < lstBusqueda1.size(); ++i) {
            if (intBuscado1 < lstBusqueda1.get(i) || intBuscado1 > lstBusqueda2.get(i) || intBuscado2 < lstBusqueda3.get(i)) continue;
            if (lstBusqueda4.get(i) == 0) {
                valor = lstValores.get(i);
                continue;
            }
            if (intBuscado2 > lstBusqueda4.get(i)) continue;
            valor = lstValores.get(i);
        }
        return valor;
    }

    public Integer VlookUpRangoIntInt(Integer intBuscado1, List<Integer> lstBusqueda1, List<Integer> lstBusqueda2, List<Integer> lstValores) {
        Integer valor = 99;
        for (int i = 0; i < lstBusqueda1.size(); ++i) {
            if (intBuscado1 < lstBusqueda1.get(i)) continue;
            if (lstBusqueda2.get(i) == 0) {
                valor = lstValores.get(i);
                continue;
            }
            if (intBuscado1 > lstBusqueda2.get(i)) continue;
            valor = lstValores.get(i);
        }
        return valor;
    }
}

