/*
 * Decompiled with CFR 0.152.
 */
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.util.Callback;

public class FlexiCobController
implements Initializable {
    private DatosVI datosvi = DatosVI.getInstance();
    private GenSubs genSubs = GenSubs.getInstance();
    private CalculosFlexi calculosFlexi = CalculosFlexi.getInstance();
    private CotizFlexi cotizFlexi = CotizFlexi.getInstance();
    private Tablas tablas = Tablas.getInstance();
    Stage stage;
    Parent root;
    private final ObservableList<Inversion> listaInversion = FXCollections.observableArrayList();
    String txtCuenta;
    String txtMoneda;
    String txtLiquidez;
    String txtPeriodicidad;
    String txtImporte;
    List<String> nombreCuenta = new ArrayList<String>();
    List<String> nombreLiquidez = new ArrayList<String>();
    List<String> nombrePeriodicidad = new ArrayList<String>();
    int indiceCuenta;
    int indiceLiquidez;
    int indicePeriodicidad;
    Double importeInver;
    Boolean inversionValida;
    @FXML
    Label lblVersion;
    @FXML
    Label lblPlanSel;
    @FXML
    TextField nombreTitular;
    @FXML
    RadioButton optMasculino;
    @FXML
    RadioButton optFemenino;
    @FXML
    RadioButton optFuma;
    @FXML
    RadioButton optNoFuma;
    @FXML
    TextField edadReal;
    @FXML
    Label edadCalculo;
    @FXML
    ComboBox cmbPlazo;
    @FXML
    ComboBox cmbFormaPago;
    @FXML
    Label lblRiesgo;
    @FXML
    ComboBox cmbRiesgo;
    @FXML
    Label lblSalarioMinimo;
    @FXML
    TextField salarioMinimo;
    @FXML
    CheckBox chkEP;
    @FXML
    CheckBox chkPASI;
    @FXML
    CheckBox chkIMA;
    @FXML
    CheckBox chkDI;
    @FXML
    CheckBox chkTI;
    @FXML
    CheckBox chkEG;
    @FXML
    CheckBox chkGF;
    @FXML
    TextField sumaBAS;
    @FXML
    Label sumaEP;
    @FXML
    TextField sumaPASI;
    @FXML
    TextField sumaIMA;
    @FXML
    TextField sumaDI;
    @FXML
    TextField sumaTI;
    @FXML
    TextField sumaEG;
    @FXML
    Label sumaGF;
    @FXML
    Label primaBAS;
    @FXML
    Label primaEP;
    @FXML
    Label primaPASI;
    @FXML
    Label primaIMA;
    @FXML
    Label primaDI;
    @FXML
    Label primaTI;
    @FXML
    Label primaEG;
    @FXML
    Label primaGF;
    @FXML
    Label primaTOT;
    @FXML
    Label recargoFormaPago;
    @FXML
    Label primaFormaPago;
    @FXML
    Label lblRecargoFormaPago;
    @FXML
    Label lblPrimaFormaPago;
    @FXML
    Button verCotizacion;
    @FXML
    Label lblAhorro;
    @FXML
    ComboBox cmbCuenta;
    @FXML
    RadioButton optPesos;
    @FXML
    RadioButton optDolares;
    @FXML
    ComboBox cmbLiquidez;
    @FXML
    ComboBox cmbPeriodicidad;
    @FXML
    TextField txtImporteInver;
    @FXML
    TableView<Inversion> tblInversion;
    @FXML
    TableColumn tblCuentaInver;
    @FXML
    TableColumn tblMonedaInver;
    @FXML
    TableColumn tblLiquidezInver;
    @FXML
    TableColumn tblPeriodicidadInver;
    @FXML
    TableColumn tblImporteInver;
    @FXML
    CheckBox chkRango;
    @FXML
    Label lblDesde;
    @FXML
    TextField hastaAno;
    @FXML
    Label lblUnoEnUno;
    @FXML
    Label lblLuego;
    @FXML
    TextField rangoLuego;
    @FXML
    Label lblAnos;
    @FXML
    AnchorPane paneAportaciones;
    @FXML
    AnchorPane paneTasas;
    @FXML
    TextField tasaDiariaMN;
    @FXML
    TextField tasaMensualMN;
    @FXML
    TextField tasaTrimestralMN;
    @FXML
    TextField tasaSemestralMN;
    @FXML
    TextField tasaDiariaDls;
    @FXML
    TextField tasaMensualDls;
    @FXML
    Button btnTasasRendimiento;
    Integer edadMinima;
    String txtMensaje;
    Integer edadMin;
    Integer edadMax;
    Integer valorTmp;
    Integer tmpInt;
    Double tmpDouble;
    Integer sumaMinima;
    Integer sumaMaxima;
    Boolean aportacionesValidas;
    Boolean tasasValidas;

    public void initialize(URL url, ResourceBundle rb) {
        this.tblCuentaInver.setCellValueFactory((Callback)new PropertyValueFactory("cuentaInver"));
        this.tblMonedaInver.setCellValueFactory((Callback)new PropertyValueFactory("monedaInver"));
        this.tblLiquidezInver.setCellValueFactory((Callback)new PropertyValueFactory("liquidezInver"));
        this.tblPeriodicidadInver.setCellValueFactory((Callback)new PropertyValueFactory("periodicidadInver"));
        this.tblImporteInver.setCellValueFactory((Callback)new PropertyValueFactory("importeInver"));
        this.tblInversion.setItems(this.listaInversion);
        this.InicializaVentana();
        this.ValoresIniciales();
        this.SeleccionaCuentaInversion();
        this.nombreTitular.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    FlexiCobController.this.FormatoTituloNombre();
                }
            }
        });
        this.edadReal.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    FlexiCobController.this.RevisaEdadReal();
                }
            }
        });
        this.cmbPlazo.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                FlexiCobController.this.RevisaPlazoSeleccionado();
            }
        });
        this.cmbCuenta.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                FlexiCobController.this.RevisaCuenta();
            }
        });
        this.cmbLiquidez.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                FlexiCobController.this.RevisaLiquidez();
            }
        });
        this.cmbPeriodicidad.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                FlexiCobController.this.RevisaPeriodicidad();
            }
        });
        this.cmbFormaPago.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                FlexiCobController.this.RevisaFormaPagoSeleccionado();
            }
        });
        this.cmbRiesgo.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                FlexiCobController.this.RevisaRiesgoSeleccionado();
            }
        });
        this.sumaBAS.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    FlexiCobController.this.ValidaSumaBAS();
                }
            }
        });
        this.sumaPASI.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    FlexiCobController.this.ValidaSumaPASI();
                }
            }
        });
        this.sumaIMA.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    FlexiCobController.this.ValidaSumaIMA();
                }
            }
        });
        this.sumaDI.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    FlexiCobController.this.ValidaSumaDI();
                }
            }
        });
        this.sumaTI.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    FlexiCobController.this.ValidaSumaTI();
                }
            }
        });
        this.sumaEG.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    FlexiCobController.this.ValidaSumaEG();
                }
            }
        });
        this.txtImporteInver.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    FlexiCobController.this.ValidaImporteInver();
                }
            }
        });
        this.nombreTitular.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaLetras(100));
        this.edadReal.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(3));
        this.sumaBAS.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(12));
        this.sumaPASI.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(12));
        this.sumaIMA.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(12));
        this.sumaDI.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(12));
        this.sumaTI.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(12));
        this.sumaEG.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(12));
        this.salarioMinimo.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(5));
        this.tasaDiariaMN.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(5));
        this.tasaMensualMN.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(5));
        this.tasaTrimestralMN.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(5));
        this.tasaSemestralMN.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(5));
        this.tasaDiariaDls.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(5));
        this.tasaMensualDls.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(5));
    }

    private void RevisaEdadReal() {
        this.datosvi.edadReal = Integer.parseInt(this.edadReal.getText().toString());
        this.DeterminaEdadCalculo();
        this.RevisaBeneficiosAdicionales();
        this.RevisaLimitesEdad();
        if (!this.txtMensaje.equals("")) {
            this.genSubs.MuestraMensaje(this.txtMensaje);
            this.verCotizacion.setDisable(true);
        } else {
            this.CalculaPrimas();
            this.verCotizacion.setDisable(false);
        }
    }

    private void RevisaPlazoSeleccionado() {
        if (this.cmbPlazo.getItems().size() > 0) {
            this.datosvi.indexPlazo = this.cmbPlazo.getSelectionModel().getSelectedIndex();
            this.datosvi.txtPlazoSel = this.cmbPlazo.getValue().toString();
            this.datosvi.plazoSel = this.datosvi.txtPlazoSel.equals("Edad 65") ? Integer.valueOf(65) : Integer.valueOf(Integer.parseInt(this.datosvi.txtPlazoSel));
            this.RevisaLimitesEdad();
            this.DeterminaEdadCalculo();
            this.DeterminaSumaMinima();
            this.ActualizaSumaBeneficios();
            this.BorraInversiones();
            this.MuestraValoresInversion();
            this.SeleccionaCuentaInversion();
            if (!this.txtMensaje.equals("")) {
                this.genSubs.MuestraMensaje(this.txtMensaje);
                this.verCotizacion.setDisable(true);
            } else {
                this.CalculaPrimas();
                this.verCotizacion.setDisable(false);
            }
        }
    }

    private void BorraInversiones() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 6; ++j) {
                for (int k = 0; k < 4; ++k) {
                    this.datosvi.Aportacion[i][j][k] = 0.0;
                }
            }
        }
    }

    private void RevisaRiesgoSeleccionado() {
        this.datosvi.indexRiesgo = this.cmbRiesgo.getSelectionModel().getSelectedIndex();
        if (this.datosvi.indexRiesgo == 1 && this.datosvi.sumaBAS < 2500000) {
            this.datosvi.sumaBAS = 2500000;
            this.sumaBAS.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaBAS));
            this.ActualizaSumaBeneficios();
        }
        this.CalculaPrimas();
    }

    private void RevisaFormaPagoSeleccionado() {
        this.datosvi.indexFormaPago = this.cmbFormaPago.getSelectionModel().getSelectedIndex();
        if (this.datosvi.indexFormaPago == 0) {
            this.datosvi.idFormaPagoSel = 1;
            this.datosvi.numPagos = 1;
            this.datosvi.formaPagoSel = "Anual";
        }
        if (this.datosvi.indexFormaPago == 1) {
            this.datosvi.idFormaPagoSel = 2;
            this.datosvi.numPagos = 2;
            this.lblPrimaFormaPago.setText("Prima semestral");
            this.datosvi.formaPagoSel = "Semestral";
        }
        if (this.datosvi.indexFormaPago == 2) {
            this.datosvi.idFormaPagoSel = 3;
            this.datosvi.numPagos = 4;
            this.lblPrimaFormaPago.setText("Prima trimestral");
            this.datosvi.formaPagoSel = "Trimestral";
        }
        if (this.datosvi.indexFormaPago == 3) {
            this.datosvi.idFormaPagoSel = 4;
            this.datosvi.numPagos = 12;
            this.lblPrimaFormaPago.setText("Prima mensual");
            this.datosvi.formaPagoSel = "Mensual";
        }
        this.CalculaPrimaFormaPago();
    }

    private void RevisaCuenta() {
        this.datosvi.indexCuenta = this.cmbCuenta.getSelectionModel().getSelectedIndex();
        this.MuestraValoresInversion();
    }

    private void RevisaLiquidez() {
        this.datosvi.indexLiquidez = this.cmbLiquidez.getSelectionModel().getSelectedIndex();
    }

    private void RevisaPeriodicidad() {
        this.datosvi.indexPeriodicidad = this.cmbPeriodicidad.getSelectionModel().getSelectedIndex();
    }

    public void AgregaInversion() {
        this.txtMensaje = "";
        this.indiceCuenta = this.datosvi.indexCuenta;
        this.indiceLiquidez = this.optPesos.isSelected() ? this.datosvi.indexLiquidez : this.datosvi.indexLiquidez + 4;
        this.indicePeriodicidad = this.datosvi.indexPeriodicidad;
        this.inversionValida = true;
        if (this.datosvi.Aportacion[this.indiceCuenta][this.indiceLiquidez][this.indicePeriodicidad] > 0.0) {
            this.inversionValida = false;
            this.txtMensaje = "Ya existe la inversi\u00f3n\r";
        }
        this.ValidaAportacionInicialMinima();
        if (this.inversionValida.booleanValue()) {
            this.txtCuenta = this.nombreCuenta.get(this.datosvi.indexCuenta);
            this.txtMoneda = this.optPesos.isSelected() ? "Pesos" : "USD";
            this.txtLiquidez = this.nombreLiquidez.get(this.datosvi.indexLiquidez);
            this.txtPeriodicidad = this.nombrePeriodicidad.get(this.datosvi.indexPeriodicidad);
            if (this.txtImporteInver.getText().equals("")) {
                this.txtImporteInver.setText("0");
            }
            this.txtImporte = this.txtImporteInver.getText().toString();
            this.listaInversion.add((Object)new Inversion(this.txtCuenta, this.txtMoneda, this.txtLiquidez, this.txtPeriodicidad, this.txtImporte));
            this.txtImporte = this.genSubs.QuitaComas(this.txtImporteInver.getText().toString());
            this.importeInver = Double.parseDouble(this.txtImporte);
            this.txtImporteInver.clear();
            this.datosvi.Aportacion[this.indiceCuenta][this.indiceLiquidez][this.indicePeriodicidad] = this.importeInver;
        } else {
            this.genSubs.MuestraMensaje(this.txtMensaje);
        }
    }

    private void ValidaAportacionInicialMinima() {
        if (this.txtImporteInver.getText().equals("") || this.txtImporteInver.getText().equals("0")) {
            this.inversionValida = false;
            this.txtMensaje = this.txtMensaje + "El importe no debe ser cero\r";
        } else if (this.datosvi.indexPeriodicidad == 0) {
            this.txtImporte = this.genSubs.QuitaComas(this.txtImporteInver.getText().toString());
            this.importeInver = Double.parseDouble(this.txtImporte);
            int indice = this.optPesos.isSelected() ? this.datosvi.indexLiquidez : this.datosvi.indexLiquidez + 4;
            if (this.importeInver < this.datosvi.aptMinima[indice]) {
                this.inversionValida = false;
                this.txtMensaje = this.txtMensaje + "La aportaci\u00f3n inicial en " + this.datosvi.nombreLiquidez[indice] + " debe ser al menos de " + this.genSubs.FormatoNumDouble("###,###", this.datosvi.aptMinima[indice]) + "\r";
            }
        }
    }

    public void EliminaInversion() {
        if (this.tblInversion.getSelectionModel().getSelectedItem() != null) {
            Inversion inversion = (Inversion)this.tblInversion.getSelectionModel().getSelectedItem();
            this.listaInversion.remove((Object)inversion);
            this.ActualizaVectorInversion();
        } else {
            this.genSubs.MuestraMensaje("Debe seleccionar una inversi\u00f3on");
        }
    }

    public void ModificaInversion() {
        if (this.tblInversion.getSelectionModel().getSelectedItem() != null) {
            Inversion inversion = (Inversion)this.tblInversion.getSelectionModel().getSelectedItem();
            String cuenta = inversion.getCuentaInver();
            String moneda = inversion.getMonedaInver();
            String liquidez = inversion.getLiquidezInver();
            String periodicidad = inversion.getPeriodicidadInver();
            moneda = inversion.getMonedaInver();
            String importe = inversion.getImporteInver();
            this.DeterminaIndices(cuenta, moneda, liquidez, periodicidad);
            this.cmbCuenta.getSelectionModel().select(this.indiceCuenta);
            this.cmbLiquidez.getSelectionModel().select(this.indiceLiquidez);
            if (moneda == "Pesos") {
                this.optPesos.setSelected(true);
            } else {
                this.optPesos.setSelected(false);
            }
            this.cmbPeriodicidad.getSelectionModel().select(this.indicePeriodicidad);
            this.txtImporteInver.setText(importe);
            this.listaInversion.remove((Object)inversion);
            this.ActualizaVectorInversion();
        } else {
            this.genSubs.MuestraMensaje("Debe seleccionar una inversi\u00f3on");
        }
    }

    private void ActualizaVectorInversion() {
        this.BorraInversiones();
        if (this.listaInversion.size() > 0) {
            for (int i = 0; i < this.listaInversion.size(); ++i) {
                String cuenta = ((Inversion)this.listaInversion.get(i)).getCuentaInver();
                String moneda = ((Inversion)this.listaInversion.get(i)).getMonedaInver();
                String liquidez = ((Inversion)this.listaInversion.get(i)).getLiquidezInver();
                String periodicidad = ((Inversion)this.listaInversion.get(i)).getPeriodicidadInver();
                String importe = this.genSubs.QuitaComas(((Inversion)this.listaInversion.get(i)).getImporteInver());
                this.DeterminaIndices(cuenta, moneda, liquidez, periodicidad);
                this.datosvi.Aportacion[this.indiceCuenta][this.indiceLiquidez][this.indicePeriodicidad] = this.importeInver = Double.valueOf(Double.parseDouble(importe));
            }
        }
    }

    private void DeterminaIndices(String cuenta, String moneda, String liquidez, String periodicidad) {
        this.indiceCuenta = cuenta == "PPR" ? 0 : (cuenta == "CPEA" ? 1 : 2);
        this.indiceLiquidez = liquidez == "Diaria" ? 0 : (liquidez == "Mensual" ? 1 : (liquidez == "Trimestral" ? 2 : 3));
        if (moneda == "USD") {
            this.indiceLiquidez += 4;
        }
        this.indicePeriodicidad = periodicidad == "Inicial" ? 0 : (periodicidad == "Mensual" ? 1 : (periodicidad == "Trimestral" ? 2 : 3));
    }

    private void ActualizaSumaBeneficios() {
        this.datosvi.sumaPASI = this.ActualizaSumaCobertura(this.datosvi.selPASI, this.datosvi.sumaPASI, "PASI");
        this.sumaPASI.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaPASI));
        this.datosvi.sumaIMA = this.ActualizaSumaCobertura(this.datosvi.selIMA, this.datosvi.sumaIMA, "ACC");
        this.sumaIMA.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaIMA));
        this.datosvi.sumaDI = this.ActualizaSumaCobertura(this.datosvi.selDI, this.datosvi.sumaDI, "ACC");
        this.sumaDI.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaDI));
        this.datosvi.sumaTI = this.ActualizaSumaCobertura(this.datosvi.selTI, this.datosvi.sumaIMA, "ACC");
        this.sumaTI.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaTI));
        this.datosvi.sumaEG = this.ActualizaSumaCobertura(this.datosvi.selEG, this.datosvi.sumaEG, "EG");
        this.sumaEG.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaEG));
        this.datosvi.sumaGF = this.ActualizaSumaCobertura(this.datosvi.selGF, this.datosvi.sumaEG, "GF");
        this.sumaGF.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaGF));
        if (this.datosvi.selEP.booleanValue()) {
            this.ActualizaSumaEP();
        }
        this.CalculaPrimas();
    }

    private Integer ActualizaSumaCobertura(Boolean selCobertura, Integer sumaCobertura, String idCobertura) {
        Integer sumaAsegurada;
        if (selCobertura.booleanValue()) {
            sumaAsegurada = this.datosvi.sumaBAS;
            this.valorTmp = this.genSubs.VlookUpStrIntInt(idCobertura, this.datosvi.idMonedaSel, this.datosvi.lstIdBeneficioSumas, this.datosvi.lstIdMonedaSumas, this.datosvi.lstSumaMaxBeneficio);
            if (sumaAsegurada > this.valorTmp && this.valorTmp > 0) {
                sumaAsegurada = this.valorTmp;
            }
            this.valorTmp = this.genSubs.VlookUpStrIntInt(idCobertura, this.datosvi.idMonedaSel, this.datosvi.lstIdBeneficioSumas, this.datosvi.lstIdMonedaSumas, this.datosvi.lstSumaMinBeneficio);
            if (sumaCobertura < this.valorTmp) {
                sumaAsegurada = this.valorTmp;
            }
        } else {
            sumaAsegurada = 0;
        }
        return sumaAsegurada;
    }

    private void ActualizaSumaEP() {
        this.datosvi.sumaEP = (double)(this.datosvi.sumaBAS + this.datosvi.sumaGF + this.datosvi.recargoFijo) * 1.0;
    }

    private void RevisaLimitesEdad() {
        this.txtMensaje = "";
        this.chkEP.setDisable(true);
        this.chkPASI.setDisable(false);
        this.chkIMA.setDisable(false);
        this.chkDI.setDisable(false);
        this.chkTI.setDisable(false);
        this.chkEG.setDisable(false);
        this.chkGF.setDisable(false);
        this.edadMin = this.EdadMinMax(this.datosvi.idPlanSel, this.datosvi.plazoSel, "BAS", "Min");
        this.edadMax = this.EdadMinMax(this.datosvi.idPlanSel, this.datosvi.plazoSel, "BAS", "Max");
        if (this.datosvi.edadReal < this.edadMin || this.datosvi.edadReal > this.edadMax) {
            this.txtMensaje = "La edad est\u00e1 fuera de rango\r";
        } else if (this.datosvi.idPlanSel == 32) {
            this.RevisaEdadBeneficios();
        }
    }

    private void RevisaEdadBeneficios() {
        this.edadMin = this.EdadMinMax(this.datosvi.idPlanSel, this.datosvi.plazoSel, "EP", "Min");
        this.edadMax = this.EdadMinMax(this.datosvi.idPlanSel, this.datosvi.plazoSel, "EP", "Max");
        if (this.datosvi.edadReal < this.edadMin || this.datosvi.edadReal > this.edadMax) {
            this.chkEP.setSelected(false);
            this.datosvi.selEP = false;
            this.sumaEP.setText("Excluido");
        } else {
            this.chkEP.setSelected(true);
            this.datosvi.selEP = true;
            this.datosvi.selEP = this.chkEP.isSelected();
            this.sumaEP.setText("Cubierto");
        }
        this.edadMin = this.EdadMinMax(this.datosvi.idPlanSel, this.datosvi.plazoSel, "PASI", "Min");
        this.edadMax = this.EdadMinMax(this.datosvi.idPlanSel, this.datosvi.plazoSel, "PASI", "Max");
        if (this.datosvi.edadReal < this.edadMin || this.datosvi.edadReal > this.edadMax) {
            this.chkPASI.setSelected(false);
            this.chkPASI.setDisable(true);
            this.datosvi.selPASI = false;
            this.sumaPASI.setVisible(false);
        }
        this.edadMin = this.EdadMinMax(this.datosvi.idPlanSel, this.datosvi.plazoSel, "IMA", "Min");
        this.edadMax = this.EdadMinMax(this.datosvi.idPlanSel, this.datosvi.plazoSel, "IMA", "Max");
        if (this.datosvi.edadReal < this.edadMin || this.datosvi.edadReal > this.edadMax) {
            this.chkIMA.setSelected(false);
            this.chkIMA.setDisable(true);
            this.datosvi.selIMA = false;
            this.sumaIMA.setVisible(false);
        }
        this.edadMin = this.EdadMinMax(this.datosvi.idPlanSel, this.datosvi.plazoSel, "DI", "Min");
        this.edadMax = this.EdadMinMax(this.datosvi.idPlanSel, this.datosvi.plazoSel, "DI", "Max");
        if (this.datosvi.edadReal < this.edadMin || this.datosvi.edadReal > this.edadMax) {
            this.chkDI.setSelected(false);
            this.chkDI.setDisable(true);
            this.datosvi.selDI = false;
            this.sumaDI.setVisible(false);
        }
        this.edadMin = this.EdadMinMax(this.datosvi.idPlanSel, this.datosvi.plazoSel, "TI", "Min");
        this.edadMax = this.EdadMinMax(this.datosvi.idPlanSel, this.datosvi.plazoSel, "TI", "Max");
        if (this.datosvi.edadReal < this.edadMin || this.datosvi.edadReal > this.edadMax || this.datosvi.idPlanSel == 6 || this.datosvi.idPlanSel == 8) {
            this.chkTI.setSelected(false);
            this.chkTI.setDisable(true);
            this.datosvi.selTI = false;
            this.sumaTI.setVisible(false);
        }
        this.edadMin = this.EdadMinMax(this.datosvi.idPlanSel, this.datosvi.plazoSel, "EG", "Min");
        this.edadMax = this.EdadMinMax(this.datosvi.idPlanSel, this.datosvi.plazoSel, "EG", "Max");
        if (this.datosvi.edadReal < this.edadMin || this.datosvi.edadReal > this.edadMax) {
            this.chkEG.setSelected(false);
            this.chkEG.setDisable(true);
            this.datosvi.selEG = false;
            this.sumaEG.setVisible(false);
        }
    }

    public void ValidaPASI() {
        this.datosvi.selPASI = this.chkPASI.isSelected();
        if (this.chkPASI.isSelected()) {
            this.datosvi.sumaPASI = this.datosvi.sumaBAS;
            this.sumaPASI.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaPASI));
            this.sumaPASI.setVisible(true);
            this.primaPASI.setVisible(true);
            this.valorTmp = this.genSubs.VlookUpStrIntInt("PASI", this.datosvi.idMonedaSel, this.datosvi.lstIdBeneficioSumas, this.datosvi.lstIdMonedaSumas, this.datosvi.lstSumaMaxBeneficio);
            if (this.datosvi.sumaPASI > this.valorTmp && this.valorTmp > 0) {
                this.datosvi.sumaPASI = this.valorTmp;
                this.sumaPASI.setText(this.genSubs.FormatoNumInteger("###,###", this.valorTmp));
            }
        } else {
            this.sumaPASI.setVisible(false);
            this.primaPASI.setVisible(false);
        }
        this.CalculaPrimas();
    }

    public void ClicIMA() {
        if (this.chkIMA.isSelected()) {
            this.sumaIMA.setVisible(true);
            this.primaIMA.setVisible(true);
            this.datosvi.selIMA = true;
            this.chkDI.setSelected(false);
            this.sumaDI.setVisible(false);
            this.primaDI.setVisible(false);
            this.datosvi.selDI = false;
            this.datosvi.sumaDI = 0;
            this.datosvi.primaDI = 0.0;
            this.chkTI.setSelected(false);
            this.sumaTI.setVisible(false);
            this.primaTI.setVisible(false);
            this.datosvi.selTI = false;
            this.datosvi.sumaTI = 0;
            this.datosvi.primaTI = 0.0;
        } else {
            this.sumaIMA.setVisible(false);
            this.primaIMA.setVisible(false);
            this.datosvi.sumaIMA = 0;
            this.datosvi.primaIMA = 0.0;
        }
        this.ValidaAccidentes();
    }

    public void ClicDI() {
        if (this.chkDI.isSelected()) {
            this.sumaDI.setVisible(true);
            this.primaDI.setVisible(true);
            this.datosvi.selDI = true;
            this.chkIMA.setSelected(false);
            this.sumaIMA.setVisible(false);
            this.primaIMA.setVisible(false);
            this.datosvi.selIMA = false;
            this.datosvi.sumaIMA = 0;
            this.datosvi.primaIMA = 0.0;
            this.chkTI.setSelected(false);
            this.sumaTI.setVisible(false);
            this.primaTI.setVisible(false);
            this.datosvi.selTI = false;
            this.datosvi.sumaTI = 0;
            this.datosvi.primaTI = 0.0;
        } else {
            this.sumaDI.setVisible(false);
            this.primaDI.setVisible(false);
            this.datosvi.sumaDI = 0;
            this.datosvi.primaDI = 0.0;
        }
        this.ValidaAccidentes();
    }

    public void ClicTI() {
        if (this.chkTI.isSelected()) {
            this.sumaTI.setVisible(true);
            this.primaTI.setVisible(true);
            this.datosvi.selTI = true;
            this.chkDI.setSelected(false);
            this.sumaDI.setVisible(false);
            this.primaDI.setVisible(false);
            this.datosvi.selDI = false;
            this.datosvi.sumaDI = 0;
            this.datosvi.primaDI = 0.0;
            this.chkIMA.setSelected(false);
            this.sumaIMA.setVisible(false);
            this.primaIMA.setVisible(false);
            this.datosvi.selIMA = false;
            this.datosvi.sumaIMA = 0;
            this.datosvi.primaIMA = 0.0;
        } else {
            this.sumaTI.setVisible(false);
            this.primaTI.setVisible(false);
            this.datosvi.sumaTI = 0;
            this.datosvi.primaTI = 0.0;
        }
        this.ValidaAccidentes();
    }

    private void ValidaAccidentes() {
        if (this.chkIMA.isSelected()) {
            this.datosvi.selIMA = true;
            this.datosvi.sumaIMA = this.datosvi.sumaBAS;
            this.sumaIMA.setVisible(true);
            this.primaIMA.setVisible(true);
            this.sumaIMA.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaIMA));
            this.valorTmp = this.genSubs.VlookUpStrIntInt("ACC", this.datosvi.idMonedaSel, this.datosvi.lstIdBeneficioSumas, this.datosvi.lstIdMonedaSumas, this.datosvi.lstSumaMaxBeneficio);
            if (this.datosvi.sumaIMA > this.valorTmp && this.valorTmp > 0) {
                this.datosvi.sumaIMA = this.valorTmp;
                this.sumaIMA.setText(this.genSubs.FormatoNumInteger("###,###", this.valorTmp));
            }
        }
        if (this.chkDI.isSelected()) {
            this.datosvi.selDI = true;
            this.datosvi.sumaDI = this.datosvi.sumaBAS;
            this.sumaDI.setVisible(true);
            this.primaDI.setVisible(true);
            this.sumaDI.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaDI));
            this.valorTmp = this.genSubs.VlookUpStrIntInt("ACC", this.datosvi.idMonedaSel, this.datosvi.lstIdBeneficioSumas, this.datosvi.lstIdMonedaSumas, this.datosvi.lstSumaMaxBeneficio);
            if (this.datosvi.sumaDI > this.valorTmp && this.valorTmp > 0) {
                this.datosvi.sumaDI = this.valorTmp;
                this.sumaDI.setText(this.genSubs.FormatoNumInteger("###,###", this.valorTmp));
            }
        }
        if (this.chkTI.isSelected()) {
            this.datosvi.selTI = true;
            this.datosvi.sumaTI = this.datosvi.sumaBAS;
            this.sumaTI.setVisible(true);
            this.primaTI.setVisible(true);
            this.sumaTI.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaTI));
            this.valorTmp = this.genSubs.VlookUpStrIntInt("ACC", this.datosvi.idMonedaSel, this.datosvi.lstIdBeneficioSumas, this.datosvi.lstIdMonedaSumas, this.datosvi.lstSumaMaxBeneficio);
            if (this.datosvi.sumaTI > this.valorTmp && this.valorTmp > 0) {
                this.datosvi.sumaTI = this.valorTmp;
                this.sumaTI.setText(this.genSubs.FormatoNumInteger("###,###", this.valorTmp));
            }
        }
        if (!(this.chkIMA.isSelected() || this.chkDI.isSelected() || this.chkTI.isSelected())) {
            this.datosvi.selIMA = false;
            this.sumaIMA.setVisible(false);
            this.primaIMA.setVisible(false);
            this.datosvi.selIMA = false;
            this.datosvi.sumaIMA = 0;
            this.datosvi.primaIMA = 0.0;
            this.datosvi.selDI = false;
            this.sumaDI.setVisible(false);
            this.primaDI.setVisible(false);
            this.datosvi.selDI = false;
            this.datosvi.sumaDI = 0;
            this.datosvi.primaDI = 0.0;
            this.datosvi.selTI = false;
            this.sumaTI.setVisible(false);
            this.primaTI.setVisible(false);
            this.datosvi.selTI = false;
            this.datosvi.sumaTI = 0;
            this.datosvi.primaTI = 0.0;
        }
        this.CalculaPrimas();
    }

    public void ValidaEG() {
        this.datosvi.selEG = this.chkEG.isSelected();
        if (this.chkEG.isSelected()) {
            this.datosvi.sumaEG = this.datosvi.sumaBAS;
            this.sumaEG.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaEG));
            this.sumaEG.setVisible(true);
            this.primaEG.setVisible(true);
            this.valorTmp = this.genSubs.VlookUpStrIntInt("EG", this.datosvi.idMonedaSel, this.datosvi.lstIdBeneficioSumas, this.datosvi.lstIdMonedaSumas, this.datosvi.lstSumaMaxBeneficio);
            if (this.datosvi.sumaEG > this.valorTmp && this.valorTmp > 0) {
                this.datosvi.sumaEG = this.valorTmp;
                this.sumaEG.setText(this.genSubs.FormatoNumInteger("###,###", this.valorTmp));
            }
        } else {
            this.sumaEG.setVisible(false);
            this.primaEG.setVisible(false);
        }
        this.CalculaPrimas();
    }

    public void ValidaGF() {
        this.datosvi.selGF = this.chkGF.isSelected();
        if (this.chkGF.isSelected()) {
            this.datosvi.sumaGF = this.datosvi.sumaBAS;
            this.sumaGF.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaGF));
            this.sumaGF.setVisible(true);
            this.primaGF.setVisible(true);
            this.valorTmp = this.genSubs.VlookUpStrIntInt("GF", this.datosvi.idMonedaSel, this.datosvi.lstIdBeneficioSumas, this.datosvi.lstIdMonedaSumas, this.datosvi.lstSumaMaxBeneficio);
            if (this.datosvi.sumaGF > this.valorTmp && this.valorTmp > 0) {
                this.datosvi.sumaGF = this.valorTmp;
                this.sumaGF.setText(this.genSubs.FormatoNumInteger("###,###", this.valorTmp));
            }
        } else {
            this.sumaGF.setVisible(false);
            this.primaGF.setVisible(false);
        }
        this.CalculaPrimas();
    }

    private Integer EdadMinMax(Integer idPlan, Integer plazo, String idCobertura, String tipo) {
        Integer edad = tipo.equals("Min") ? this.genSubs.VlookUp2IntStrInt(idPlan, plazo, idCobertura, this.datosvi.lstIdPlanEdad, this.datosvi.lstPlazoEdad, this.datosvi.lstIdBeneficio, this.datosvi.lstEdadMin) : this.genSubs.VlookUp2IntStrInt(idPlan, plazo, idCobertura, this.datosvi.lstIdPlanEdad, this.datosvi.lstPlazoEdad, this.datosvi.lstIdBeneficio, this.datosvi.lstEdadMax);
        return edad;
    }

    private void DeterminaSumaMinima() {
        Integer sumaMinBas = this.genSubs.VlookUpIntInt(this.datosvi.idPlanSel, this.datosvi.lstIdPlanSumaMin, this.datosvi.lstSumaMin);
        if (this.datosvi.sumaBAS < sumaMinBas) {
            this.datosvi.sumaBAS = sumaMinBas;
        }
        this.sumaBAS.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaBAS));
    }

    private void ValoresIniciales() {
        this.LlenaCombos();
        this.nombreTitular.setText(this.datosvi.nombreTitular);
        this.optFuma.setSelected(this.datosvi.optFuma.booleanValue());
        this.optMasculino.setSelected(this.datosvi.optMasculino.booleanValue());
        this.edadReal.setText(String.valueOf(this.datosvi.edadReal));
        this.salarioMinimo.setText(String.valueOf(this.datosvi.salarioMinimo));
        this.RevisaBeneficiosAdicionales();
        this.sumaBAS.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaBAS));
        if (this.datosvi.idPlanSel == 32) {
            this.sumaPASI.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaPASI));
            this.sumaIMA.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaIMA));
            this.sumaDI.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaDI));
            this.sumaTI.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaTI));
            this.sumaEG.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaEG));
            this.sumaGF.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaGF));
        }
        this.nombreCuenta.clear();
        this.nombreCuenta.add("PPR");
        this.nombreCuenta.add("CPEA");
        this.nombreCuenta.add("Ahorro");
        this.nombreLiquidez.clear();
        if (this.optPesos.isSelected()) {
            this.nombreLiquidez.add("Diaria");
            this.nombreLiquidez.add("Mensual");
            this.nombreLiquidez.add("Trimestral");
            this.nombreLiquidez.add("Semesral");
        } else {
            this.nombreLiquidez.add("Diaria");
            this.nombreLiquidez.add("Mensual");
        }
        this.datosvi.tasaInvAnual = this.tablas.CargaTasasFlexi();
        this.datosvi.recargoFijo = this.genSubs.VlookUp2IntInt(this.datosvi.idPlanSel, this.datosvi.idMonedaSel, this.datosvi.lstIdPlanSumaMin, this.datosvi.lstIdMonedaSumaMin, this.datosvi.lstRecFijo);
        this.RevisaVisibilidadControles();
        this.CalculaPrimas();
    }

    private void MuestraValoresInversion() {
        this.listaInversion.clear();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 6; ++j) {
                for (int k = 0; k < 4; ++k) {
                    if (!(this.datosvi.Aportacion[i][j][k] > 0.0)) continue;
                    this.txtCuenta = this.nombreCuenta.get(i);
                    this.txtLiquidez = this.nombreLiquidez.get(j);
                    this.txtPeriodicidad = this.nombrePeriodicidad.get(k);
                    this.importeInver = this.datosvi.Aportacion[i][j][k];
                    this.txtImporte = this.genSubs.FormatoNumDouble("###,###", this.importeInver);
                    this.listaInversion.add((Object)new Inversion(this.txtCuenta, this.txtMoneda, this.txtLiquidez, this.txtPeriodicidad, this.txtImporte));
                }
            }
        }
        this.txtImporteInver.setText("");
    }

    private void RevisaBeneficiosAdicionales() {
        Boolean deshabilitado = true;
        Boolean visible = true;
        if (this.datosvi.idPlanSel == 31) {
            this.datosvi.selEP = false;
            this.datosvi.selPASI = false;
            this.datosvi.selIMA = false;
            this.datosvi.selDI = false;
            this.datosvi.selTI = false;
            this.datosvi.selEG = false;
            this.datosvi.selGF = false;
            this.datosvi.sumaPASI = 0;
            this.datosvi.sumaIMA = 0;
            this.datosvi.sumaDI = 0;
            this.datosvi.sumaTI = 0;
            this.datosvi.sumaEG = 0;
            this.datosvi.sumaGF = 0;
            deshabilitado = true;
            visible = false;
        } else {
            deshabilitado = false;
            visible = true;
        }
        this.chkEP.setDisable(true);
        this.chkPASI.setDisable(deshabilitado.booleanValue());
        this.chkIMA.setDisable(deshabilitado.booleanValue());
        this.chkDI.setDisable(deshabilitado.booleanValue());
        this.chkTI.setDisable(deshabilitado.booleanValue());
        this.chkEG.setDisable(deshabilitado.booleanValue());
        this.chkGF.setDisable(deshabilitado.booleanValue());
        this.sumaEP.setVisible(visible.booleanValue());
        this.sumaPASI.setVisible(visible.booleanValue());
        this.sumaIMA.setVisible(visible.booleanValue());
        this.sumaDI.setVisible(visible.booleanValue());
        this.sumaTI.setVisible(visible.booleanValue());
        this.sumaEG.setVisible(visible.booleanValue());
        this.sumaGF.setVisible(visible.booleanValue());
        this.primaEP.setVisible(visible.booleanValue());
        this.primaPASI.setVisible(visible.booleanValue());
        this.primaIMA.setVisible(visible.booleanValue());
        this.primaDI.setVisible(visible.booleanValue());
        this.primaTI.setVisible(visible.booleanValue());
        this.primaEG.setVisible(visible.booleanValue());
        this.primaGF.setVisible(visible.booleanValue());
        this.chkEP.setSelected(this.datosvi.selEP.booleanValue());
        this.chkPASI.setSelected(this.datosvi.selPASI.booleanValue());
        this.chkIMA.setSelected(this.datosvi.selIMA.booleanValue());
        this.chkDI.setSelected(this.datosvi.selDI.booleanValue());
        this.chkTI.setSelected(this.datosvi.selTI.booleanValue());
        this.chkEG.setSelected(this.datosvi.selEG.booleanValue());
        this.chkGF.setSelected(this.datosvi.selGF.booleanValue());
        if (this.datosvi.idPlanSel == 32) {
            this.RevisaEdadBeneficios();
        }
    }

    private void RevisaVisibilidadControles() {
        this.sumaEP.setVisible(this.chkEP.isSelected());
        this.primaEP.setVisible(this.chkEP.isSelected());
        this.sumaPASI.setVisible(this.chkPASI.isSelected());
        this.primaPASI.setVisible(this.chkPASI.isSelected());
        this.sumaIMA.setVisible(this.chkIMA.isSelected());
        this.primaIMA.setVisible(this.chkIMA.isSelected());
        this.sumaDI.setVisible(this.chkDI.isSelected());
        this.primaDI.setVisible(this.chkDI.isSelected());
        this.sumaTI.setVisible(this.chkTI.isSelected());
        this.primaTI.setVisible(this.chkTI.isSelected());
        this.sumaEG.setVisible(this.chkEG.isSelected());
        this.primaEG.setVisible(this.chkEG.isSelected());
        this.sumaGF.setVisible(this.chkGF.isSelected());
        this.primaGF.setVisible(this.chkGF.isSelected());
        if (this.datosvi.idPlanSel == 31) {
            this.lblRiesgo.setVisible(false);
            this.cmbRiesgo.setVisible(false);
            this.lblSalarioMinimo.setVisible(false);
            this.salarioMinimo.setVisible(false);
        } else {
            this.lblRiesgo.setVisible(true);
            this.cmbRiesgo.setVisible(true);
            this.cmbRiesgo.setDisable(true);
            this.lblSalarioMinimo.setVisible(true);
            this.salarioMinimo.setVisible(true);
        }
    }

    private void ValidaSumaBAS() {
        if (this.sumaBAS.getText().equals("")) {
            this.sumaBAS.setText("0");
        }
        this.datosvi.sumaBAS = this.tmpInt = Integer.valueOf(Integer.parseInt(this.genSubs.QuitaComas(this.sumaBAS.getText().toString())));
        this.sumaMinima = this.genSubs.VlookUp2IntInt(this.datosvi.idPlanSel, this.datosvi.idMonedaSel, this.datosvi.lstIdPlanSumaMin, this.datosvi.lstIdMonedaSumaMin, this.datosvi.lstSumaMin);
        if (this.datosvi.idPlanSel == 32 && this.datosvi.indexRiesgo == 1) {
            this.sumaMinima = 2500000;
        }
        if (this.tmpInt < this.sumaMinima) {
            this.datosvi.sumaBAS = this.sumaMinima;
        }
        if (this.datosvi.idPlanSel == 31 && this.datosvi.sumaBAS > 1000000) {
            this.datosvi.sumaBAS = 1000000;
        }
        this.sumaBAS.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaBAS));
        this.ActualizaSumaBeneficios();
    }

    public void ValidaEP() {
        this.datosvi.selEP = this.chkEP.isSelected();
        this.sumaEP.setVisible(true);
        if (this.chkEP.isSelected()) {
            this.ActualizaSumaEP();
            this.sumaEP.setText("Cubierto");
        } else {
            this.sumaEP.setText("Excluido");
        }
        this.CalculaPrimas();
    }

    private void ValidaSumaPASI() {
        if (this.sumaPASI.getText().equals("")) {
            this.sumaPASI.setText("0");
        }
        this.datosvi.sumaPASI = this.tmpInt = Integer.valueOf(Integer.parseInt(this.genSubs.QuitaComas(this.sumaPASI.getText().toString())));
        if (this.datosvi.sumaPASI > this.datosvi.sumaBAS) {
            this.datosvi.sumaPASI = this.datosvi.sumaBAS;
        }
        this.sumaMinima = this.genSubs.VlookUpStrIntInt("PASI", this.datosvi.idMonedaSel, this.datosvi.lstIdBeneficioSumas, this.datosvi.lstIdMonedaSumas, this.datosvi.lstSumaMinBeneficio);
        if (this.datosvi.sumaPASI < this.sumaMinima) {
            this.datosvi.sumaPASI = this.sumaMinima;
        }
        this.sumaMaxima = this.genSubs.VlookUpStrIntInt("PASI", this.datosvi.idMonedaSel, this.datosvi.lstIdBeneficioSumas, this.datosvi.lstIdMonedaSumas, this.datosvi.lstSumaMaxBeneficio);
        if (this.datosvi.sumaPASI > this.sumaMaxima && this.sumaMaxima > 0) {
            this.datosvi.sumaPASI = this.sumaMaxima;
        }
        this.sumaPASI.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaPASI));
        this.CalculaPrimas();
    }

    private void ValidaSumaIMA() {
        if (this.sumaIMA.getText().equals("")) {
            this.sumaIMA.setText("0");
        }
        this.datosvi.sumaIMA = this.tmpInt = Integer.valueOf(Integer.parseInt(this.genSubs.QuitaComas(this.sumaIMA.getText().toString())));
        if (this.datosvi.sumaIMA > this.datosvi.sumaBAS) {
            this.datosvi.sumaIMA = this.datosvi.sumaBAS;
        }
        this.sumaMinima = this.genSubs.VlookUpStrIntInt("ACC", this.datosvi.idMonedaSel, this.datosvi.lstIdBeneficioSumas, this.datosvi.lstIdMonedaSumas, this.datosvi.lstSumaMinBeneficio);
        if (this.datosvi.sumaIMA < this.sumaMinima) {
            this.datosvi.sumaIMA = this.sumaMinima;
        }
        this.sumaMaxima = this.genSubs.VlookUpStrIntInt("ACC", this.datosvi.idMonedaSel, this.datosvi.lstIdBeneficioSumas, this.datosvi.lstIdMonedaSumas, this.datosvi.lstSumaMaxBeneficio);
        if (this.datosvi.sumaIMA > this.sumaMaxima && this.sumaMaxima > 0) {
            this.datosvi.sumaIMA = this.sumaMaxima;
        }
        this.sumaIMA.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaIMA));
        this.CalculaPrimas();
    }

    private void ValidaSumaDI() {
        if (this.sumaDI.getText().equals("")) {
            this.sumaDI.setText("0");
        }
        this.datosvi.sumaDI = this.tmpInt = Integer.valueOf(Integer.parseInt(this.genSubs.QuitaComas(this.sumaDI.getText().toString())));
        if (this.datosvi.sumaDI > this.datosvi.sumaBAS) {
            this.datosvi.sumaDI = this.datosvi.sumaBAS;
        }
        this.sumaMinima = this.genSubs.VlookUpStrIntInt("ACC", this.datosvi.idMonedaSel, this.datosvi.lstIdBeneficioSumas, this.datosvi.lstIdMonedaSumas, this.datosvi.lstSumaMinBeneficio);
        if (this.datosvi.sumaDI < this.sumaMinima) {
            this.datosvi.sumaDI = this.sumaMinima;
        }
        this.sumaMaxima = this.genSubs.VlookUpStrIntInt("ACC", this.datosvi.idMonedaSel, this.datosvi.lstIdBeneficioSumas, this.datosvi.lstIdMonedaSumas, this.datosvi.lstSumaMaxBeneficio);
        if (this.datosvi.sumaDI > this.sumaMaxima && this.sumaMaxima > 0) {
            this.datosvi.sumaDI = this.sumaMaxima;
        }
        this.sumaDI.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaDI));
        this.CalculaPrimas();
    }

    private void ValidaSumaTI() {
        if (this.sumaTI.getText().equals("")) {
            this.sumaTI.setText("0");
        }
        this.datosvi.sumaTI = this.tmpInt = Integer.valueOf(Integer.parseInt(this.genSubs.QuitaComas(this.sumaTI.getText().toString())));
        if (this.datosvi.sumaTI > this.datosvi.sumaBAS) {
            this.datosvi.sumaTI = this.datosvi.sumaBAS;
        }
        this.sumaMinima = this.genSubs.VlookUpStrIntInt("ACC", this.datosvi.idMonedaSel, this.datosvi.lstIdBeneficioSumas, this.datosvi.lstIdMonedaSumas, this.datosvi.lstSumaMinBeneficio);
        if (this.datosvi.sumaTI < this.sumaMinima) {
            this.datosvi.sumaTI = this.sumaMinima;
        }
        this.sumaMaxima = this.genSubs.VlookUpStrIntInt("ACC", this.datosvi.idMonedaSel, this.datosvi.lstIdBeneficioSumas, this.datosvi.lstIdMonedaSumas, this.datosvi.lstSumaMaxBeneficio);
        if (this.datosvi.sumaTI > this.sumaMaxima && this.sumaMaxima > 0) {
            this.datosvi.sumaTI = this.sumaMaxima;
        }
        this.sumaTI.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaTI));
        this.CalculaPrimas();
    }

    private void ValidaSumaEG() {
        if (this.sumaEG.getText().equals("")) {
            this.sumaEG.setText("0");
        }
        this.datosvi.sumaEG = this.tmpInt = Integer.valueOf(Integer.parseInt(this.genSubs.QuitaComas(this.sumaEG.getText().toString())));
        if (this.datosvi.sumaEG > this.datosvi.sumaBAS) {
            this.datosvi.sumaEG = this.datosvi.sumaBAS;
        }
        this.sumaMinima = this.genSubs.VlookUpStrIntInt("EG", this.datosvi.idMonedaSel, this.datosvi.lstIdBeneficioSumas, this.datosvi.lstIdMonedaSumas, this.datosvi.lstSumaMinBeneficio);
        if (this.datosvi.sumaEG < this.sumaMinima) {
            this.datosvi.sumaEG = this.sumaMinima;
        }
        this.sumaMaxima = this.genSubs.VlookUpStrIntInt("EG", this.datosvi.idMonedaSel, this.datosvi.lstIdBeneficioSumas, this.datosvi.lstIdMonedaSumas, this.datosvi.lstSumaMaxBeneficio);
        if (this.datosvi.sumaEG > this.sumaMaxima && this.sumaMaxima > 0) {
            this.datosvi.sumaEG = this.sumaMaxima;
        }
        this.sumaEG.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaEG));
        this.CalculaPrimas();
    }

    private void ValidaImporteInver() {
        if (this.txtImporteInver.getText().equals("")) {
            this.txtImporteInver.setText("0");
        }
        this.tmpDouble = Double.parseDouble(this.genSubs.QuitaComas(this.txtImporteInver.getText().toString()));
        this.txtImporteInver.setText(this.genSubs.FormatoNumDouble("###,###", this.tmpDouble));
    }

    public void CalculaPrimas() {
        this.DeterminaEdadCalculo();
        this.RevisaBeneficiosAdicionales();
        this.calculosFlexi.CalculaPrimas();
        this.primaBAS.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaBAS + (double)this.datosvi.recargoFijo.intValue()));
        if (this.datosvi.selEP.booleanValue()) {
            this.primaEP.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaEP));
            this.primaEP.setVisible(true);
        } else {
            this.primaEP.setVisible(false);
        }
        this.primaEP.setVisible(this.datosvi.selEP.booleanValue());
        this.sumaEP.setVisible(this.datosvi.selEP.booleanValue());
        this.primaPASI.setVisible(this.datosvi.selPASI.booleanValue());
        this.sumaPASI.setVisible(this.datosvi.selPASI.booleanValue());
        this.primaIMA.setVisible(this.datosvi.selIMA.booleanValue());
        this.sumaIMA.setVisible(this.datosvi.selIMA.booleanValue());
        this.primaDI.setVisible(this.datosvi.selDI.booleanValue());
        this.sumaDI.setVisible(this.datosvi.selDI.booleanValue());
        this.primaTI.setVisible(this.datosvi.selTI.booleanValue());
        this.sumaTI.setVisible(this.datosvi.selTI.booleanValue());
        this.primaEG.setVisible(this.datosvi.selEG.booleanValue());
        this.sumaEG.setVisible(this.datosvi.selEG.booleanValue());
        this.primaGF.setVisible(this.datosvi.selGF.booleanValue());
        this.sumaGF.setVisible(this.datosvi.selGF.booleanValue());
        if (this.datosvi.selPASI.booleanValue()) {
            this.primaPASI.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaPASI));
        }
        if (this.datosvi.selIMA.booleanValue()) {
            this.primaIMA.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaIMA));
        }
        if (this.datosvi.selDI.booleanValue()) {
            this.primaDI.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaDI));
        }
        if (this.datosvi.selTI.booleanValue()) {
            this.primaTI.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaTI));
        }
        if (this.datosvi.selEG.booleanValue()) {
            this.primaEG.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaEG));
        }
        if (this.datosvi.selGF.booleanValue()) {
            this.primaGF.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaGF));
        }
        this.datosvi.primaTOT = this.datosvi.primaBAS + (double)this.datosvi.recargoFijo.intValue() + this.datosvi.primaEP + this.datosvi.primaPASI;
        DatosVI datosVI = this.datosvi;
        datosVI.primaTOT = datosVI.primaTOT + (this.datosvi.primaIMA + this.datosvi.primaDI + this.datosvi.primaTI + this.datosvi.primaEG + this.datosvi.primaGF);
        this.primaTOT.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaTOT));
        this.primaTOT.setVisible(true);
        this.CalculaPrimaFormaPago();
    }

    private void CalculaPrimaFormaPago() {
        if (this.datosvi.indexFormaPago == 0) {
            this.datosvi.recargoFormaPago = 0.0;
            this.datosvi.primaFormaPago = this.datosvi.primaTOT;
            this.lblRecargoFormaPago.setVisible(false);
            this.lblPrimaFormaPago.setVisible(false);
            this.recargoFormaPago.setVisible(false);
            this.primaFormaPago.setVisible(false);
            this.datosvi.tasaRecargo = 0.0;
        } else {
            this.datosvi.tasaRecargo = this.genSubs.VlookUp3IntDbl(this.datosvi.idPlanSel, this.datosvi.idMonedaSel, this.datosvi.idFormaPagoSel, this.datosvi.lstIdPlanRecargo, this.datosvi.lstIdMonedaRecargo, this.datosvi.lstIdFormaPago, this.datosvi.lstTasaRecargo);
            this.datosvi.recargoFormaPago = this.datosvi.primaTOT * this.datosvi.tasaRecargo;
            this.datosvi.primaFormaPago = (this.datosvi.primaTOT + this.datosvi.recargoFormaPago) / (double)this.datosvi.numPagos.intValue();
            this.lblRecargoFormaPago.setVisible(true);
            this.lblPrimaFormaPago.setVisible(true);
            this.recargoFormaPago.setVisible(true);
            this.primaFormaPago.setVisible(true);
            this.recargoFormaPago.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.recargoFormaPago));
            this.primaFormaPago.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaFormaPago));
        }
    }

    private void DeterminaEdadCalculo() {
        Integer reduccion = 0;
        this.datosvi.optMasculino = this.optMasculino.isSelected();
        this.datosvi.optFemenino = this.optFemenino.isSelected();
        this.datosvi.optFuma = this.optFuma.isSelected();
        this.datosvi.optNoFuma = this.optNoFuma.isSelected();
        this.datosvi.sexo = this.datosvi.optMasculino != false ? "M" : "F";
        this.datosvi.fuma = this.datosvi.optFuma != false ? "S" : "N";
        this.edadMinima = this.datosvi.idPlanSel == 31 ? Integer.valueOf(15) : Integer.valueOf(18);
        if (this.datosvi.plazoSel == 65 || this.datosvi.plazoSel == 60) {
            reduccion = 0;
        } else {
            if (this.datosvi.optMasculino.booleanValue() && this.datosvi.optFuma.booleanValue()) {
                reduccion = 0;
            }
            if (this.datosvi.optMasculino.booleanValue() && !this.datosvi.optFuma.booleanValue()) {
                reduccion = 2;
            }
            if (this.datosvi.optFemenino.booleanValue() && this.datosvi.optFuma.booleanValue()) {
                reduccion = 3;
            }
            if (this.datosvi.optFemenino.booleanValue() && !this.datosvi.optFuma.booleanValue()) {
                reduccion = 5;
            }
        }
        this.datosvi.edadCalculo = this.datosvi.edadReal - reduccion;
        if (this.datosvi.edadCalculo < this.edadMinima) {
            this.datosvi.edadCalculo = this.edadMinima;
        }
        this.edadCalculo.setText(this.datosvi.edadCalculo.toString());
    }

    private void LlenaCombos() {
        this.cmbPlazo.getItems().clear();
        this.datosvi.lstPlazo.clear();
        this.datosvi.lstPlazo.add("10");
        this.datosvi.lstPlazo.add("20");
        if (this.datosvi.planSel.equals("FlexiLife Sue\u00f1os")) {
            this.datosvi.lstPlazo.add("Edad 65");
        }
        this.cmbPlazo.getItems().addAll(this.datosvi.lstPlazo);
        this.cmbPlazo.getSelectionModel().select(this.datosvi.indexPlazo);
        this.cmbFormaPago.getItems().clear();
        this.datosvi.lstFormaPago.clear();
        this.datosvi.lstFormaPago.add("Anual");
        this.datosvi.lstFormaPago.add("Semestral");
        this.datosvi.lstFormaPago.add("Trimestral");
        this.datosvi.lstFormaPago.add("Mensual");
        this.cmbFormaPago.getItems().addAll(this.datosvi.lstFormaPago);
        this.cmbFormaPago.getSelectionModel().select(this.datosvi.indexFormaPago);
        this.datosvi.formaPagoSel = this.datosvi.indexFormaPago == 0 ? "Anual" : (this.datosvi.indexFormaPago == 1 ? "Semestral" : (this.datosvi.indexFormaPago == 2 ? "Trimestral" : "Mensual"));
        this.cmbRiesgo.getItems().clear();
        this.cmbRiesgo.getItems().add((Object)"Normal");
        this.cmbRiesgo.getItems().add((Object)"Preferente");
        this.cmbRiesgo.getSelectionModel().select(this.datosvi.indexRiesgo);
        this.cmbCuenta.getItems().clear();
        this.cmbCuenta.getItems().add((Object)"Plan Personal de Retiro (PPR)");
        this.cmbCuenta.getItems().add((Object)"Plan Personal Especial de Ahorro (CPEA)");
        this.cmbCuenta.getItems().add((Object)"Ahorro");
        this.cmbCuenta.getSelectionModel().select(this.datosvi.indexCuenta);
        this.OpcionMoneda();
        this.cmbPeriodicidad.getItems().clear();
        this.cmbPeriodicidad.getItems().add((Object)"Inicial");
        this.cmbPeriodicidad.getItems().add((Object)"Mensual");
        this.cmbPeriodicidad.getItems().add((Object)"Trimestral");
        this.cmbPeriodicidad.getItems().add((Object)"Anual");
        this.cmbPeriodicidad.getSelectionModel().selectFirst();
        this.datosvi.indexPeriodicidad = 0;
        this.nombrePeriodicidad.clear();
        this.nombrePeriodicidad.add("Inicial");
        this.nombrePeriodicidad.add("Mensual");
        this.nombrePeriodicidad.add("Trimestral");
        this.nombrePeriodicidad.add("Anual");
    }

    public void VerCotizacion() {
        this.GuardaDatos();
        this.ValidaAportaciones();
        if (this.txtMensaje == "") {
            this.calculosFlexi.ConstruyeCotizacion();
            this.cotizFlexi.ImprimeCotizacion();
        } else {
            this.genSubs.MuestraMensaje(this.txtMensaje);
        }
    }

    private void ValidaAportaciones() {
        int j;
        Double tipoCambio = 1.0;
        Double aportacion1 = 0.0;
        Double aportacionSubsecuente = 0.0;
        Double sumaPeriodicidad = 0.0;
        Boolean hayAportacionInicial = false;
        this.txtMensaje = "";
        this.datosvi.hayPPR = false;
        this.datosvi.hayCPEA = false;
        this.datosvi.hayAhorro = false;
        if (this.datosvi.idPlanSel == 32) {
            this.aportacionesValidas = false;
            for (int i = 0; i < 3; ++i) {
                for (int j2 = 0; j2 < 6; ++j2) {
                    for (int k = 0; k < 4; ++k) {
                        if (!(this.datosvi.Aportacion[i][j2][k] > 0.0)) continue;
                        if (k == 0) {
                            hayAportacionInicial = true;
                        }
                        this.aportacionesValidas = true;
                        if (i == 0) {
                            this.datosvi.hayPPR = true;
                            continue;
                        }
                        if (i == 1) {
                            this.datosvi.hayCPEA = true;
                            continue;
                        }
                        this.datosvi.hayAhorro = true;
                    }
                }
            }
        } else {
            this.aportacionesValidas = true;
            for (j = 0; j < 6; ++j) {
                for (int k = 0; k < 4; ++k) {
                    if (k == 0) {
                        hayAportacionInicial = true;
                    }
                    if (!(this.datosvi.Aportacion[2][j][k] > 0.0)) continue;
                    this.datosvi.hayAhorro = true;
                }
            }
        }
        if (!this.aportacionesValidas.booleanValue()) {
            this.txtMensaje = "Debe haber al menos una aportaci\u00f3n\r";
            this.genSubs.MuestraMensaje(this.txtMensaje);
        } else if (!hayAportacionInicial.booleanValue()) {
            this.txtMensaje = "Debe haber al menos una aportaci\u00f3n inicial\r";
            this.genSubs.MuestraMensaje(this.txtMensaje);
        } else if (this.datosvi.idPlanSel == 32 && this.datosvi.plazoSel == 65) {
            aportacion1 = 0.0;
            aportacionSubsecuente = 0.0;
            for (j = 0; j < 6; ++j) {
                tipoCambio = j < 4 ? Double.valueOf(1.0) : this.datosvi.tipoCambioDolar;
                aportacion1 = aportacion1 + (this.datosvi.Aportacion[0][j][0] + 11.0 * this.datosvi.Aportacion[0][j][1] + 3.0 * this.datosvi.Aportacion[0][j][2]) * tipoCambio;
                aportacionSubsecuente = aportacionSubsecuente + (12.0 * this.datosvi.Aportacion[0][j][1] + 4.0 * this.datosvi.Aportacion[0][j][2] + this.datosvi.Aportacion[0][j][3]) * tipoCambio;
            }
            if (aportacion1 > this.datosvi.maximoPPR) {
                this.txtMensaje = this.txtMensaje + "La aportaci\u00f3n inicial en PPR excede al m\u00e1ximo actual de: " + this.genSubs.FormatoNumDouble("###,###", this.datosvi.maximoPPR) + "\r";
            } else if (aportacionSubsecuente > this.datosvi.maximoPPR) {
                this.txtMensaje = this.txtMensaje + "La aportaci\u00f3n de a\u00f1os subsecuentes en PPR excede al m\u00e1ximo actual de: " + this.genSubs.FormatoNumDouble("###,###", this.datosvi.maximoPPR) + "\r";
            }
            aportacion1 = 0.0;
            aportacionSubsecuente = 0.0;
            for (j = 0; j < 6; ++j) {
                tipoCambio = j < 4 ? Double.valueOf(1.0) : this.datosvi.tipoCambioDolar;
                aportacion1 = aportacion1 + (this.datosvi.Aportacion[1][j][0] + 11.0 * this.datosvi.Aportacion[1][j][1] + 3.0 * this.datosvi.Aportacion[1][j][2]) * tipoCambio;
                aportacionSubsecuente = aportacionSubsecuente + (12.0 * this.datosvi.Aportacion[1][j][1] + 4.0 * this.datosvi.Aportacion[1][j][2] + this.datosvi.Aportacion[1][j][3]) * tipoCambio;
            }
            if (aportacion1 > this.datosvi.maximoCPEA) {
                this.txtMensaje = this.txtMensaje + "La aportaci\u00f3n inicial en CPEA excede al m\u00e1ximo actual de: " + this.genSubs.FormatoNumDouble("###,###", this.datosvi.maximoPPR) + "\r";
            } else if (aportacionSubsecuente > this.datosvi.maximoCPEA) {
                this.txtMensaje = this.txtMensaje + "La aportaci\u00f3n de a\u00f1os subsecuentes en CPEA excede al m\u00e1ximo actual de: " + this.genSubs.FormatoNumDouble("###,###", this.datosvi.maximoPPR) + "\r";
            }
        }
    }

    public void MuestraTasas() {
        this.datosvi.tasaInvAnual = this.tablas.CargaTasasFlexi();
        Double tasa = this.datosvi.tasaInvAnual[0][0] * 100.0;
        this.tasaDiariaMN.setText(this.genSubs.FormatoNumDouble("0.00", tasa));
        tasa = this.datosvi.tasaInvAnual[0][1] * 100.0;
        this.tasaMensualMN.setText(this.genSubs.FormatoNumDouble("0.00", tasa));
        tasa = this.datosvi.tasaInvAnual[0][2] * 100.0;
        this.tasaTrimestralMN.setText(this.genSubs.FormatoNumDouble("0.00", tasa));
        tasa = this.datosvi.tasaInvAnual[0][3] * 100.0;
        this.tasaSemestralMN.setText(this.genSubs.FormatoNumDouble("0.00", tasa));
        tasa = this.datosvi.tasaInvAnual[0][4] * 100.0;
        this.tasaDiariaDls.setText(this.genSubs.FormatoNumDouble("0.00", tasa));
        tasa = this.datosvi.tasaInvAnual[0][5] * 100.0;
        this.tasaMensualDls.setText(this.genSubs.FormatoNumDouble("0.00", tasa));
        this.paneAportaciones.setVisible(false);
        this.paneTasas.setVisible(true);
    }

    public void RangoImpresion() {
        this.datosvi.rangoImpresion = this.chkRango.isSelected();
        if (this.chkRango.isSelected()) {
            this.lblDesde.setVisible(true);
            this.hastaAno.setVisible(true);
            this.lblUnoEnUno.setVisible(true);
            this.lblLuego.setVisible(true);
            this.rangoLuego.setVisible(true);
            this.lblAnos.setVisible(true);
        } else {
            this.lblDesde.setVisible(false);
            this.hastaAno.setVisible(false);
            this.lblUnoEnUno.setVisible(false);
            this.lblLuego.setVisible(false);
            this.rangoLuego.setVisible(false);
            this.lblAnos.setVisible(false);
        }
    }

    private void InicializaVentana() {
        this.lblVersion.setText(this.datosvi.idVersion + this.datosvi.textoLegal);
        this.lblPlanSel.setText(this.datosvi.planSel);
        this.lblAhorro.setLayoutX(0.0);
        this.lblAhorro.setLayoutY(25.0);
        this.datosvi.rangoImpresion = false;
        this.chkRango.setVisible(false);
        this.lblDesde.setVisible(false);
        this.hastaAno.setVisible(false);
        this.lblUnoEnUno.setVisible(false);
        this.lblLuego.setVisible(false);
        this.rangoLuego.setVisible(false);
        this.lblAnos.setVisible(false);
        this.datosvi.hastaAno = 0;
        this.datosvi.rangoLuego = 0;
        this.paneAportaciones.setVisible(true);
        this.paneTasas.setVisible(false);
        this.paneTasas.setLayoutX(this.paneAportaciones.getLayoutX());
        this.paneTasas.setLayoutY(this.paneAportaciones.getLayoutY());
    }

    public void ClicCancelarTasas() {
        this.paneTasas.setVisible(false);
        this.paneAportaciones.setVisible(true);
    }

    public void ClicGuardarTasas() {
        this.ValidaTasas();
        if (!this.tasasValidas.booleanValue()) {
            this.txtMensaje = "Se modificaron las tasas a los valores m\u00e1ximos";
            this.genSubs.MuestraMensaje(this.txtMensaje);
        } else {
            Double tasa;
            this.paneTasas.setVisible(false);
            this.paneAportaciones.setVisible(true);
            this.datosvi.tasaInvAnual[0][0] = tasa = Double.valueOf(Double.parseDouble(this.tasaDiariaMN.getText().toString()) / 100.0);
            this.datosvi.tasaInvAnual[0][1] = tasa = Double.valueOf(Double.parseDouble(this.tasaMensualMN.getText().toString()) / 100.0);
            this.datosvi.tasaInvAnual[0][2] = tasa = Double.valueOf(Double.parseDouble(this.tasaTrimestralMN.getText().toString()) / 100.0);
            this.datosvi.tasaInvAnual[0][3] = tasa = Double.valueOf(Double.parseDouble(this.tasaSemestralMN.getText().toString()) / 100.0);
            this.datosvi.tasaInvAnual[0][4] = tasa = Double.valueOf(Double.parseDouble(this.tasaDiariaDls.getText().toString()) / 100.0);
            this.datosvi.tasaInvAnual[0][5] = tasa = Double.valueOf(Double.parseDouble(this.tasaMensualDls.getText().toString()) / 100.0);
            this.tablas.GuardaTasasFlexi();
            this.tablas.CargaTasasFlexi();
        }
    }

    public void ClicSugeridos() {
        this.datosvi.tasaInvAnual = this.tablas.CargaTasasFlexi();
        Double tasa = this.datosvi.tasaInvAnual[4][0] * 100.0;
        this.tasaDiariaMN.setText(this.genSubs.FormatoNumDouble("0.00", tasa));
        tasa = this.datosvi.tasaInvAnual[4][1] * 100.0;
        this.tasaMensualMN.setText(this.genSubs.FormatoNumDouble("0.00", tasa));
        tasa = this.datosvi.tasaInvAnual[4][2] * 100.0;
        this.tasaTrimestralMN.setText(this.genSubs.FormatoNumDouble("0.00", tasa));
        tasa = this.datosvi.tasaInvAnual[4][3] * 100.0;
        this.tasaSemestralMN.setText(this.genSubs.FormatoNumDouble("0.00", tasa));
        tasa = this.datosvi.tasaInvAnual[4][4] * 100.0;
        this.tasaDiariaDls.setText(this.genSubs.FormatoNumDouble("0.00", tasa));
        tasa = this.datosvi.tasaInvAnual[4][5] * 100.0;
        this.tasaMensualDls.setText(this.genSubs.FormatoNumDouble("0.00", tasa));
    }

    private void ValidaTasas() {
        this.tasasValidas = true;
        Double tasa = Double.parseDouble(this.tasaDiariaMN.getText().toString()) / 100.0;
        if (tasa > this.datosvi.tasaInvAnual[3][0]) {
            this.tasasValidas = false;
            tasa = this.datosvi.tasaInvAnual[3][0] * 100.0;
            this.tasaDiariaMN.setText(this.genSubs.FormatoNumDouble("00.00", tasa));
        }
        if ((tasa = Double.valueOf(Double.parseDouble(this.tasaMensualMN.getText().toString()) / 100.0)) > this.datosvi.tasaInvAnual[3][1]) {
            this.tasasValidas = false;
            tasa = this.datosvi.tasaInvAnual[3][1] * 100.0;
            this.tasaMensualMN.setText(this.genSubs.FormatoNumDouble("00.00", tasa));
        }
        if ((tasa = Double.valueOf(Double.parseDouble(this.tasaTrimestralMN.getText().toString()) / 100.0)) > this.datosvi.tasaInvAnual[3][2]) {
            this.tasasValidas = false;
            tasa = this.datosvi.tasaInvAnual[3][2] * 100.0;
            this.tasaTrimestralMN.setText(this.genSubs.FormatoNumDouble("00.00", tasa));
        }
        if ((tasa = Double.valueOf(Double.parseDouble(this.tasaSemestralMN.getText().toString()) / 100.0)) > this.datosvi.tasaInvAnual[3][3]) {
            this.tasasValidas = false;
            tasa = this.datosvi.tasaInvAnual[3][3] * 100.0;
            this.tasaSemestralMN.setText(this.genSubs.FormatoNumDouble("00.00", tasa));
        }
        if ((tasa = Double.valueOf(Double.parseDouble(this.tasaDiariaDls.getText().toString()) / 100.0)) > this.datosvi.tasaInvAnual[3][4]) {
            this.tasasValidas = false;
            tasa = this.datosvi.tasaInvAnual[3][4] * 100.0;
            this.tasaDiariaDls.setText(this.genSubs.FormatoNumDouble("00.00", tasa));
        }
        if ((tasa = Double.valueOf(Double.parseDouble(this.tasaMensualDls.getText().toString()) / 100.0)) > this.datosvi.tasaInvAnual[3][5]) {
            this.tasasValidas = false;
            tasa = this.datosvi.tasaInvAnual[3][5] * 100.0;
            this.tasaMensualDls.setText(this.genSubs.FormatoNumDouble("00.00", tasa));
        }
    }

    private void SeleccionaCuentaInversion() {
        if (this.datosvi.idPlanSel == 31) {
            this.cmbCuenta.getSelectionModel().selectLast();
            this.cmbCuenta.setVisible(false);
            this.lblAhorro.setVisible(true);
            this.datosvi.indexCuenta = 2;
        } else if (this.datosvi.plazoSel < 65) {
            this.cmbCuenta.getSelectionModel().select(2);
            this.cmbCuenta.setVisible(false);
            this.lblAhorro.setVisible(true);
            this.datosvi.indexCuenta = 2;
        } else {
            this.cmbCuenta.setVisible(true);
            this.lblAhorro.setVisible(false);
            this.cmbCuenta.getSelectionModel().selectFirst();
            this.datosvi.indexCuenta = 0;
        }
        this.cmbLiquidez.getSelectionModel().selectFirst();
        this.cmbPeriodicidad.getSelectionModel().selectFirst();
        this.datosvi.indexLiquidez = 0;
        this.datosvi.indexPeriodicidad = 0;
        this.txtImporteInver.setText("");
        this.optPesos.setSelected(true);
    }

    public void OpcionMoneda() {
        this.cmbLiquidez.getItems().clear();
        if (this.optPesos.isSelected()) {
            this.cmbLiquidez.getItems().add((Object)"Diaria");
            this.cmbLiquidez.getItems().add((Object)"Mensual");
            this.cmbLiquidez.getItems().add((Object)"Trimestral");
            this.cmbLiquidez.getItems().add((Object)"Semestral");
        } else {
            this.cmbLiquidez.getItems().add((Object)"Diaria");
            this.cmbLiquidez.getItems().add((Object)"Mensual");
        }
        this.cmbLiquidez.getSelectionModel().selectFirst();
        this.datosvi.indexLiquidez = 0;
        this.txtImporteInver.setText("");
    }

    private void CreaArregloAportaciones() {
    }

    public void RegresaInicio() {
        this.GuardaDatos();
        this.stage = (Stage)this.lblVersion.getScene().getWindow();
        this.MuestraVentana("Inicio.fxml");
    }

    private void GuardaDatos() {
        this.datosvi.nombreTitular = this.nombreTitular.getText();
        this.datosvi.edadReal = Integer.parseInt(this.edadReal.getText().toString());
        this.datosvi.sexo = this.optMasculino.isSelected() ? "M" : "F";
        this.datosvi.fuma = this.optFuma.isSelected() ? "S" : "N";
    }

    public void GeneraMemoriaCalculo() {
    }

    private void MuestraVentana(String nombreVentana) {
        try {
            this.root = (Parent)FXMLLoader.load((URL)this.getClass().getResource(nombreVentana));
            Scene scene = new Scene(this.root);
            this.stage.setScene(scene);
            scene.getStylesheets().add((Object)"cssBase.css");
            this.stage.show();
        }
        catch (Exception e2) {
            System.out.println("No pudo cargar " + nombreVentana);
        }
    }

    private void FormatoTituloNombre() {
        String[] arr = this.nombreTitular.getText().split(" ");
        StringBuffer sb = new StringBuffer();
        if (!this.nombreTitular.getText().equals("")) {
            for (int i = 0; i < arr.length; ++i) {
                sb.append(Character.toUpperCase(arr[i].charAt(0))).append(arr[i].substring(1)).append(" ");
                this.nombreTitular.setText(sb.toString().trim());
            }
        }
    }

    private void FormatoAportacion() {
    }

    public static class Inversion {
        private SimpleStringProperty cuentaInver = new SimpleStringProperty();
        private SimpleStringProperty monedaInver = new SimpleStringProperty();
        private SimpleStringProperty liquidezInver = new SimpleStringProperty();
        private SimpleStringProperty periodicidadInver = new SimpleStringProperty();
        private SimpleStringProperty importeInver = new SimpleStringProperty();

        public SimpleStringProperty cuentaInverProperty() {
            return this.cuentaInver;
        }

        public void setCuentaInver(String value) {
            this.cuentaInver.set(value);
        }

        public String getCuentaInver() {
            return this.cuentaInver.get();
        }

        public SimpleStringProperty monedaInverProperty() {
            return this.monedaInver;
        }

        public void setMonedaInver(String value) {
            this.monedaInver.set(value);
        }

        public String getMonedaInver() {
            return this.monedaInver.get();
        }

        public SimpleStringProperty liquidezInverProperty() {
            return this.liquidezInver;
        }

        public void setLiquidezInver(String value) {
            this.liquidezInver.set(value);
        }

        public String getLiquidezInver() {
            return this.liquidezInver.get();
        }

        public SimpleStringProperty periodicidadInverProperty() {
            return this.periodicidadInver;
        }

        public void setPeriodicidadInver(String value) {
            this.periodicidadInver.set(value);
        }

        public String getPeriodicidadInver() {
            return this.periodicidadInver.get();
        }

        public SimpleStringProperty importeInverProperty() {
            return this.importeInver;
        }

        public void setImporteInver(String value) {
            this.importeInver.set(value);
        }

        public String getImporteInver() {
            return this.importeInver.get();
        }

        private Inversion(String cuenta, String moneda, String liquidez, String periodicidad, String importe) {
            this.cuentaInver = new SimpleStringProperty(cuenta);
            this.monedaInver = new SimpleStringProperty(moneda);
            this.liquidezInver = new SimpleStringProperty(liquidez);
            this.periodicidadInver = new SimpleStringProperty(periodicidad);
            this.importeInver = new SimpleStringProperty(importe);
        }
    }
}

