/*
 * Decompiled with CFR 0.152.
 */
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Accordion;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;

public class CobEducaController
implements Initializable {
    private DatosVI datosvi = DatosVI.getInstance();
    private Datos datos = Datos.getInstance();
    private GenSubs genSubs = GenSubs.getInstance();
    private CalculosVI calculosvi = CalculosVI.getInstance();
    private CotizVI cotizvi = CotizVI.getInstance();
    private PresentadorTrad presentadorTrad = PresentadorTrad.getInstance();
    @FXML
    Accordion accEducaLife;
    @FXML
    TitledPane panelTitular;
    @FXML
    TitledPane panelMenor;
    @FXML
    TextField nombreTitularEdu;
    @FXML
    RadioButton optMasculinoEdu;
    @FXML
    RadioButton optFemeninoEdu;
    @FXML
    RadioButton optFumaEdu;
    @FXML
    RadioButton optNoFumaEdu;
    @FXML
    TextField edadRealEdu;
    @FXML
    Label edadCalculoEdu;
    @FXML
    ComboBox cmbMonedaEdu;
    @FXML
    CheckBox chkConyuge;
    @FXML
    TextField nombreConyuge;
    @FXML
    RadioButton optMasculinoConyuge;
    @FXML
    RadioButton optFemeninoConyuge;
    @FXML
    RadioButton optFumaConyuge;
    @FXML
    RadioButton optNoFumaConyuge;
    @FXML
    Label titEdadCalculoConyuge;
    @FXML
    Label titEdadRealConyuge;
    @FXML
    TextField edadRealConyuge;
    @FXML
    Label edadCalculoConyuge;
    @FXML
    TextField nombreMenor;
    @FXML
    RadioButton optMasculinoMenor;
    @FXML
    RadioButton optFemeninoMenor;
    @FXML
    TextField edadRealMenor;
    @FXML
    CheckBox chkGPPIedu;
    @FXML
    CheckBox chkPASIedu;
    @FXML
    CheckBox chkGPPFedu;
    @FXML
    CheckBox chkIMAedu;
    @FXML
    CheckBox chkTIBAedu;
    @FXML
    CheckBox chkEGedu;
    @FXML
    CheckBox chkGFedu;
    @FXML
    TextField sumaBASedu;
    @FXML
    Label sumaGPPIedu;
    @FXML
    TextField sumaPASIedu;
    @FXML
    Label sumaGPPFedu;
    @FXML
    TextField sumaIMAedu;
    @FXML
    TextField sumaTIBAedu;
    @FXML
    TextField sumaEGedu;
    @FXML
    Label sumaGFedu;
    @FXML
    Label primaBASedu;
    @FXML
    Label primaGPPIedu;
    @FXML
    Label primaPASIedu;
    @FXML
    Label primaGPPFedu;
    @FXML
    Label primaIMAedu;
    @FXML
    Label primaTIBAedu;
    @FXML
    Label primaEGedu;
    @FXML
    Label primaGFedu;
    @FXML
    Label primaTotalTitular;
    @FXML
    TextField epMillarBASedu;
    @FXML
    TextField epPorBASedu;
    @FXML
    TextField epPorINVedu;
    @FXML
    TextField epPorACCedu;
    @FXML
    TextField epMillarBASconyugeEdu;
    @FXML
    TextField epPorBASconyugeEdu;
    @FXML
    ComboBox cmbDotalMenor;
    @FXML
    CheckBox chkMiniEdad5;
    @FXML
    CheckBox chkMiniEdad11;
    @FXML
    CheckBox chkMiniEdad14;
    @FXML
    CheckBox chkMiniEdad16;
    @FXML
    CheckBox chkGFmenor;
    @FXML
    TextField sumaDotalMenor;
    @FXML
    Label sumaMiniEdad5;
    @FXML
    Label sumaMiniEdad11;
    @FXML
    Label sumaMiniEdad14;
    @FXML
    Label sumaMiniEdad16;
    @FXML
    Label sumaGFmenor;
    @FXML
    Label primaDotalMenor;
    @FXML
    Label primaMiniEdad5;
    @FXML
    Label primaMiniEdad11;
    @FXML
    Label primaMiniEdad14;
    @FXML
    Label primaMiniEdad16;
    @FXML
    Label primaGFmenor;
    @FXML
    Label primaTotalMenor;
    @FXML
    Label titConyuge;
    @FXML
    Label titEPconyuge;
    @FXML
    Label titBASconyuge;
    @FXML
    CheckBox chkGFconyuge;
    @FXML
    TextField sumaBASconyuge;
    @FXML
    Label sumaGFconyuge;
    @FXML
    Label primaBASconyuge;
    @FXML
    Label primaGFconyuge;
    @FXML
    Label lblPrimaConyuge;
    @FXML
    Label primaConyuge;
    @FXML
    Label lblEPconyuge;
    @FXML
    Label lblEPmillarConyuge;
    @FXML
    Label lblEPporConyuge;
    @FXML
    ComboBox cmbFormaPagoEdu;
    @FXML
    Label primaTOTedu;
    @FXML
    Label recargoFormaPagoEdu;
    @FXML
    Label primaFormaPagoEdu;
    @FXML
    Label lblRecargoFormaPago;
    @FXML
    Label lblPrimaFormaPago;
    @FXML
    Button verCotizacion;
    @FXML
    CheckBox chkSaldado;
    @FXML
    TextField tipoCambio;
    @FXML
    Label lblTipoCambio;
    @FXML
    Button btnPresentacion;
    String txtMensaje;
    Integer valorTmp;
    Integer tmpInt;
    Double tmpDouble;
    Integer sumaMin;
    Integer sumaMax;
    Integer sumaMinima;
    Integer sumaMaxima;
    Integer edadMax;
    Integer edadMin;
    Stage stage;
    Parent root;
    @FXML
    Label lblVersion;
    @FXML
    Label lblPlanSel;

    public void initialize(URL url, ResourceBundle rb) {
        this.ValoresIniciales();
        this.ValidaGPPIedu();
        this.ValidaGPPFedu();
        this.InicializaVentana();
        this.cmbMonedaEdu.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                CobEducaController.this.RevisaMonedaSeleccionada();
            }
        });
        this.cmbDotalMenor.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                CobEducaController.this.RevisaDotalSeleccionado();
            }
        });
        this.cmbFormaPagoEdu.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                ((CobEducaController)CobEducaController.this).datosvi.formaPagoSelEdu = newValue;
                CobEducaController.this.RevisaFormaPagoSeleccionado();
            }
        });
        this.edadRealEdu.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    CobEducaController.this.ValidaEdadRealEdu();
                }
            }
        });
        this.sumaBASedu.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    CobEducaController.this.ValidaSumaBASedu();
                }
            }
        });
        this.sumaPASIedu.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    CobEducaController.this.ValidaSumaPASIedu();
                }
            }
        });
        this.sumaIMAedu.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    CobEducaController.this.ValidaSumaIMAedu();
                }
            }
        });
        this.sumaTIBAedu.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    CobEducaController.this.ValidaSumaTIBAedu();
                }
            }
        });
        this.sumaEGedu.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    CobEducaController.this.ValidaSumaEGedu();
                }
            }
        });
        this.edadRealMenor.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    CobEducaController.this.ValidaEdadRealMenor();
                }
            }
        });
        this.sumaDotalMenor.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    CobEducaController.this.ValidaSumaDotalMenor();
                }
            }
        });
        this.sumaBASconyuge.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    CobEducaController.this.ValidaSumaBASconyuge();
                }
            }
        });
        this.edadRealConyuge.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    CobEducaController.this.ValidaEdadRealConyuge();
                }
            }
        });
        this.epMillarBASedu.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    CobEducaController.this.ValidaEpMillarBASedu();
                }
            }
        });
        this.epPorBASedu.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    CobEducaController.this.ValidaEpPorBASedu();
                }
            }
        });
        this.epPorINVedu.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    CobEducaController.this.ValidaEpPorINVedu();
                }
            }
        });
        this.epPorACCedu.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    CobEducaController.this.ValidaEpPorACCedu();
                }
            }
        });
        this.epMillarBASconyugeEdu.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    CobEducaController.this.ValidaEpMillarBASconyugeEdu();
                }
            }
        });
        this.epPorBASconyugeEdu.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    CobEducaController.this.ValidaEpPorBASconyugeEdu();
                }
            }
        });
        this.tipoCambio.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    CobEducaController.this.ValidaTipoCambio();
                }
            }
        });
        this.nombreTitularEdu.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaLetras(100));
        this.edadRealEdu.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(3));
        this.sumaBASedu.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(11));
        this.sumaPASIedu.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(11));
        this.sumaIMAedu.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(11));
        this.sumaTIBAedu.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(11));
        this.sumaEGedu.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(11));
        this.sumaDotalMenor.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(11));
        this.sumaBASconyuge.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(11));
        this.epMillarBASedu.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(3));
        this.epPorBASedu.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(3));
        this.epPorINVedu.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(3));
        this.epPorACCedu.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(3));
        this.epMillarBASconyugeEdu.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(3));
        this.epPorBASconyugeEdu.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(3));
        this.edadRealMenor.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(3));
        this.edadRealConyuge.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(3));
        this.accEducaLife.setExpandedPane(this.panelTitular);
    }

    private void RevisaMonedaSeleccionada() {
        this.datosvi.monedaSelEdu = this.cmbMonedaEdu.getValue().toString();
        if (this.datosvi.monedaSelEdu.equals("Pesos")) {
            this.datosvi.idMonedaSelEdu = 1;
            this.tipoCambio.setVisible(false);
            this.lblTipoCambio.setVisible(false);
        } else {
            this.datosvi.idMonedaSelEdu = 2;
            this.tipoCambio.setVisible(true);
            this.lblTipoCambio.setVisible(true);
        }
        this.DeterminaSumaMinima();
        this.ActualizaSumaBeneficios();
        this.ActualizaSumaDotal();
        this.ActualizaSumaMiniDotales();
    }

    private void RevisaDotalSeleccionado() {
        if (this.cmbDotalMenor.getItems().size() > 0) {
            this.CalculaPlazos();
            this.CalculaPrimas();
        }
    }

    private void RevisaFormaPagoSeleccionado() {
        if (this.datosvi.formaPagoSelEdu.equals("Anual")) {
            this.datosvi.idFormaPagoSelEdu = 1;
            this.datosvi.numPagosEdu = 1;
        }
        if (this.datosvi.formaPagoSelEdu.equals("Semestral")) {
            this.datosvi.idFormaPagoSelEdu = 2;
            this.datosvi.numPagosEdu = 2;
            this.lblPrimaFormaPago.setText("Prima semestral");
        }
        if (this.datosvi.formaPagoSelEdu.equals("Trimestral")) {
            this.datosvi.idFormaPagoSelEdu = 3;
            this.datosvi.numPagosEdu = 4;
            this.lblPrimaFormaPago.setText("Prima trimestral");
        }
        if (this.datosvi.formaPagoSelEdu.equals("Mensual")) {
            this.datosvi.idFormaPagoSelEdu = 4;
            this.datosvi.numPagosEdu = 12;
            this.lblPrimaFormaPago.setText("Prima mensual");
        }
        this.CalculaPrimaFormaPago();
    }

    private void CalculaPlazos() {
        this.datosvi.dotalMenorSel = this.cmbDotalMenor.getValue().toString();
        this.datosvi.edadAlcanzadaDotal = this.genSubs.VlookUpStrInt(this.datosvi.dotalMenorSel, this.datosvi.lstDotalMenor, this.datosvi.lstPlazoDotalMenor);
        this.datosvi.plazoTitularEdu = this.datosvi.plazoDotal = Integer.valueOf(this.datosvi.edadAlcanzadaDotal - this.datosvi.edadRealMenor);
    }

    private void ActualizaSumaDotal() {
        this.datosvi.sumaDotalMenor = this.datosvi.sumaBASedu;
        this.sumaMin = this.genSubs.VlookUpStrIntInt("Dotal", this.datosvi.idMonedaSelEdu, this.datosvi.lstCoberturaEdu, this.datosvi.lstIdMonedaEdu, this.datosvi.lstSumaMinEdu);
        if (this.datosvi.sumaDotalMenor < this.sumaMin) {
            this.datosvi.sumaDotalMenor = this.sumaMin;
        }
        this.sumaMax = this.genSubs.VlookUpStrIntInt("Dotal", this.datosvi.idMonedaSelEdu, this.datosvi.lstCoberturaEdu, this.datosvi.lstIdMonedaEdu, this.datosvi.lstSumaMaxEdu);
        if (this.datosvi.sumaDotalMenor > this.sumaMax) {
            this.datosvi.sumaDotalMenor = this.sumaMax;
        }
        this.sumaDotalMenor.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaDotalMenor));
    }

    public void ClicConyuge() {
        Boolean tmpBool = this.chkConyuge.isSelected();
        this.datosvi.selConyugeEdu = this.chkConyuge.isSelected();
        this.nombreConyuge.setVisible(tmpBool.booleanValue());
        this.titEdadRealConyuge.setVisible(tmpBool.booleanValue());
        this.edadRealConyuge.setVisible(tmpBool.booleanValue());
        this.optMasculinoConyuge.setVisible(tmpBool.booleanValue());
        this.optFemeninoConyuge.setVisible(tmpBool.booleanValue());
        this.optFumaConyuge.setVisible(tmpBool.booleanValue());
        this.optNoFumaConyuge.setVisible(tmpBool.booleanValue());
        this.titConyuge.setVisible(tmpBool.booleanValue());
        this.titEdadCalculoConyuge.setVisible(tmpBool.booleanValue());
        this.edadCalculoConyuge.setVisible(tmpBool.booleanValue());
        this.titEPconyuge.setVisible(tmpBool.booleanValue());
        this.epMillarBASconyugeEdu.setVisible(tmpBool.booleanValue());
        this.epPorBASconyugeEdu.setVisible(tmpBool.booleanValue());
        this.titBASconyuge.setVisible(tmpBool.booleanValue());
        this.sumaBASconyuge.setVisible(tmpBool.booleanValue());
        this.primaBASconyuge.setVisible(tmpBool.booleanValue());
        this.chkGFconyuge.setVisible(tmpBool.booleanValue());
        this.sumaGFconyuge.setVisible(tmpBool.booleanValue());
        this.primaGFconyuge.setVisible(tmpBool.booleanValue());
        this.lblPrimaConyuge.setVisible(tmpBool.booleanValue());
        this.primaConyuge.setVisible(tmpBool.booleanValue());
        this.lblEPconyuge.setVisible(tmpBool.booleanValue());
        this.lblEPmillarConyuge.setVisible(tmpBool.booleanValue());
        this.lblEPporConyuge.setVisible(tmpBool.booleanValue());
        if (tmpBool.booleanValue()) {
            this.datosvi.sumaBASconyuge = this.sumaMin = this.genSubs.VlookUpStrIntInt("Conyuge", this.datosvi.idMonedaSelEdu, this.datosvi.lstCoberturaEdu, this.datosvi.lstIdMonedaEdu, this.datosvi.lstSumaMinEdu);
            this.sumaBASconyuge.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaBASconyuge));
        } else {
            this.datosvi.sumaBASconyuge = 0;
            this.sumaBASconyuge.setText("");
            this.primaBASconyuge.setText("");
            this.primaConyuge.setText("");
        }
        this.CalculaPrimas();
    }

    public void ClicSexoFuma() {
        this.datosvi.optMasculinoEdu = this.optMasculinoEdu.isSelected();
        this.datosvi.sexoTitularEdu = this.datosvi.optMasculinoEdu != false ? "M" : "F";
        this.datosvi.optFumaEdu = this.optFumaEdu.isSelected();
        this.datosvi.optNoFumaEdu = this.optNoFumaEdu.isSelected();
        this.datosvi.fumaTitularEdu = this.datosvi.optFumaEdu != false ? "S" : "N";
        this.DeterminaEdadCalculo();
        this.DeterminaEdadCalculoConyuge();
        this.CalculaPrimas();
    }

    public void ClicFumaConyuge() {
        this.datosvi.fumaConyuge = this.optFumaConyuge.isSelected() ? "S" : "N";
        this.DeterminaEdadCalculoConyuge();
        this.CalculaPrimas();
    }

    public void ClicSexoConyuge() {
        this.datosvi.sexoConyuge = this.optMasculinoConyuge.isSelected() ? "M" : "F";
        this.DeterminaEdadCalculoConyuge();
        this.CalculaPrimas();
    }

    private void ValidaEdadRealEdu() {
        if (this.edadRealEdu.getText().equals("")) {
            this.edadRealEdu.setText("0");
        }
        this.datosvi.edadRealEdu = Integer.parseInt(this.edadRealEdu.getText().toString());
        this.txtMensaje = "";
        if (this.datosvi.edadRealEdu < 18) {
            this.txtMensaje = "La edad del titular debe ser mayor a 17\r";
            this.txtMensaje = this.txtMensaje + "Se cambia a edad m\u00ednima";
            this.edadRealEdu.setText("18");
        } else if (this.datosvi.edadRealEdu > 70) {
            this.txtMensaje = "La edad del titular menor a 71\r";
            this.txtMensaje = this.txtMensaje + "Se cambia a edad m\u00e1xima";
            this.edadRealEdu.setText("70");
        }
        if (!this.txtMensaje.equals("")) {
            this.genSubs.MuestraMensaje(this.txtMensaje);
            this.verCotizacion.setDisable(true);
        } else {
            this.datosvi.edadRealEdu = Integer.parseInt(this.edadRealEdu.getText().toString());
            this.DeterminaEdadCalculo();
            this.RevisaLimitesEdad();
            this.CalculaPlazos();
            this.CalculaPrimas();
            this.verCotizacion.setDisable(false);
        }
    }

    private void DeterminaEdadCalculo() {
        Integer reduccionEdad = this.datosvi.sexoTitularEdu.equals("M") ? (this.datosvi.fumaTitularEdu.equals("S") ? Integer.valueOf(0) : Integer.valueOf(2)) : (this.datosvi.fumaTitularEdu.equals("S") ? Integer.valueOf(3) : Integer.valueOf(5));
        this.datosvi.edadCalculoEdu = this.datosvi.edadRealEdu - reduccionEdad;
        if (this.datosvi.edadCalculoEdu < 18) {
            this.datosvi.edadCalculoEdu = 18;
        }
        this.edadCalculoEdu.setText(this.genSubs.FormatoNumInteger("##", this.datosvi.edadCalculoEdu));
    }

    private void DeterminaEdadCalculoConyuge() {
        Integer reduccionEdad = this.datosvi.sexoConyuge.equals("M") ? (this.datosvi.fumaConyuge.equals("S") ? Integer.valueOf(0) : Integer.valueOf(2)) : (this.datosvi.fumaConyuge.equals("S") ? Integer.valueOf(3) : Integer.valueOf(5));
        this.datosvi.edadCalculoConyuge = this.datosvi.edadRealConyuge - reduccionEdad;
        if (this.datosvi.edadCalculoConyuge < 18) {
            this.datosvi.edadCalculoConyuge = 18;
        }
        this.edadCalculoConyuge.setText(this.genSubs.FormatoNumInteger("##", this.datosvi.edadCalculoConyuge));
    }

    private void ValidaEdadRealMenor() {
        if (this.edadRealMenor.getText().equals("")) {
            this.edadRealMenor.setText("0");
        }
        this.datosvi.edadRealMenor = Integer.parseInt(this.edadRealMenor.getText().toString());
        this.txtMensaje = "";
        if (this.datosvi.edadRealMenor > 18) {
            this.txtMensaje = "La edad del menor debe ser menor a 19\r";
            this.txtMensaje = this.txtMensaje + "Se cambia a edad m\u00e1xima";
            this.genSubs.MuestraMensaje(this.txtMensaje);
            this.edadRealMenor.setText("18");
        }
        this.datosvi.edadRealMenor = Integer.parseInt(this.edadRealMenor.getText().toString());
        this.DeterminaMiniDotales();
        this.DeterminaPlazoDotal();
        this.CalculaPrimas();
    }

    private void ValidaEdadRealConyuge() {
        if (this.edadRealConyuge.getText().equals("")) {
            this.edadRealConyuge.setText("0");
        }
        this.datosvi.edadRealConyuge = Integer.parseInt(this.edadRealConyuge.getText().toString());
        this.txtMensaje = "";
        if (this.datosvi.edadRealConyuge < 18) {
            this.txtMensaje = "La edad del c\u00f3nyuge debe ser mayor a 17\r";
            this.txtMensaje = this.txtMensaje + "Se cambia a edad m\u00ednima";
            this.edadRealConyuge.setText("18");
        } else if (this.datosvi.edadRealConyuge > 70) {
            this.txtMensaje = "La edad del c\u00f3nyuge menor a 71\r";
            this.txtMensaje = this.txtMensaje + "Se cambia a edad m\u00e1xima";
            this.edadRealConyuge.setText("70");
        }
        if (!this.txtMensaje.equals("")) {
            this.genSubs.MuestraMensaje(this.txtMensaje);
        }
        this.datosvi.edadRealConyuge = Integer.parseInt(this.edadRealConyuge.getText().toString());
        this.DeterminaEdadCalculoConyuge();
        this.CalculaPrimas();
    }

    private void ValidaEpMillarBASedu() {
        if (this.epMillarBASedu.getText().equals("")) {
            this.epMillarBASedu.setText("0");
        }
        this.datosvi.epMillarBASedu = this.tmpDouble = Double.valueOf(Double.parseDouble(this.epMillarBASedu.getText().toString()));
        this.CalculaPrimas();
    }

    private void ValidaEpPorBASedu() {
        if (this.epPorBASedu.getText().equals("")) {
            this.epPorBASedu.setText("0");
        }
        this.tmpDouble = Double.parseDouble(this.epPorBASedu.getText().toString());
        this.datosvi.epPorBASedu = this.tmpDouble / 100.0;
        this.CalculaPrimas();
    }

    private void ValidaEpPorINVedu() {
        if (this.epPorINVedu.getText().equals("")) {
            this.epPorINVedu.setText("0");
        }
        this.tmpDouble = Double.parseDouble(this.epPorINVedu.getText().toString());
        this.datosvi.epPorINVedu = this.tmpDouble / 100.0;
        this.CalculaPrimas();
    }

    private void ValidaEpPorACCedu() {
        if (this.epPorACCedu.getText().equals("")) {
            this.epPorACCedu.setText("0");
        }
        this.tmpDouble = Double.parseDouble(this.epPorACCedu.getText().toString());
        this.datosvi.epPorACCedu = this.tmpDouble / 100.0;
        this.CalculaPrimas();
    }

    private void ValidaEpMillarBASconyugeEdu() {
        if (this.epMillarBASconyugeEdu.getText().equals("")) {
            this.epMillarBASconyugeEdu.setText("0");
        }
        this.datosvi.epMillarBASconyugeEdu = this.tmpDouble = Double.valueOf(Double.parseDouble(this.epMillarBASconyugeEdu.getText().toString()));
        this.CalculaPrimas();
    }

    private void ValidaEpPorBASconyugeEdu() {
        if (this.epPorBASconyugeEdu.getText().equals("")) {
            this.epPorBASconyugeEdu.setText("0");
        }
        this.tmpDouble = Double.parseDouble(this.epPorBASconyugeEdu.getText().toString());
        this.datosvi.epPorBASconyugeEdu = this.tmpDouble / 100.0;
        this.CalculaPrimas();
    }

    private void DeterminaMiniDotales() {
        this.chkMiniEdad5.setDisable(false);
        this.chkMiniEdad11.setDisable(false);
        this.chkMiniEdad14.setDisable(false);
        this.chkMiniEdad16.setDisable(false);
        if (this.datosvi.edadRealMenor >= 1) {
            this.chkMiniEdad5.setSelected(false);
            this.chkMiniEdad5.setDisable(true);
            this.datosvi.selMiniEdad5 = false;
        }
        if (this.datosvi.edadRealMenor >= 7) {
            this.chkMiniEdad11.setSelected(false);
            this.chkMiniEdad11.setDisable(true);
            this.datosvi.selMiniEdad11 = false;
        }
        if (this.datosvi.edadRealMenor >= 10) {
            this.chkMiniEdad14.setSelected(false);
            this.chkMiniEdad14.setDisable(true);
            this.datosvi.selMiniEdad14 = false;
        }
        if (this.datosvi.edadRealMenor >= 12) {
            this.chkMiniEdad16.setSelected(false);
            this.chkMiniEdad16.setDisable(true);
            this.datosvi.selMiniEdad16 = false;
        }
    }

    private void DeterminaPlazoDotal() {
        Integer indiceMinimoDotal = this.datosvi.edadRealMenor <= 13 ? Integer.valueOf(0) : Integer.valueOf(this.datosvi.edadRealMenor - 13);
        this.cmbDotalMenor.getItems().clear();
        for (int i = indiceMinimoDotal.intValue(); i < this.datosvi.lstDotalMenor.size(); ++i) {
            this.cmbDotalMenor.getItems().add((Object)this.datosvi.lstDotalMenor.get(i));
        }
        this.datosvi.dotalMenorSel = this.datosvi.lstDotalMenor.get(indiceMinimoDotal);
        this.cmbDotalMenor.setValue((Object)this.datosvi.dotalMenorSel);
        this.CalculaPlazos();
    }

    public void ClicSexoMenor() {
        this.datosvi.optMasculinoMenor = this.optMasculinoMenor.isSelected();
        this.datosvi.optFemeninoMenor = this.optFemeninoMenor.isSelected();
        this.datosvi.sexoMenor = this.datosvi.optMasculinoMenor != false ? "M" : "F";
    }

    private void ValidaSumaBASedu() {
        if (this.sumaBASedu.getText().equals("")) {
            this.sumaBASedu.setText("0");
        }
        this.datosvi.sumaBASedu = this.tmpInt = Integer.valueOf(Integer.parseInt(this.genSubs.QuitaComas(this.sumaBASedu.getText().toString())));
        this.sumaMin = this.genSubs.VlookUpStrIntInt("Titular", this.datosvi.idMonedaSelEdu, this.datosvi.lstCoberturaEdu, this.datosvi.lstIdMonedaEdu, this.datosvi.lstSumaMinEdu);
        if (this.tmpInt < this.sumaMin) {
            this.datosvi.sumaBASedu = this.sumaMin;
        }
        this.sumaBASedu.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaBASedu));
        this.ActualizaSumaBeneficios();
    }

    private void ValidaSumaBASconyuge() {
        if (this.sumaBASconyuge.getText().equals("")) {
            this.sumaBASconyuge.setText("0");
        }
        this.datosvi.sumaBASconyuge = this.tmpInt = Integer.valueOf(Integer.parseInt(this.genSubs.QuitaComas(this.sumaBASconyuge.getText().toString())));
        this.sumaMin = this.genSubs.VlookUpStrIntInt("Conyuge", this.datosvi.idMonedaSelEdu, this.datosvi.lstCoberturaEdu, this.datosvi.lstIdMonedaEdu, this.datosvi.lstSumaMinEdu);
        if (this.tmpInt < this.sumaMin) {
            this.datosvi.sumaBASconyuge = this.sumaMin;
        }
        if (this.datosvi.sumaBASconyuge > this.datosvi.sumaBASedu) {
            this.datosvi.sumaBASconyuge = this.datosvi.sumaBASedu;
        }
        this.sumaBASconyuge.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaBASconyuge));
        this.CalculaPrimas();
    }

    public void ValidaGPPIedu() {
        this.datosvi.selGPPIedu = this.chkGPPIedu.isSelected();
        this.sumaGPPIedu.setVisible(true);
        if (this.chkGPPIedu.isSelected()) {
            this.sumaGPPIedu.setText("Cubierto");
        } else {
            this.sumaGPPIedu.setText("Excluido");
        }
        this.CalculaPrimas();
    }

    public void ValidaGPPFedu() {
        this.datosvi.selGPPFedu = this.chkGPPFedu.isSelected();
        this.sumaGPPFedu.setVisible(true);
        if (this.chkGPPFedu.isSelected()) {
            this.sumaGPPFedu.setText("Cubierto");
        } else {
            this.sumaGPPFedu.setText("Excluido");
        }
        this.CalculaPrimas();
    }

    public void ValidaPASIedu() {
        this.datosvi.selPASIedu = this.chkPASIedu.isSelected();
        this.datosvi.sumaPASIedu = 0;
        if (this.datosvi.selPASIedu.booleanValue()) {
            this.datosvi.sumaPASIedu = this.datosvi.sumaBASedu;
        }
        this.sumaPASIedu.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaPASIedu));
        this.CalculaPrimas();
    }

    public void ValidaEGedu() {
        this.datosvi.selEGedu = this.chkEGedu.isSelected();
        this.datosvi.sumaEGedu = 0;
        if (this.datosvi.selEGedu.booleanValue()) {
            this.datosvi.sumaEGedu = this.datosvi.sumaBASedu;
        }
        this.sumaEGedu.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaEGedu));
        this.ValidaSumaEGedu();
        this.CalculaPrimas();
    }

    public void ValidaGFtitularEdu() {
        this.datosvi.selGFedu = this.chkGFedu.isSelected();
        this.datosvi.sumaGFedu = 0;
        if (this.datosvi.selGFedu.booleanValue()) {
            this.datosvi.sumaGFedu = this.datosvi.sumaBASedu;
            this.valorTmp = this.genSubs.VlookUpStrIntInt("GF", this.datosvi.idMonedaSelEdu, this.datosvi.lstIdBeneficioSumas, this.datosvi.lstIdMonedaSumas, this.datosvi.lstSumaMaxBeneficio);
            if (this.datosvi.sumaGFedu > this.valorTmp) {
                this.datosvi.sumaGFedu = this.valorTmp;
            }
        }
        this.sumaGFedu.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaGFedu));
        this.CalculaPrimas();
    }

    public void ValidaIMAedu() {
        if (this.chkIMAedu.isSelected()) {
            this.sumaIMAedu.setVisible(true);
            this.primaIMAedu.setVisible(true);
            this.datosvi.selIMAedu = true;
            this.chkTIBAedu.setSelected(false);
            this.sumaTIBAedu.setVisible(false);
            this.primaTIBAedu.setVisible(false);
            this.datosvi.selTIBAedu = false;
            this.datosvi.sumaTIBAedu = 0;
            this.datosvi.primaTIBAedu = 0.0;
        } else {
            this.sumaIMAedu.setVisible(false);
            this.primaIMAedu.setVisible(false);
            this.datosvi.sumaIMAedu = 0;
            this.datosvi.primaIMAedu = 0.0;
        }
        this.ValidaAccidentes();
    }

    public void ValidaTIBAedu() {
        if (this.chkTIBAedu.isSelected()) {
            this.sumaTIBAedu.setVisible(true);
            this.primaTIBAedu.setVisible(true);
            this.datosvi.selTIBAedu = true;
            this.chkIMAedu.setSelected(false);
            this.sumaIMAedu.setVisible(false);
            this.primaIMAedu.setVisible(false);
            this.datosvi.selIMAedu = false;
            this.datosvi.sumaIMAedu = 0;
            this.datosvi.primaIMAedu = 0.0;
        } else {
            this.sumaTIBAedu.setVisible(false);
            this.primaTIBAedu.setVisible(false);
            this.datosvi.sumaTIBAedu = 0;
            this.datosvi.primaTIBAedu = 0.0;
        }
        this.ValidaAccidentes();
    }

    private void ValidaAccidentes() {
        if (this.chkIMAedu.isSelected()) {
            this.datosvi.selIMAedu = true;
            this.datosvi.sumaIMAedu = this.datosvi.sumaBASedu;
            this.sumaIMAedu.setVisible(true);
            this.primaIMAedu.setVisible(true);
            this.sumaIMAedu.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaIMAedu));
            this.valorTmp = this.genSubs.VlookUpStrIntInt("ACC", this.datosvi.idMonedaSelEdu, this.datosvi.lstIdBeneficioSumas, this.datosvi.lstIdMonedaSumas, this.datosvi.lstSumaMaxBeneficio);
        }
        if (this.chkTIBAedu.isSelected()) {
            this.datosvi.selTIBAedu = true;
            this.datosvi.sumaTIBAedu = this.datosvi.sumaBASedu;
            this.sumaTIBAedu.setVisible(true);
            this.primaTIBAedu.setVisible(true);
            this.sumaTIBAedu.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaTIBAedu));
        }
        if (!this.chkIMAedu.isSelected() && !this.chkTIBAedu.isSelected()) {
            this.datosvi.selIMAedu = false;
            this.sumaIMAedu.setVisible(false);
            this.primaIMAedu.setVisible(false);
            this.datosvi.selIMAedu = false;
            this.datosvi.sumaIMAedu = 0;
            this.datosvi.primaIMAedu = 0.0;
            this.datosvi.selTIBAedu = false;
            this.sumaTIBAedu.setVisible(false);
            this.primaTIBAedu.setVisible(false);
            this.datosvi.selTIBAedu = false;
            this.datosvi.sumaTIBAedu = 0;
            this.datosvi.primaTIBAedu = 0.0;
        }
        this.CalculaPrimas();
    }

    private void ValidaSumaPASIedu() {
        this.datosvi.sumaPASIedu = this.ValidaSumaCobertura(this.sumaPASIedu, "PASI");
        this.sumaPASIedu.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaPASIedu));
        this.CalculaPrimas();
    }

    private void ValidaSumaIMAedu() {
        this.datosvi.sumaIMAedu = this.ValidaSumaCobertura(this.sumaIMAedu, "IMA");
        this.sumaIMAedu.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaIMAedu));
        this.CalculaPrimas();
    }

    private void ValidaSumaTIBAedu() {
        this.datosvi.sumaTIBAedu = this.ValidaSumaCobertura(this.sumaTIBAedu, "TIBA");
        this.sumaTIBAedu.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaTIBAedu));
        this.CalculaPrimas();
    }

    private void ValidaSumaEGedu() {
        this.datosvi.sumaEGedu = this.ValidaSumaCobertura(this.sumaEGedu, "EG");
        this.sumaEGedu.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaEGedu));
        this.CalculaPrimas();
    }

    private Integer ValidaSumaCobertura(TextField sumaCobertura, String idCobertura) {
        Integer sumaAsegurada = 0;
        if (sumaCobertura.getText().equals("")) {
            sumaCobertura.setText("0");
        }
        if ((sumaAsegurada = (this.tmpInt = Integer.valueOf(Integer.parseInt(this.genSubs.QuitaComas(sumaCobertura.getText().toString()))))) > this.datosvi.sumaBASedu) {
            sumaAsegurada = this.datosvi.sumaBASedu;
        }
        this.sumaMinima = this.genSubs.VlookUpStrIntInt(idCobertura, this.datosvi.idMonedaSelEdu, this.datosvi.lstCoberturaEdu, this.datosvi.lstIdMonedaEdu, this.datosvi.lstSumaMinEdu);
        if (sumaAsegurada < this.sumaMinima) {
            sumaAsegurada = this.sumaMinima;
        }
        this.sumaMaxima = this.genSubs.VlookUpStrIntInt(idCobertura, this.datosvi.idMonedaSelEdu, this.datosvi.lstCoberturaEdu, this.datosvi.lstIdMonedaEdu, this.datosvi.lstSumaMaxEdu);
        if (sumaAsegurada > this.sumaMaxima && this.sumaMaxima > 0) {
            sumaAsegurada = this.sumaMaxima;
        }
        return sumaAsegurada;
    }

    private void ValidaTipoCambio() {
        Integer tipoCambioMin = 1;
        if (this.datosvi.monedaSelEdu.equals("D\u00f3lares")) {
            if (this.tipoCambio.getText().equals("")) {
                this.tipoCambio.setText("0");
            }
            this.datosvi.tipoCambioDolar = Double.parseDouble(this.tipoCambio.getText().toString());
            tipoCambioMin = this.datos.conEPmetalife != false ? Integer.valueOf(1) : Integer.valueOf(15);
            if (this.datosvi.tipoCambioDolar < (double)tipoCambioMin.intValue()) {
                this.txtMensaje = "Proporcione un tipo de cambio mayor";
                this.genSubs.MuestraMensaje(this.txtMensaje);
                this.verCotizacion.setDisable(true);
            } else {
                this.verCotizacion.setDisable(false);
                this.ValidaSumaDotalMenor();
            }
        }
    }

    public void RevisaSaldado() {
        this.datosvi.incluirSaldado = this.chkSaldado.isSelected();
    }

    private void ActualizaSumaBeneficios() {
        this.datosvi.sumaPASIedu = this.ActualizaSumaCobertura(this.datosvi.selPASIedu, "PASI");
        this.sumaPASIedu.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaPASIedu));
        this.datosvi.sumaIMAedu = this.ActualizaSumaCobertura(this.datosvi.selIMAedu, "IMA");
        this.sumaIMAedu.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaIMAedu));
        this.datosvi.sumaTIBAedu = this.ActualizaSumaCobertura(this.datosvi.selTIBAedu, "TIBA");
        this.sumaTIBAedu.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaTIBAedu));
        this.datosvi.sumaEGedu = this.ActualizaSumaCobertura(this.datosvi.selEGedu, "EG");
        this.sumaEGedu.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaEGedu));
        this.datosvi.sumaGFedu = this.ActualizaSumaCobertura(this.datosvi.selGFedu, "GF");
        this.sumaGFedu.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaGFedu));
        this.datosvi.sumaGFconyuge = this.ActualizaSumaCobertura(this.datosvi.selGFconyuge, "GF");
        this.datosvi.sumaGFconyuge = this.ActualizaSumaCobertura(this.datosvi.selGFconyuge, "GF");
        this.sumaGFconyuge.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaGFconyuge));
        this.datosvi.sumaBASconyuge = this.datosvi.sumaBASedu;
        this.sumaBASconyuge.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaBASconyuge));
        this.datosvi.sumaGFmenor = this.ActualizaSumaCobertura(this.datosvi.selGFmenor, "GF");
        this.sumaGFmenor.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaGFmenor));
        this.CalculaPrimas();
    }

    private Integer ActualizaSumaCobertura(Boolean selCobertura, String idCobertura) {
        Integer sumaAsegurada;
        if (selCobertura.booleanValue()) {
            sumaAsegurada = this.datosvi.sumaBASedu;
            this.valorTmp = this.genSubs.VlookUpStrIntInt(idCobertura, this.datosvi.idMonedaSelEdu, this.datosvi.lstCoberturaEdu, this.datosvi.lstIdMonedaEdu, this.datosvi.lstSumaMaxEdu);
            if (sumaAsegurada > this.valorTmp && this.valorTmp > 0) {
                sumaAsegurada = this.valorTmp;
            }
            this.valorTmp = this.genSubs.VlookUpStrIntInt(idCobertura, this.datosvi.idMonedaSelEdu, this.datosvi.lstCoberturaEdu, this.datosvi.lstIdMonedaEdu, this.datosvi.lstSumaMinEdu);
            if (sumaAsegurada < this.valorTmp) {
                sumaAsegurada = this.valorTmp;
            }
        } else {
            sumaAsegurada = 0;
        }
        return sumaAsegurada;
    }

    public void ValidaMiniEdad5() {
        this.datosvi.selMiniEdad5 = this.chkMiniEdad5.isSelected();
        this.datosvi.sumaMiniEdad5 = this.DeterminaSumaMiniDotal(this.datosvi.selMiniEdad5);
        this.sumaMiniEdad5.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaMiniEdad5));
        this.CalculaPrimas();
    }

    public void ValidaMiniEdad11() {
        this.datosvi.selMiniEdad11 = this.chkMiniEdad11.isSelected();
        this.datosvi.sumaMiniEdad11 = this.DeterminaSumaMiniDotal(this.datosvi.selMiniEdad11);
        this.sumaMiniEdad11.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaMiniEdad11));
        this.CalculaPrimas();
    }

    public void ValidaMiniEdad14() {
        this.datosvi.selMiniEdad14 = this.chkMiniEdad14.isSelected();
        this.datosvi.sumaMiniEdad14 = this.DeterminaSumaMiniDotal(this.datosvi.selMiniEdad14);
        this.sumaMiniEdad14.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaMiniEdad14));
        this.CalculaPrimas();
    }

    public void ValidaMiniEdad16() {
        this.datosvi.selMiniEdad16 = this.chkMiniEdad16.isSelected();
        this.datosvi.sumaMiniEdad16 = this.DeterminaSumaMiniDotal(this.datosvi.selMiniEdad16);
        this.sumaMiniEdad16.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaMiniEdad16));
        this.CalculaPrimas();
    }

    private Integer DeterminaSumaMiniDotal(Boolean selMiniDotal) {
        Integer sumaAsegurada;
        if (selMiniDotal.booleanValue()) {
            this.tmpDouble = this.datosvi.porSumaMini * (double)this.datosvi.sumaDotalMenor.intValue();
            this.tmpDouble = this.genSubs.Redondea(this.tmpDouble, 0);
            sumaAsegurada = this.tmpDouble.intValue();
        } else {
            sumaAsegurada = 0;
        }
        return sumaAsegurada;
    }

    public void ValidaGFmenor() {
        this.datosvi.selGFmenor = this.chkGFmenor.isSelected();
        this.datosvi.sumaGFmenor = 0;
        if (this.datosvi.selGFmenor.booleanValue()) {
            this.datosvi.sumaGFmenor = this.datosvi.sumaDotalMenor;
            this.valorTmp = this.genSubs.VlookUpStrIntInt("GF", this.datosvi.idMonedaSelEdu, this.datosvi.lstIdBeneficioSumas, this.datosvi.lstIdMonedaSumas, this.datosvi.lstSumaMaxBeneficio);
            if (this.datosvi.sumaGFmenor > this.valorTmp) {
                this.datosvi.sumaGFmenor = this.valorTmp;
            }
        }
        this.sumaGFmenor.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaGFmenor));
        this.CalculaPrimas();
    }

    public void ValidaGFconyuge() {
        this.datosvi.selGFconyuge = this.chkGFconyuge.isSelected();
        this.datosvi.sumaGFconyuge = 0;
        if (this.datosvi.selGFconyuge.booleanValue()) {
            this.datosvi.sumaGFconyuge = this.datosvi.sumaBASconyuge;
            this.valorTmp = this.genSubs.VlookUpStrIntInt("GF", this.datosvi.idMonedaSelEdu, this.datosvi.lstIdBeneficioSumas, this.datosvi.lstIdMonedaSumas, this.datosvi.lstSumaMaxBeneficio);
            if (this.datosvi.sumaGFconyuge > this.valorTmp) {
                this.datosvi.sumaGFconyuge = this.valorTmp;
            }
            this.sumaGFconyuge.setVisible(true);
            this.primaGFconyuge.setVisible(true);
        } else {
            this.datosvi.sumaGFconyuge = 0;
            this.sumaGFconyuge.setVisible(false);
            this.primaGFconyuge.setVisible(false);
        }
        this.sumaGFconyuge.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaGFconyuge));
        this.CalculaPrimas();
    }

    private void ValidaSumaDotalMenor() {
        if (this.sumaDotalMenor.getText().equals("")) {
            this.sumaDotalMenor.setText("0");
        }
        this.datosvi.sumaDotalMenor = this.tmpInt = Integer.valueOf(Integer.parseInt(this.genSubs.QuitaComas(this.sumaDotalMenor.getText().toString())));
        this.sumaMin = this.genSubs.VlookUpStrIntInt("Dotal", this.datosvi.idMonedaSelEdu, this.datosvi.lstCoberturaEdu, this.datosvi.lstIdMonedaEdu, this.datosvi.lstSumaMinEdu);
        if (this.tmpInt < this.sumaMin) {
            this.datosvi.sumaDotalMenor = this.sumaMin;
        }
        if (this.datosvi.idMonedaSelEdu == 2) {
            this.tmpDouble = this.datosvi.tipoCambioDolar * (double)this.datosvi.sumaDotalMenor.intValue();
            this.sumaMax = this.genSubs.VlookUpStrIntInt("Dotal", 1, this.datosvi.lstCoberturaEdu, this.datosvi.lstIdMonedaEdu, this.datosvi.lstSumaMaxEdu);
            this.tmpInt = this.tmpDouble.intValue();
            if (this.datos.conEPmetalife.booleanValue()) {
                this.sumaMax = 1000000;
            }
            if (this.tmpInt > this.sumaMax) {
                this.tmpInt = this.sumaMax;
            }
            this.tmpDouble = (double)this.tmpInt.intValue() / this.datosvi.tipoCambioDolar;
            this.datosvi.sumaDotalMenor = this.tmpDouble.intValue();
        } else {
            this.sumaMax = this.genSubs.VlookUpStrIntInt("Dotal", this.datosvi.idMonedaSelEdu, this.datosvi.lstCoberturaEdu, this.datosvi.lstIdMonedaEdu, this.datosvi.lstSumaMaxEdu);
            if (this.tmpInt > this.sumaMax) {
                this.datosvi.sumaDotalMenor = this.sumaMax;
            }
        }
        this.sumaDotalMenor.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaDotalMenor));
        this.ActualizaSumaMiniDotales();
    }

    private void ActualizaSumaMiniDotales() {
        this.ValidaMiniEdad5();
        this.ValidaMiniEdad11();
        this.ValidaMiniEdad14();
        this.ValidaMiniEdad16();
    }

    private void CalculaPrimas() {
        Double primaMenor = 0.0;
        Double primaTitular = 0.0;
        this.sumaGPPIedu.setVisible(this.datosvi.selGPPIedu.booleanValue());
        this.primaGPPIedu.setVisible(this.datosvi.selGPPIedu.booleanValue());
        this.sumaPASIedu.setVisible(this.datosvi.selPASIedu.booleanValue());
        this.primaPASIedu.setVisible(this.datosvi.selPASIedu.booleanValue());
        this.sumaGPPFedu.setVisible(this.datosvi.selGPPFedu.booleanValue());
        this.primaGPPFedu.setVisible(this.datosvi.selGPPFedu.booleanValue());
        this.sumaIMAedu.setVisible(this.datosvi.selIMAedu.booleanValue());
        this.primaIMAedu.setVisible(this.datosvi.selIMAedu.booleanValue());
        this.sumaTIBAedu.setVisible(this.datosvi.selTIBAedu.booleanValue());
        this.primaTIBAedu.setVisible(this.datosvi.selTIBAedu.booleanValue());
        this.sumaEGedu.setVisible(this.datosvi.selEGedu.booleanValue());
        this.primaEGedu.setVisible(this.datosvi.selEGedu.booleanValue());
        this.sumaGFedu.setVisible(this.datosvi.selGFedu.booleanValue());
        this.primaGFedu.setVisible(this.datosvi.selGFedu.booleanValue());
        this.sumaDotalMenor.setVisible(true);
        this.primaDotalMenor.setVisible(true);
        this.sumaMiniEdad5.setVisible(this.datosvi.selMiniEdad5.booleanValue());
        this.sumaMiniEdad11.setVisible(this.datosvi.selMiniEdad11.booleanValue());
        this.sumaMiniEdad14.setVisible(this.datosvi.selMiniEdad14.booleanValue());
        this.sumaMiniEdad16.setVisible(this.datosvi.selMiniEdad16.booleanValue());
        this.primaMiniEdad5.setVisible(this.datosvi.selMiniEdad5.booleanValue());
        this.primaMiniEdad11.setVisible(this.datosvi.selMiniEdad11.booleanValue());
        this.primaMiniEdad14.setVisible(this.datosvi.selMiniEdad14.booleanValue());
        this.primaMiniEdad16.setVisible(this.datosvi.selMiniEdad16.booleanValue());
        this.sumaGFmenor.setVisible(this.datosvi.selGFmenor.booleanValue());
        this.primaGFmenor.setVisible(this.datosvi.selGFmenor.booleanValue());
        if (this.chkConyuge.isSelected()) {
            this.sumaBASconyuge.setVisible(this.chkConyuge.isSelected());
            this.primaBASconyuge.setVisible(this.chkConyuge.isSelected());
            this.sumaGFconyuge.setVisible(this.datosvi.selGFconyuge.booleanValue());
            this.primaGFconyuge.setVisible(this.datosvi.selGFconyuge.booleanValue());
        }
        this.calculosvi.CalculaPrimasEdu();
        this.primaBASedu.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaBASedu + (double)this.datosvi.recargoFijoEdu.intValue()));
        this.primaGPPIedu.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaGPPIedu));
        this.primaPASIedu.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaPASIedu));
        this.primaGPPFedu.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaGPPFedu));
        this.primaIMAedu.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaIMAedu));
        this.primaTIBAedu.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaTIBAedu));
        this.primaEGedu.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaEGedu));
        this.primaGFedu.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaGFedu));
        primaTitular = this.datosvi.primaBASedu + (double)this.datosvi.recargoFijoEdu.intValue() + this.datosvi.primaGPPIedu + this.datosvi.primaPASIedu;
        primaTitular = primaTitular + (this.datosvi.primaGPPFedu + this.datosvi.primaIMAedu + this.datosvi.primaTIBAedu);
        primaTitular = primaTitular + (this.datosvi.primaEGedu + this.datosvi.primaGFedu);
        this.primaTotalTitular.setText(this.genSubs.FormatoNumDouble("###,###.00", primaTitular));
        this.primaDotalMenor.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaDotalMenor));
        this.primaMiniEdad5.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaMiniEdad5));
        this.primaMiniEdad11.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaMiniEdad11));
        this.primaMiniEdad14.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaMiniEdad14));
        this.primaMiniEdad16.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaMiniEdad16));
        this.primaGFmenor.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaGFmenor));
        primaMenor = this.datosvi.primaDotalMenor + this.datosvi.primaMiniEdad5 + this.datosvi.primaMiniEdad11 + this.datosvi.primaMiniEdad14 + this.datosvi.primaMiniEdad16 + this.datosvi.primaGFmenor;
        this.primaTotalMenor.setText(this.genSubs.FormatoNumDouble("###,###", primaMenor));
        this.primaBASconyuge.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaBASconyuge));
        this.primaGFconyuge.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaGFconyuge));
        this.primaConyuge.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaBASconyuge + this.datosvi.primaGFconyuge));
        this.primaGPPIedu.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaGPPIedu));
        this.primaGPPFedu.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaGPPFedu));
        this.datosvi.primaTOTedu = this.datosvi.primaBASedu + (double)this.datosvi.recargoFijoEdu.intValue() + this.datosvi.primaGPPIedu + this.datosvi.primaPASIedu;
        DatosVI datosVI = this.datosvi;
        datosVI.primaTOTedu = datosVI.primaTOTedu + (this.datosvi.primaGPPFedu + this.datosvi.primaIMAedu + this.datosvi.primaTIBAedu);
        datosVI = this.datosvi;
        datosVI.primaTOTedu = datosVI.primaTOTedu + (this.datosvi.primaEGedu + this.datosvi.primaGFedu);
        datosVI = this.datosvi;
        datosVI.primaTOTedu = datosVI.primaTOTedu + (this.datosvi.primaDotalMenor + this.datosvi.primaMiniEdad5 + this.datosvi.primaMiniEdad11);
        datosVI = this.datosvi;
        datosVI.primaTOTedu = datosVI.primaTOTedu + (this.datosvi.primaMiniEdad14 + this.datosvi.primaMiniEdad16 + this.datosvi.primaGFmenor);
        datosVI = this.datosvi;
        datosVI.primaTOTedu = datosVI.primaTOTedu + (this.datosvi.primaBASconyuge + this.datosvi.primaGFconyuge);
        this.primaTOTedu.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaTOTedu));
        this.CalculaPrimaFormaPago();
    }

    private void CalculaPrimaFormaPago() {
        if (this.datosvi.formaPagoSelEdu.equals("Anual")) {
            this.datosvi.recargoFormaPagoEdu = 0.0;
            this.datosvi.primaFormaPagoEdu = this.datosvi.primaTOTedu;
            this.lblRecargoFormaPago.setVisible(false);
            this.lblPrimaFormaPago.setVisible(false);
            this.recargoFormaPagoEdu.setVisible(false);
            this.primaFormaPagoEdu.setVisible(false);
        } else {
            Double tasaRecargo = this.genSubs.VlookUp3IntDbl(22, this.datosvi.idMonedaSelEdu, this.datosvi.idFormaPagoSelEdu, this.datosvi.lstIdPlanRecargo, this.datosvi.lstIdMonedaRecargo, this.datosvi.lstIdFormaPago, this.datosvi.lstTasaRecargo);
            this.datosvi.recargoFormaPagoEdu = this.datosvi.primaTOTedu * tasaRecargo;
            this.datosvi.primaFormaPagoEdu = (this.datosvi.primaTOTedu + this.datosvi.recargoFormaPagoEdu) / (double)this.datosvi.numPagosEdu.intValue();
            this.lblRecargoFormaPago.setVisible(true);
            this.lblPrimaFormaPago.setVisible(true);
            this.recargoFormaPagoEdu.setVisible(true);
            this.primaFormaPagoEdu.setVisible(true);
            this.recargoFormaPagoEdu.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.recargoFormaPagoEdu));
            this.primaFormaPagoEdu.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosvi.primaFormaPagoEdu));
        }
    }

    public void RegresaInicio() {
        this.stage = (Stage)this.lblVersion.getScene().getWindow();
        this.datosvi.primeraVez = true;
        this.MuestraVentana("Inicio");
    }

    private void ValoresIniciales() {
        if (this.datosvi.primeraVezEdu.booleanValue()) {
            this.DatosPersonalesDefault();
            this.ValoresDefault();
        } else {
            this.DatosPersonales();
            if (this.datosvi.idPlanSel == this.datosvi.idPlanSelAnt) {
                this.ValoresCapturados();
            } else {
                this.ValoresDefault();
                this.datosvi.idPlanSelAnt = this.datosvi.idPlanSel;
            }
        }
        this.txtMensaje = "";
        this.RevisaLimitesEdad();
        if (!this.txtMensaje.equals("")) {
            this.genSubs.MuestraMensaje(this.txtMensaje);
        } else {
            this.nombreTitularEdu.selectAll();
        }
        this.datosvi.primeraVez = false;
        this.datosvi.idPlanSelAnt = this.datosvi.idPlanSel;
        this.CalculaPrimas();
        this.datosvi.esVidasConjuntas = false;
    }

    private void DatosPersonalesDefault() {
        this.nombreTitularEdu.setText("Nombre del titular");
        this.optMasculinoEdu.setSelected(true);
        this.optFumaEdu.setSelected(true);
        this.edadRealEdu.setText("35");
        this.datosvi.edadRealEdu = 35;
        this.edadCalculoEdu.setText("35");
        this.datosvi.edadCalculoEdu = 35;
        this.datosvi.optMasculinoEdu = true;
        this.datosvi.optFemeninoEdu = false;
        this.datosvi.optFumaEdu = true;
        this.datosvi.optNoFumaEdu = false;
        this.datosvi.sexoTitularEdu = "M";
        this.datosvi.fumaTitularEdu = "S";
        this.nombreConyuge.setText("Nombre del c\u00f3nyuge");
        this.datosvi.sexoConyuge = "F";
        this.optFemeninoConyuge.setSelected(true);
        this.optFumaConyuge.setSelected(true);
        this.datosvi.fumaConyuge = "S";
        this.edadRealConyuge.setText("35");
        this.datosvi.edadRealConyuge = 35;
        this.datosvi.edadCalculoConyuge = 32;
        this.edadCalculoConyuge.setText("32");
        this.nombreMenor.setText("Nombre del menor");
        this.optMasculinoMenor.setSelected(true);
        this.optFemeninoMenor.setSelected(false);
        this.datosvi.sexoMenor = "M";
        this.edadRealMenor.setText("0");
        this.datosvi.edadRealMenor = 0;
    }

    private void ValoresDefault() {
        this.chkGPPIedu.setSelected(true);
        this.chkGPPIedu.setDisable(true);
        this.datosvi.selGPPIedu = true;
        this.chkPASIedu.setSelected(false);
        this.chkGPPFedu.setSelected(true);
        this.chkGPPFedu.setDisable(true);
        this.datosvi.selGPPFedu = true;
        this.chkIMAedu.setSelected(false);
        this.chkTIBAedu.setSelected(false);
        this.chkEGedu.setSelected(false);
        this.chkGFedu.setSelected(false);
        this.sumaGPPIedu.setText("");
        this.sumaPASIedu.setText("");
        this.sumaGPPFedu.setText("");
        this.sumaIMAedu.setText("");
        this.sumaTIBAedu.setText("");
        this.sumaEGedu.setText("");
        this.sumaGFedu.setText("");
        this.sumaGPPIedu.setVisible(false);
        this.sumaPASIedu.setVisible(false);
        this.sumaGPPFedu.setVisible(false);
        this.sumaIMAedu.setVisible(false);
        this.sumaTIBAedu.setVisible(false);
        this.sumaEGedu.setVisible(false);
        this.sumaGFedu.setVisible(false);
        this.primaBASedu.setText("");
        this.primaGPPIedu.setText("");
        this.primaPASIedu.setText("");
        this.primaGPPFedu.setText("");
        this.primaIMAedu.setText("");
        this.primaTIBAedu.setText("");
        this.primaEGedu.setText("");
        this.primaGFedu.setText("");
        this.primaBASedu.setVisible(true);
        this.primaGPPIedu.setVisible(false);
        this.primaPASIedu.setVisible(false);
        this.primaGPPFedu.setVisible(false);
        this.primaIMAedu.setVisible(false);
        this.primaTIBAedu.setVisible(false);
        this.primaEGedu.setVisible(false);
        this.primaGFedu.setVisible(false);
        this.datosvi.selGPPIedu = false;
        this.datosvi.selPASIedu = false;
        this.datosvi.selGPPFedu = false;
        this.datosvi.selIMAedu = false;
        this.datosvi.selTIBAedu = false;
        this.datosvi.selEGedu = false;
        this.datosvi.selGFedu = false;
        this.datosvi.sumaBASedu = 0;
        this.datosvi.sumaGPPIedu = 0;
        this.datosvi.sumaPASIedu = 0;
        this.datosvi.sumaGPPFedu = 0;
        this.datosvi.sumaIMAedu = 0;
        this.datosvi.sumaTIBAedu = 0;
        this.datosvi.sumaEGedu = 0;
        this.datosvi.sumaGFedu = 0;
        this.datosvi.primaBASedu = 0.0;
        this.datosvi.primaGPPIedu = 0.0;
        this.datosvi.primaPASIedu = 0.0;
        this.datosvi.primaGPPFedu = 0.0;
        this.datosvi.primaIMAedu = 0.0;
        this.datosvi.primaTIBAedu = 0.0;
        this.datosvi.primaEGedu = 0.0;
        this.datosvi.primaGFedu = 0.0;
        this.chkMiniEdad5.setSelected(false);
        this.chkMiniEdad11.setSelected(false);
        this.chkMiniEdad14.setSelected(false);
        this.chkMiniEdad16.setSelected(false);
        this.chkGFmenor.setSelected(false);
        this.sumaMiniEdad5.setText("");
        this.sumaMiniEdad11.setText("");
        this.sumaMiniEdad14.setText("");
        this.sumaMiniEdad16.setText("");
        this.sumaGFmenor.setText("");
        this.sumaMiniEdad5.setVisible(false);
        this.sumaMiniEdad11.setVisible(false);
        this.sumaMiniEdad14.setVisible(false);
        this.sumaMiniEdad16.setVisible(false);
        this.sumaGFmenor.setVisible(false);
        this.primaDotalMenor.setText("");
        this.primaMiniEdad5.setText("");
        this.primaMiniEdad11.setText("");
        this.primaMiniEdad14.setText("");
        this.primaMiniEdad16.setText("");
        this.primaGFmenor.setText("");
        this.primaDotalMenor.setVisible(false);
        this.primaMiniEdad5.setVisible(false);
        this.primaMiniEdad11.setVisible(false);
        this.primaMiniEdad14.setVisible(false);
        this.primaMiniEdad16.setVisible(false);
        this.primaGFmenor.setVisible(false);
        this.datosvi.selMiniEdad5 = false;
        this.datosvi.selMiniEdad11 = false;
        this.datosvi.selMiniEdad14 = false;
        this.datosvi.selMiniEdad16 = false;
        this.datosvi.selGFmenor = false;
        this.datosvi.sumaDotalMenor = 0;
        this.datosvi.sumaMiniEdad5 = 0;
        this.datosvi.sumaMiniEdad11 = 0;
        this.datosvi.sumaMiniEdad14 = 0;
        this.datosvi.sumaMiniEdad16 = 0;
        this.datosvi.sumaGFmenor = 0;
        this.datosvi.primaDotalMenor = 0.0;
        this.datosvi.primaMiniEdad5 = 0.0;
        this.datosvi.primaMiniEdad11 = 0.0;
        this.datosvi.primaMiniEdad14 = 0.0;
        this.datosvi.primaMiniEdad16 = 0.0;
        this.datosvi.primaGFmenor = 0.0;
        this.chkConyuge.setSelected(false);
        this.datosvi.selConyugeEdu = false;
        this.nombreConyuge.setVisible(false);
        this.edadRealConyuge.setVisible(false);
        this.optMasculinoConyuge.setVisible(false);
        this.optFemeninoConyuge.setVisible(false);
        this.optFumaConyuge.setVisible(false);
        this.optNoFumaConyuge.setVisible(false);
        this.titConyuge.setVisible(false);
        this.titEdadRealConyuge.setVisible(false);
        this.titEdadCalculoConyuge.setVisible(false);
        this.edadCalculoConyuge.setVisible(false);
        this.titEPconyuge.setVisible(false);
        this.epMillarBASconyugeEdu.setVisible(false);
        this.epPorBASconyugeEdu.setVisible(false);
        this.titBASconyuge.setVisible(false);
        this.chkGFconyuge.setVisible(false);
        this.chkGFconyuge.setSelected(false);
        this.sumaBASconyuge.setText("");
        this.sumaGFconyuge.setText("");
        this.sumaBASconyuge.setVisible(false);
        this.sumaGFconyuge.setVisible(false);
        this.primaBASconyuge.setText("");
        this.primaGFconyuge.setText("");
        this.primaBASconyuge.setVisible(false);
        this.primaGFconyuge.setVisible(false);
        this.datosvi.selBASconyuge = false;
        this.datosvi.selGFconyuge = false;
        this.datosvi.sumaBASconyuge = 0;
        this.datosvi.sumaGFconyuge = 0;
        this.datosvi.primaBASconyuge = 0.0;
        this.datosvi.primaGFconyuge = 0.0;
        this.lblPrimaConyuge.setVisible(false);
        this.primaConyuge.setVisible(false);
        this.lblEPconyuge.setVisible(false);
        this.lblEPmillarConyuge.setVisible(false);
        this.lblEPporConyuge.setVisible(false);
        this.chkSaldado.setSelected(false);
        this.chkSaldado.setVisible(false);
        this.datosvi.incluirSaldado = false;
        this.epMillarBASedu.setText("");
        this.epPorBASedu.setText("");
        this.epPorINVedu.setText("");
        this.epPorACCedu.setText("");
        this.epMillarBASconyugeEdu.setText("");
        this.epPorBASconyugeEdu.setText("");
        this.datosvi.epMillarBASedu = 0.0;
        this.datosvi.epPorBASedu = 0.0;
        this.datosvi.epPorINVedu = 0.0;
        this.datosvi.epPorACCedu = 0.0;
        this.datosvi.epMillarBASconyugeEdu = 0.0;
        this.datosvi.epPorBASconyugeEdu = 0.0;
        this.datosvi.hayExtraprimas = false;
        this.LlenaCombos();
        this.valorTmp = this.genSubs.VlookUpStrIntInt("Dotal", this.datosvi.idMonedaSelEdu, this.datosvi.lstCoberturaEdu, this.datosvi.lstIdMonedaEdu, this.datosvi.lstSumaMinEdu);
        this.sumaDotalMenor.setText(this.genSubs.FormatoNumInteger("###,###", this.valorTmp));
        this.datosvi.sumaDotalMenor = this.valorTmp;
        this.tipoCambio.setText(this.genSubs.FormatoNumDouble("##.##", this.datosvi.tipoCambioDolar));
    }

    private void LlenaCombos() {
        this.cmbDotalMenor.getItems().clear();
        this.cmbDotalMenor.getItems().addAll(this.datosvi.lstDotalMenor);
        this.cmbMonedaEdu.getItems().clear();
        this.cmbMonedaEdu.getItems().addAll(this.datosvi.lstMonedaEdu);
        this.cmbFormaPagoEdu.getItems().clear();
        this.cmbFormaPagoEdu.getItems().addAll(this.datosvi.lstEduFormaPago);
        if (this.datosvi.primeraVezEdu.booleanValue()) {
            this.datosvi.formaPagoSelEdu = "Anual";
            this.datosvi.idFormaPagoSelEdu = 1;
            this.datosvi.dotalMenorSel = "Dotal a edad alcanzada 18";
            this.datosvi.plazoTitularEdu = 18;
            this.datosvi.plazoDotal = 18;
            this.datosvi.edadAlcanzadaDotal = 18;
            this.datosvi.monedaSelEdu = "Pesos";
            this.datosvi.idMonedaSelEdu = 1;
        }
        this.cmbFormaPagoEdu.setValue((Object)this.datosvi.formaPagoSelEdu);
        this.cmbDotalMenor.setValue((Object)this.datosvi.dotalMenorSel);
        this.cmbMonedaEdu.setValue((Object)this.datosvi.monedaSelEdu);
        this.RevisaMonedaSeleccionada();
    }

    private void DeterminaSumaMinima() {
        this.sumaMin = this.genSubs.VlookUpStrIntInt("Titular", this.datosvi.idMonedaSelEdu, this.datosvi.lstCoberturaEdu, this.datosvi.lstIdMonedaEdu, this.datosvi.lstSumaMinEdu);
        this.sumaBASedu.setText(this.genSubs.FormatoNumInteger("###,###", this.sumaMin));
        this.datosvi.sumaBASedu = this.sumaMin;
        this.datosvi.recargoFijoEdu = this.genSubs.VlookUpStrIntInt("Titular", this.datosvi.idMonedaSelEdu, this.datosvi.lstCoberturaEdu, this.datosvi.lstIdMonedaEdu, this.datosvi.lstRecFijoEdu);
    }

    private void DatosPersonales() {
        this.epMillarBASedu.setText(this.genSubs.FormatoNumDouble("###.00", this.datosvi.epMillarBASedu));
        this.epPorBASedu.setText(this.genSubs.FormatoNumDouble("###.00", this.datosvi.epPorBASedu * 100.0));
        this.epPorINVedu.setText(this.genSubs.FormatoNumDouble("###.00", this.datosvi.epPorINVedu * 100.0));
        this.epPorACCedu.setText(this.genSubs.FormatoNumDouble("###.00", this.datosvi.epPorACCedu * 100.0));
        this.epMillarBASconyugeEdu.setText(this.genSubs.FormatoNumDouble("###.00", this.datosvi.epMillarBASconyugeEdu));
        this.epPorBASconyugeEdu.setText(this.genSubs.FormatoNumDouble("###.00", this.datosvi.epPorBASconyugeEdu * 100.0));
    }

    private void ValoresCapturados() {
        this.sumaBASedu.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaBASedu));
        if (this.datosvi.selGPPIedu.booleanValue()) {
            this.chkGPPIedu.setSelected(true);
            this.primaGPPIedu.setVisible(true);
        } else {
            this.chkGPPIedu.setSelected(false);
            this.primaGPPIedu.setVisible(false);
        }
        if (this.datosvi.selPASIedu.booleanValue()) {
            this.chkPASIedu.setSelected(true);
            this.sumaPASIedu.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaPASIedu));
            this.sumaPASIedu.setVisible(true);
            this.primaPASIedu.setVisible(true);
        } else {
            this.sumaPASIedu.setVisible(false);
            this.primaPASIedu.setVisible(false);
        }
        if (this.datosvi.selGPPFedu.booleanValue()) {
            this.chkGPPFedu.setSelected(true);
            this.primaGPPFedu.setVisible(true);
        } else {
            this.chkGPPFedu.setSelected(false);
            this.primaGPPFedu.setVisible(false);
        }
        if (this.datosvi.selIMAedu.booleanValue()) {
            this.chkIMAedu.setSelected(true);
            this.sumaIMAedu.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaIMAedu));
            this.sumaIMAedu.setVisible(true);
            this.primaIMAedu.setVisible(true);
        } else {
            this.sumaIMAedu.setVisible(false);
            this.primaIMAedu.setVisible(false);
        }
        if (this.datosvi.selTIBAedu.booleanValue()) {
            this.chkTIBAedu.setSelected(true);
            this.sumaTIBAedu.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaTIBAedu));
            this.sumaTIBAedu.setVisible(true);
            this.primaTIBAedu.setVisible(true);
        } else {
            this.sumaTIBAedu.setVisible(false);
            this.primaTIBAedu.setVisible(false);
        }
        if (this.datosvi.selEGedu.booleanValue()) {
            this.chkEGedu.setSelected(true);
            this.sumaEGedu.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaEGedu));
            this.sumaEGedu.setVisible(true);
            this.primaEGedu.setVisible(true);
        } else {
            this.sumaEGedu.setVisible(false);
            this.primaEGedu.setVisible(false);
        }
        if (this.datosvi.selGFedu.booleanValue()) {
            this.chkGFedu.setSelected(true);
            this.sumaGFedu.setText(this.genSubs.FormatoNumInteger("###,###", this.datosvi.sumaGFedu));
            this.sumaGFedu.setVisible(true);
            this.primaGFedu.setVisible(true);
        } else {
            this.sumaGFedu.setVisible(false);
            this.primaGFedu.setVisible(false);
        }
        this.DeterminaEdadCalculo();
        this.LlenaCombos();
        this.DatosPersonales();
        this.tipoCambio.setText(this.genSubs.FormatoNumDouble("##.##", this.datosvi.tipoCambioDolar));
    }

    public void VerCotizacion() {
        this.GuardaDatos();
        this.cotizvi.ImprimeCotizacion();
    }

    private void GuardaDatos() {
        this.datosvi.nombreTitularEdu = this.nombreTitularEdu.getText().toString();
        this.datosvi.sexoTitularEdu = this.optMasculinoEdu.isSelected() ? "M" : "F";
        this.datosvi.fumaTitularEdu = this.optFumaEdu.isSelected() ? "S" : "N";
        this.datosvi.edadRealEdu = Integer.parseInt(this.edadRealEdu.getText().toString());
        this.DeterminaEdadCalculo();
        this.datosvi.nombreConyuge = this.datosvi.selConyugeEdu != false ? this.nombreConyuge.getText().toString() : "";
        this.datosvi.nombreMenor = this.nombreMenor.getText().toString();
        this.datosvi.sexoMenor = this.optMasculinoMenor.isSelected() ? "M" : "F";
        this.datosvi.dotalMenorSel = this.cmbDotalMenor.getValue().toString();
        this.datosvi.nombreMenor = this.nombreMenor.getText().toString();
        this.datosvi.selGFconyuge = this.chkGFconyuge.isSelected();
        this.datosvi.hayExtraprimas = false;
        if (this.datosvi.epMillarBASedu > 0.0 || this.datosvi.epPorBASedu > 0.0 || this.datosvi.epPorINVedu > 0.0 || this.datosvi.epPorACCedu > 0.0) {
            this.datosvi.hayExtraprimas = true;
        }
        if (this.datosvi.epMillarBASconyugeEdu > 0.0 || this.datosvi.epPorBASconyugeEdu > 0.0) {
            this.datosvi.hayExtraprimas = true;
        }
    }

    private void RevisaLimitesEdad() {
        this.edadMax = this.EdadMinMax(20, "PASI", "Max");
        if (this.datosvi.edadRealEdu > this.edadMax) {
            this.chkPASIedu.setSelected(false);
            this.datosvi.selPASIedu = false;
            this.chkPASIedu.setDisable(true);
        } else {
            this.chkPASIedu.setDisable(false);
        }
        this.edadMax = this.EdadMinMax(20, "GPPI", "Max");
        if (this.datosvi.edadRealEdu > this.edadMax) {
            this.chkGPPIedu.setSelected(false);
            this.datosvi.selGPPIedu = false;
            this.chkGPPIedu.setDisable(true);
        } else {
            this.chkGPPIedu.setSelected(true);
            this.datosvi.selGPPIedu = true;
            this.chkGPPIedu.setDisable(true);
        }
        this.ValidaGPPIedu();
        this.edadMax = this.EdadMinMax(20, "IMA", "Max");
        if (this.datosvi.edadRealEdu > this.edadMax) {
            this.datosvi.selIMAedu = false;
            this.chkIMAedu.setSelected(false);
            this.chkIMAedu.setDisable(true);
        } else {
            this.chkIMAedu.setDisable(false);
        }
        this.edadMax = this.EdadMinMax(20, "TIBA", "Max");
        if (this.datosvi.edadRealEdu > this.edadMax) {
            this.datosvi.selTIBAedu = false;
            this.chkTIBAedu.setSelected(false);
            this.chkTIBAedu.setDisable(true);
        } else {
            this.chkTIBAedu.setDisable(false);
        }
        this.edadMin = this.EdadMinMax(20, "EG", "Min");
        this.edadMax = this.EdadMinMax(20, "EG", "Max");
        if (this.datosvi.edadRealEdu > this.edadMax || this.datosvi.edadRealEdu < this.edadMin) {
            this.datosvi.selEGedu = false;
            this.chkEGedu.setSelected(false);
            this.chkEGedu.setDisable(true);
        } else {
            this.chkEGedu.setDisable(false);
        }
    }

    public void ClicPresentacion() {
        this.presentadorTrad.GeneraPresentacionTrad();
    }

    private Integer EdadMinMax(Integer idPlan, String idCobertura, String tipo) {
        Integer edad = tipo.equals("Min") ? this.genSubs.VlookUpIntStrInt(idPlan, idCobertura, this.datosvi.lstIdPlanEdad, this.datosvi.lstIdBeneficio, this.datosvi.lstEdadMin) : this.genSubs.VlookUpIntStrInt(idPlan, idCobertura, this.datosvi.lstIdPlanEdad, this.datosvi.lstIdBeneficio, this.datosvi.lstEdadMax);
        return edad;
    }

    private void InicializaVentana() {
        this.lblVersion.setText(this.datosvi.idVersion + this.datosvi.textoLegal);
        this.lblPlanSel.setText(this.datosvi.planSel);
        this.btnPresentacion.setVisible(true);
    }

    private void MuestraVentana(String nombreVentana) {
        try {
            this.root = (Parent)FXMLLoader.load((URL)this.getClass().getResource(nombreVentana + ".fxml"));
        }
        catch (Exception e) {
            System.out.println("No pudo cargar " + nombreVentana);
        }
        Scene scene = new Scene(this.root);
        this.stage.setScene(scene);
        scene.getStylesheets().add((Object)"cssBase.css");
        this.stage.show();
    }
}

